/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.actions;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.convert.entity.OrderUnitConversionRecordConverter;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.business.other.impl.OtherStorageOrderContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.enums.DgPlanOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.enums.DgPlanOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class PlanOrderAuditPassAction
extends AbstractAction<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(PlanOrderAuditPassAction.class);
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;

    @Override
    public void doExecute(StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> stateContext) {
        log.info("\u8fdb\u5165\u8ba1\u5212\u5165\u51fa\u5e93\u5ba1\u6838\u901a\u8fc7InOutNoticeAuditPassAction");
        final StatemachineExecutorBo executorBo = (StatemachineExecutorBo)stateContext.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
        boolean autoComplete = Objects.equals(stateContext.getExtendedState().get((Object)"autoComplete", String.class), "1");
        boolean onlyResult = Objects.equals(stateContext.getExtendedState().get((Object)"onlyResult", String.class), "1");
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        receiveDeliveryNoticeOrderFacadeBo.setSourceType(((PlanOrderEo)executorBo.getEo()).getBusinessType());
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(((PlanOrderEo)executorBo.getEo()).getLogicWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseName(((PlanOrderEo)executorBo.getEo()).getLogicWarehouseName());
        receiveDeliveryNoticeOrderFacadeBo.setPhysicsWarehouseCode(((PlanOrderEo)executorBo.getEo()).getPhysicsWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setPhysicsWarehouseName(((PlanOrderEo)executorBo.getEo()).getPhysicsWarehouseName());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceNo(((PlanOrderEo)executorBo.getEo()).getOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setSendWms(true);
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.PLAN_ORDER);
        receiveDeliveryNoticeOrderFacadeBo.setExternalOrderNo(((PlanOrderEo)executorBo.getEo()).getExternalOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setBusinessType(((PlanOrderEo)executorBo.getEo()).getBusinessType());
        receiveDeliveryNoticeOrderFacadeBo.setDisplayBusinessType(((PlanOrderEo)executorBo.getEo()).getBusinessType());
        receiveDeliveryNoticeOrderFacadeBo.setShipmentEnterpriseCode(((PlanOrderEo)executorBo.getEo()).getLogisticsCompanyCode());
        receiveDeliveryNoticeOrderFacadeBo.setShipmentEnterpriseName(((PlanOrderEo)executorBo.getEo()).getLogisticsCompanyName());
        receiveDeliveryNoticeOrderFacadeBo.setAutoComplete(autoComplete);
        receiveDeliveryNoticeOrderFacadeBo.setRemark(((PlanOrderEo)executorBo.getEo()).getRemark());
        receiveDeliveryNoticeOrderFacadeBo.setExtension(((PlanOrderEo)executorBo.getEo()).getExtension());
        receiveDeliveryNoticeOrderFacadeBo.setOnlyGenResult(onlyResult);
        receiveDeliveryNoticeOrderFacadeBo.setCreatePerson(((PlanOrderEo)executorBo.getEo()).getCreatePerson());
        List detailEos = (List)executorBo.getVariables().get(OtherStorageOrderContextEnum.PLAN_ORDER_DETAIL_LIST.getCode());
        List addressEos = (List)executorBo.getVariables().get(OtherStorageOrderContextEnum.BASE_ORDER_ADDRESS_LIST.getCode());
        receiveDeliveryNoticeOrderFacadeBo.setBaseOrderAddressEoList(Optional.ofNullable(this.getBaseOrderAddress(addressEos)).map(xva$0 -> Lists.newArrayList((Object[])new BaseOrderAddressEo[]{xva$0})).orElse(null));
        ArrayList detailReqDtoList = Lists.newArrayList();
        List<OrderUnitConversionRecordEo> unitConversionRecordEos = this.getOrderUnitConversionRecordEos(executorBo);
        Map conversionRecordEoMap = unitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, Function.identity(), (a1, a2) -> a1));
        for (PlanOrderDetailEo detail : detailEos) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            detailReqDto.setPreOrderItemId(detail.getId());
            detailReqDto.setSkuCode(detail.getSkuCode());
            detailReqDto.setSkuName(detail.getSkuName());
            detailReqDto.setExtension(detail.getExtension());
            detailReqDto.setBatch(detail.getBatch());
            detailReqDto.setVolume(detail.getVolume());
            detailReqDto.setWeight(detail.getWeight());
            detailReqDto.setInventoryProperty(detail.getInventoryProperty());
            detailReqDto.setExtension(detail.getExtension());
            OrderUnitConversionRecordEo orderUnitConversionRecordEo = (OrderUnitConversionRecordEo)conversionRecordEoMap.get(detail.getSkuCode());
            detailReqDto.setQuantity(UnitTransferUtils.pareSaleNum((BigDecimal)detail.getPlanQuantity(), (OrderUnitConversionRecordDto)((OrderUnitConversionRecordDto)OrderUnitConversionRecordConverter.INSTANCE.toDto((BaseEo)orderUnitConversionRecordEo)), (boolean)true));
            detailReqDto.setDocumentCode(detail.getOrderNo());
            detailReqDto.setBaseTo(false);
            detailReqDtoList.add(detailReqDto);
        }
        receiveDeliveryNoticeOrderFacadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutNoticeOrderContext) {
                    InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)context;
                    outNoticeOrderContext.setSendWms(true);
                }
                if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                    ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)context;
                    receiveDeliveryNoticeOrderContext.setShopCode(((PlanOrderEo)executorBo.getEo()).getShopCode());
                    receiveDeliveryNoticeOrderContext.setShopName(((PlanOrderEo)executorBo.getEo()).getShopName());
                    receiveDeliveryNoticeOrderContext.setShopId(((PlanOrderEo)executorBo.getEo()).getShopId());
                    Optional.ofNullable(((PlanOrderEo)executorBo.getEo()).getExtension()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(ex -> {
                        if (StringUtils.isNotBlank((CharSequence)context.getExtension())) {
                            JSONObject jsonObject = JSONObject.parseObject((String)ex);
                            jsonObject.putAll((Map)JSONObject.parseObject((String)context.getExtension()));
                            receiveDeliveryNoticeOrderContext.setExtension(jsonObject.toJSONString());
                        } else {
                            receiveDeliveryNoticeOrderContext.setExtension((String)ex);
                        }
                    });
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(true);
            }
        });
        receiveDeliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(detailReqDtoList);
        if ("out".equals(((PlanOrderEo)executorBo.getEo()).getOperationType())) {
            this.baseOrderFacade.deliveryNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        } else {
            this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        }
    }

    private List<OrderUnitConversionRecordEo> getOrderUnitConversionRecordEos(StatemachineExecutorBo<PlanOrderEo> executorBo) {
        return this.orderUnitConversionRecordService.getRecordByOrderNo(executorBo.getEo().getOrderNo());
    }

    private void unitConversion(BaseOrderDetailReqDto dto, PlanOrderDetailEo detail, OrderUnitConversionRecordEo unitConversionEo) {
        BigDecimal rate = BigDecimal.ZERO.compareTo(unitConversionEo.getNum()) == 0 ? BigDecimal.ONE : unitConversionEo.getToNum().divide(unitConversionEo.getNum(), 6, RoundingMode.HALF_UP);
        BigDecimal planQuantity = BigDecimalUtils.multiply((BigDecimal)detail.getPlanQuantity(), (BigDecimal)rate);
        dto.setQuantity(planQuantity);
    }

    private BaseOrderAddressEo getBaseOrderAddress(List<BaseOrderAddressEo> addressEos) {
        if (CollectionUtils.isEmpty(addressEos)) {
            return null;
        }
        BaseOrderAddressEo addressEo = addressEos.get(0);
        BaseOrderAddressEo baseOrderAddressEo = new BaseOrderAddressEo();
        BeanUtil.copyProperties((Object)addressEo, (Object)baseOrderAddressEo, (String[])new String[0]);
        baseOrderAddressEo.setProvince(addressEo.getProvince());
        baseOrderAddressEo.setProvinceCode(addressEo.getProvinceCode());
        baseOrderAddressEo.setCity(addressEo.getCity());
        baseOrderAddressEo.setCityCode(addressEo.getCityCode());
        baseOrderAddressEo.setDistrict(addressEo.getDistrict());
        baseOrderAddressEo.setDistrictCode(addressEo.getDistrictCode());
        baseOrderAddressEo.setDetailAddress(addressEo.getDetailAddress());
        baseOrderAddressEo.setEncryptProvince(addressEo.getEncryptProvince());
        baseOrderAddressEo.setEncryptCity(addressEo.getEncryptCity());
        baseOrderAddressEo.setEncryptDistrict(addressEo.getEncryptDistrict());
        baseOrderAddressEo.setEncryptDetailAddress(addressEo.getEncryptDetailAddress());
        return baseOrderAddressEo;
    }
}

