/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.actions;

import cn.hutool.core.util.ObjectUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.other.impl.OtherStorageOrderContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.enums.DgPlanOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.enums.DgPlanOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class PlanOrderPreemptionChoiceAction
extends AbstractAction<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(PlanOrderPreemptionChoiceAction.class);
    @Resource
    protected ICalcInventoryService calcInventoryService;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;

    @Override
    public void doExecute(StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> context) {
        log.info("\u8fdb\u5165\u4e86\u66f4\u65b0\u91c7\u8d2d\u7684PlanOrderPreemptionChoiceAction");
        StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
        if (ObjectUtil.equals((Object)((PlanOrderEo)executorBo.getEo()).getOperationType(), (Object)"out")) {
            List planOrderDetailEos = (List)executorBo.getVariables().get(OtherStorageOrderContextEnum.PLAN_ORDER_DETAIL_LIST.getCode());
            Map<Object, OrderUnitConversionRecordDto> unitConversionRecordDtoMap = this.unitProcess(((PlanOrderEo)executorBo.getEo()).getOrderNo(), planOrderDetailEos);
            PreemptDto preemptParam = new PreemptDto();
            preemptParam.setSourceNo(((PlanOrderEo)executorBo.getEo()).getOrderNo());
            preemptParam.setSourceType(((PlanOrderEo)executorBo.getEo()).getOrderType());
            preemptParam.setBusinessType(((PlanOrderEo)executorBo.getEo()).getBusinessType());
            preemptParam.setExternalOrderNo(((PlanOrderEo)executorBo.getEo()).getExternalOrderNo());
            preemptParam.setNoneLineNo(Boolean.valueOf(true));
            ArrayList detailParams = Lists.newArrayList();
            for (PlanOrderDetailEo detailEo : planOrderDetailEos) {
                CalcDetailDto detailParam = new CalcDetailDto();
                OrderUnitConversionRecordDto unitEo = unitConversionRecordDtoMap.get(this.getKey(detailEo.getSkuCode(), detailEo.getPlanQuantity(), detailEo.getUnit()));
                detailParam.setNum(unitEo != null ? unitEo.getToNum() : detailEo.getPlanQuantity());
                detailParam.setSkuCode(detailEo.getSkuCode());
                String warehouseCode = ((PlanOrderEo)executorBo.getEo()).getLogicWarehouseCode();
                detailParam.setLogicWarehouseCode(warehouseCode);
                detailParam.setInventoryProperty(detailEo.getInventoryProperty());
                detailParam.setBatch(detailEo.getBatch());
                preemptParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailEo.getBatch())));
                detailParams.add(detailParam);
            }
            preemptParam.setDetails((List)detailParams);
            this.calcInventoryService.updatePreempt(preemptParam);
        }
    }

    private Map<Object, OrderUnitConversionRecordDto> unitProcess(String adjustmentOrderNo, List<PlanOrderDetailEo> adjustmentOrderDetailEos) {
        ArrayList unitConversionDetails = new ArrayList();
        adjustmentOrderDetailEos.forEach(detailEo -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(detailEo.getUnit());
            unitConversionDetail.setSkuCode(detailEo.getSkuCode());
            unitConversionDetail.setCurNum(detailEo.getPlanQuantity());
            unitConversionDetails.add(unitConversionDetail);
        });
        OrderUnitConversionReqDto orderUnitConversionReqDto = new OrderUnitConversionReqDto();
        orderUnitConversionReqDto.setDocumentCode(adjustmentOrderNo);
        orderUnitConversionReqDto.setType("adjustment");
        orderUnitConversionReqDto.setOrderUnitConversionDetailList(unitConversionDetails);
        List<OrderUnitConversionRecordDto> orderUnitConversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(orderUnitConversionReqDto);
        return orderUnitConversionRecordDtos.stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), o.getNum(), o.getUnit()), Function.identity(), (k1, k2) -> k1));
    }

    private Object getKey(String skuCode, BigDecimal num, String currentUnit) {
        return skuCode + InventoryConfig.getCommonSeparate() + num.setScale(6) + InventoryConfig.getCommonSeparate() + currentUnit;
    }
}

