/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.config;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.dict.dto.Schemas.DictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.DictEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryThirdAuditConfigurationDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPlanOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPlanOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderExtDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.InspectionPassDto;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IInspectionPassService;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.actions.PlanOrderAuditPassAction;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.actions.PlanOrderCancelAction;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.actions.PlanOrderFinishAction;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.actions.PlanOrderPreemptionChoiceAction;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.actions.PlanOrderReleasePreemptionAction;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.enums.DgPlanOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.enums.DgPlanOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.event.PlanOrderUpdateEvent;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.inventory.service.third.PushThirdAuditBo;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import com.yunxi.dg.base.center.inventory.statemachine.executor.PlanStatemachineExecutor;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.EnableStateMachineFactory;
import org.springframework.statemachine.config.StateMachineConfigurerAdapter;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.persist.DefaultStateMachinePersister;
import org.springframework.statemachine.persist.StateMachinePersister;

@Configuration
@EnableStateMachineFactory(name={"planOrderStateMachineFactory"})
public class DgPlanStateMachineBuilder
extends StateMachineConfigurerAdapter<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(DgPlanStateMachineBuilder.class);
    @Resource
    private IPlanOrderDomain planOrderDomain;
    @Resource
    private PlanOrderPreemptionChoiceAction planOrderPreemptionChoiceAction;
    @Resource
    private PlanOrderAuditPassAction planOrderAuditPassAction;
    @Resource
    private PlanOrderReleasePreemptionAction planOrderReleasePreemptionAction;
    @Resource
    private PlanOrderCancelAction planOrderCancelAction;
    @Resource
    private PlanOrderFinishAction planOrderFinishAction;
    @Resource
    private IPlanOrderDetailDomain planOrderDetailDomain;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    private IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private IPcpDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IInspectionPassService inspectionPassService;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IInventoryThirdAuditConfigurationDomain inventoryThirdAuditConfigurationDomain;

    public void configure(StateMachineStateConfigurer<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> states) throws Exception {
        states.withStates().initial((Object)DgPlanOrderStatusEnum.WAIT_SUBMIT).choice((Object)DgPlanOrderStatusEnum.WAIT_INVENTORY_CHOISE).choice((Object)DgPlanOrderStatusEnum.COMMIT_CHOISE).choice((Object)DgPlanOrderStatusEnum.IN_INVENTORY_CHOISE).choice((Object)DgPlanOrderStatusEnum.OUT_INVENTORY_CHOISE).state((Object)DgPlanOrderStatusEnum.PORTION_IN, this.planOrderSendMqAction()).state((Object)DgPlanOrderStatusEnum.PORTION_OUT, this.planOrderSendMqAction()).state((Object)DgPlanOrderStatusEnum.COMPLETED, context -> {
            this.pushSap().execute(context);
            this.backfull().execute(context);
            this.planOrderSendMqAction().execute(context);
        }).state((Object)DgPlanOrderStatusEnum.FINISH, context -> {
            this.backfull().execute(context);
            this.planOrderSendMqAction().execute(context);
        }).state((Object)DgPlanOrderStatusEnum.WAIT_AUDIT, this.planOrderSendMqAction()).state((Object)DgPlanOrderStatusEnum.WAIT_THIRD_AUDIT, this.planOrderSendMqAction()).state((Object)DgPlanOrderStatusEnum.AUDIT_FAILED, this.planOrderSendMqAction()).state((Object)DgPlanOrderStatusEnum.WAIT_IN, this.planOrderSendMqAction()).state((Object)DgPlanOrderStatusEnum.WAIT_OUT, this.planOrderSendMqAction()).state((Object)DgPlanOrderStatusEnum.CANCEL, this.planOrderSendMqAction());
    }

    @NotNull
    private Action<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> planOrderSendMqAction() {
        return context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            PlanOrderEo eo = (PlanOrderEo)executorBo.getEo();
            eo.setOrderStatus(((DgPlanOrderStatusEnum)((Object)((Object)context.getStateMachine().getState().getId()))).getKey());
            log.info("\u8ba1\u5212\u7c7b\u51fa\u5165\u5e93\u5355\u636e\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u63a8\u9001:{},{}", (Object)eo.getOrderNo(), (Object)eo.getExternalOrderNo());
            this.commonsMqService.publishMessage("PUBLISH_TOPIC", "PUSH_PLAN_ORDER", (Object)JSON.toJSONString((Object)eo));
        };
    }

    @NotNull
    private Action<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> pushSap() {
        return context -> {
            ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
            if (InventoryConfig.getPushSapAble().canPush(PushAble.CanPushBo.builder().build())) {
                InventoryConfig.getPushSapAble().push(receiveDeliveryResultOrderContext);
            }
        };
    }

    @NotNull
    private Action<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> generateInspectionPass() {
        return context -> {
            log.info("\u8fdb\u5165\u65b0\u589e\u8d28\u68c0\u653e\u884cAction:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)context));
            String orderNo = (String)context.getExtendedState().getVariables().get("orderNo");
            try {
                this.inspec((StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum>)context, orderNo);
            }
            catch (Exception e) {
                log.error("\u8d28\u68c0\u5904\u7406:{}", (Object)e.getMessage());
            }
        };
    }

    private Action<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> backfull() {
        return context -> {
            log.info("\u8ba1\u5212\u5355\u6279\u6b21\u56de\u5199");
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            PlanOrderEo eo = (PlanOrderEo)executorBo.getEo();
            this.doBackfull(eo);
        };
    }

    private void doBackfull(PlanOrderEo eo) {
        Map idMap = ((ExtQueryChainWrapper)this.planOrderDetailDomain.filter().eq((Object)"order_no", (Object)eo.getOrderNo())).list().stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map<Long, BigDecimal> numMap = idMap.values().stream().collect(Collectors.toMap(BaseEo::getId, PlanOrderDetailEo::getPlanQuantity));
        List receiveDeliveryResultOrderDetailEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)eo.getOrderNo())).list();
        ArrayList<PlanOrderDetailEo> planOrderDetailEos = new ArrayList<PlanOrderDetailEo>();
        if (CollectionUtil.isNotEmpty((Collection)receiveDeliveryResultOrderDetailEos)) {
            Map<Long, List<ReceiveDeliveryResultOrderDetailEo>> idResultDetails = receiveDeliveryResultOrderDetailEos.stream().collect(Collectors.groupingBy(ReceiveDeliveryResultOrderDetailEo::getPreOrderItemId));
            idResultDetails.forEach((k, v) -> {
                ArrayList<List<ReceiveDeliveryResultOrderDetailEo>> arrayList = new ArrayList<List<ReceiveDeliveryResultOrderDetailEo>>(v.stream().collect(Collectors.groupingBy(r -> r.getSkuCode() + r.getBatch() + r.getInventoryProperty())).values());
                arrayList.forEach(eos -> {
                    ReceiveDeliveryResultOrderDetailEo o = (ReceiveDeliveryResultOrderDetailEo)eos.get(0);
                    PlanOrderDetailEo planOrderDetailEo = (PlanOrderDetailEo)idMap.get(o.getPreOrderItemId());
                    PlanOrderDetailEo detailEo = (PlanOrderDetailEo)BeanUtil.copyProperties((Object)planOrderDetailEo, PlanOrderDetailEo.class, (String[])new String[]{"id"});
                    List<OrderUnitConversionRecordEo> orderUnitConversionRecordEos = this.getRecordByCode(o.getRelevanceNo());
                    Map<String, BigDecimal> ratioMap = orderUnitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum()), (a, a1) -> a));
                    Map<String, BigDecimal> toRatioMap = orderUnitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getNum(), (BigDecimal)r.getToNum()), (a, a1) -> a));
                    BigDecimal ratio = ratioMap.getOrDefault(o.getSkuCode(), BigDecimal.ONE);
                    BigDecimal toRatio = toRatioMap.getOrDefault(o.getSkuCode(), BigDecimal.ONE);
                    detailEo.setOrderNo(o.getRelevanceNo());
                    detailEo.setItemStatus(o.getItemStatus());
                    detailEo.setSkuCode(o.getSkuCode());
                    detailEo.setSkuName(o.getSkuName());
                    detailEo.setBatch(o.getBatch());
                    detailEo.setDoneQuantity(UnitTransferUtils.pareSaleNum((BigDecimal)eos.stream().map(ReceiveDeliveryResultOrderDetailEo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add), (BigDecimal)ratio, (BigDecimal)toRatio));
                    detailEo.setPlanQuantity(detailEo.getDoneQuantity());
                    detailEo.setWaitQuantity(UnitTransferUtils.pareSaleNum((BigDecimal)eos.stream().map(ReceiveDeliveryResultOrderDetailEo::getWaitQuantity).reduce(BigDecimal.ZERO, BigDecimal::add), (BigDecimal)ratio, (BigDecimal)toRatio));
                    detailEo.setCancelQuantity(eos.stream().map(ReceiveDeliveryResultOrderDetailEo::getCancelQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                    detailEo.setExtension(planOrderDetailEo.getExtension());
                    detailEo.setUnit(planOrderDetailEo.getUnit());
                    detailEo.setVolume(planOrderDetailEo.getVolume());
                    detailEo.setWeight(planOrderDetailEo.getWeight());
                    detailEo.setInventoryProperty(o.getInventoryProperty());
                    if (arrayList.indexOf(eos) == arrayList.size() - 1) {
                        detailEo.setPlanQuantity((BigDecimal)numMap.get(o.getPreOrderItemId()));
                        detailEo.setId(o.getPreOrderItemId());
                        detailEo.setCancelQuantity(BigDecimalUtils.subtract((BigDecimal)((BigDecimal)numMap.get(o.getId())), (BigDecimal)detailEo.getDoneQuantity()));
                    } else {
                        numMap.compute(o.getPreOrderItemId(), (n, r) -> BigDecimalUtils.subtract((BigDecimal)r, (BigDecimal)detailEo.getDoneQuantity()));
                    }
                    planOrderDetailEos.add(detailEo);
                });
            });
            this.orderUnitConversionRecordService.planOrderVolumeAndWeightProcess(eo.getOrderNo(), planOrderDetailEos);
            PlanOrderDetailEo planOrderDetailEo = new PlanOrderDetailEo();
            planOrderDetailEo.setOrderNo(eo.getOrderNo());
            this.planOrderDetailDomain.delete((BaseEo)planOrderDetailEo);
            this.planOrderDetailDomain.insertBatch(planOrderDetailEos);
        }
    }

    private List<OrderUnitConversionRecordEo> getRecordByCode(String relevanceNo) {
        return this.orderUnitConversionRecordService.getOrderUnitConversionRecordEos(relevanceNo, (ExtQueryChainWrapper<OrderUnitConversionRecordEo>)this.orderUnitConversionRecordDomain.filter());
    }

    public void configure(StateMachineConfigurationConfigurer<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> config) throws Exception {
        config.withConfiguration().machineId("planOrder").autoStartup(true).listener((StateMachineListener)new StateMachineListenerAdapter<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum>(){

            public void stateMachineStopped(StateMachine<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> stateMachine) {
                log.info("stateMachineStopped");
                if (stateMachine.hasStateMachineError()) {
                    log.info("stateMachineError");
                    return;
                }
                StatemachineExecutorBo executeBo = (StatemachineExecutorBo)stateMachine.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
                if (ObjectUtil.isEmpty((Object)executeBo)) {
                    return;
                }
                DgPlanOrderStatusEnum id = (DgPlanOrderStatusEnum)((Object)stateMachine.getState().getId());
                PlanOrderEo eo = (PlanOrderEo)executeBo.getEo();
                if (ObjectUtil.isNull((Object)eo) || ObjectUtil.isNull((Object)eo.getId())) {
                    return;
                }
                eo.setOrderStatus(id.getKey());
                DgPlanStateMachineBuilder.this.planOrderDomain.updateSelective((BaseEo)eo);
                InventoryConfig.getApplicationEventPublisher().publishEvent((ApplicationEvent)new PlanOrderUpdateEvent((PlanOrderExtDto)BeanUtil.copyProperties((Object)eo, PlanOrderExtDto.class, (String[])new String[0])));
                DgPlanStateMachineBuilder.this.commonsMqService.sendSingleMessage("planOrderEvent", (Object)JSONObject.toJSONString((Object)eo));
            }
        });
    }

    @Bean
    public PlanStatemachineExecutor planInOutStatemachineExecutor() {
        return new PlanStatemachineExecutor();
    }

    @Bean
    public StateMachinePersister<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum, PlanOrderEo> planInOutStatemachineExecutorPersister(PlanStatemachineExecutor planStatemachineExecutor) {
        return new DefaultStateMachinePersister((StateMachinePersist)planStatemachineExecutor);
    }

    public void configure(StateMachineTransitionConfigurer<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> transitions) throws Exception {
        ((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)transitions.withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_SUBMIT)).event((Object)DgPlanOrderStatusEventEnum.SUBMIT)).target((Object)DgPlanOrderStatusEnum.COMMIT_CHOISE).action(this.waitAuditAction())).and()).withExternal().source((Object)DgPlanOrderStatusEnum.AUDIT_FAILED)).event((Object)DgPlanOrderStatusEventEnum.SUBMIT)).target((Object)DgPlanOrderStatusEnum.COMMIT_CHOISE).action(this.waitAuditAction())).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_SUBMIT)).event((Object)DgPlanOrderStatusEventEnum.AUTOCOMPLETE)).action(r -> {
            StatemachineExecutorBo executorBo = (StatemachineExecutorBo)r.getStateMachine().getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
            r.getExtendedState().getVariables().put("autoComplete", "1");
            r.getExtendedState().getVariables().put("onlyResult", executorBo.getVariablesOrDefault("onlyGenResult", Boolean.class, false) != false ? "2" : "1");
        })).target((Object)DgPlanOrderStatusEnum.COMPLETED).action(this.passAuditAction())).action(this.backfull())).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_AUDIT)).event((Object)DgPlanOrderStatusEventEnum.AUTOCOMPLETE)).action(r -> {
            StatemachineExecutorBo executorBo = (StatemachineExecutorBo)r.getStateMachine().getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
            r.getExtendedState().getVariables().put("autoComplete", "1");
            r.getExtendedState().getVariables().put("onlyResult", executorBo.getVariablesOrDefault("onlyGenResult", Boolean.class, false) != false ? "2" : "1");
        })).target((Object)DgPlanOrderStatusEnum.COMPLETED).action(this.passAuditAction())).action(this.backfull())).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_AUDIT)).event((Object)DgPlanOrderStatusEventEnum.AUDIT)).target((Object)DgPlanOrderStatusEnum.WAIT_INVENTORY_CHOISE).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_THIRD_AUDIT)).event((Object)DgPlanOrderStatusEventEnum.AUDIT)).target((Object)DgPlanOrderStatusEnum.WAIT_INVENTORY_CHOISE).and()).withChoice().source((Object)DgPlanOrderStatusEnum.COMMIT_CHOISE).first((Object)DgPlanOrderStatusEnum.WAIT_THIRD_AUDIT, context -> {
            StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getStateMachine().getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
            return this.inventoryThirdAuditConfigurationDomain.canThirdAudit(((PlanOrderEo)executorBo.getEo()).getOrderType(), ((PlanOrderEo)executorBo.getEo()).getBusinessType(), Integer.valueOf(1));
        }, DgPlanStateMachineBuilder.thirdAuditPush()).last((Object)DgPlanOrderStatusEnum.WAIT_AUDIT).and()).withChoice().source((Object)DgPlanOrderStatusEnum.WAIT_INVENTORY_CHOISE).first((Object)DgPlanOrderStatusEnum.WAIT_IN, context -> {
            StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getStateMachine().getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
            return "in".equals(((PlanOrderEo)executorBo.getEo()).getOperationType());
        }, this.passAuditAction()).last((Object)DgPlanOrderStatusEnum.WAIT_OUT, this.passAuditAction()).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_AUDIT)).event((Object)DgPlanOrderStatusEventEnum.AUDITFAILED)).target((Object)DgPlanOrderStatusEnum.AUDIT_FAILED).action(context -> this.planOrderReleasePreemptionAction.execute(context))).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_THIRD_AUDIT)).event((Object)DgPlanOrderStatusEventEnum.AUDITFAILED)).target((Object)DgPlanOrderStatusEnum.AUDIT_FAILED).action(context -> this.planOrderReleasePreemptionAction.execute(context))).and()).withExternal().source((Object)DgPlanOrderStatusEnum.AUDIT_FAILED)).event((Object)DgPlanOrderStatusEventEnum.RESUBMIT)).target((Object)DgPlanOrderStatusEnum.COMMIT_CHOISE).action(this.waitAuditAction())).and()).withExternal().source((Object)DgPlanOrderStatusEnum.AUDIT_FAILED)).event((Object)DgPlanOrderStatusEventEnum.CANCEL)).target((Object)DgPlanOrderStatusEnum.CANCEL).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_IN)).event((Object)DgPlanOrderStatusEventEnum.RECEIVE)).target((Object)DgPlanOrderStatusEnum.IN_INVENTORY_CHOISE).and()).withChoice().source((Object)DgPlanOrderStatusEnum.IN_INVENTORY_CHOISE).first((Object)DgPlanOrderStatusEnum.PORTION_IN, this.checkAllProcess(), this.pushSap()).then((Object)DgPlanOrderStatusEnum.FINISH, this.checkFinish(), this.pushSap()).last((Object)DgPlanOrderStatusEnum.COMPLETED).and()).withExternal().source((Object)DgPlanOrderStatusEnum.PORTION_IN)).event((Object)DgPlanOrderStatusEventEnum.RECEIVE)).target((Object)DgPlanOrderStatusEnum.IN_INVENTORY_CHOISE).and()).withChoice().source((Object)DgPlanOrderStatusEnum.IN_INVENTORY_CHOISE).first((Object)DgPlanOrderStatusEnum.FINISH, this.checkFinish(), this.pushSap()).then((Object)DgPlanOrderStatusEnum.PORTION_IN, this.checkAllProcess(), this.pushSap()).last((Object)DgPlanOrderStatusEnum.COMPLETED, this.backfull()).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_OUT)).event((Object)DgPlanOrderStatusEventEnum.DELIVERY)).target((Object)DgPlanOrderStatusEnum.OUT_INVENTORY_CHOISE).and()).withExternal().source((Object)DgPlanOrderStatusEnum.PORTION_OUT)).event((Object)DgPlanOrderStatusEventEnum.DELIVERY)).target((Object)DgPlanOrderStatusEnum.OUT_INVENTORY_CHOISE).and()).withChoice().source((Object)DgPlanOrderStatusEnum.OUT_INVENTORY_CHOISE).first((Object)DgPlanOrderStatusEnum.FINISH, this.checkFinish(), this.pushSap()).then((Object)DgPlanOrderStatusEnum.PORTION_OUT, this.checkAllProcess(), this.pushSap()).last((Object)DgPlanOrderStatusEnum.COMPLETED, this.backfull()).and()).withExternal().source((Object)DgPlanOrderStatusEnum.PORTION_IN)).event((Object)DgPlanOrderStatusEventEnum.FINISH)).target((Object)DgPlanOrderStatusEnum.FINISH).action(context -> this.planOrderFinishAction.execute(context))).and()).withExternal().source((Object)DgPlanOrderStatusEnum.PORTION_OUT)).event((Object)DgPlanOrderStatusEventEnum.FINISH)).target((Object)DgPlanOrderStatusEnum.FINISH).action(context -> this.planOrderFinishAction.execute(context))).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_OUT)).event((Object)DgPlanOrderStatusEventEnum.CANCEL)).target((Object)DgPlanOrderStatusEnum.CANCEL).guard(this.checkCancel())).action(context -> this.planOrderCancelAction.execute(context))).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_IN)).event((Object)DgPlanOrderStatusEventEnum.CANCEL)).target((Object)DgPlanOrderStatusEnum.CANCEL).guard(this.checkCancel())).action(context -> this.planOrderCancelAction.execute(context))).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_SUBMIT)).event((Object)DgPlanOrderStatusEventEnum.CANCEL)).target((Object)DgPlanOrderStatusEnum.CANCEL).and()).withExternal().source((Object)DgPlanOrderStatusEnum.WAIT_AUDIT)).event((Object)DgPlanOrderStatusEventEnum.CANCEL)).target((Object)DgPlanOrderStatusEnum.CANCEL).action(context -> this.planOrderReleasePreemptionAction.execute(context));
    }

    @NotNull
    private static Action<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> thirdAuditPush() {
        return new AbstractAction<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum>(){

            @Override
            protected void doExecute(StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> context) {
                StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getStateMachine().getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
                InventoryConfig.getPushThirdAuditAble().push(PushThirdAuditBo.builder().businessOrderNo(((PlanOrderEo)executorBo.getEo()).getOrderNo()).businessType(((PlanOrderEo)executorBo.getEo()).getBusinessType()).orderType(((PlanOrderEo)executorBo.getEo()).getOrderType()).build());
            }
        };
    }

    @NotNull
    private Action<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> waitAuditAction() {
        return new AbstractAction<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum>(){

            @Override
            protected void doExecute(StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> context) {
                DgPlanStateMachineBuilder.this.planOrderPreemptionChoiceAction.execute(context);
            }
        };
    }

    @NotNull
    private Guard<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> checkCancel() {
        return context -> true;
    }

    @NotNull
    private AbstractAction<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> passAuditAction() {
        return new AbstractAction<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum>(){

            @Override
            protected void doExecute(StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> context) {
                DgPlanStateMachineBuilder.this.planOrderAuditPassAction.execute(context);
            }
        };
    }

    @NotNull
    private Guard<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> checkAllProcess() {
        return context -> {
            boolean flag;
            log.info("\u8fdb\u5165\u5224\u65ad\u662f\u5426\u90e8\u5206\u53d1\u8d27\u6536\u8d27context:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)context));
            String orderNo = (String)context.getExtendedState().getVariables().get("orderNo");
            boolean bl = flag = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)orderNo)).in((Object)"order_status", new Object[]{BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode(), BaseOrderStatusEnum.RNO_TOTAL_RECEIVE.getCode()})).count() > 0;
            if (!flag) {
                this.updatePlanDetailQuantity(orderNo, (StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum>)context);
            }
            return !flag;
        };
    }

    @NotNull
    private Guard<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> checkFinish() {
        return context -> {
            boolean flag;
            log.info("\u8fdb\u5165\u5224\u65ad\u662f\u5426\u5b8c\u7ed3context:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)context));
            String orderNo = (String)context.getExtendedState().getVariables().get("orderNo");
            boolean bl = flag = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)orderNo)).in((Object)"order_status", new Object[]{BaseOrderStatusEnum.FINISH_OVER.getCode()})).count() > 0;
            if (flag) {
                this.updatePlanDetailQuantity(orderNo, (StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum>)context);
            }
            try {
                this.inspec((StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum>)context, orderNo);
            }
            catch (Exception e) {
                log.error("\u8d28\u68c0\u5904\u7406:{}", (Object)e.getMessage());
            }
            return flag;
        };
    }

    private void inspec(StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> context, String orderNo) {
        this.updatePlanDetailQuantity(orderNo, context);
        if (InventoryConfig.isNoneBatch() || InventoryConfig.isEnableInspction()) {
            return;
        }
        PlanOrderEo eo = (PlanOrderEo)((StatemachineExecutorBo)context.getStateMachine().getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class)).getEo();
        log.info("planOrderEo:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)eo));
        ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
        log.info("receiveDeliveryResultOrderContext:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)receiveDeliveryResultOrderContext));
        this.generateInspectionPass(eo, receiveDeliveryResultOrderContext);
    }

    @NotNull
    private void updatePlanDetailQuantity(String orderNo, StateContext<DgPlanOrderStatusEnum, DgPlanOrderStatusEventEnum> context) {
        List noticeOrderDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)orderNo)).orderByDesc((Object)"create_time")).list();
        Map<Long, List<ReceiveDeliveryNoticeOrderDetailEo>> detailMap = noticeOrderDetailEos.stream().collect(Collectors.groupingBy(e -> e.getPreOrderItemId()));
        List planOrderDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.planOrderDetailDomain.filter().eq((Object)"order_no", (Object)orderNo)).eq((Object)"dr", (Object)YesNoEnum.NO)).list();
        BigDecimal allDoneQuantity = BigDecimal.ZERO;
        for (PlanOrderDetailEo planOrderDetailEo : planOrderDetailEos) {
            List<ReceiveDeliveryNoticeOrderDetailEo> list = detailMap.get(planOrderDetailEo.getId());
            if (CollectionUtils.isEmpty(list)) continue;
            BigDecimal doneQuantity = list.stream().map(ReceiveDeliveryNoticeOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal cancelQuantity = list.stream().map(ReceiveDeliveryNoticeOrderDetailEo::getCancelQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            planOrderDetailEo.setDoneQuantity(doneQuantity);
            planOrderDetailEo.setCancelQuantity(cancelQuantity);
            planOrderDetailEo.setWaitQuantity(planOrderDetailEo.getPlanQuantity().subtract(doneQuantity).subtract(cancelQuantity));
            allDoneQuantity = allDoneQuantity.add(doneQuantity);
        }
        this.planOrderDetailDomain.getMapper().updateBatchByIds(planOrderDetailEos);
        PlanOrderEo eo = (PlanOrderEo)((StatemachineExecutorBo)context.getStateMachine().getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class)).getEo();
        eo.setDoneQuantity(allDoneQuantity);
    }

    private void generateInspectionPass(PlanOrderEo eo, ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext) {
        String enableStatus;
        if (!"receive".equals(receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderEo().getOrderType())) {
            return;
        }
        DictDto dictDto = this.dictQueryApiProxy.querySameTableByGroupCodeAndCode(DictEnum.INSPECTION_PASS_CONFIG.getGroupCode(), DictEnum.INSPECTION_PASS_CONFIG.getCode());
        log.info("\u6839\u636e\u8d28\u68c0\u653e\u884c\u914d\u7f6ecode\u3010{}\u3011\u83b7\u53d6\u5b57\u5178\u8868\u4fe1\u606f\uff1a{}", (Object)DictEnum.INSPECTION_PASS_CONFIG.getCode(), (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)dictDto));
        String string = enableStatus = Objects.nonNull(dictDto) ? dictDto.getValue() : null;
        if (!ValidFlagEnum.ENABLE.getCode().equals(enableStatus)) {
            this.inspectionPassService.updateBatchRecordPass(receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderDetailEoList());
            return;
        }
        List unitConversionRecordEos = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)eo.getOrderNo())).list();
        ArrayList<InspectionPassDto> dtos = new ArrayList<InspectionPassDto>();
        for (ReceiveDeliveryResultOrderDetailEo receiveDeliveryResultOrderDetailEo : receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderDetailEoList()) {
            if (!LogicWarehouseQualityEnum.WAIT_INSPECTION.getCode().equals(receiveDeliveryResultOrderDetailEo.getInventoryProperty())) continue;
            InspectionPassDto inspectionPassDto = new InspectionPassDto();
            inspectionPassDto.setInspectionTime(new Date());
            inspectionPassDto.setSkuCode(receiveDeliveryResultOrderDetailEo.getSkuCode());
            inspectionPassDto.setSkuName(receiveDeliveryResultOrderDetailEo.getSkuName());
            inspectionPassDto.setBatch(receiveDeliveryResultOrderDetailEo.getBatch());
            inspectionPassDto.setQuantity(receiveDeliveryResultOrderDetailEo.getQuantity());
            inspectionPassDto.setWaitQuantity(receiveDeliveryResultOrderDetailEo.getQuantity());
            inspectionPassDto.setRelevanceNo(receiveDeliveryResultOrderDetailEo.getRelevanceNo());
            inspectionPassDto.setLogicWarehouseCode(eo.getLogicWarehouseCode());
            inspectionPassDto.setLogicWarehouseName(eo.getLogicWarehouseName());
            inspectionPassDto.setSupplierCode(eo.getSupplierCode());
            inspectionPassDto.setSupplierName(eo.getSupplierName());
            inspectionPassDto.setOrganizationCode(eo.getOrganizationCode());
            inspectionPassDto.setOrganizationName(eo.getOrganizationName());
            inspectionPassDto.setRelevanceNo(eo.getOrderNo());
            inspectionPassDto.setInventoryProperty(receiveDeliveryResultOrderDetailEo.getInventoryProperty());
            inspectionPassDto.setOrderType(eo.getOrderType());
            inspectionPassDto.setBusinessType(eo.getBusinessType());
            inspectionPassDto.setDocumentCode(eo.getOrderNo());
            inspectionPassDto.setConvedUnit(false);
            if (StringUtils.isNotBlank((CharSequence)eo.getExtension())) {
                Map extensionMap = Optional.ofNullable(com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.parseObject((String)eo.getExtension(), Map.class)).orElse(new HashMap());
                inspectionPassDto.setErpOrderNo((String)extensionMap.get("erpReturnNoticeNo"));
            }
            dtos.add(inspectionPassDto);
        }
        UnitTransferUtils.unitConvertBySingleOrder(dtos, (List)unitConversionRecordEos);
        if (CollectionUtils.isNotEmpty(dtos)) {
            this.inspectionPassService.batchGenerate(dtos);
        }
    }

    @NotNull
    private String getMapKey(String skuCode, String batch) {
        return skuCode + " " + batch;
    }

    @NotNull
    private String getMapKey(String k1, String k2, BigDecimal k3) {
        return k1 + " " + k2 + " " + k3;
    }
}

