/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.DateUtil;
import com.yunxi.dg.base.center.dict.dto.Schemas.DictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.bussiness.CsTransferDispatcherHandleStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.bussiness.CsTransferDispatcherStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.request.DispatcherOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.DispatcherOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.exception.InventoryExceptionCode;
import com.yunxi.dg.base.center.inventory.service.business.difforder.IDispatcherOrderService;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.DispatcherOperateWayEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TransferOrderDispatcherComponent {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderDispatcherComponent.class);
    @Resource
    private ITransferOrderDomain transferOrderDomain;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Resource
    private IDispatcherOrderService dispatcherOrderService;
    @Resource
    private IPcpDictQueryApiProxy pcpDictApiProxy;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private IDispatcherOrderDomain dispatcherOrderDomain;
    @Resource
    private IDispatcherOrderDetailDomain dispatcherOrderDetailDomain;

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public TransferOrderEo dispatcherTransferOrder(String transferOrderNo) {
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)transferOrderNo), (String)"\u8c03\u62e8\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
        AssertUtil.isTrue((null != transferOrderEo ? 1 : 0) != 0, (String)("\u5355\u53f7" + transferOrderNo + "\u4e0d\u5b58\u5728!"));
        log.info("\u8fdb\u884c\u6536\u53d1\u5dee\u5f02\u5904\u7406\u7684\u6311\u62e8\u5355\u8be6\u60c5\u662f:{}", (Object)JSON.toJSONString((Object)transferOrderEo));
        AssertUtil.isTrue((TransferOrderStatus.END.code().equals(transferOrderEo.getOrderStatus()) || TransferOrderStatus.COMPLETED.code().equals(transferOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u53ea\u6709\u5df2\u5b8c\u6210\u624d\u53ef\u4ee5\u8ba1\u7b97\u5dee\u5f02\uff01");
        if (StringUtils.isNotBlank((CharSequence)transferOrderEo.getDispatcherHandleStatus())) {
            return transferOrderEo;
        }
        List transferOrderDetailEos = this.transferOrderDetailDomain.queryByTransferOrderNo(transferOrderNo);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)transferOrderDetailEos), (String)"\u8c03\u62e8\u5355\u8be6\u60c5\u4e3a\u7a7a");
        this.dispatcher(transferOrderEo, transferOrderDetailEos);
        log.info("\u5224\u65ad\u662f\u5426\u81ea\u52a8\u751f\u6210\u6536\u53d1\u5dee\u5f02\u5355\u7684dict");
        if (CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode().equals(transferOrderEo.getDispatcherStatus())) {
            return transferOrderEo;
        }
        DictDto dictDto = this.pcpDictApiProxy.queryByGroupCodeAndCode("COMMON_CONFIG", "AUTO_CREATE_DISPATCHER");
        DictDto manuakCreate = this.pcpDictApiProxy.queryByGroupCodeAndCode("COMMON_CONFIG", "MANUAL_CREATE_TRANSFER");
        String orderSrc = transferOrderEo.getOrderSrc();
        log.info("\u5224\u65ad\u662f\u5426\u81ea\u52a8\u751f\u6210\u6536\u53d1\u5dee\u5f02\u5355\u7684dict:{},orderSrc:{},\u5224\u65ad\u662f\u5426\u624b\u52a8\u521b\u5efa\u7684\u8c03\u62e8\u5355\uff1a{}", new Object[]{JSON.toJSONString((Object)dictDto), orderSrc, JSON.toJSONString((Object)manuakCreate)});
        if (null != dictDto && InventoryExceptionCode.SUCCESS_CODE.getCode().equals(dictDto.getSubLabel()) && (manuakCreate == null || manuakCreate.getSubLabel().equals(orderSrc))) {
            try {
                this.dispatcherOrderService.calculateDifferencesDispatcher(transferOrderNo);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u81ea\u52a8\u751f\u6210\u5dee\u5f02\u5355\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            }
            log.info("\u6536\u53d1\u5dee\u5f02\u5904\u7406\u5b8c\u6210");
        }
        return transferOrderEo;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void handleDifferencesDispatcher(String transferOrderNo) {
        if (!InventoryConfig.isDispatchOrderEnable()) {
            return;
        }
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)transferOrderNo), (String)"\u8c03\u62e8\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
        AssertUtil.isTrue((null != transferOrderEo ? 1 : 0) != 0, (String)("\u5355\u53f7" + transferOrderNo + "\u4e0d\u5b58\u5728!"));
        if (CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode().equals(transferOrderEo.getDispatcherStatus())) {
            log.info("\u8c03\u62e8\u5355\u65e0\u5dee\u5f02\uff0c\u4e0d\u8fdb\u884c\u5904\u7406\uff01");
            return;
        }
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)transferOrderEo.getDispatcherHandleStatus()), (String)"\u8c03\u62e8\u5355\u53ea\u6709\u751f\u6210\u5dee\u5f02\u5355\u624d\u53ef\u4ee5\u5904\u7406\u5dee\u5f02\uff01");
        log.info("\u6267\u884c\u6536\u53d1\u5dee\u5f02\u5904\u7406\u7684\u6311\u62e8\u5355\u8be6\u60c5\u662f:{}", (Object)JSON.toJSONString((Object)transferOrderEo));
        List transferOrderDetailEos = this.transferOrderDetailDomain.queryByTransferOrderNo(transferOrderNo);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)transferOrderDetailEos), (String)"\u8c03\u62e8\u5355\u8be6\u60c5\u4e3a\u7a7a");
        List dispatcherOrderEos = ((ExtQueryChainWrapper)this.dispatcherOrderDomain.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dispatcherOrderEos), (String)("\u8c03\u62e8\u5355\u53f7" + transferOrderNo + "\u672a\u751f\u6210\u6536\u53d1\u5dee\u5f02\u5355\uff0c\u8bf7\u68c0\u67e5!"));
        for (DispatcherOrderEo orderEo : dispatcherOrderEos) {
            DispatcherOrderReqDto dispatcherOrderReqDto = this.buildDispatcherOrderReqDto(orderEo);
            log.info("\u81ea\u52a8\u5dee\u5f02\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)dispatcherOrderReqDto));
            this.dispatcherOrderService.handleDifferencesDispatcher(dispatcherOrderReqDto);
        }
    }

    public DispatcherOrderReqDto buildDispatcherOrderReqDto(DispatcherOrderEo orderEo) {
        if (orderEo == null) {
            return null;
        }
        List dispatcherOrderDetailEos = ((ExtQueryChainWrapper)this.dispatcherOrderDetailDomain.filter().eq((Object)"order_no", (Object)orderEo.getOrderNo())).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dispatcherOrderDetailEos), (String)("\u6536\u53d1\u5dee\u5f02\u5355" + orderEo.getOrderNo() + "\u8be6\u60c5\u4e3a\u7a7a!"));
        DispatcherOrderReqDto dispatcherOrderReqDto = new DispatcherOrderReqDto();
        dispatcherOrderReqDto.setOrderNo(orderEo.getOrderNo());
        dispatcherOrderReqDto.setBizDate(DateUtil.getCurrenDate());
        List dispatcherOrderDetailReqDtos = dispatcherOrderDetailEos.stream().map(x -> {
            DispatcherOrderDetailReqDto reqDto = (DispatcherOrderDetailReqDto)BeanUtil.copyProperties((Object)x, DispatcherOrderDetailReqDto.class, (String[])new String[0]);
            if ("less_dispatcher".equals(x.getBusinessType())) {
                reqDto.setDispatcherCause("less_warehouse_under_delivery");
                reqDto.setOperationWay(DispatcherOperateWayEnum.LESS_RETURN_TRANSFER.getCode());
            } else {
                reqDto.setDispatcherCause("more_warehouse_multiple_shipments");
                reqDto.setOperationWay(DispatcherOperateWayEnum.MORE_TRANSFER.getCode());
            }
            reqDto.setLiabilityProject("delivery_warehouse");
            reqDto.setRemark("\u81ea\u52a8\u5dee\u5f02\u5904\u7406");
            return reqDto;
        }).collect(Collectors.toList());
        dispatcherOrderReqDto.setDispatcherOrderDetailReqDtos(dispatcherOrderDetailReqDtos);
        return dispatcherOrderReqDto;
    }

    private void dispatcher(TransferOrderEo transferOrderEo, List<TransferOrderDetailEo> transferOrderDetailEos) {
        String transferOrderNo = transferOrderEo.getTransferOrderNo();
        List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEos = this.getInOutNoticeOrderDetailEos(transferOrderNo);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(csOutNoticeOrderDetailEos), (String)"\u5165\u5e93\u901a\u77e5\u5355\u8be6\u60c5\u4e3a\u7a7a");
        List<InOutResultOrderDetailEo> csOutResultOrderDetailEos = this.getInOutResultOrderDetailEos(transferOrderNo);
        transferOrderEo.setReceivelessQuantity(BigDecimal.ZERO);
        transferOrderEo.setOverchargeQuantity(BigDecimal.ZERO);
        Map<String, TransferOrderDetailEo> transferOrderDetailEoMap = transferOrderDetailEos.stream().collect(Collectors.toMap(a -> a.getSkuCode() + InventoryConfig.getCommonSeparate() + (!InventoryConfig.isDispatchOrderBatch() ? "" : StringUtils.upperCase((String)a.getBatch())), Function.identity(), (key1, key2) -> key2));
        Map<String, TransferOrderDetailEo> transferOrderDetailEoItemMap = transferOrderDetailEos.stream().collect(Collectors.toMap(TransferOrderDetailEo::getSkuCode, Function.identity(), (key1, key2) -> key2));
        Map inNoticeOrderDetailEoMap = csOutNoticeOrderDetailEos.stream().collect(Collectors.toMap(a -> a.getSkuCode() + InventoryConfig.getCommonSeparate() + TransferOrderDispatcherComponent.getBatch(a), Function.identity(), (key1, key2) -> key2));
        if (CollectionUtils.isEmpty(csOutResultOrderDetailEos)) {
            csOutResultOrderDetailEos = new ArrayList<InOutResultOrderDetailEo>();
        }
        Map<String, BigDecimal> ratioMap = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)transferOrderNo)).list().stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum(), (int)6), (o, o1) -> o));
        Map inResultOrderDetailEoMap = csOutResultOrderDetailEos.stream().collect(Collectors.toMap(a -> a.getSkuCode() + InventoryConfig.getCommonSeparate() + (!InventoryConfig.isDispatchOrderBatch() ? "" : StringUtils.upperCase((String)a.getBatch())), Function.identity(), (key1, key2) -> key2));
        HashMap<String, BigDecimal> lessMap = new HashMap<String, BigDecimal>(10);
        HashMap<String, BigDecimal> flowMap = new HashMap<String, BigDecimal>(10);
        this.calcLessFlow(csOutNoticeOrderDetailEos, csOutResultOrderDetailEos, ratioMap, lessMap, flowMap);
        log.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503ccsTransferOrderDetailEos1111:{}", (Object)JSON.toJSONString(transferOrderDetailEos));
        this.initMoreLine(transferOrderEo, csOutResultOrderDetailEos, transferOrderDetailEoMap, transferOrderDetailEoItemMap, ratioMap);
        log.info("\u8c03\u62e8\u5355\u8ba1\u7b97\u5dee\u5f02\u662f\u5426\u5f00\u542f\u5546\u54c1\u5355\u4f4d\u6362\u7b97\uff1a{}", (Object)InventoryConfig.isEnableUnit());
        if (InventoryConfig.isEnableUnit()) {
            this.volumeAndWeigtProcess(transferOrderEo, transferOrderDetailEos);
        }
        log.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503ccsTransferOrderDetailEos2222:{}", (Object)JSON.toJSONString(transferOrderDetailEos));
        transferOrderDetailEos.forEach(dto -> {
            log.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503cdto:{}", (Object)JSON.toJSONString((Object)dto));
            log.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503coutNoticeOrderDetailEoMap:{}", (Object)JSON.toJSONString((Object)inNoticeOrderDetailEoMap));
            log.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503coutResultOrderDetailEoMap:{}", (Object)JSON.toJSONString((Object)inResultOrderDetailEoMap));
            String key = dto.getSkuCode() + InventoryConfig.getCommonSeparate() + (!InventoryConfig.isDispatchOrderBatch() ? "" : StringUtils.upperCase((String)dto.getBatch()));
            log.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503ckey:{}", (Object)key);
            if (inNoticeOrderDetailEoMap.containsKey(key)) {
                InOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)inNoticeOrderDetailEoMap.get(key);
                if (inResultOrderDetailEoMap.containsKey(key)) {
                    BigDecimal flowVal = (BigDecimal)flowMap.get(key);
                    BigDecimal lessVal = (BigDecimal)lessMap.get(key);
                    dto.setDispatcherStatus(this.getDispatcherStatus(flowVal, lessVal));
                    dto.setDispatcherQuantity(flowVal);
                    dto.setDispatcherLessQuantity(BigDecimalUtils.multiply((BigDecimal)lessVal, (BigDecimal)new BigDecimal("-1")));
                    transferOrderEo.setReceivelessQuantity(BigDecimalUtils.add((BigDecimal)transferOrderEo.getReceivelessQuantity(), (BigDecimal)lessVal));
                    transferOrderEo.setOverchargeQuantity(BigDecimalUtils.add((BigDecimal)transferOrderEo.getOverchargeQuantity(), (BigDecimal)flowVal));
                } else {
                    log.info("key:{},\u8d70\u4e86\u5c11\u6536", (Object)key);
                    BigDecimal planQuantity = csOutNoticeOrderDetailEo.getPlanQuantity();
                    planQuantity = BigDecimalUtils.divide((BigDecimal)planQuantity, (BigDecimal)((BigDecimal)ratioMap.get(csOutNoticeOrderDetailEo.getSkuCode())), (int)6);
                    dto.setDispatcherStatus(this.getDispatcherStatus((null == dto.getDispatcherQuantity() ? BigDecimal.ZERO : dto.getDispatcherQuantity()).subtract(planQuantity)));
                    if (CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(dto.getDispatcherStatus())) {
                        dto.setDispatcherLessQuantity(BigDecimal.ZERO);
                        dto.setDispatcherQuantity((null == dto.getDispatcherQuantity() ? BigDecimal.ZERO : dto.getDispatcherQuantity()).subtract(planQuantity).abs());
                    } else if (CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode().equals(dto.getDispatcherStatus())) {
                        dto.setDispatcherLessQuantity((null == dto.getDispatcherQuantity() ? BigDecimal.ZERO : dto.getDispatcherQuantity()).subtract(planQuantity).abs());
                        dto.setDispatcherQuantity(BigDecimal.ZERO);
                    } else {
                        dto.setDispatcherLessQuantity(BigDecimal.ZERO);
                        dto.setDispatcherQuantity(BigDecimal.ZERO);
                    }
                    transferOrderEo.setReceivelessQuantity(transferOrderEo.getReceivelessQuantity().add(planQuantity));
                }
            }
            this.transferOrderDetailDomain.updateSelective((BaseEo)dto);
        });
        transferOrderEo.setDispatcherStatus(this.getDispatcherStatus(transferOrderEo.getOverchargeQuantity(), transferOrderEo.getReceivelessQuantity()));
        transferOrderEo.setDispatcherHandleStatus(CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode().equals(transferOrderEo.getDispatcherStatus()) ? CsTransferDispatcherHandleStatusEnum.NO_DISPATCHER.getCode() : CsTransferDispatcherHandleStatusEnum.WAIT_CREATE.getCode());
        log.info("\u66f4\u65b0\u8c03\u62e8\u4e3b\u5355\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)transferOrderEo));
        this.transferOrderDomain.updateTransferOrderDispatcher(transferOrderEo);
    }

    private void calcLessFlow(List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEos, List<InOutResultOrderDetailEo> csOutResultOrderDetailEos, Map<String, BigDecimal> ratioMap, Map<String, BigDecimal> lessMap, Map<String, BigDecimal> flowMap) {
        if (CollectionUtils.isNotEmpty(csOutResultOrderDetailEos)) {
            Map outNoticeOrderDetailCountMap = BeanUtil.copyToList(csOutNoticeOrderDetailEos, InOutNoticeOrderDetailEo.class).stream().collect(Collectors.toMap(a -> a.getDocumentNo() + InventoryConfig.getCommonSeparate() + a.getSkuCode() + InventoryConfig.getCommonSeparate() + TransferOrderDispatcherComponent.getBatch(a), Function.identity(), (key1, key2) -> {
                key2.setPlanQuantity(BigDecimalUtils.add((BigDecimal)key1.getPlanQuantity(), (BigDecimal)key2.getPlanQuantity()));
                return key2;
            }));
            Map<String, List<InOutResultOrderDetailEo>> outResultOrderDetailCountMap = csOutResultOrderDetailEos.stream().collect(Collectors.groupingBy(a -> a.getPreOrderNo() + InventoryConfig.getCommonSeparate() + a.getSkuCode() + InventoryConfig.getCommonSeparate() + (!InventoryConfig.isDispatchOrderBatch() ? "" : StringUtils.upperCase((String)a.getBatch()))));
            outNoticeOrderDetailCountMap.forEach((k, v) -> {
                String saveKey = v.getSkuCode() + InventoryConfig.getCommonSeparate() + (!InventoryConfig.isDispatchOrderBatch() ? "" : StringUtils.upperCase((String)v.getBatch()));
                BigDecimal ratio = (BigDecimal)ratioMap.get(v.getSkuCode());
                if (outResultOrderDetailCountMap.containsKey(k)) {
                    List inOutResultOrderDetailEos = (List)outResultOrderDetailCountMap.get(k);
                    BigDecimal reduce = inOutResultOrderDetailEos.stream().map(InOutResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal bigDecimal = BigDecimalUtils.subtract((BigDecimal)reduce, (BigDecimal)v.getPlanQuantity());
                    if (BigDecimalUtils.geZero((BigDecimal)bigDecimal).booleanValue()) {
                        flowMap.compute(saveKey, (ok, ov) -> BigDecimalUtils.add((BigDecimal)ov, (BigDecimal)BigDecimalUtils.divide((BigDecimal)bigDecimal, (BigDecimal)ratio, (int)6)));
                    } else {
                        lessMap.compute(saveKey, (ok, ov) -> BigDecimalUtils.add((BigDecimal)ov, (BigDecimal)BigDecimalUtils.divide((BigDecimal)bigDecimal.abs(), (BigDecimal)ratio, (int)6)));
                    }
                } else {
                    lessMap.compute(saveKey, (ok, ov) -> BigDecimalUtils.add((BigDecimal)ov, (BigDecimal)BigDecimalUtils.divide((BigDecimal)v.getPlanQuantity().abs(), (BigDecimal)ratio, (int)6)));
                }
            });
        }
    }

    private static String getBatch(InOutNoticeOrderDetailEo a) {
        return !InventoryConfig.isDispatchOrderBatch() ? "" : StringUtils.upperCase((String)a.getBatch());
    }

    private void initMoreLine(TransferOrderEo transferOrderEo, List<InOutResultOrderDetailEo> csOutResultOrderDetailEos, Map<String, TransferOrderDetailEo> transferOrderDetailEoMap, Map<String, TransferOrderDetailEo> transferOrderDetailEoItemMap, Map<String, BigDecimal> ratioMap) {
        if (CollectionUtils.isNotEmpty(csOutResultOrderDetailEos)) {
            Map<String, List<InOutResultOrderDetailEo>> map = csOutResultOrderDetailEos.stream().collect(Collectors.groupingBy(dto -> dto.getSkuCode() + InventoryConfig.getCommonSeparate() + (!InventoryConfig.isDispatchOrderBatch() ? "" : StringUtils.upperCase((String)dto.getBatch()))));
            List detailEos = map.entrySet().stream().filter(entry -> {
                InOutResultOrderDetailEo dto = (InOutResultOrderDetailEo)((List)entry.getValue()).get(0);
                String key = dto.getSkuCode() + InventoryConfig.getCommonSeparate() + (!InventoryConfig.isDispatchOrderBatch() ? "" : StringUtils.upperCase((String)dto.getBatch()));
                return !transferOrderDetailEoMap.containsKey(key);
            }).map(entry -> {
                InOutResultOrderDetailEo dto = (InOutResultOrderDetailEo)((List)entry.getValue()).get(0);
                BigDecimal ratio = (BigDecimal)ratioMap.get(dto.getSkuCode());
                AssertUtil.isTrue((boolean)transferOrderDetailEoItemMap.containsKey(dto.getSkuCode()), (String)("\u8c03\u62e8\u5355\u660e\u7ec6\u4e2d\u6ca1\u6709\u8be5\u7269\u6599" + dto.getSkuCode()));
                TransferOrderDetailEo eo = new TransferOrderDetailEo();
                BeanUtils.copyProperties(transferOrderDetailEoItemMap.get(dto.getSkuCode()), (Object)eo);
                eo.setId(null);
                eo.setDispatcherStatus(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                eo.setDispatcherQuantity(BigDecimalUtils.divide((BigDecimal)((List)entry.getValue()).stream().map(InOutResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add), (BigDecimal)ratio, (int)6));
                eo.setQuantity(BigDecimal.ZERO);
                eo.setDoneInQuantity(BigDecimal.ZERO);
                eo.setDoneOutQuantity(BigDecimal.ZERO);
                eo.setWaitOutQuantity(BigDecimal.ZERO);
                eo.setWaitInQuantity(BigDecimal.ZERO);
                eo.setQuantity(BigDecimal.ZERO);
                eo.setBatch(!InventoryConfig.isDispatchOrderBatch() ? "" : StringUtils.upperCase((String)dto.getBatch()));
                eo.setCreateTime(new Date());
                eo.setUpdateTime(new Date());
                log.info("\u8c03\u62e8\u5355{},\u65b0\u589e\u660e\u7ec6\u884c\uff1a{}", (Object)eo.getTransferOrderNo(), (Object)JSON.toJSONString((Object)eo));
                log.info("\u8c03\u62e8\u5355{},dto\uff1a{}", (Object)eo.getTransferOrderNo(), (Object)JSON.toJSONString((Object)dto));
                transferOrderEo.setOverchargeQuantity(transferOrderEo.getOverchargeQuantity().add(eo.getDispatcherQuantity()));
                return eo;
            }).collect(Collectors.toList());
            Optional.of(detailEos).filter(CollectionUtils::isNotEmpty).map(eos -> this.volumeAndWeigtProcess(transferOrderEo, (List<TransferOrderDetailEo>)eos)).ifPresent(arg_0 -> ((ITransferOrderDetailDomain)this.transferOrderDetailDomain).insertBatch(arg_0));
        }
    }

    @NotNull
    private List<TransferOrderDetailEo> volumeAndWeigtProcess(TransferOrderEo transferOrderEo, @NotEmpty List<TransferOrderDetailEo> eos) {
        IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
        calculateWeightAndVolumeBo.setVolumeDetailBos(eos.stream().map(eo -> {
            IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
            calculateWeightAndVolumeDetailBo.setQuantity(eo.getQuantity());
            calculateWeightAndVolumeDetailBo.setUnit(eo.getUnit());
            calculateWeightAndVolumeDetailBo.setSkuCode(eo.getSkuCode());
            return calculateWeightAndVolumeDetailBo;
        }).collect(Collectors.toList()));
        calculateWeightAndVolumeBo.setDocumentCode(transferOrderEo.getTransferOrderNo());
        Map<String, BasicOrderDtoExtension> volumeMap = this.orderUnitConversionRecordService.calculateWeightAndVolume(calculateWeightAndVolumeBo);
        eos.forEach(eo -> {
            BasicOrderDtoExtension dtoExtension = (BasicOrderDtoExtension)volumeMap.get(eo.getSkuCode() + InventoryConfig.getCommonSeparate() + eo.getQuantity());
            eo.setVolume(dtoExtension.getVolume());
            eo.setWeight(dtoExtension.getWeight());
        });
        return eos;
    }

    private List<InOutResultOrderDetailEo> getInOutResultOrderDetailEos(String transferOrderNo) {
        InOutResultOrderEo outResultOrderEo = new InOutResultOrderEo();
        outResultOrderEo.setRelevanceNo(transferOrderNo);
        outResultOrderEo.setDispatcherStatus(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
        List csOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.queryCsOutResultOrderDetailList(outResultOrderEo);
        return csOutResultOrderDetailEos;
    }

    private List<InOutNoticeOrderDetailEo> getInOutNoticeOrderDetailEos(String transferOrderNo) {
        InOutResultOrderDetailEo outResultOrderDetailEo = new InOutResultOrderDetailEo();
        outResultOrderDetailEo.setRelevanceNo(transferOrderNo);
        return this.inOutNoticeOrderDetailDomain.queryCsOutNoticeOrderDetailList(outResultOrderDetailEo);
    }

    private String getDispatcherStatus(BigDecimal overchargeQuantity, BigDecimal receivelessQuantity) {
        overchargeQuantity = null == overchargeQuantity ? BigDecimal.ZERO : overchargeQuantity;
        BigDecimal bigDecimal = receivelessQuantity = null == receivelessQuantity ? BigDecimal.ZERO : receivelessQuantity;
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) != 0 && receivelessQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.DISPATCHER.getCode();
        }
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) == 0 && receivelessQuantity.compareTo(BigDecimal.ZERO) == 0) {
            return CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode();
        }
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode();
        }
        if (receivelessQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode();
        }
        return null;
    }

    private String getDispatcherStatus(BigDecimal dispatcherQuantity) {
        BigDecimal bigDecimal = dispatcherQuantity = null == dispatcherQuantity ? BigDecimal.ZERO : dispatcherQuantity;
        if (dispatcherQuantity.compareTo(BigDecimal.ZERO) > 0) {
            return CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode();
        }
        if (dispatcherQuantity.compareTo(BigDecimal.ZERO) == 0) {
            return CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode();
        }
        if (dispatcherQuantity.compareTo(BigDecimal.ZERO) < 0) {
            return CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode();
        }
        return null;
    }
}

