/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.action;

import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderDispatcherComponent;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveEvent;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveState;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TransferOrderCompleteAction {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderCompleteAction.class);
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private ITransferOrderDas transferOrderDas;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Resource
    private TransferOrderDispatcherComponent transferOrderDispatcherComponent;

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void complete(StateContext<TransferOrderReceiveState, TransferOrderReceiveEvent> context) {
        log.info("\u6267\u884c\u5b8c\u7ed3action....");
        TransferOrderEo transferOrderEo = (TransferOrderEo)context.getExtendedState().get((Object)"transferOrderEo", TransferOrderEo.class);
        BaseOrderCommonCancelBo receiveDeliveryNoticeOrderContext = BaseOrderCommonCancelBo.builder().relevanceNo(transferOrderEo.getTransferOrderNo()).sourceType(transferOrderEo.getType()).build();
        this.baseOrderFacade.deliveryNoticeOrderCloseByRelevanceNo(receiveDeliveryNoticeOrderContext);
        this.baseOrderFacade.receiveNoticeOrderCloseByRelevanceNo(receiveDeliveryNoticeOrderContext);
        this.doComplete(transferOrderEo);
    }

    public void doComplete(TransferOrderEo transferOrderEo) {
        transferOrderEo.setOrderStatus(TransferOrderStatus.END.code());
        transferOrderEo.setDeliveryStatus(TransferOrderReceiveState.COMPLETED.getCode());
        if (TransferOrderReceiveState.getByCode((String)transferOrderEo.getDeliveryStatus()) == TransferOrderReceiveState.PARTIALLY_RECEIVED) {
            transferOrderEo.setDeliveryStatus(TransferOrderReceiveState.PARTIALLY_RECEIVED_COMPLETED.getCode());
        }
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
        this.transferOrderDetailDomain.statisticsDispatcherByTransferOrderNo(transferOrderEo.getTransferOrderNo(), true, InventoryConfig.isDispatchOrderBatch());
        this.transferOrderDispatcherComponent.dispatcherTransferOrder(transferOrderEo.getTransferOrderNo());
        if (InventoryConfig.isAutoHandleDispatchOrderEnable()) {
            this.transferOrderDispatcherComponent.handleDifferencesDispatcher(transferOrderEo.getTransferOrderNo());
        }
    }
}

