/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderAggDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.IAdjustmentOrderService;
import com.yunxi.dg.base.center.inventory.service.business.transfer.ITransferOrderAggService;
import com.yunxi.dg.base.center.inventory.service.business.transfer.ITransferOrderService;
import com.yunxi.dg.base.center.inventory.utils.DateUtils;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.trade.proxy.order.IOrderConfigQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransferOrderAggServiceImpl
implements ITransferOrderAggService {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderAggServiceImpl.class);
    @Resource(name="inventoryAdjustmentOrderServiceImpl")
    private IAdjustmentOrderService inventoryAdjustmentOrderService;
    @Resource
    private ITransferOrderService transferOrderService;
    @Resource
    private ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Resource
    private IOrderConfigQueryApiProxy orderConfigQueryApiProxy;
    private static final String ORDER_STATUS_FINISHED = "finished";
    private static final String ORDER_STATUS_COMPLETED = "completed";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> autoGenerateTransferOrder(TransferOrderAggDto transferOrderAggDto) {
        AdjustmentOrderDto adjustmentOrderReqDto = transferOrderAggDto.getAdjustmentOrderDto();
        TransferOrderComboReqDto transferOrderReqDto = transferOrderAggDto.getTransferOrderComboReqDto();
        this.reSetBizDate(transferOrderReqDto.getTransferOrderReqDto());
        if (transferOrderAggDto.getReverse().booleanValue()) {
            return this.processNormalOrder(adjustmentOrderReqDto, transferOrderReqDto);
        }
        return this.processReverseOrder(transferOrderReqDto, adjustmentOrderReqDto);
    }

    private void reSetBizDate(TransferOrderReqDto transferOrderReqDto) {
        if (TransferOrderTypeEnum.O_TO_O_TRANSFER.getCode().equals(transferOrderReqDto.getType()) || TransferOrderTypeEnum.REVERSE_O_TO_O_TRANSFER.getCode().equals(transferOrderReqDto.getType())) {
            log.info("\u8c03\u62e8\u5355:{}\u662f\u8c03\u62e8\u6c47\u603b\u5355,\u8fdb\u884c\u4e1a\u52a1\u65f6\u95f4\u68c0\u67e5", (Object)transferOrderReqDto.getTransferOrderNo());
            Date bizDate = transferOrderReqDto.getBizDate();
            int courtMonth = DateUtils.getMonth((Date)bizDate);
            int courtDay = DateUtils.getDate((Date)bizDate);
            Boolean verifyWarning = (Boolean)RestResponseHelper.extractData((RestResponse)this.orderConfigQueryApiProxy.verifyHqU9CheckoutWarning(Integer.valueOf(courtMonth), Integer.valueOf(courtDay)));
            if (verifyWarning.booleanValue()) {
                log.info("\u8c03\u62e8\u5355:{}\u7684\u4e1a\u52a1\u65e5\u671f\u5728\u9884\u8b66\u8303\u56f4\u5185,\u4e1a\u52a1\u65f6\u95f4\u8bbe\u7f6e\u6210\u4e0b\u4e2a\u6708", (Object)transferOrderReqDto.getTransferOrderNo());
                transferOrderReqDto.setBizDate(DateUtils.getMonthStart((Date)DateUtils.addMonth((Date)bizDate, (int)1)));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void commitTransferOrder(String orderNo) {
        TransferOrderRespDto transferOrderRespDto = (TransferOrderRespDto)RestResponseHelper.extractData(this.transferOrderService.detailByOrderNo(orderNo));
        TransferOrderKeyDto orderKeyDto = new TransferOrderKeyDto();
        orderKeyDto.setTransferOrderNo(orderNo);
        orderKeyDto.setAutoComplete(Boolean.valueOf(true));
        if (((Boolean)RestResponseHelper.extractData(this.transferOrderService.commit(orderKeyDto))).booleanValue()) {
            AdjustmentOrderDto adjustmentOrderReqDto = this.buildAdjustmentOrderReqDto(transferOrderRespDto);
            adjustmentOrderReqDto.setRemark(orderNo);
            Long adjustmentOrderId = this.inventoryAdjustmentOrderService.addAdjustmentOrder(adjustmentOrderReqDto);
            AdjustmentOrderDto adjustmentOrderDto = this.inventoryAdjustmentOrderService.queryById(adjustmentOrderId);
            if (adjustmentOrderDto != null && ORDER_STATUS_FINISHED.equals(adjustmentOrderDto.getOrderStatus())) {
                this.transferOrderService.updateRemarkById(transferOrderRespDto.getId(), adjustmentOrderDto.getAdjustmentNo());
                log.info("\u81ea\u52a8\u63d0\u4ea4\u8c03\u62e8\u5355\u4e14\u521b\u5efa\u8c03\u6574\u5355\u6d41\u7a0b\u6210\u529f");
            }
        }
    }

    private AdjustmentOrderDto buildAdjustmentOrderReqDto(TransferOrderRespDto transferOrderRespDto) {
        AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
        adjustmentOrderDto.setAdjustmentOrderDetailDtos(new ArrayList());
        adjustmentOrderDto.setEvent("audit_success");
        adjustmentOrderDto.setOrderType("INVENTORY_ADJUSTMENT");
        adjustmentOrderDto.setPushSap(Integer.valueOf(0));
        adjustmentOrderDto.setPushWms(Integer.valueOf(0));
        adjustmentOrderDto.setBusinessType("inventory_adjustment");
        adjustmentOrderDto.setBizDate(new Date());
        adjustmentOrderDto.setWarehouseCode(transferOrderRespDto.getInLogicWarehouseCode());
        adjustmentOrderDto.setWarehouseName(transferOrderRespDto.getInLogicWarehouseName());
        adjustmentOrderDto.setOrganizationCode(transferOrderRespDto.getInOrganizationCode());
        adjustmentOrderDto.setOrganizationName(transferOrderRespDto.getInOrganizationName());
        adjustmentOrderDto.setPhysicsWarehouseCode(transferOrderRespDto.getInPhysicsWarehouseCode());
        adjustmentOrderDto.setPhysicsWarehouseName(transferOrderRespDto.getInPhysicsWarehouseName());
        adjustmentOrderDto.setAdjustmentOrderDetailDtos(this.buildAdjustmentOrderDetailReqDto(transferOrderRespDto));
        return adjustmentOrderDto;
    }

    private List<AdjustmentOrderDetailDto> buildAdjustmentOrderDetailReqDto(TransferOrderRespDto transferOrderRespDto) {
        ArrayList<AdjustmentOrderDetailDto> details = new ArrayList<AdjustmentOrderDetailDto>();
        for (TransferOrderDetailReqDto reqDto : transferOrderRespDto.getDetailList()) {
            details.add(this.buildAdjustmentOrderDetailReq(transferOrderRespDto.getType(), reqDto));
        }
        return details;
    }

    public AdjustmentOrderDetailDto buildAdjustmentOrderDetailReq(String type, TransferOrderDetailReqDto reqDto) {
        AdjustmentOrderDetailDto detailDto = new AdjustmentOrderDetailDto();
        BeanUtil.copyProperties((Object)reqDto, (Object)detailDto, (String[])new String[0]);
        detailDto.setChangeType("increase");
        if (TransferOrderTypeEnum.REVERSE_O_TO_O_TRANSFER.getCode().equals(type)) {
            detailDto.setChangeType("decrease");
        }
        detailDto.setChangeQuantity(reqDto.getQuantity());
        return detailDto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> processReverseOrder(TransferOrderComboReqDto transferOrderComboReqDto, AdjustmentOrderDto adjustmentOrderReqDto) {
        List detailList = transferOrderComboReqDto.getDetailList();
        ArrayList commitDetailList = Lists.newArrayList();
        ArrayList auditDetailList = Lists.newArrayList();
        List skuCodes = detailList.stream().map(TransferOrderDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        String logicWarehouseCode = transferOrderComboReqDto.getTransferOrderReqDto().getOutLogicWarehouseCode();
        List logicInventoryTotalEos = this.logicInventoryTotalDomain.queryByWarehouseCodesAndSkuCodes((List)Lists.newArrayList((Object[])new String[]{logicWarehouseCode}), skuCodes, (List)Lists.newArrayList((Object[])new String[]{LogicWarehouseQualityEnum.QUALIFIED.getCode()}));
        Map<String, BigDecimal> logicInventoryTotalEoMap = logicInventoryTotalEos.stream().collect(Collectors.toMap(LogicInventoryTotalEo::getSkuCode, LogicInventoryTotalEo::getAvailable));
        for (TransferOrderDetailReqDto detail : detailList) {
            BigDecimal availbleInventory = logicInventoryTotalEoMap.get(detail.getSkuCode());
            if (availbleInventory == null || detail.getQuantity().compareTo(availbleInventory) > 0) {
                commitDetailList.add(detail);
                continue;
            }
            auditDetailList.add(detail);
        }
        ArrayList<String> transferOrderNos = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)commitDetailList)) {
            TransferOrderComboReqDto commitComboReqDto = (TransferOrderComboReqDto)BeanUtil.copyProperties((Object)transferOrderComboReqDto, TransferOrderComboReqDto.class, (String[])new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)auditDetailList)) {
                commitComboReqDto.getTransferOrderReqDto().setSettledTransferOrderNo(null);
            }
            commitComboReqDto.setCommitType("SAVE");
            commitComboReqDto.setDetailList((List)commitDetailList);
            Long transferOrderId = (Long)RestResponseHelper.extractData(this.transferOrderService.add(commitComboReqDto));
            TransferOrderRespDto transferOrderRespDto = (TransferOrderRespDto)RestResponseHelper.extractData(this.transferOrderService.detail(TransferOrderKeyDto.builder().id(transferOrderId).build()));
            transferOrderNos.add(transferOrderRespDto.getTransferOrderNo());
        }
        if (!CollectionUtils.isNotEmpty((Collection)auditDetailList)) return transferOrderNos;
        transferOrderComboReqDto.setCommitType("AUDIT");
        transferOrderComboReqDto.setDetailList((List)auditDetailList);
        transferOrderComboReqDto.setAutoComplete(Boolean.valueOf(true));
        Long transferOrderId = (Long)RestResponseHelper.extractData(this.transferOrderService.add(transferOrderComboReqDto));
        TransferOrderRespDto transferOrderRespDto = (TransferOrderRespDto)RestResponseHelper.extractData(this.transferOrderService.detail(TransferOrderKeyDto.builder().id(transferOrderId).build()));
        if (transferOrderRespDto == null || !TransferOrderStatus.COMPLETED.code().equals(transferOrderRespDto.getOrderStatus())) throw new BizException("\u81ea\u52a8\u521b\u5efa\u8c03\u62e8\u5355\u6d41\u7a0b\u5931\u8d25");
        adjustmentOrderReqDto.setRemark(transferOrderRespDto.getTransferOrderNo());
        Set skuCodeSet = auditDetailList.stream().map(TransferOrderDetailReqDto::getSkuCode).collect(Collectors.toSet());
        List oldList = adjustmentOrderReqDto.getAdjustmentOrderDetailDtos();
        ArrayList<AdjustmentOrderDetailDto> newList = new ArrayList<AdjustmentOrderDetailDto>();
        for (AdjustmentOrderDetailDto adjustmentOrderDetailDto : oldList) {
            if (!skuCodeSet.contains(adjustmentOrderDetailDto.getSkuCode())) continue;
            newList.add(adjustmentOrderDetailDto);
        }
        adjustmentOrderReqDto.setAdjustmentOrderDetailDtos(newList);
        log.info("\u5254\u9664\u6389\u8c03\u6574\u5355\u4e2d\u4e0d\u6ee1\u8db3\u5e93\u5b58\u7684sku\u540e\uff0c\u751f\u6210\u8c03\u6574\u5355\u7684\u660e\u7ec6\uff1a{}", (Object)JSONObject.toJSONString(newList));
        Long adjustmentOrderId = this.inventoryAdjustmentOrderService.addAdjustmentOrder(adjustmentOrderReqDto);
        AdjustmentOrderDto adjustmentOrderDto = this.inventoryAdjustmentOrderService.queryById(adjustmentOrderId);
        if (adjustmentOrderDto == null || !ORDER_STATUS_FINISHED.equals(adjustmentOrderDto.getOrderStatus())) throw new BizException("\u81ea\u52a8\u521b\u5efa\u8c03\u62e8\u5355\u6d41\u7a0b\u5931\u8d25");
        this.transferOrderService.updateRemarkById(transferOrderRespDto.getId(), adjustmentOrderDto.getAdjustmentNo());
        log.info("\u81ea\u52a8\u521b\u5efa\u8c03\u62e8\u5355\u6d41\u7a0b\u6210\u529f");
        transferOrderNos.add(transferOrderRespDto.getTransferOrderNo());
        return transferOrderNos;
    }

    private List<String> processNormalOrder(AdjustmentOrderDto adjustmentOrderReqDto, TransferOrderComboReqDto transferOrderReqDto) {
        transferOrderReqDto.setAutoComplete(Boolean.valueOf(true));
        Long adjustmentOrderId = this.inventoryAdjustmentOrderService.addAdjustmentOrder(adjustmentOrderReqDto);
        AdjustmentOrderDto adjustmentOrderDto = this.inventoryAdjustmentOrderService.queryById(adjustmentOrderId);
        if (adjustmentOrderDto != null && ORDER_STATUS_FINISHED.equals(adjustmentOrderDto.getOrderStatus())) {
            transferOrderReqDto.getTransferOrderReqDto().setRemark(adjustmentOrderDto.getAdjustmentNo());
            Long transferOrderId = (Long)RestResponseHelper.extractData(this.transferOrderService.add(transferOrderReqDto));
            TransferOrderRespDto transferOrderRespDto = (TransferOrderRespDto)RestResponseHelper.extractData(this.transferOrderService.detail(TransferOrderKeyDto.builder().id(transferOrderId).build()));
            if (transferOrderRespDto != null && TransferOrderStatus.COMPLETED.code().equals(transferOrderRespDto.getOrderStatus())) {
                this.inventoryAdjustmentOrderService.updateRemarkById(adjustmentOrderId, transferOrderRespDto.getTransferOrderNo());
                log.info("\u81ea\u52a8\u521b\u5efa\u8c03\u62e8\u5355\u6d41\u7a0b\u6210\u529f");
                return Collections.singletonList(transferOrderRespDto.getTransferOrderNo());
            }
            throw new BizException("\u81ea\u52a8\u521b\u5efa\u8c03\u62e8\u5355\u6d41\u7a0b\u5931\u8d25");
        }
        throw new BizException("\u81ea\u52a8\u521b\u5efa\u8c03\u62e8\u5355\u6d41\u7a0b\u5931\u8d25");
    }
}

