/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.helper;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.persist.StateMachinePersister;
import org.springframework.stereotype.Component;

@Component
public class TransferOrderDeliveryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferOrderDeliveryHelper.class);
    @Resource
    private ILockService lockService;
    @Resource
    private StateMachineFactory<TransferOrderDeliveryState, TransferOrderDeliveryEvent> deliveryStateMachineFactory;
    @Autowired
    private StateMachinePersister<TransferOrderDeliveryState, TransferOrderDeliveryEvent, String> deliveryStateMachinePersister;

    public synchronized boolean waitingForShipmentWithdraw(String transferOrderNo) {
        Mutex finalLock;
        String key = "STATEMACHINE:EXECUTOR:" + transferOrderNo;
        int i = 60;
        Mutex lock = null;
        StateMachine deliveryStateMachine = this.deliveryStateMachineFactory.getStateMachine(transferOrderNo);
        boolean result = false;
        try {
            lock = this.lockService.lock(key, "1", i, i * 2, TimeUnit.SECONDS);
            deliveryStateMachine.start();
            this.deliveryStateMachinePersister.restore(deliveryStateMachine, (Object)transferOrderNo);
            deliveryStateMachine.getExtendedState().getVariables().put("transferOrderNo", transferOrderNo);
            String preStatus = ((TransferOrderDeliveryState)deliveryStateMachine.getState().getId()).getCode();
            result = deliveryStateMachine.sendEvent((Object)TransferOrderDeliveryEvent.WAITING_FOR_DELIVERY_WITHDRAW);
            LOGGER.info("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u53d1\u8d27\u72b6\u6001\u673a", preStatus, TransferOrderDeliveryEvent.WAITING_FOR_DELIVERY_WITHDRAW.getDesc(), result});
            String errMsg = (String)deliveryStateMachine.getExtendedState().getVariables().get("errMsg");
            if (result && StringUtils.isEmpty((CharSequence)errMsg)) {
                this.deliveryStateMachinePersister.persist(deliveryStateMachine, (Object)transferOrderNo);
            } else {
                LOGGER.info("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u53d1\u8d27\u72b6\u6001\u673a", preStatus, TransferOrderDeliveryEvent.WAITING_FOR_DELIVERY_WITHDRAW.getDesc(), false});
                if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                    throw new BizException(errMsg);
                }
            }
            finalLock = lock;
        }
        catch (Exception e) {
            try {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
                throw new BizException(e.getMessage());
            }
            catch (Throwable throwable) {
                Mutex finalLock2 = lock;
                InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
                deliveryStateMachine.stop();
                throw throwable;
            }
        }
        InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
        deliveryStateMachine.stop();
        return result;
    }

    public synchronized boolean sendEvent(TransferOrderDeliveryEvent event, String transferOrderNo) {
        Mutex finalLock;
        String key = "STATEMACHINE:EXECUTOR:" + transferOrderNo;
        int i = 60;
        Mutex lock = null;
        StateMachine deliveryStateMachine = this.deliveryStateMachineFactory.getStateMachine(transferOrderNo);
        boolean result = false;
        try {
            lock = this.lockService.lock(key, "1", i, i * 2, TimeUnit.SECONDS);
            deliveryStateMachine.start();
            this.deliveryStateMachinePersister.restore(deliveryStateMachine, (Object)transferOrderNo);
            deliveryStateMachine.getExtendedState().getVariables().put("transferOrderNo", transferOrderNo);
            String preStatus = ((TransferOrderDeliveryState)deliveryStateMachine.getState().getId()).getCode();
            result = deliveryStateMachine.sendEvent((Object)event);
            LOGGER.info("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u53d1\u8d27\u72b6\u6001\u673a", preStatus, event.getDesc(), result});
            String errMsg = (String)deliveryStateMachine.getExtendedState().getVariables().get("errMsg");
            if (result && StringUtils.isEmpty((CharSequence)errMsg)) {
                this.deliveryStateMachinePersister.persist(deliveryStateMachine, (Object)transferOrderNo);
            } else {
                LOGGER.info("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u53d1\u8d27\u72b6\u6001\u673a", preStatus, TransferOrderDeliveryEvent.WAITING_FOR_DELIVERY_WITHDRAW.getDesc(), false});
                if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                    throw new BizException(errMsg);
                }
            }
            finalLock = lock;
        }
        catch (Exception e) {
            try {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
                throw new BizException(e.getMessage());
            }
            catch (Throwable throwable) {
                Mutex finalLock2 = lock;
                InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
                deliveryStateMachine.stop();
                throw throwable;
            }
        }
        InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
        deliveryStateMachine.stop();
        return result;
    }
}

