/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.helper;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveEvent;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveState;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.persist.StateMachinePersister;
import org.springframework.stereotype.Component;

@Component
public class TransferOrderReceiveHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferOrderReceiveHelper.class);
    @Resource
    private StateMachineFactory<TransferOrderReceiveState, TransferOrderReceiveEvent> deliveryStateMachineFactory;
    @Autowired
    private StateMachinePersister<TransferOrderReceiveState, TransferOrderReceiveEvent, String> persister;
    @Resource
    private ILockService lockService;

    public boolean sendEvent(TransferOrderReceiveEvent event, TransferOrderEo transferOrderEo) {
        Mutex finalLock;
        StateMachine deliveryStateMachine = this.deliveryStateMachineFactory.getStateMachine(transferOrderEo.getTransferOrderNo());
        String key = "STATEMACHINE:EXECUTOR:" + transferOrderEo.getTransferOrderNo();
        int i = 60;
        Mutex lock = null;
        boolean result = false;
        try {
            lock = this.lockService.lock(key, "1", i, i * 2, TimeUnit.SECONDS);
            deliveryStateMachine.start();
            this.persister.restore(deliveryStateMachine, (Object)transferOrderEo.getTransferOrderNo());
            deliveryStateMachine.getExtendedState().getVariables().put("transferOrderEo", transferOrderEo);
            String preStatus = ((TransferOrderReceiveState)deliveryStateMachine.getState().getId()).getCode();
            result = deliveryStateMachine.sendEvent((Object)event);
            String errMsg = (String)deliveryStateMachine.getExtendedState().getVariables().get("errMsg");
            if (result && StringUtils.isEmpty((CharSequence)errMsg)) {
                this.persister.persist(deliveryStateMachine, (Object)transferOrderEo.getTransferOrderNo());
            } else {
                LOGGER.info("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u53d1\u8d27\u72b6\u6001\u673a", preStatus, TransferOrderDeliveryEvent.WAITING_FOR_DELIVERY_WITHDRAW.getDesc(), false});
                if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                    throw new BizException(errMsg);
                }
            }
            finalLock = lock;
        }
        catch (Exception e) {
            try {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
                throw new BizException(e.getMessage());
            }
            catch (Throwable throwable) {
                Mutex finalLock2 = lock;
                InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
                deliveryStateMachine.stop();
                throw throwable;
            }
        }
        InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
        deliveryStateMachine.stop();
        return result;
    }
}

