/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.IFormInAble;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FormInAbleImpl
extends BaseAble
implements IFormInAble {
    private static final Logger log = LoggerFactory.getLogger(FormInAbleImpl.class);

    @Override
    public void formIn(FormInDto dto) {
        dto.setValidNegative(Boolean.FALSE);
        log.info("warehouse inventory formIn(\u5355\u636e\u5165\u5e93), param:{}", (Object)JSON.toJSONString((Object)dto));
        dto.setNoneBatch(Boolean.valueOf(false));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        ArrayList details = Lists.newArrayList();
        details.addAll(dto.getDetails());
        if (!dto.getIgnoreFutureIn().booleanValue()) {
            this.checkDetails(dto.getReleaseDetails());
            details.addAll(dto.getReleaseDetails());
        }
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(details);
        this.checkSku(details);
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto, (source, target) -> {
            if (InventoryConfig.isPreemptHiddenBatch() && "99999999-hidden".equals(source.getBatch())) {
                target.setValidNegative(Boolean.valueOf(false));
            }
            target.setChangeBalance(source.getNum());
            target.setChangeAvailable(source.getNum());
        });
        if (!dto.getIgnoreFutureIn().booleanValue()) {
            dto.getReleaseDetails().forEach(r -> {
                CalcInventoryDetailDto logicTotalDetail = new CalcInventoryDetailDto();
                logicTotalDetail.setChangeFutureIn(r.getNum().negate());
                logicTotalDetail.setSkuCode(r.getSkuCode());
                logicTotalDetail.setValidNegative(Boolean.valueOf(false));
                logicTotalDetail.setBatch(r.getBatch());
                logicTotalDetail.setInventoryProperty(r.getInventoryProperty());
                logicTotalDetail.setWarehouseCode(r.getLogicWarehouseCode());
                logicTotalDetail.setOperate("\u91ca\u653e\u5f85\u6536");
                logicCalcDto.getDetails().add(logicTotalDetail);
            });
            this.inventoryDueInDomain.insertBatch(this.transferDueIn(dto.getReleaseDetails(), dto.getSourceNo()));
        }
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }
}

