/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.IReleasePreemptAble;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReleasePreemptAbleImpl
extends BaseAble
implements IReleasePreemptAble {
    private static final Logger log = LoggerFactory.getLogger(ReleasePreemptAbleImpl.class);

    @Override
    public void releasePreempt(ReleasePreemptDto dto) {
        List inventoryUsageRecordEos;
        log.info("warehouse inventory releasePreempt(\u91ca\u653e\u9884\u5360), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        dto.setAllRelease((Boolean)ObjectUtil.defaultIfNull((Object)dto.getAllRelease(), (Object)true));
        dto.setEmptyForError((Boolean)ObjectUtil.defaultIfNull((Object)dto.getEmptyForError(), (Object)true));
        if (!dto.getAllRelease().booleanValue()) {
            this.checkDetails((CalcDto)dto);
        }
        if (null == dto.getIsSaleOrder()) {
            dto.setIsSaleOrder(Boolean.FALSE);
        }
        if (CollectionUtil.isEmpty((Collection)(inventoryUsageRecordEos = this.inventoryPreemptionDomain.queryBySourceNos((List)Lists.newArrayList((Object[])dto.getSourceNo().split(",")))))) {
            if (!dto.getEmptyForError().booleanValue()) {
                return;
            }
            throw new BizException(StrUtil.format((CharSequence)"\u8be5\u5355\u636e[%s]\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55", (Object[])new Object[]{dto.getSourceNo()}));
        }
        dto.setExternalOrderNo(((InventoryUsageRecordEo)inventoryUsageRecordEos.get(0)).getExternalOrderNo());
        this.releasePreemptAndSetDetail(dto, inventoryUsageRecordEos);
        this.doRelease(dto);
    }

    private void doRelease(ReleasePreemptDto dto) {
        List details = dto.getDetails();
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(details);
        this.checkSku(details);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    private CalcInventoryDto createLogicCalcDto(ReleasePreemptDto dto) {
        CalcInventoryDto calcInventoryDto = this.createLogicCalcDto(dto, (source, target) -> {
            target.setChangeAvailable(source.getNum());
            target.setChangePreempt(BigDecimalUtils.negate((BigDecimal)source.getNum()));
            target.setPreemptId(source.getPreemptId());
            target.setSourceNo(source.getSourceNo());
            target.setSourceType(source.getSourceType());
            target.setBusinessType(source.getBusinessType());
            target.setBeforePreemptNum(source.getBeforePreemptNum());
            target.setAfterPreemptNum(source.getAfterPreemptNum());
            if (dto.getIsSaleOrder().booleanValue()) {
                target.setChangeAllocate(BigDecimalUtils.negate((BigDecimal)source.getNum()));
            }
        });
        calcInventoryDto.setValidNegative(Boolean.valueOf(false));
        return calcInventoryDto;
    }
}

