/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.ITransferInAble;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransferInAbleImpl
extends BaseAble
implements ITransferInAble {
    private static final Logger log = LoggerFactory.getLogger(TransferInAbleImpl.class);

    @Override
    public void transferIn(TransferInDto dto) {
        log.info("warehouse inventory transferIn(\u8c03\u62e8\u5165\u5e93), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        List details = dto.getDetails();
        this.checkSku(details);
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(details);
        if (CollectionUtil.isNotEmpty((Collection)dto.getReleaseDetails())) {
            this.inventoryDueInDomain.insertBatch(this.transferDecrDueIn(dto.getReleaseDetails(), (String)DataExtractUtils.ifNullElse((Object)dto.getTransferOrderNo(), (Object)dto.getSourceNo())));
        }
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    private CalcInventoryDto createLogicCalcDto(TransferInDto dto) {
        CalcInventoryDto calcInventoryDto = this.createLogicCalcDto(dto, (source, target) -> {
            target.setOperate(dto.getDesc() + "-\u5165\u5e93");
            target.setChangeBalance(source.getNum());
            target.setChangeAvailable(source.getNum());
            target.setValidNegative(Boolean.valueOf(false));
        });
        calcInventoryDto.setValidNegative(Boolean.valueOf(false));
        for (CalcDetailDto releaseDetail : dto.getReleaseDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc() + "-\u91ca\u653e\u5728\u9014");
            detailDto.setChangeIntransit(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
            detailDto.setWarehouseCode(releaseDetail.getLogicWarehouseCode());
            detailDto.setSkuCode(releaseDetail.getSkuCode());
            detailDto.setBatch(releaseDetail.getBatch());
            detailDto.setInventoryProperty(releaseDetail.getInventoryProperty());
            detailDto.setValidNegative(Boolean.valueOf(false));
            calcInventoryDto.getDetails().add(detailDto);
        }
        return calcInventoryDto;
    }
}

