/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.ReceiveDeliveryNoticeOrderConverter;
import com.yunxi.dg.base.center.inventory.dao.mapper.LogicWarehouseMapper;
import com.yunxi.dg.base.center.inventory.dao.mapper.RelWarehouseShipmentMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderExtRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OrderUpdateShipmentInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.entity.IReceiveDeliveryNoticeOrderService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReceiveDeliveryNoticeOrderServiceImpl
extends BaseServiceImpl<ReceiveDeliveryNoticeOrderDto, ReceiveDeliveryNoticeOrderEo, IReceiveDeliveryNoticeOrderDomain>
implements IReceiveDeliveryNoticeOrderService {
    private static final Logger log = LoggerFactory.getLogger(ReceiveDeliveryNoticeOrderServiceImpl.class);
    @Resource
    private RelWarehouseShipmentMapper relWarehouseShipmentMapper;
    @Resource
    private LogicWarehouseMapper logicWarehouseMapper;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;

    public ReceiveDeliveryNoticeOrderServiceImpl(IReceiveDeliveryNoticeOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ReceiveDeliveryNoticeOrderDto, ReceiveDeliveryNoticeOrderEo> converter() {
        return ReceiveDeliveryNoticeOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Boolean updateOrderShipmentInfo(OrderUpdateShipmentInfoReqDto orderUpdateShipmentInfoReqDto) {
        log.info("updateOrderShipmentInfo==>\u66f4\u65b0\u8ba2\u5355\u7269\u6d41\u4fe1\u606f,orderUpdateShipmentInfoReqDto:{}", (Object)LogUtils.buildLogContent((Object)orderUpdateShipmentInfoReqDto));
        AssertUtil.isTrue((null != orderUpdateShipmentInfoReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String orderNo = orderUpdateShipmentInfoReqDto.getOrderNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u8ba2\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        orderUpdateShipmentInfoReqDto.setShipmentEnterpriseCode((String)ObjectUtils.defaultIfNull((Object)orderUpdateShipmentInfoReqDto.getShipmentEnterpriseCode(), (Object)""));
        orderUpdateShipmentInfoReqDto.setShipmentEnterpriseName((String)ObjectUtils.defaultIfNull((Object)orderUpdateShipmentInfoReqDto.getShipmentEnterpriseName(), (Object)""));
        String shipmentEnterpriseCode = orderUpdateShipmentInfoReqDto.getShipmentEnterpriseCode();
        String shipmentEnterpriseName = orderUpdateShipmentInfoReqDto.getShipmentEnterpriseName();
        QueryWrapper csDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        List csDeliveryNoticeOrderEoList = ((IReceiveDeliveryNoticeOrderDomain)this.domain).getMapper().selectList((Wrapper)csDeliveryNoticeOrderEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csDeliveryNoticeOrderEoList)) {
            return Boolean.TRUE;
        }
        ReceiveDeliveryNoticeOrderEo csDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)csDeliveryNoticeOrderEoList.get(0);
        csDeliveryNoticeOrderEo.setShipmentEnterpriseCode(shipmentEnterpriseCode);
        csDeliveryNoticeOrderEo.setShipmentEnterpriseName(shipmentEnterpriseName);
        csDeliveryNoticeOrderEo.setShippingType((String)ObjectUtils.defaultIfNull((Object)orderUpdateShipmentInfoReqDto.getTransportTypeCode(), (Object)""));
        csDeliveryNoticeOrderEo.setOrderSyncDate(orderUpdateShipmentInfoReqDto.getOrderSyncDate());
        csDeliveryNoticeOrderEo.setTransportStyle(orderUpdateShipmentInfoReqDto.getTransportStyle() == null ? null : String.valueOf(orderUpdateShipmentInfoReqDto.getTransportStyle()));
        csDeliveryNoticeOrderEoQueryWrapper.clear();
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)csDeliveryNoticeOrderEo.getId());
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ((IReceiveDeliveryNoticeOrderDomain)this.domain).getMapper().updateAll((BaseEo)csDeliveryNoticeOrderEo, (Wrapper)csDeliveryNoticeOrderEoQueryWrapper);
        InOutNoticeOrderEo inOutNoticeOrderEo = new InOutNoticeOrderEo();
        QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderEo.setShipmentEnterpriseCode(shipmentEnterpriseCode);
        inOutNoticeOrderEo.setShipmentEnterpriseName(shipmentEnterpriseName);
        inOutNoticeOrderEo.setShippingType(orderUpdateShipmentInfoReqDto.getTransportTypeCode());
        inOutNoticeOrderEo.setTransportStyle(orderUpdateShipmentInfoReqDto.getTransportStyle() == null ? null : String.valueOf(orderUpdateShipmentInfoReqDto.getTransportStyle()));
        inOutNoticeOrderEoQueryWrapper.eq((Object)"pre_order_no", (Object)csDeliveryNoticeOrderEo.getDocumentNo());
        inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        this.inOutNoticeOrderDomain.getMapper().update((Object)inOutNoticeOrderEo, (Wrapper)inOutNoticeOrderEoQueryWrapper);
        return Boolean.TRUE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void updateOrderShipmentInfoBatch(List<OrderUpdateShipmentInfoReqDto> orderUpdateShipmentInfoReqDtoList) {
        log.info("updateOrderShipmentInfoBatch==>\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u7269\u6d41\u4fe1\u606f,orderUpdateShipmentInfoReqDto:{}", (Object)LogUtils.buildLogContent(orderUpdateShipmentInfoReqDtoList));
        if (CollectionUtils.isEmpty(orderUpdateShipmentInfoReqDtoList)) {
            return;
        }
        orderUpdateShipmentInfoReqDtoList.stream().collect(Collectors.groupingBy(r -> String.join((CharSequence)InventoryConfig.getCommonSeparate(), r.getShipmentEnterpriseCode(), r.getTransportTypeCode()))).forEach((k, v) -> {
            OrderUpdateShipmentInfoReqDto orderUpdateShipmentInfoReqDto = (OrderUpdateShipmentInfoReqDto)v.get(0);
            Set set = v.stream().flatMap(r -> ((List)Optional.ofNullable(r.getOrderNos()).orElse(new ArrayList())).stream()).collect(Collectors.toSet());
            Set documentSet = v.stream().flatMap(r -> ((List)Optional.ofNullable(r.getDocumentNos()).orElse(new ArrayList())).stream()).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(set) && CollectionUtils.isEmpty(documentSet)) {
                return;
            }
            ReceiveDeliveryNoticeOrderEo noticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
            noticeOrderEo.setShipmentEnterpriseCode(orderUpdateShipmentInfoReqDto.getShipmentEnterpriseCode());
            noticeOrderEo.setShipmentEnterpriseName(orderUpdateShipmentInfoReqDto.getShipmentEnterpriseName());
            noticeOrderEo.setShippingType(orderUpdateShipmentInfoReqDto.getTransportTypeCode());
            UpdateWrapper deliveryNoticeOrderEoUpdateWrapper = new UpdateWrapper();
            deliveryNoticeOrderEoUpdateWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            if (CollectionUtils.isNotEmpty(set)) {
                deliveryNoticeOrderEoUpdateWrapper.in((Object)"relevance_no", set);
            } else {
                deliveryNoticeOrderEoUpdateWrapper.in((Object)"document_no", documentSet);
            }
            deliveryNoticeOrderEoUpdateWrapper.set((Object)"order_sync_date", null);
            deliveryNoticeOrderEoUpdateWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
            ((IReceiveDeliveryNoticeOrderDomain)this.domain).getMapper().update((Object)noticeOrderEo, (Wrapper)deliveryNoticeOrderEoUpdateWrapper);
        });
    }

    @Override
    public List<ReceiveDeliveryNoticeOrderExtRespDto> queryByOrderSyncDate(ReceiveDeliveryNoticeOrderPageReqDto dto) {
        List receiveDeliveryNoticeOrderExtRespList = ((IReceiveDeliveryNoticeOrderDomain)this.domain).queryByOrderSyncDate(dto);
        if (CollectionUtils.isEmpty((Collection)receiveDeliveryNoticeOrderExtRespList)) {
            return new ArrayList<ReceiveDeliveryNoticeOrderExtRespDto>();
        }
        List relevanceNo = receiveDeliveryNoticeOrderExtRespList.stream().map(ReceiveDeliveryNoticeOrderDto::getRelevanceNo).collect(Collectors.toList());
        List unitConversionRecordEoList = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in((Object)"document_code", relevanceNo)).list();
        Map unitConversionMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, Function.identity(), (o2, o1) -> o2));
        receiveDeliveryNoticeOrderExtRespList.forEach(item -> {
            OrderUnitConversionRecordEo orderUnitConversionRecordEo = (OrderUnitConversionRecordEo)unitConversionMap.get(item.getSkuCode());
            if (orderUnitConversionRecordEo != null) {
                item.setUnit(orderUnitConversionRecordEo.getUnit());
                item.setBasicUnit(orderUnitConversionRecordEo.getToUnit());
                item.setItemNum(UnitTransferUtils.pareSaleNum((BigDecimal)item.getPlanQuantity(), (OrderUnitConversionRecordDto)((OrderUnitConversionRecordDto)BeanUtil.copyProperties(unitConversionMap.get(item.getSkuCode()), OrderUnitConversionRecordDto.class, (String[])new String[0])), (boolean)false));
            }
        });
        return receiveDeliveryNoticeOrderExtRespList;
    }

    @Override
    public PageInfo<ReceiveDeliveryNoticeOrderExtRespDto> queryByOrderSyncDatePage(ReceiveDeliveryNoticeOrderPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo deliveryOutRespDtoPageInfo = new PageInfo(((IReceiveDeliveryNoticeOrderDomain)this.domain).queryByOrderSyncDate(dto));
        if (CollectionUtils.isEmpty((Collection)deliveryOutRespDtoPageInfo.getList())) {
            return deliveryOutRespDtoPageInfo;
        }
        List relevanceNo = deliveryOutRespDtoPageInfo.getList().stream().map(ReceiveDeliveryNoticeOrderDto::getRelevanceNo).collect(Collectors.toList());
        List unitConversionRecordEoList = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in((Object)"document_code", relevanceNo)).list();
        Map unitConversionMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, Function.identity(), (o2, o1) -> o2));
        deliveryOutRespDtoPageInfo.getList().forEach(item -> {
            OrderUnitConversionRecordEo orderUnitConversionRecordEo = (OrderUnitConversionRecordEo)unitConversionMap.get(item.getSkuCode());
            if (orderUnitConversionRecordEo != null) {
                item.setUnit(orderUnitConversionRecordEo.getUnit());
                item.setBasicUnit(orderUnitConversionRecordEo.getToUnit());
                item.setItemNum(UnitTransferUtils.pareSaleNum((BigDecimal)item.getPlanQuantity(), (OrderUnitConversionRecordDto)((OrderUnitConversionRecordDto)BeanUtil.copyProperties(unitConversionMap.get(item.getSkuCode()), OrderUnitConversionRecordDto.class, (String[])new String[0])), (boolean)false));
            }
        });
        return deliveryOutRespDtoPageInfo;
    }
}

