/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsValidFlagEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.dao.das.RelWarehouseShipmentDas;
import com.yunxi.dg.base.center.inventory.dao.mapper.RelWarehouseShipmentMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.RelWarehouseShipmentPageQueryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.RelWarehouseShipmentParamQueryDto;
import com.yunxi.dg.base.center.inventory.dto.request.other.RelWarehouseShipmentAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.other.RelWarehouseShipmentGenerateDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.other.RelWarehouseShipmentGenerateReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.other.RelWarehouseShipmentUpdateReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.other.RelWarehouseShipmentDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.other.RelWarehouseShipmentPageRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.other.RelWarehouseShipmentParticularsRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.other.RelWarehouseShipmentRespDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseShipmentEo;
import com.yunxi.dg.base.center.inventory.exception.InventoryExceptionCode;
import com.yunxi.dg.base.center.inventory.service.entity.IRelWarehouseShipmentService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RelWarehouseShipmentServiceImpl
implements IRelWarehouseShipmentService {
    private static Logger logger = LoggerFactory.getLogger(RelWarehouseShipmentServiceImpl.class);
    @Autowired
    private RelWarehouseShipmentDas relWarehouseShipmentDas;
    @Autowired
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    private RelWarehouseShipmentMapper relWarehouseShipmentMapper;

    @Override
    public Long add(RelWarehouseShipmentAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)addReqDto));
        AssertUtil.isTrue((addReqDto != null ? 1 : 0) != 0, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        RelWarehouseShipmentEo insertEo = RelWarehouseShipmentEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.relWarehouseShipmentDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, RelWarehouseShipmentUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent((Object)updateReqDto));
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue((updateReqDto != null ? 1 : 0) != 0, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        RelWarehouseShipmentEo updateEo = RelWarehouseShipmentEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.relWarehouseShipmentDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u53c2\u6570\u6709\u8bef");
        RelWarehouseShipmentEo eo = (RelWarehouseShipmentEo)this.relWarehouseShipmentDas.selectByPrimaryKey(id);
        AssertUtil.isTrue((eo != null ? 1 : 0) != 0, (String)InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.relWarehouseShipmentDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Boolean generateRelInfo(RelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        logger.info("generateRelInfo==>\u65b0\u589e\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f,relWarehouseShipmentGenerateReqDto:{}", (Object)LogUtils.buildLogContent((Object)relWarehouseShipmentGenerateReqDto));
        this.checkParams(relWarehouseShipmentGenerateReqDto);
        this.checkRepetition(relWarehouseShipmentGenerateReqDto);
        List detailReqDtoList = relWarehouseShipmentGenerateReqDto.getDetailReqDtoList();
        ArrayList relWarehouseShipmentEoList = Lists.newArrayList();
        for (RelWarehouseShipmentGenerateDetailReqDto detailReqDto : detailReqDtoList) {
            RelWarehouseShipmentEo relWarehouseShipmentEo = new RelWarehouseShipmentEo();
            relWarehouseShipmentEo.setWarehouseCode(relWarehouseShipmentGenerateReqDto.getWarehouseCode());
            relWarehouseShipmentEo.setWarehouseName(relWarehouseShipmentGenerateReqDto.getWarehouseName());
            relWarehouseShipmentEo.setRemark(relWarehouseShipmentGenerateReqDto.getRemark());
            relWarehouseShipmentEo.setShipmentEnterpriseId(detailReqDto.getShipmentEnterpriseId());
            relWarehouseShipmentEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            relWarehouseShipmentEo.setShipmentEnterpriseCode(detailReqDto.getShipmentEnterpriseCode());
            relWarehouseShipmentEo.setShipmentEnterpriseName(detailReqDto.getShipmentEnterpriseName());
            relWarehouseShipmentEo.setShipmentPriority(detailReqDto.getShipmentPriority());
            relWarehouseShipmentEo.setValidFlag(ValidFlagEnum.ENABLE.getCode());
            relWarehouseShipmentEoList.add(relWarehouseShipmentEo);
        }
        this.relWarehouseShipmentMapper.insertBatch((List)relWarehouseShipmentEoList);
        return true;
    }

    private void checkRepetition(RelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        String warehouseCode = relWarehouseShipmentGenerateReqDto.getWarehouseCode();
        QueryWrapper csRelWarehouseShipmentEoQueryWrapper = new QueryWrapper();
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"valid_flag", (Object)ValidFlagEnum.ENABLE.getCode());
        List relWarehouseShipmentEoList = this.relWarehouseShipmentMapper.selectList((Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)relWarehouseShipmentEoList), (String)String.format("\u4ed3\u5e93\u3010%s\u3011\u5df2\u8bbe\u7f6e\u7269\u6d41\u5546\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e", warehouseCode));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void deleteRelInfo(String warehouseCode) {
        logger.info("deleteRelInfo==>\u6839\u636e\u4ed3\u5e93\u7f16\u7801\u5220\u9664\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f,warehouseCode:{}", (Object)warehouseCode);
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseCode), (String)"\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csRelWarehouseShipmentEoQueryWrapper = new QueryWrapper();
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"valid_flag", (Object)ValidFlagEnum.ENABLE.getCode());
        List relWarehouseShipmentEoList = this.relWarehouseShipmentMapper.selectList((Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)relWarehouseShipmentEoList), (String)"\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f");
        for (RelWarehouseShipmentEo relWarehouseShipmentEo : relWarehouseShipmentEoList) {
            csRelWarehouseShipmentEoQueryWrapper.clear();
            csRelWarehouseShipmentEoQueryWrapper.eq((Object)"id", (Object)relWarehouseShipmentEo.getId());
            relWarehouseShipmentEo.setValidFlag(ValidFlagEnum.DISABLE.getCode());
            relWarehouseShipmentEo.setDr(YesNoEnum.YES.getValue());
            this.relWarehouseShipmentMapper.update((Object)relWarehouseShipmentEo, (Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Boolean editRelInfo(RelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        logger.info("editRelInfo==>\u7f16\u8f91\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f,relWarehouseShipmentGenerateReqDto:{}", (Object)LogUtils.buildLogContent((Object)relWarehouseShipmentGenerateReqDto));
        AssertUtil.isTrue((null != relWarehouseShipmentGenerateReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseCode = relWarehouseShipmentGenerateReqDto.getWarehouseCode();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseCode), (String)"\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List detailReqDtoList = relWarehouseShipmentGenerateReqDto.getDetailReqDtoList();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)detailReqDtoList), (String)"\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (RelWarehouseShipmentGenerateDetailReqDto detailReqDto : detailReqDtoList) {
            String shipmentEnterpriseCode = detailReqDto.getShipmentEnterpriseCode();
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)shipmentEnterpriseCode), (String)"\u7269\u6d41\u5546\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            Integer shipmentPriority = detailReqDto.getShipmentPriority();
            AssertUtil.isTrue((null != shipmentPriority && shipmentPriority >= 1 && shipmentPriority <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"\u4f18\u5148\u7ea7\u53c2\u6570\u6709\u8bef");
        }
        QueryWrapper csRelWarehouseShipmentEoQueryWrapper = new QueryWrapper();
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"valid_flag", (Object)ValidFlagEnum.ENABLE.getCode());
        List relWarehouseShipmentEoList = this.relWarehouseShipmentMapper.selectList((Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)relWarehouseShipmentEoList), (String)"\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f");
        for (RelWarehouseShipmentEo relWarehouseShipmentEo : relWarehouseShipmentEoList) {
            csRelWarehouseShipmentEoQueryWrapper.clear();
            csRelWarehouseShipmentEoQueryWrapper.eq((Object)"id", (Object)relWarehouseShipmentEo.getId());
            relWarehouseShipmentEo.setValidFlag(ValidFlagEnum.DISABLE.getCode());
            relWarehouseShipmentEo.setDr(YesNoEnum.YES.getValue());
            this.relWarehouseShipmentMapper.update((Object)relWarehouseShipmentEo, (Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        }
        this.generateRelInfo(relWarehouseShipmentGenerateReqDto);
        return true;
    }

    @Override
    public RelWarehouseShipmentRespDto selectByPrimaryKey(Long id) {
        RelWarehouseShipmentRespDto relWarehouseShipmentRespDto = new RelWarehouseShipmentRespDto();
        RelWarehouseShipmentEo relWarehouseShipmentEo = (RelWarehouseShipmentEo)this.relWarehouseShipmentDas.selectByPrimaryKey(id);
        BeanUtil.copyProperties((Object)relWarehouseShipmentEo, (Object)relWarehouseShipmentRespDto, (String[])new String[0]);
        return relWarehouseShipmentRespDto;
    }

    @Override
    public RelWarehouseShipmentParticularsRespDto queryByWarehouseCode(String warehouseCode) {
        logger.info("queryByWarehouseCode==>\u6839\u636e\u4ed3\u5e93\u7f16\u7801\u5220\u9664\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f,warehouseCode:{}", (Object)warehouseCode);
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseCode), (String)"\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csRelWarehouseShipmentEoQueryWrapper = new QueryWrapper();
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"valid_flag", (Object)ValidFlagEnum.ENABLE.getCode());
        csRelWarehouseShipmentEoQueryWrapper.orderByAsc((Object)"shipment_priority");
        List relWarehouseShipmentEoList = this.relWarehouseShipmentMapper.selectList((Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)relWarehouseShipmentEoList)) {
            return new RelWarehouseShipmentParticularsRespDto();
        }
        RelWarehouseShipmentParticularsRespDto relWarehouseShipmentPageRespDto = new RelWarehouseShipmentParticularsRespDto();
        RelWarehouseShipmentEo csRelWarehouseShipmentEo = (RelWarehouseShipmentEo)relWarehouseShipmentEoList.get(0);
        CubeBeanUtils.copyProperties((Object)relWarehouseShipmentPageRespDto, (Object)csRelWarehouseShipmentEo, (String[])new String[0]);
        relWarehouseShipmentPageRespDto.setId(csRelWarehouseShipmentEo.getId());
        relWarehouseShipmentPageRespDto.setWarehouseCode(csRelWarehouseShipmentEo.getWarehouseCode());
        relWarehouseShipmentPageRespDto.setWarehouseName(csRelWarehouseShipmentEo.getWarehouseName());
        ArrayList detailRespDtoList = Lists.newArrayList();
        for (RelWarehouseShipmentEo relWarehouseShipmentEo : relWarehouseShipmentEoList) {
            RelWarehouseShipmentDetailRespDto detailRespDto = new RelWarehouseShipmentDetailRespDto();
            detailRespDto.setId(relWarehouseShipmentEo.getId());
            detailRespDto.setShipmentEnterpriseCode(relWarehouseShipmentEo.getShipmentEnterpriseCode());
            detailRespDto.setShipmentEnterpriseName(relWarehouseShipmentEo.getShipmentEnterpriseName());
            detailRespDto.setShipmentPriority(relWarehouseShipmentEo.getShipmentPriority());
            detailRespDtoList.add(detailRespDto);
        }
        relWarehouseShipmentPageRespDto.setDetailRespDtoList((List)detailRespDtoList);
        return relWarehouseShipmentPageRespDto;
    }

    @Override
    public PageInfo<RelWarehouseShipmentPageRespDto> queryPage(RelWarehouseShipmentPageQueryDto relWarehouseShipmentPageQueryDto) {
        logger.info("queryPage==>\u5217\u8868\u5206\u9875\u67e5\u8be2,relWarehouseShipmentPageQueryDto:{}", (Object)LogUtils.buildLogContent((Object)relWarehouseShipmentPageQueryDto));
        AssertUtil.isTrue((null != relWarehouseShipmentPageQueryDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((null != relWarehouseShipmentPageQueryDto.getPageNum() && relWarehouseShipmentPageQueryDto.getPageNum() > 0 ? 1 : 0) != 0, (String)"\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue((null != relWarehouseShipmentPageQueryDto.getPageSize() && relWarehouseShipmentPageQueryDto.getPageSize() > 0 ? 1 : 0) != 0, (String)"\u5206\u9875\u53c2\u6570\u6709\u8bef");
        PageHelper.startPage((int)relWarehouseShipmentPageQueryDto.getPageNum(), (int)relWarehouseShipmentPageQueryDto.getPageSize());
        ExtQueryChainWrapper filter = new ExtQueryChainWrapper((BaseMapper)this.relWarehouseShipmentMapper, true);
        this.buildePageWrapperGroupBy((ExtQueryChainWrapper<RelWarehouseShipmentEo>)filter, relWarehouseShipmentPageQueryDto);
        List warehouseCodes = filter.select(new String[]{"warehouse_code"}).list();
        if (CollectionUtils.isEmpty((Collection)warehouseCodes)) {
            logger.info("\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
            return new PageInfo();
        }
        relWarehouseShipmentPageQueryDto.setWarehouseCodes(warehouseCodes.stream().map(RelWarehouseShipmentEo::getWarehouseCode).collect(Collectors.toList()));
        ExtQueryChainWrapper queryFilter = this.relWarehouseShipmentDas.filter();
        this.buildePageWrapper((ExtQueryChainWrapper<RelWarehouseShipmentEo>)queryFilter, relWarehouseShipmentPageQueryDto);
        List eos = queryFilter.list();
        ArrayList csChannelWarehouseRespDtoList = Lists.newArrayList();
        Map<String, List<RelWarehouseShipmentEo>> resultList = eos.stream().collect(Collectors.groupingBy(RelWarehouseShipmentEo::getWarehouseCode));
        resultList.forEach((key, value) -> {
            RelWarehouseShipmentPageRespDto relWarehouseShipmentPageRespDto = new RelWarehouseShipmentPageRespDto();
            RelWarehouseShipmentEo relWarehouseShipmentEo = (RelWarehouseShipmentEo)value.get(0);
            ArrayList detailRespDtoList = new ArrayList(value.size());
            BeanUtil.copyProperties((Object)relWarehouseShipmentEo, (Object)relWarehouseShipmentPageRespDto, (String[])new String[0]);
            value.forEach(o -> {
                RelWarehouseShipmentDetailRespDto detailRespDto = new RelWarehouseShipmentDetailRespDto();
                BeanUtil.copyProperties((Object)o, (Object)detailRespDto, (String[])new String[0]);
                detailRespDtoList.add(detailRespDto);
            });
            relWarehouseShipmentPageRespDto.setDetailRespDtoList(detailRespDtoList);
            csChannelWarehouseRespDtoList.add(relWarehouseShipmentPageRespDto);
        });
        PageInfo pageInfo = new PageInfo((List)csChannelWarehouseRespDtoList);
        return pageInfo;
    }

    @Override
    public List<RelWarehouseShipmentPageRespDto> queryRelInfoList(RelWarehouseShipmentPageQueryDto relWarehouseShipmentPageQueryDto) {
        List csLogicWarehouseEoList;
        logger.info("queryRelInfoList==>\u67e5\u8be2\u53ef\u7528\u7684\u7269\u6d41\u5546\u4ed3\u5e93\u96c6\u5408,relWarehouseShipmentPageQueryDto:{}", (Object)LogUtils.buildLogContent((Object)relWarehouseShipmentPageQueryDto));
        ExtQueryChainWrapper filter = this.relWarehouseShipmentDas.filter();
        this.buildePageWrapper((ExtQueryChainWrapper<RelWarehouseShipmentEo>)filter, relWarehouseShipmentPageQueryDto);
        List eoList = filter.list();
        QueryWrapper csLogicWarehouseEoQueryWrapper = new QueryWrapper();
        csLogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)ValidFlagEnum.ENABLE.getCode());
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            List warehouseCodeList = eoList.stream().map(RelWarehouseShipmentEo::getWarehouseCode).collect(Collectors.toList());
            csLogicWarehouseEoQueryWrapper.notIn((Object)"warehouse_code", warehouseCodeList);
        }
        if (CollectionUtils.isEmpty((Collection)(csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)csLogicWarehouseEoQueryWrapper)))) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        for (LogicWarehouseEo csLogicWarehouseEo : csLogicWarehouseEoList) {
            RelWarehouseShipmentPageRespDto respDto = new RelWarehouseShipmentPageRespDto();
            respDto.setId(csLogicWarehouseEo.getId());
            respDto.setWarehouseCode(csLogicWarehouseEo.getWarehouseCode());
            respDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
            resultList.add(respDto);
        }
        return resultList;
    }

    private void buildePageWrapper(ExtQueryChainWrapper<RelWarehouseShipmentEo> filter, RelWarehouseShipmentPageQueryDto relWarehouseShipmentPageQueryDto) {
        List shipmentEnterpriseCodeList;
        List warehouseCodes;
        filter.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        filter.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        String warehouseCode = relWarehouseShipmentPageQueryDto.getWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
            filter.eq((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (CollectionUtils.isNotEmpty((Collection)(warehouseCodes = relWarehouseShipmentPageQueryDto.getWarehouseCodes()))) {
            filter.in((Object)"warehouse_code", (Collection)warehouseCodes);
        }
        if (CollectionUtils.isNotEmpty((Collection)(shipmentEnterpriseCodeList = relWarehouseShipmentPageQueryDto.getShipmentEnterpriseCodes()))) {
            filter.in((Object)"shipment_enterprise_code", (Collection)shipmentEnterpriseCodeList);
        }
    }

    private void buildePageWrapperGroupBy(ExtQueryChainWrapper<RelWarehouseShipmentEo> filter, RelWarehouseShipmentPageQueryDto relWarehouseShipmentPageQueryDto) {
        this.buildePageWrapper(filter, relWarehouseShipmentPageQueryDto);
        filter.groupBy((Object)"warehouse_code");
    }

    @Override
    public List<RelWarehouseShipmentRespDto> queryByParam(RelWarehouseShipmentParamQueryDto relWarehouseShipmentParamQueryDto) {
        logger.info("queryByParam==>\u591a\u6761\u4ef6\u67e5\u8be2,relWarehouseShipmentParamQueryDto:{}", (Object)LogUtils.buildLogContent((Object)relWarehouseShipmentParamQueryDto));
        if (null == relWarehouseShipmentParamQueryDto) {
            return Lists.newArrayList();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        this.buildQueryWrapper((QueryWrapper<RelWarehouseShipmentEo>)queryWrapper, relWarehouseShipmentParamQueryDto);
        List csRelWarehouseShipmentEoList = this.relWarehouseShipmentMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseShipmentEoList)) {
            return Lists.newArrayList();
        }
        ArrayList relWarehouseShipmentRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)relWarehouseShipmentRespDtoList, (Collection)csRelWarehouseShipmentEoList, RelWarehouseShipmentRespDto.class);
        return relWarehouseShipmentRespDtoList;
    }

    @Override
    public RelWarehouseShipmentDetailRespDto queryHighestPriorityByWarehouseCode(String warehouseCode) {
        return null;
    }

    @Override
    public Integer importRelInfo(List<RelWarehouseShipmentGenerateReqDto> relWarehouseShipmentGenerateReqDtos) {
        if (CollectionUtils.isEmpty(relWarehouseShipmentGenerateReqDtos)) {
            return 0;
        }
        relWarehouseShipmentGenerateReqDtos.forEach(this::generateRelInfo);
        return relWarehouseShipmentGenerateReqDtos.size();
    }

    private void checkParams(RelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        AssertUtil.isTrue((null != relWarehouseShipmentGenerateReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseCode = relWarehouseShipmentGenerateReqDto.getWarehouseCode();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseCode), (String)"\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper physicsWarehouseEoQueryWrapper = new QueryWrapper();
        physicsWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        physicsWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        List physicsWarehouseEos = this.physicsWarehouseDomain.getMapper().selectList((Wrapper)physicsWarehouseEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)physicsWarehouseEos), (String)"\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)physicsWarehouseEos.get(0);
        relWarehouseShipmentGenerateReqDto.setWarehouseName(physicsWarehouseEo.getWarehouseName());
        List detailReqDtoList = relWarehouseShipmentGenerateReqDto.getDetailReqDtoList();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)detailReqDtoList), (String)"\u7269\u6d41\u660e\u7ec6\u4fe1\u606f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (RelWarehouseShipmentGenerateDetailReqDto generateDetailReqDto : detailReqDtoList) {
            String shipmentEnterpriseCode = generateDetailReqDto.getShipmentEnterpriseCode();
            String shipmentEnterpriseName = generateDetailReqDto.getShipmentEnterpriseName();
            Integer shipmentPriority = generateDetailReqDto.getShipmentPriority();
            if (null == shipmentPriority) {
                shipmentPriority = 1;
                generateDetailReqDto.setShipmentPriority(Integer.valueOf(1));
            }
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)shipmentEnterpriseName), (String)"\u7269\u6d41\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)shipmentEnterpriseCode), (String)"\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue((null != shipmentPriority && shipmentPriority >= 1 && shipmentPriority <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"\u4f18\u5148\u7ea7\u53c2\u6570\u6709\u8bef");
        }
    }

    private void buildQueryWrapper(QueryWrapper<RelWarehouseShipmentEo> queryWrapper, RelWarehouseShipmentParamQueryDto relWarehouseShipmentParamQueryDto) {
        Integer shipmentPriority;
        List shipmentEnterpriseCodeList;
        String shipmentEnterpriseCode;
        List warehouseCodeList;
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        String warehouseCode = relWarehouseShipmentParamQueryDto.getWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
            LogicWarehouseEo logicWarehouseEo = Optional.ofNullable(this.logicWarehouseDomain.queryByCode(warehouseCode)).orElse(new LogicWarehouseEo());
            queryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)(warehouseCodeList = relWarehouseShipmentParamQueryDto.getWarehouseCodeList()))) {
            List logicWarehouseEos = Optional.ofNullable(this.logicWarehouseDomain.queryByCodes(warehouseCodeList)).orElse(new ArrayList());
            queryWrapper.in((Object)"warehouse_code", (Collection)logicWarehouseEos.stream().map(LogicWarehouseEo::getPhysicsWarehouseCode).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((CharSequence)(shipmentEnterpriseCode = relWarehouseShipmentParamQueryDto.getShipmentEnterpriseCode()))) {
            queryWrapper.eq((Object)"shipment_enterprise_code", (Object)shipmentEnterpriseCode);
        }
        if (CollectionUtils.isNotEmpty((Collection)(shipmentEnterpriseCodeList = relWarehouseShipmentParamQueryDto.getShipmentEnterpriseCodeList()))) {
            queryWrapper.in((Object)"shipment_enterprise_code", (Collection)shipmentEnterpriseCodeList);
        }
        if (null != (shipmentPriority = relWarehouseShipmentParamQueryDto.getShipmentPriority())) {
            queryWrapper.eq((Object)"shipment_priority", (Object)shipmentPriority);
        }
    }
}

