/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.helper.data;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.service.helper.data.IDataQueryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDataQueryHelper<T>
implements IDataQueryHelper<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataQueryHelper.class);
    protected final Cache<String, T> DATA_CACHE = Caffeine.newBuilder().initialCapacity(500).maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    @Autowired
    ICacheService cacheService;

    abstract String getCacheKey();

    abstract String getKey(T var1);

    abstract Class<T> getType();

    abstract List<T> getDataBaseData(List<String> var1);

    @Override
    public List<T> getByCodes(List<String> codes) {
        if (CollectionUtil.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        codes = codes.stream().filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList copySkuCodes = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)copySkuCodes, codes, String.class);
        Map<String, T> redisCargoMapEos = this.getDataCacheMap(copySkuCodes);
        ArrayList redisDataDtoList = Lists.newArrayList(redisCargoMapEos.values());
        redisDataDtoList.removeIf(Objects::isNull);
        log.info("data codes \u7f13\u5b58\u547d\u4e2d\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonStr((Object)redisDataDtoList));
        copySkuCodes.removeIf(o -> null != redisDataDtoList.stream().filter(c -> StringUtils.equals((CharSequence)o, (CharSequence)this.getKey(c))).findFirst().orElse(null));
        log.info("data codes \u672a\u547d\u4e2d\u7f13\u5b58codes: {}", (Object)copySkuCodes);
        if (CollectionUtil.isNotEmpty((Collection)copySkuCodes)) {
            List<T> dataList = this.getDataBaseData(copySkuCodes);
            if (CollectionUtils.isEmpty(dataList)) {
                return new ArrayList();
            }
            HashMap putRedisMap = Maps.newHashMap();
            for (T data : dataList) {
                String key = this.getKey(data);
                if (StringUtils.isBlank((CharSequence)key)) continue;
                putRedisMap.put(key, JSONUtil.toJsonStr(data));
                this.DATA_CACHE.put((Object)key, data);
                redisCargoMapEos.put(key, data);
            }
            this.cacheService.hmset(this.getCacheKey(), (Map)putRedisMap);
            this.cacheService.expire(this.getCacheKey(), 300);
            log.info("code: {}, \u5199\u5165Redis\u7ed3\u679c", (Object)copySkuCodes);
        }
        return new ArrayList<T>(redisCargoMapEos.values());
    }

    private Map<String, T> getDataCacheMap(List<String> copyCodes) {
        Map redisCache;
        Map allPresent = this.DATA_CACHE.getAllPresent(copyCodes);
        copyCodes.removeIf(allPresent::containsKey);
        HashMap resultMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Map)allPresent)) {
            resultMap.putAll(allPresent);
        }
        if (CollectionUtils.isNotEmpty(copyCodes) && !(redisCache = this.cacheService.hmget(this.getCacheKey(), copyCodes.toArray(new String[0]), this.getType())).isEmpty()) {
            redisCache.entrySet().stream().filter(r -> Objects.nonNull(r.getValue())).forEach(entry -> {
                this.DATA_CACHE.put(entry.getKey(), entry.getValue());
                resultMap.put(entry.getKey(), entry.getValue());
            });
        }
        return resultMap;
    }

    @Override
    public void cleanByCodes(List<String> codes) {
        this.DATA_CACHE.cleanUp();
        this.cacheService.hdel(this.getCacheKey(), codes.toArray(new String[0]));
    }
}

