/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.pda.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.convert.entity.LogisticsCompanySiteConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseRelationSiteDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogisticsCompanySiteDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.ChangeStatusLogisticsSiteDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRelationSiteDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsCompanySiteDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsCompanySitePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MatchLogicWarehouseRelationSiteDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MatchLogicWarehouseRelationSitePageDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseRelationSiteEo;
import com.yunxi.dg.base.center.inventory.eo.LogisticsCompanySiteEo;
import com.yunxi.dg.base.center.inventory.service.pda.ILogisticsCompanySiteService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogisticsCompanySiteServiceImpl
extends BaseServiceImpl<LogisticsCompanySiteDto, LogisticsCompanySiteEo, ILogisticsCompanySiteDomain>
implements ILogisticsCompanySiteService {
    private static final Logger logger = LoggerFactory.getLogger(LogisticsCompanySiteServiceImpl.class);
    @Resource
    private ILogicWarehouseRelationSiteDomain iLogicWarehouseRelationSiteDomain;
    @Resource
    private ILogisticsCompanySiteDomain iLogisticsCompanySiteDomain;

    public LogisticsCompanySiteServiceImpl(ILogisticsCompanySiteDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogisticsCompanySiteDto, LogisticsCompanySiteEo> converter() {
        return LogisticsCompanySiteConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addInLogisticsCompanySite(LogisticsCompanySiteDto addReqDto) {
        logger.info("\u65b0\u589e\u7269\u6d41\u7f51\u70b9\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)addReqDto));
        this.checkParam(addReqDto);
        List duplicateEo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iLogisticsCompanySiteDomain.filter().eq((Object)"logistics_company_code", (Object)addReqDto.getLogisticsCompanyCode())).eq(StringUtils.isNotBlank((CharSequence)addReqDto.getLogisticsSiteCode()), (Object)"logistics_site_code", (Object)addReqDto.getLogisticsSiteCode())).eq(StringUtils.isNotBlank((CharSequence)addReqDto.getLogisticsSiteName()), (Object)"logistics_site_name", (Object)addReqDto.getLogisticsSiteName())).eq((Object)"platform_account", (Object)addReqDto.getPlatformAccount())).list();
        if (CollectionUtils.isNotEmpty((Collection)duplicateEo)) {
            throw new BizException("\u5df2\u7ecf\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u8bf7\u6838\u5b9e");
        }
        LogisticsCompanySiteEo inLogisticsCompanySiteEo = new LogisticsCompanySiteEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inLogisticsCompanySiteEo);
        this.iLogisticsCompanySiteDomain.insert((BaseEo)inLogisticsCompanySiteEo);
        return inLogisticsCompanySiteEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyInLogisticsCompanySite(LogisticsCompanySiteDto modifyReqDto) {
        logger.info("\u66f4\u65b0\u7269\u6d41\u7f51\u70b9\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)modifyReqDto));
        this.checkParam(modifyReqDto);
        List duplicateEo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iLogisticsCompanySiteDomain.filter().eq((Object)"logistics_company_code", (Object)modifyReqDto.getLogisticsCompanyCode())).eq(StringUtils.isNotBlank((CharSequence)modifyReqDto.getLogisticsSiteCode()), (Object)"logistics_site_code", (Object)modifyReqDto.getLogisticsSiteCode())).eq(StringUtils.isNotBlank((CharSequence)modifyReqDto.getLogisticsSiteName()), (Object)"logistics_site_name", (Object)modifyReqDto.getLogisticsSiteName())).ne(modifyReqDto.getId() != null, (Object)"id", (Object)modifyReqDto.getId())).eq((Object)"platform_account", (Object)modifyReqDto.getPlatformAccount())).list();
        if (CollectionUtils.isNotEmpty((Collection)duplicateEo)) {
            throw new BizException("\u5df2\u7ecf\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u8bf7\u6838\u5b9e");
        }
        LogisticsCompanySiteEo inLogisticsCompanySiteEo = new LogisticsCompanySiteEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)inLogisticsCompanySiteEo);
        this.iLogisticsCompanySiteDomain.updateSelective((BaseEo)inLogisticsCompanySiteEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInLogisticsCompanySite(List<Long> ids) {
        logger.info("\u5220\u9664\u7269\u6d41\u7f51\u70b9\u4fe1\u606f:{}", (Object)JSON.toJSONString(ids));
        ids.forEach(id -> this.iLogisticsCompanySiteDomain.deleteById(id));
    }

    @Override
    public PageInfo<LogisticsCompanySiteDto> queryByPage(LogisticsCompanySitePageReqDto queryDto) {
        return this.iLogisticsCompanySiteDomain.queryByPage(queryDto);
    }

    public void queryParam(ExtQueryChainWrapper<LogisticsCompanySiteEo> filter, LogisticsCompanySitePageReqDto queryDto) {
        if (StringUtils.isNotBlank((CharSequence)queryDto.getLogisticsCompanyName())) {
            filter.like((Object)"logistics_company_name", (Object)queryDto.getLogisticsCompanyName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getLogisticsCompanyCode())) {
            filter.eq((Object)"logistics_company_code", (Object)queryDto.getLogisticsCompanyCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getLogisticsSiteCode())) {
            filter.eq((Object)"logistics_site_code", (Object)queryDto.getLogisticsSiteCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getLogisticsSiteName())) {
            filter.like((Object)"logistics_site_name", (Object)queryDto.getLogisticsSiteName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShopCode())) {
            filter.eq((Object)"shop_code", (Object)queryDto.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShopName())) {
            filter.like((Object)"shop_name", (Object)queryDto.getShopName());
        }
        if (null != queryDto.getCustomerAccountType()) {
            filter.eq((Object)"customer_account_type", (Object)queryDto.getCustomerAccountType());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getLogisticsCompanyCodeList())) {
            filter.in((Object)"logistics_company_code", (Collection)queryDto.getLogisticsCompanyCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getLogisticsCompanyNameList())) {
            filter.in((Object)"logistics_company_name", (Collection)queryDto.getLogisticsCompanyNameList());
        }
        filter.orderByDesc((Object)"id");
    }

    @Override
    public void modifyInLogisticsSiteRelationLogicWarehouse(List<LogicWarehouseRelationSiteDto> relationSiteDtoList) {
        this.checkParamLogisticsSiteRelationLogicWarehouse(relationSiteDtoList);
        Long logisticsSiteId = relationSiteDtoList.get(0).getLogisticsSiteId();
        this.extractedVaildDuplicate(relationSiteDtoList, logisticsSiteId);
        this.iLogicWarehouseRelationSiteDomain.removeLogicWarehouseRelationBySiteIds(relationSiteDtoList.stream().map(LogicWarehouseRelationSiteDto::getLogisticsSiteId).collect(Collectors.toList()));
        this.iLogicWarehouseRelationSiteDomain.insertBatch(BeanCopyUtil.copyPropertiesForList(relationSiteDtoList, LogicWarehouseRelationSiteEo.class));
    }

    private void extractedVaildDuplicate(List<LogicWarehouseRelationSiteDto> relationSiteDtoList, Long logisticsSiteId) {
        LogisticsCompanySiteEo logisticsCompanySiteEo = (LogisticsCompanySiteEo)this.iLogisticsCompanySiteDomain.selectByPrimaryKey(logisticsSiteId);
        List repList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iLogisticsCompanySiteDomain.filter().eq((Object)"logistics_company_code", (Object)logisticsCompanySiteEo.getLogisticsCompanyCode())).eq((Object)"platform_account", (Object)logisticsCompanySiteEo.getPlatformAccount())).list();
        if (CollectionUtils.isNotEmpty((Collection)repList)) {
            List idList = repList.stream().map(BaseEo::getId).collect(Collectors.toList());
            List logisticsSiteList = ((ExtQueryChainWrapper)this.iLogicWarehouseRelationSiteDomain.filter().in((Object)"logistics_site_id", idList)).list();
            List collectWarehouseCode = logisticsSiteList.stream().map(LogicWarehouseRelationSiteEo::getWarehouseCode).collect(Collectors.toList());
            List addWarehouseCode = relationSiteDtoList.stream().map(LogicWarehouseRelationSiteDto::getWarehouseCode).collect(Collectors.toList());
            HashSet set = new HashSet(collectWarehouseCode);
            set.retainAll(addWarehouseCode);
            ArrayList intersection = new ArrayList(set);
            if (CollectionUtils.isNotEmpty(intersection)) {
                throw new BizException("\u540c\u4e00\u7269\u6d41\u4ed3\u5e93/\u7535\u5b50\u9762\u5355\u5ba2\u6237\u8d26\u53f7\u548c\u6708\u7ed3\u8d26\u53f7/\u7f51\u70b9\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u903b\u8f91\u4ed3:{}", JSON.toJSONString(intersection));
            }
        }
    }

    @Override
    public PageInfo<MatchLogicWarehouseRelationSiteDto> queryLogicWarehouseRelationSiteByLogisticsSiteIdPage(MatchLogicWarehouseRelationSitePageDto queryDto) {
        return this.iLogicWarehouseRelationSiteDomain.queryLogicWarehouseRelationSiteByLogisticsSiteIdPage(queryDto);
    }

    @Override
    public void changeStatusLogisticsSite(ChangeStatusLogisticsSiteDto statusLogisticsSiteDto) {
        LogisticsCompanySiteEo siteEo = (LogisticsCompanySiteEo)this.iLogisticsCompanySiteDomain.selectByPrimaryKey(statusLogisticsSiteDto.getLogisticsSiteId());
        siteEo.setStatus(statusLogisticsSiteDto.getStatus());
        this.iLogisticsCompanySiteDomain.update((BaseEo)siteEo);
    }

    public void checkParam(LogisticsCompanySiteDto addReqDto) {
        AssertUtil.assertNotBlank((String)addReqDto.getLogisticsCompanyName(), (String)"\u7269\u6d41\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertNotBlank((String)addReqDto.getLogisticsCompanyCode(), (String)"\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertNotBlank((String)addReqDto.getPlatformAccount(), (String)"\u7535\u5b50\u9762\u5355\u8d26\u6237\u53f7\u7801/\u6708\u7ed3\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void checkParamLogisticsSiteRelationLogicWarehouse(List<LogicWarehouseRelationSiteDto> relationSiteDtoList) {
        AssertUtil.assertNotEmpty(relationSiteDtoList, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (LogicWarehouseRelationSiteDto siteDto : relationSiteDtoList) {
            AssertUtil.assertNotBlank((String)siteDto.getWarehouseCode(), (String)"\u5173\u8054\u7684\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            AssertUtil.isTrue((siteDto.getWarehouseId() != null ? 1 : 0) != 0, (String)"\u5173\u8054\u7684\u4ed3\u5e93Id\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue((siteDto.getLogisticsSiteId() != null ? 1 : 0) != 0, (String)"\u5173\u8054\u7684\u7269\u6d41\u7ad9\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

