/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.utils;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.yunxi.dg.base.commons.utils.MD5Util;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionCallback;

@Service
public class SendMqHelper {
    private static final Logger log = LoggerFactory.getLogger(SendMqHelper.class);
    @Autowired
    private ICommonsMqService mqService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private Environment environment;

    public void sendPublishMq(Object event, String tag) {
        this.sendPublishMq(event, tag, (TransactionCallback<Boolean>)((TransactionCallback)t -> true));
    }

    public void sendPublishMq(Object event, String tag, TransactionCallback<Boolean> action) {
        MessageVo messageVo = new MessageVo();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("yes.req.userCode", ServiceContext.getContext().get("yes.req.userCode"));
        hashMap.put("yes.req.requestId", ServiceContext.getContext().get("yes.req.requestId"));
        String dataStr = JSONObject.toJSONString((Object)event);
        if (dataStr.getBytes().length > 12000) {
            log.info("mq\u5927\u62a5\u6587\u5904\u7406:{}", (Object)dataStr);
            String key = MD5Util.getMd5ByString((String)dataStr);
            this.cacheService.setCache(key, (Object)dataStr, 21600);
            hashMap.put("yes.req.findDataFlag", key);
            hashMap.put("yes.req.cacheGroup", this.cacheService.getDefaultGroup());
            messageVo.setData((Object)key);
        } else {
            messageVo.setData((Object)dataStr);
        }
        messageVo.setExtValue1((Object)JSONObject.toJSONString(hashMap));
        this.mqService.publishMessage(this.environment.resolvePlaceholders("${inventory.process.mq:PUBLISH_TOPIC}"), tag, (Object)messageVo);
    }
}

