/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.facade;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.data.DataDictDto;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.TypeOfDocumentEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderAutoCompleteSettingDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.unit.OrderUnitConverterDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.PushWmsAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.ReceiveDeliveryNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderDocumentTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderDeliveryNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderDeliveryNoticeCloseEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderDeliveryNoticeGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInNoticeGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderReceiveNoticeCancelEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderReceiveNoticeCloseEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.InOutNoticeOrderCompleteEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.AdjustNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.AssembleDisassembleOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderConfirmFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderUnhookFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.helper.IInOutBackBaseOrderFacadeHelper;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.helper.IUnHookBaseOrderFacadeHelper;
import com.yunxi.dg.base.center.inventory.service.baseorder.helper.BaseOrderExtensionHelper;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.AdjustNoticeOrderAbleImpl;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.AssemblyDisassemblyNoticeOrderAbleImpl;
import com.yunxi.dg.base.center.inventory.service.helper.data.DictDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.service.holdMerge.MergeOrderNoticeVo;
import com.yunxi.dg.base.center.inventory.service.utils.SendMqHelper;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.dto.old.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.logistics.dto.entity.SendOrderDetailDto;
import com.yunxi.dg.base.center.logistics.proxy.send.ISendOrderApiProxy;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;

@Service
public class BaseOrderFacadeImpl
implements BaseOrderFacade {
    private static final Logger log = LoggerFactory.getLogger(BaseOrderFacadeImpl.class);
    @Resource
    private InOutNoticeOrderAble outNoticeOrderAbleImpl;
    @Resource
    private InOutNoticeOrderAble inNoticeOrderAbleImpl;
    @Resource
    private ReceiveDeliveryNoticeOrderAble receiveNoticeOrderAbleImpl;
    @Resource
    private ReceiveDeliveryNoticeOrderAble deliveryNoticeOrderAbleImpl;
    @Resource
    private InOutResultOrderAble outResultOrderAbleImpl;
    @Resource
    private AdjustNoticeOrderAbleImpl adjustNoticeOrderAble;
    @Resource
    protected AssemblyDisassemblyNoticeOrderAbleImpl assemblyDisassemblyNoticeOrderAble;
    @Resource
    private IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    private IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    private IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private DictDataQueryHelperImpl dictDataQueryHelper;
    @Resource
    private ISendOrderApiProxy iSendOrderApiProxy;
    @Resource
    private IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    private IOrderAutoCompleteSettingDomain orderAutoCompleteSettingDomain;
    @Resource
    private SendMqHelper sendMqHelper;
    @Value(value="${yunxi.dg.base.project}")
    protected String projectCode;
    @Resource
    protected ILockService lockService;
    @Resource
    protected ICacheService cacheService;
    @Resource
    public IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private IInOutBackBaseOrderFacadeHelper inOutBackBaseOrderFacadeHelper;
    @Resource
    private IUnHookBaseOrderFacadeHelper unHookBaseOrderFacadeHelper;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuProxy;

    @Override
    public void inNoticeOrderGen(InOutNoticeOrderContext inOutNoticeOrderContext) {
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN);
        if (inOutNoticeOrderContext.getAutoComplete().booleanValue()) {
            inOutNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.INO_TOTAL_IN);
        } else {
            inOutNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.INO_WAIT_IN);
        }
        this.inNoticeOrderAbleImpl.generate(inOutNoticeOrderContext);
    }

    @Override
    public void outNoticeOrderGen(InOutNoticeOrderContext inOutNoticeOrderContext) {
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
        if (inOutNoticeOrderContext.getAutoComplete().booleanValue()) {
            inOutNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.ONO_TOTAL_OUT);
        } else {
            inOutNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_OUT);
            inOutNoticeOrderContext.setIntercept(true);
        }
        this.outNoticeOrderAbleImpl.generate(inOutNoticeOrderContext);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public InOutNoticeOrderContext inNoticeOrderGen(InOutNoticeOrderFacadeBo inOutNoticeOrderFacadeBo) {
        Boolean autoComplete = inOutNoticeOrderFacadeBo.getAutoComplete();
        InOutNoticeOrderContext outNoticeOrderContext = this.getInOutNoticeOrderContext(inOutNoticeOrderFacadeBo);
        this.inNoticeOrderGen(outNoticeOrderContext);
        InventoryConfig.pushEvent(new BaseOrderInNoticeGenEvent(outNoticeOrderContext));
        if (autoComplete.booleanValue()) {
            InOutNoticeOrderEo inOutNoticeOrderEo = outNoticeOrderContext.getInOutNoticeOrderEo();
            InOutResultOrderFacadeBo context = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)outNoticeOrderContext, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
            context.setInOutNoticeOrderDetailEos(outNoticeOrderContext.getInOutNoticeOrderDetailEoList());
            this.inResultOrderGen(context);
            ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)context, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
            receiveDeliveryNoticeOrderContext.setDocumentNo(inOutNoticeOrderFacadeBo.getReceiveDeliveryNoticeOrderEo().getDocumentNo());
            if (outNoticeOrderContext.getOperateTypeEnum().equals((Object)BaseOrderOperateTypeEnum.RECEIVE)) {
                this.receiveNoticeOrderAbleImpl.complete(receiveDeliveryNoticeOrderContext);
            } else {
                this.deliveryNoticeOrderAbleImpl.complete(receiveDeliveryNoticeOrderContext);
            }
            inOutNoticeOrderFacadeBo.execComplete(outNoticeOrderContext);
        }
        return outNoticeOrderContext;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public InOutNoticeOrderContext adjustNoticeOrderGen(AdjustNoticeOrderFacadeBo adjustNoticeOrderFacadeBo) {
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)adjustNoticeOrderFacadeBo, InOutNoticeOrderContext.class, (String[])new String[0]);
        BeanUtil.copyProperties((Object)adjustNoticeOrderFacadeBo.getInOutNoticeOrderEo(), (Object)outNoticeOrderContext, (String[])new String[0]);
        InOutNoticeOrderEo inOutNoticeOrderEo = adjustNoticeOrderFacadeBo.getInOutNoticeOrderEo();
        inOutNoticeOrderEo.setOrderType(BaseOrderOperateTypeEnum.IN_OUT.getCode().toLowerCase());
        BeanUtil.copyProperties((Object)inOutNoticeOrderEo, (Object)outNoticeOrderContext, (String[])new String[0]);
        InOutNoticeOrderEo orderEo = (InOutNoticeOrderEo)BeanUtil.copyProperties((Object)inOutNoticeOrderEo, InOutNoticeOrderEo.class, (String[])new String[0]);
        outNoticeOrderContext.setPreOrderNo(inOutNoticeOrderEo.getDocumentNo());
        outNoticeOrderContext.setInOutNoticeOrderEo(orderEo);
        outNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN_OUT);
        outNoticeOrderContext.setOrderStatus(adjustNoticeOrderFacadeBo.getAutoComplete() != false ? BaseOrderStatusEnum.INO_TOTAL_IN : BaseOrderStatusEnum.INO_WAIT_IN);
        outNoticeOrderContext.setSendWms(Boolean.TRUE);
        this.adjustNoticeOrderAble.generate(outNoticeOrderContext);
        if (adjustNoticeOrderFacadeBo.getAutoComplete().booleanValue()) {
            InOutResultOrderFacadeBo inOutResultOrderFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)adjustNoticeOrderFacadeBo, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            inOutResultOrderFacadeBo.setInOutNoticeOrderEo(outNoticeOrderContext.getInOutNoticeOrderEo());
            inOutResultOrderFacadeBo.setInOutNoticeOrderDetailEos(outNoticeOrderContext.getInOutNoticeOrderDetailEoList());
            this.adjustResultOrderGen(inOutResultOrderFacadeBo);
        }
        return outNoticeOrderContext;
    }

    @Override
    public InOutNoticeOrderContext assembleDisassembleOutNoticeOrderGen(AssembleDisassembleOrderFacadeBo assembleDisassembleOrderFacadeBo) {
        InOutNoticeOrderEo orderEo = (InOutNoticeOrderEo)BeanUtil.copyProperties((Object)assembleDisassembleOrderFacadeBo.getInOutNoticeOrderEo(), InOutNoticeOrderEo.class, (String[])new String[0]);
        orderEo.setOrderType(BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY.getCode().toLowerCase());
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)assembleDisassembleOrderFacadeBo, InOutNoticeOrderContext.class, (String[])new String[0]);
        BeanUtil.copyProperties((Object)orderEo, (Object)outNoticeOrderContext, (String[])new String[0]);
        outNoticeOrderContext.setPreOrderNo(orderEo.getDocumentNo());
        outNoticeOrderContext.setInOutNoticeOrderEo(orderEo);
        outNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY);
        outNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.PROCESSING);
        if (CollectionUtils.isNotEmpty(assembleDisassembleOrderFacadeBo.getAllOrderDetailReqDtos())) {
            outNoticeOrderContext.setOrderBasicsDetailReqDtoList(assembleDisassembleOrderFacadeBo.getAllOrderDetailReqDtos());
        }
        this.outNoticeOrderAbleImpl.generate(outNoticeOrderContext);
        return outNoticeOrderContext;
    }

    private InOutNoticeOrderContext getInOutNoticeOrderContext(InOutNoticeOrderFacadeBo inOutNoticeOrderFacadeBo) {
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = inOutNoticeOrderFacadeBo.getReceiveDeliveryNoticeOrderEo();
        AssertUtils.notNull((Object)receiveDeliveryNoticeOrderEo, (String)"\u6536\u53d1\u901a\u77e5\u5355\u4f20\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        String rdDocumentNo = receiveDeliveryNoticeOrderEo.getDocumentNo();
        InOutNoticeOrderContext inOutNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderEo, InOutNoticeOrderContext.class, (String[])new String[]{"document_no"});
        BeanUtil.copyProperties((Object)inOutNoticeOrderFacadeBo, (Object)inOutNoticeOrderContext, (CopyOptions)CopyOptions.create().ignoreNullValue());
        inOutNoticeOrderContext.setPreOrderNo(rdDocumentNo);
        inOutNoticeOrderContext.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)receiveDeliveryNoticeOrderEo.getRelevanceTableName()));
        inOutNoticeOrderContext.setOperateTypeEnum(this.getOperateTypeEnum(receiveDeliveryNoticeOrderEo.getOrderType()));
        if (BaseOrderOperateTypeEnum.OUT.equals((Object)inOutNoticeOrderContext.getOperateTypeEnum())) {
            inOutNoticeOrderContext.setLogicWarehouseCode(receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode());
            inOutNoticeOrderContext.setLogicWarehouseName(receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseName());
            inOutNoticeOrderContext.setPhysicsWarehouseCode(receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseCode());
            inOutNoticeOrderContext.setPhysicsWarehouseName(receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseName());
        } else {
            inOutNoticeOrderContext.setLogicWarehouseCode(receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode());
            inOutNoticeOrderContext.setLogicWarehouseName(receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseName());
            inOutNoticeOrderContext.setPhysicsWarehouseCode(receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseCode());
            inOutNoticeOrderContext.setPhysicsWarehouseName(receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseName());
        }
        inOutNoticeOrderContext.setOrderBasicsDetailReqDtoList(((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)rdDocumentNo)).list().stream().map(detail -> {
            BaseOrderDetailReqDto reqDto = (BaseOrderDetailReqDto)((Object)((Object)BeanUtil.copyProperties((Object)detail, BaseOrderDetailReqDto.class, (String[])new String[]{"id"})));
            reqDto.setQuantity(detail.getPlanQuantity());
            BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)JSON.parseObject((String)detail.getExtension(), BasicOrderDtoExtension.class);
            if (Objects.nonNull(basicOrderDtoExtension)) {
                reqDto.setWeight(basicOrderDtoExtension.getWeight());
                reqDto.setVolume(basicOrderDtoExtension.getVolume());
                reqDto.setSkuDisplayName(basicOrderDtoExtension.getSkuDisplayName());
            }
            return reqDto;
        }).collect(Collectors.toList()));
        inOutNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(inOutNoticeOrderContext.getOrderBasicsDetailReqDtoList());
        return inOutNoticeOrderContext;
    }

    @NotNull
    private BaseOrderOperateTypeEnum getOperateTypeEnum(String type) {
        return BaseOrderOperateTypeEnum.DELIVERY.getCode().equalsIgnoreCase(type) ? BaseOrderOperateTypeEnum.OUT : BaseOrderOperateTypeEnum.IN;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public InOutNoticeOrderContext outNoticeOrderGen(InOutNoticeOrderFacadeBo inOutNoticeOrderFacadeBo) {
        Boolean autoComplete = inOutNoticeOrderFacadeBo.getAutoComplete();
        InOutNoticeOrderContext outNoticeOrderContext = this.getInOutNoticeOrderContext(inOutNoticeOrderFacadeBo);
        this.outNoticeOrderGen(outNoticeOrderContext);
        InventoryConfig.pushEvent(new BaseOrderOutNoticeGenEvent(outNoticeOrderContext));
        if (autoComplete.booleanValue()) {
            InOutNoticeOrderEo inOutNoticeOrderEo = outNoticeOrderContext.getInOutNoticeOrderEo();
            InOutResultOrderFacadeBo context = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)outNoticeOrderContext, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
            context.setInOutNoticeOrderDetailEos(outNoticeOrderContext.getInOutNoticeOrderDetailEoList());
            this.outResultOrderGen(context);
            ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)context, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
            receiveDeliveryNoticeOrderContext.setDocumentNo(inOutNoticeOrderFacadeBo.getReceiveDeliveryNoticeOrderEo().getDocumentNo());
            if (outNoticeOrderContext.getOperateTypeEnum().equals((Object)BaseOrderOperateTypeEnum.RECEIVE)) {
                this.receiveNoticeOrderAbleImpl.complete(receiveDeliveryNoticeOrderContext);
            } else {
                this.deliveryNoticeOrderAbleImpl.complete(receiveDeliveryNoticeOrderContext);
            }
        }
        inOutNoticeOrderFacadeBo.execComplete(outNoticeOrderContext);
        return outNoticeOrderContext;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public ReceiveDeliveryNoticeOrderContext receiveNoticeOrderGen(ReceiveDeliveryNoticeOrderFacadeBo facadeBo) {
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)facadeBo.getLogicWarehouseCode()), (String)"\u64cd\u4f5c\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)facadeBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        facadeBo.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        this.wrapperRdData(facadeBo, receiveDeliveryNoticeOrderContext);
        Boolean autoComplete = receiveDeliveryNoticeOrderContext.getAutoComplete();
        if (autoComplete.booleanValue()) {
            receiveDeliveryNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.RNO_TOTAL_RECEIVE);
        } else {
            receiveDeliveryNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.RNO_WAIT_RECEIVE);
        }
        this.receiveNoticeOrderAbleImpl.generate(receiveDeliveryNoticeOrderContext);
        if (receiveDeliveryNoticeOrderContext.getGenerateInOut().booleanValue()) {
            InOutNoticeOrderContext outNoticeOrderContext = this.getInOutNoticeOrderContext(receiveDeliveryNoticeOrderContext);
            this.inNoticeOrderGen(outNoticeOrderContext);
            if (facadeBo.isGenAdjustNotice()) {
                AdjustNoticeOrderFacadeBo adjustNoticeOrderFacadeBo = (AdjustNoticeOrderFacadeBo)BeanUtil.copyProperties((Object)facadeBo, AdjustNoticeOrderFacadeBo.class, (String[])new String[0]);
                adjustNoticeOrderFacadeBo.setInOutNoticeOrderEo(outNoticeOrderContext.getInOutNoticeOrderEo());
                adjustNoticeOrderFacadeBo.getInOutNoticeOrderEo().setOldInventoryProperty(facadeBo.getOrderBasicsDetailReqDtoList().get(0).getOldInventoryProperty());
                this.adjustNoticeOrderGen(adjustNoticeOrderFacadeBo);
            }
            InventoryConfig.pushEvent(new BaseOrderInNoticeGenEvent(outNoticeOrderContext));
            if (autoComplete.booleanValue()) {
                InOutNoticeOrderEo inOutNoticeOrderEo = outNoticeOrderContext.getInOutNoticeOrderEo();
                InOutResultOrderFacadeBo context = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)outNoticeOrderContext, InOutResultOrderFacadeBo.class, (String[])new String[0]);
                context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
                context.setInOutNoticeOrderDetailEos(outNoticeOrderContext.getInOutNoticeOrderDetailEoList());
                this.inResultOrderGen(context);
                facadeBo.execComplete(receiveDeliveryNoticeOrderContext);
                return receiveDeliveryNoticeOrderContext;
            }
        }
        if (autoComplete.booleanValue()) {
            ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo();
            ReceiveDeliveryResultOrderContext context = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderContext, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
            context.setPreOrderNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
            this.receiveResultOrderGen(context);
        }
        facadeBo.execComplete(receiveDeliveryNoticeOrderContext);
        return receiveDeliveryNoticeOrderContext;
    }

    private void wrapperRdData(ReceiveDeliveryNoticeOrderFacadeBo facadeBo, ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext) {
        String type;
        receiveDeliveryNoticeOrderContext.setMultipleIn(InventoryConfig.isMultipleIn());
        receiveDeliveryNoticeOrderContext.setRelevanceNo(facadeBo.getRelevanceNo());
        receiveDeliveryNoticeOrderContext.setShippingType(facadeBo.getTransportTypeCode());
        facadeBo.setBaseOrderAddressEoList(Optional.ofNullable(facadeBo.getBaseOrderAddressEoList()).orElse(new ArrayList()));
        receiveDeliveryNoticeOrderContext.setBaseOrderAddressEoList(facadeBo.getBaseOrderAddressEoList());
        receiveDeliveryNoticeOrderContext.setMultipleOut(InventoryConfig.isMultipleOut());
        receiveDeliveryNoticeOrderContext.setIsBatchManage(!InventoryConfig.isNoneBatch());
        receiveDeliveryNoticeOrderContext.setLogicWarehouseCode(facadeBo.getLogicWarehouseCode());
        if (StringUtils.isBlank((CharSequence)facadeBo.getLogicWarehouseName()) || StringUtils.isBlank((CharSequence)facadeBo.getPhysicsWarehouseCode())) {
            Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)facadeBo.getLogicWarehouseCode())).last(" limit 1")).one()).ifPresent(one -> {
                receiveDeliveryNoticeOrderContext.setLogicWarehouseName(one.getWarehouseName());
                receiveDeliveryNoticeOrderContext.setPhysicsWarehouseCode(one.getPhysicsWarehouseCode());
                receiveDeliveryNoticeOrderContext.setPhysicsWarehouseName(one.getPhysicsWarehouseName());
                facadeBo.setLogicWarehouseName(one.getWarehouseName());
                facadeBo.setPhysicsWarehouseCode(one.getPhysicsWarehouseCode());
                facadeBo.setPhysicsWarehouseName(one.getPhysicsWarehouseName());
            });
        }
        HashSet skuCodes = new HashSet();
        receiveDeliveryNoticeOrderContext.getOrderBasicsDetailReqDtoList().forEach(r -> {
            if (r.getPreOrderItemId() == null) {
                r.setPreOrderItemId(IdWorker.getId());
            }
            r.setInventoryProperty((String)DataExtractUtils.ifNullElse((Object)r.getInventoryProperty(), (Object)LogicWarehouseQualityEnum.QUALIFIED.getCode()));
            skuCodes.add(r.getSkuCode());
        });
        HashMap<String, String> code2DisplayNameMap = new HashMap<String, String>();
        List itemSkus = null;
        if (CollectionUtils.isNotEmpty(skuCodes) && CollectionUtil.isNotEmpty((Collection)(itemSkus = this.itemSkuProxy.queryBySkuCode(new ArrayList(skuCodes))))) {
            code2DisplayNameMap.putAll(itemSkus.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getDisplayName())).collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getDisplayName, (k1, k2) -> k1)));
        }
        log.info("\u67e5\u8be2sku\u7b80\u79f0\uff1a{}", (Object)JSONObject.toJSONString(code2DisplayNameMap));
        receiveDeliveryNoticeOrderContext.getOrderBasicsDetailReqDtoList().forEach(item -> Optional.ofNullable(code2DisplayNameMap.get(item.getSkuCode())).ifPresent(item::setSkuDisplayName));
        if (StringUtils.isNotBlank((CharSequence)facadeBo.getDisplayBusinessType())) {
            receiveDeliveryNoticeOrderContext.setDisplayBusinessType(facadeBo.getDisplayBusinessType());
            Optional.ofNullable(this.dictDataQueryHelper.getByCodes(Lists.newArrayList((Object[])new String[]{facadeBo.getDisplayBusinessType()}))).filter(CollectionUtils::isNotEmpty).map(r -> (DataDictDto)r.get(0)).filter(d -> StringUtils.isNotBlank((CharSequence)d.getGroupCode())).ifPresent(dataDictDto -> {
                receiveDeliveryNoticeOrderContext.setJumpDocumentType(dataDictDto.getCode());
                receiveDeliveryNoticeOrderContext.setJumpDocumentName(dataDictDto.getStatement());
                receiveDeliveryNoticeOrderContext.setDisplayBusinessName(dataDictDto.getSubLabel());
                Optional.ofNullable(dataDictDto.getGroupCode()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(receiveDeliveryNoticeOrderContext::setBusinessType);
            });
        }
        boolean isDelivery = BaseOrderOperateTypeEnum.DELIVERY.equals((Object)receiveDeliveryNoticeOrderContext.getOperateTypeEnum());
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)facadeBo.getLogicWarehouseCode())).last("limit 1")).one();
        if (facadeBo.getGenerateInOut().booleanValue() && ObjectUtil.equals((Object)YesNoEnum.YES.getValue(), (Object)logicWarehouseEo.getIsVirtual())) {
            receiveDeliveryNoticeOrderContext.setAutoComplete(true);
            receiveDeliveryNoticeOrderContext.setSendWms(false);
        }
        this.judgeAutoComplete(facadeBo, receiveDeliveryNoticeOrderContext);
        boolean autoComplete = this.orderAutoCompleteSettingDomain.matchBySetting(receiveDeliveryNoticeOrderContext.getJumpDocumentType(), receiveDeliveryNoticeOrderContext.getDisplayBusinessType(), receiveDeliveryNoticeOrderContext.getLogicWarehouseCode(), receiveDeliveryNoticeOrderContext.getPhysicsWarehouseCode(), isDelivery ? "out" : "in", receiveDeliveryNoticeOrderContext.getAutoComplete());
        receiveDeliveryNoticeOrderContext.setAutoComplete(autoComplete);
        String string = type = isDelivery ? "consignor" : "consignee";
        if (facadeBo.getBaseOrderAddressEoList().stream().noneMatch(r -> Objects.equals(type, r.getContactsType()))) {
            facadeBo.getBaseOrderAddressEoList().add(this.getDefaultAddress(logicWarehouseEo, type));
        }
        receiveDeliveryNoticeOrderContext.setTargetLogicWarehouseCode(facadeBo.getTransferInLogicWarehouseCode());
        receiveDeliveryNoticeOrderContext.setTotalQuantity(facadeBo.getOrderBasicsDetailReqDtoList().stream().map(OrderUnitConverterDto::getQuantity).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
    }

    @NotNull
    private BaseOrderAddressEo getDefaultAddress(LogicWarehouseEo logicWarehouseEo, String type) {
        BaseOrderAddressEo baseOrderAddressEo = new BaseOrderAddressEo();
        baseOrderAddressEo.setContactsType(type);
        WarehouseAddressEo warehouseCodeEo = (WarehouseAddressEo)Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseAddressDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode())).eq((Object)"warehouse_classify", (Object)"physics")).last("limit 1")).one()).orElse(new WarehouseAddressEo());
        baseOrderAddressEo.setProvince(warehouseCodeEo.getProvince());
        baseOrderAddressEo.setCity(warehouseCodeEo.getCity());
        baseOrderAddressEo.setDistrict(warehouseCodeEo.getDistrict());
        baseOrderAddressEo.setDetailAddress(warehouseCodeEo.getDetailAddress());
        baseOrderAddressEo.setEncryptProvince(warehouseCodeEo.getProvince());
        baseOrderAddressEo.setEncryptCity(warehouseCodeEo.getCity());
        baseOrderAddressEo.setEncryptDistrict(warehouseCodeEo.getDistrict());
        baseOrderAddressEo.setEncryptDetailAddress(warehouseCodeEo.getDetailAddress());
        baseOrderAddressEo.setContacts(warehouseCodeEo.getContacts());
        baseOrderAddressEo.setEncryptContacts(warehouseCodeEo.getContacts());
        baseOrderAddressEo.setPhone(warehouseCodeEo.getPhone());
        baseOrderAddressEo.setEncryptPhone(warehouseCodeEo.getPhone());
        return baseOrderAddressEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public ReceiveDeliveryNoticeOrderContext deliveryNoticeOrderGen(ReceiveDeliveryNoticeOrderFacadeBo facadeBo) {
        log.info("deliveryNoticeOrderGen: {}", (Object)JSON.toJSONString((Object)facadeBo));
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)facadeBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.DELIVERY);
        facadeBo.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        this.wrapperRdData(facadeBo, receiveDeliveryNoticeOrderContext);
        log.info("deliveryNoticeOrderGen_receiveDeliveryNoticeOrderContext: {}", (Object)JSON.toJSONString((Object)receiveDeliveryNoticeOrderContext));
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.DELIVERY);
        Boolean autoComplete = receiveDeliveryNoticeOrderContext.getAutoComplete();
        if (autoComplete.booleanValue()) {
            receiveDeliveryNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.DNO_TOTAL_DELIVERY);
        } else {
            receiveDeliveryNoticeOrderContext.setOrderStatus(BaseOrderStatusEnum.DNO_WAIT_DELIVERY);
        }
        this.deliveryNoticeOrderAbleImpl.generate(receiveDeliveryNoticeOrderContext);
        InventoryConfig.pushEvent(new BaseOrderDeliveryNoticeGenEvent(receiveDeliveryNoticeOrderContext));
        if (receiveDeliveryNoticeOrderContext.getGenerateInOut().booleanValue()) {
            InOutNoticeOrderContext outNoticeOrderContext = this.getInOutNoticeOrderContext(receiveDeliveryNoticeOrderContext);
            this.outNoticeOrderGen(outNoticeOrderContext);
            if (facadeBo instanceof AssembleDisassembleOrderFacadeBo) {
                AssembleDisassembleOrderFacadeBo orderFacadeBo = (AssembleDisassembleOrderFacadeBo)facadeBo;
                orderFacadeBo.setInOutNoticeOrderEo(outNoticeOrderContext.getInOutNoticeOrderEo());
                this.assembleDisassembleOutNoticeOrderGen(orderFacadeBo);
            }
            InventoryConfig.pushEvent(new BaseOrderOutNoticeGenEvent(outNoticeOrderContext));
            if (autoComplete.booleanValue()) {
                InOutNoticeOrderEo inOutNoticeOrderEo = outNoticeOrderContext.getInOutNoticeOrderEo();
                InOutResultOrderFacadeBo inOutResultOrderFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)outNoticeOrderContext, InOutResultOrderFacadeBo.class, (String[])new String[0]);
                inOutResultOrderFacadeBo.setInOutNoticeOrderEo(inOutNoticeOrderEo);
                inOutResultOrderFacadeBo.setInOutNoticeOrderDetailEos(outNoticeOrderContext.getInOutNoticeOrderDetailEoList());
                inOutResultOrderFacadeBo.setTransferInLogicWarehouseCode(facadeBo.getTransferInLogicWarehouseCode());
                inOutResultOrderFacadeBo.setShippingInfoReqDtoList(outNoticeOrderContext.getShippingInfoReqDtoList());
                this.outResultOrderGen(inOutResultOrderFacadeBo);
                facadeBo.execComplete(receiveDeliveryNoticeOrderContext);
                return receiveDeliveryNoticeOrderContext;
            }
        }
        if (autoComplete.booleanValue()) {
            ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo();
            ReceiveDeliveryResultOrderContext context = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderContext, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
            context.setPreOrderNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
            this.deliveryResultOrderGen(context);
        }
        facadeBo.execComplete(receiveDeliveryNoticeOrderContext);
        return receiveDeliveryNoticeOrderContext;
    }

    private void judgeAutoComplete(ReceiveDeliveryNoticeOrderFacadeBo facadeBo, ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext) {
        if (!InventoryConfig.getPushWms().canPushWms(PushWmsAble.CanPushWmsBo.builder().logicWarehouseCode(receiveDeliveryNoticeOrderContext.getLogicWarehouseCode()).businessType(receiveDeliveryNoticeOrderContext.getDisplayBusinessType()).targetLogicWarehouseCode(receiveDeliveryNoticeOrderContext.getTargetLogicWarehouseCode()).relevanceTableNameEnum(receiveDeliveryNoticeOrderContext.getRelevanceTableName()).orderType(receiveDeliveryNoticeOrderContext.getJumpDocumentType()).inOut(receiveDeliveryNoticeOrderContext.getOperateTypeEnum().getCode()).relevanceNo(receiveDeliveryNoticeOrderContext.getRelevanceNo()).build()) && receiveDeliveryNoticeOrderContext.getGenerateInOut().booleanValue() && !TypeOfDocumentEnum.REFUND_ORDER.getCode().equals(receiveDeliveryNoticeOrderContext.getJumpDocumentType())) {
            log.info("\u4e0d\u7528\u63a8\u9001wms\u8bbe\u7f6e\u81ea\u52a8\u5b8c\u6210");
            facadeBo.setAutoComplete(true);
            receiveDeliveryNoticeOrderContext.setAutoComplete(true);
        }
    }

    private InOutNoticeOrderContext getInOutNoticeOrderContext(ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext) {
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderContext, InOutNoticeOrderContext.class, (String[])new String[0]);
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo();
        outNoticeOrderContext.setPreOrderNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
        InOutNoticeOrderEo inOutNoticeOrderEo = Objects.nonNull(outNoticeOrderContext.getInOutNoticeOrderEo()) ? outNoticeOrderContext.getInOutNoticeOrderEo() : new InOutNoticeOrderEo();
        this.receiveDeliveryToOutIn(receiveDeliveryNoticeOrderEo, inOutNoticeOrderEo);
        outNoticeOrderContext.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        outNoticeOrderContext.setSendWms(receiveDeliveryNoticeOrderContext.isSendWms());
        outNoticeOrderContext.setAutoComplete(receiveDeliveryNoticeOrderContext.getAutoComplete());
        outNoticeOrderContext.setShopId(receiveDeliveryNoticeOrderEo.getShopId());
        outNoticeOrderContext.setShopCode(receiveDeliveryNoticeOrderEo.getShopCode());
        outNoticeOrderContext.setShopName(receiveDeliveryNoticeOrderEo.getShopName());
        return outNoticeOrderContext;
    }

    private void receiveDeliveryToOutIn(ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo, InOutNoticeOrderEo inOutNoticeOrderEo) {
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode())) {
            inOutNoticeOrderEo.setOutLogicWarehouseCode(receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseName())) {
            inOutNoticeOrderEo.setOutLogicWarehouseName(receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseCode())) {
            inOutNoticeOrderEo.setOutPhysicsWarehouseCode(receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseName())) {
            inOutNoticeOrderEo.setOutPhysicsWarehouseName(receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode())) {
            inOutNoticeOrderEo.setInLogicWarehouseCode(receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseName())) {
            inOutNoticeOrderEo.setInLogicWarehouseName(receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseCode())) {
            inOutNoticeOrderEo.setInPhysicsWarehouseCode(receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseName())) {
            inOutNoticeOrderEo.setInPhysicsWarehouseName(receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode())) {
            inOutNoticeOrderEo.setShipmentEnterpriseCode(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShipmentEnterpriseName())) {
            inOutNoticeOrderEo.setShipmentEnterpriseName(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShippingCode())) {
            inOutNoticeOrderEo.setShippingCode(receiveDeliveryNoticeOrderEo.getShippingCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDisplayBusinessType())) {
            inOutNoticeOrderEo.setDisplayBusinessType(receiveDeliveryNoticeOrderEo.getDisplayBusinessType());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getDisplayBusinessName())) {
            inOutNoticeOrderEo.setDisplayBusinessName(receiveDeliveryNoticeOrderEo.getDisplayBusinessName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getJumpDocumentType())) {
            inOutNoticeOrderEo.setJumpDocumentType(receiveDeliveryNoticeOrderEo.getJumpDocumentType());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getJumpDocumentName())) {
            inOutNoticeOrderEo.setJumpDocumentName(receiveDeliveryNoticeOrderEo.getJumpDocumentName());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getRepairOrderNo())) {
            inOutNoticeOrderEo.setRepairOrderNo(receiveDeliveryNoticeOrderEo.getRepairOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShopCode())) {
            inOutNoticeOrderEo.setShopCode(receiveDeliveryNoticeOrderEo.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShopName())) {
            inOutNoticeOrderEo.setShopName(receiveDeliveryNoticeOrderEo.getShopName());
        }
        if (Objects.nonNull(receiveDeliveryNoticeOrderEo.getShopId())) {
            inOutNoticeOrderEo.setShopId(receiveDeliveryNoticeOrderEo.getShopId());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getOaidOrderSourceCode())) {
            inOutNoticeOrderEo.setOaidOrderSourceCode(receiveDeliveryNoticeOrderEo.getOaidOrderSourceCode());
        }
        if (Objects.nonNull(receiveDeliveryNoticeOrderEo.getPayTime())) {
            inOutNoticeOrderEo.setPayTime(receiveDeliveryNoticeOrderEo.getPayTime());
        }
        if (Objects.nonNull(receiveDeliveryNoticeOrderEo.getTradeOrderCreateTime())) {
            inOutNoticeOrderEo.setTradeOrderCreateTime(receiveDeliveryNoticeOrderEo.getTradeOrderCreateTime());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getSourcePlatformCode())) {
            inOutNoticeOrderEo.setSourcePlatformCode(receiveDeliveryNoticeOrderEo.getSourcePlatformCode());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getExchangePlatformAfterSaleOrderNo())) {
            inOutNoticeOrderEo.setExchangePlatformAfterSaleOrderNo(receiveDeliveryNoticeOrderEo.getExchangePlatformAfterSaleOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getRepairOrderNo())) {
            inOutNoticeOrderEo.setRepairOrderNo(receiveDeliveryNoticeOrderEo.getRepairOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getWmsOrderNo())) {
            inOutNoticeOrderEo.setWmsOrderNo(receiveDeliveryNoticeOrderEo.getWmsOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getShippingJson())) {
            inOutNoticeOrderEo.setShippingJson(receiveDeliveryNoticeOrderEo.getShippingJson());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getLogisticsOrderNo())) {
            inOutNoticeOrderEo.setLogisticsOrderNo(receiveDeliveryNoticeOrderEo.getLogisticsOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)receiveDeliveryNoticeOrderEo.getOffsetType())) {
            inOutNoticeOrderEo.setOffsetType(receiveDeliveryNoticeOrderEo.getOffsetType());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public InOutResultOrderContext inResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        return this.inOutBackBaseOrderFacadeHelper.inResultOrderGen(facadeBo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public InOutResultOrderContext adjustResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        return this.inOutBackBaseOrderFacadeHelper.adjustResultOrderGen(facadeBo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public InOutResultOrderContext assembleDisassembleResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        return this.inOutBackBaseOrderFacadeHelper.assembleDisassembleResultOrderGen(facadeBo);
    }

    private InOutResultOrderContext inOutResultOrderComplete(InOutResultOrderContext context, InOutNoticeOrderEo inOutNoticeOrderEo) {
        log.info("inOutResultOrderComplete-InOutResultOrderContext:{}", (Object)JSON.toJSONString((Object)context));
        if (context.getAutoComplete().booleanValue() || !context.isLinkNoticeUpdate()) {
            return context;
        }
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)context, InOutNoticeOrderContext.class, (String[])new String[0]);
        outNoticeOrderContext.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
        if ("in".equals(context.getInOutResultOrderEo().getOrderType())) {
            this.inNoticeOrderAbleImpl.complete(outNoticeOrderContext);
        } else if ("out".equals(context.getInOutResultOrderEo().getOrderType())) {
            this.outNoticeOrderAbleImpl.complete(outNoticeOrderContext);
        } else {
            this.adjustNoticeOrderAble.complete(outNoticeOrderContext);
        }
        context.execComplete(context);
        if (outNoticeOrderContext.isNoticeEnd()) {
            InventoryConfig.pushEvent(new InOutNoticeOrderCompleteEvent(outNoticeOrderContext));
        }
        return context;
    }

    private InOutResultOrderContext getInOutResultOrderContext(InOutResultOrderFacadeBo facadeBo) {
        AssertUtil.isTrue((facadeBo.getInOutNoticeOrderEo() != null ? 1 : 0) != 0, (String)"\u5173\u8054\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(facadeBo.getInOutNoticeOrderDetailEos()), (String)"\u5173\u8054\u901a\u77e5\u5355\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        InOutResultOrderContext context = (InOutResultOrderContext)BeanUtil.copyProperties((Object)facadeBo, InOutResultOrderContext.class, (String[])new String[0]);
        InOutNoticeOrderEo inOutNoticeOrderEo = facadeBo.getInOutNoticeOrderEo();
        context.setMultipleIn(InventoryConfig.isMultipleIn());
        context.setMultipleOut(InventoryConfig.isMultipleOut());
        context.setPreOrderNo(inOutNoticeOrderEo.getDocumentNo());
        context.setBusinessType(inOutNoticeOrderEo.getBusinessType());
        context.setExternalOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
        context.setRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        context.setDisplayBusinessType(inOutNoticeOrderEo.getDisplayBusinessType());
        context.setDisplayBusinessName(inOutNoticeOrderEo.getDisplayBusinessName());
        context.setJumpDocumentType(inOutNoticeOrderEo.getJumpDocumentType());
        context.setJumpDocumentName(inOutNoticeOrderEo.getJumpDocumentName());
        context.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutNoticeOrderEo.getRelevanceTableName()));
        context.setTotalQuantity(facadeBo.getOrderBasicsDetailReqDtoList().stream().map(OrderUnitConverterDto::getQuantity).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        InOutResultOrderEo outResultOrderEo = Optional.ofNullable(context.getInOutResultOrderEo()).orElse(new InOutResultOrderEo());
        outResultOrderEo.setExtension(inOutNoticeOrderEo.getExtension());
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutLogicWarehouseCode())) {
            outResultOrderEo.setOutLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutLogicWarehouseName())) {
            outResultOrderEo.setOutLogicWarehouseName(inOutNoticeOrderEo.getOutLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInventoryProperty())) {
            outResultOrderEo.setInventoryProperty(inOutNoticeOrderEo.getInventoryProperty());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutPhysicsWarehouseCode())) {
            outResultOrderEo.setOutPhysicsWarehouseCode(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutPhysicsWarehouseName())) {
            outResultOrderEo.setOutPhysicsWarehouseName(inOutNoticeOrderEo.getOutPhysicsWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInLogicWarehouseCode())) {
            outResultOrderEo.setInLogicWarehouseCode(inOutNoticeOrderEo.getInLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInLogicWarehouseName())) {
            outResultOrderEo.setInLogicWarehouseName(inOutNoticeOrderEo.getInLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInPhysicsWarehouseCode())) {
            outResultOrderEo.setInPhysicsWarehouseCode(inOutNoticeOrderEo.getInPhysicsWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInPhysicsWarehouseName())) {
            outResultOrderEo.setInPhysicsWarehouseName(inOutNoticeOrderEo.getInPhysicsWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getShopCode())) {
            outResultOrderEo.setShopCode(inOutNoticeOrderEo.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getShopName())) {
            outResultOrderEo.setShopName(inOutNoticeOrderEo.getShopName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getWmsOrderNo())) {
            outResultOrderEo.setWmsOrderNo(inOutNoticeOrderEo.getWmsOrderNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)inOutNoticeOrderEo.getLogisticsOrderNo())) {
            outResultOrderEo.setLogisticsOrderNo(inOutNoticeOrderEo.getLogisticsOrderNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)inOutNoticeOrderEo.getOffsetType())) {
            outResultOrderEo.setOffsetType(inOutNoticeOrderEo.getOffsetType());
        }
        context.setInOutResultOrderEo(outResultOrderEo);
        BaseOrderExtensionHelper.loadByExtension(context, inOutNoticeOrderEo);
        context.setExtension(facadeBo.getExtensionExternal());
        return context;
    }

    @Override
    public InOutResultOrderContext outResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        return this.inOutBackBaseOrderFacadeHelper.outResultOrderGen(facadeBo);
    }

    @NotNull
    private ReceiveDeliveryResultOrderEo initRdResultByInOutResult(InOutResultOrderEo inOutResultOrderEo) {
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)BeanUtil.copyProperties((Object)inOutResultOrderEo, ReceiveDeliveryResultOrderEo.class, (String[])new String[0]);
        receiveDeliveryResultOrderEo.setDeliveryLogicWarehouseCode(inOutResultOrderEo.getOutLogicWarehouseCode());
        receiveDeliveryResultOrderEo.setDeliveryLogicWarehouseName(inOutResultOrderEo.getOutLogicWarehouseName());
        receiveDeliveryResultOrderEo.setInventoryProperty(inOutResultOrderEo.getInventoryProperty());
        receiveDeliveryResultOrderEo.setDeliveryPhysicsWarehouseCode(inOutResultOrderEo.getOutPhysicsWarehouseCode());
        receiveDeliveryResultOrderEo.setDeliveryPhysicsWarehouseName(inOutResultOrderEo.getOutPhysicsWarehouseName());
        receiveDeliveryResultOrderEo.setReceiveLogicWarehouseCode(inOutResultOrderEo.getInLogicWarehouseCode());
        receiveDeliveryResultOrderEo.setReceiveLogicWarehouseName(inOutResultOrderEo.getInLogicWarehouseName());
        receiveDeliveryResultOrderEo.setReceivePhysicsWarehouseCode(inOutResultOrderEo.getInPhysicsWarehouseCode());
        receiveDeliveryResultOrderEo.setReceivePhysicsWarehouseName(inOutResultOrderEo.getInPhysicsWarehouseName());
        receiveDeliveryResultOrderEo.setShopCode(inOutResultOrderEo.getShopCode());
        receiveDeliveryResultOrderEo.setShopName(inOutResultOrderEo.getShopName());
        receiveDeliveryResultOrderEo.setWmsOrderNo(inOutResultOrderEo.getWmsOrderNo());
        receiveDeliveryResultOrderEo.setLogisticsOrderNo(inOutResultOrderEo.getLogisticsOrderNo());
        receiveDeliveryResultOrderEo.setShippingCode(inOutResultOrderEo.getShippingCode());
        receiveDeliveryResultOrderEo.setOffsetType(inOutResultOrderEo.getOffsetType());
        return receiveDeliveryResultOrderEo;
    }

    @Override
    public void receiveResultOrderGen(ReceiveDeliveryResultOrderContext context) {
        this.inOutBackBaseOrderFacadeHelper.receiveResultOrderGen(context);
    }

    @Override
    public void deliveryResultOrderGen(ReceiveDeliveryResultOrderContext context) {
        this.inOutBackBaseOrderFacadeHelper.deliveryResultOrderGen(context);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void inNoticeOrderClose(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN);
        this.inNoticeOrderAbleImpl.close(inOutNoticeOrderContext);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void outNoticeOrderClose(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
        this.outNoticeOrderAbleImpl.close(inOutNoticeOrderContext);
        if (BaseOrderDocumentTypeEnum.MERGE.getCode().equals(inOutNoticeOrderContext.getInOutNoticeOrderEo().getDocumentType())) {
            this.mergeOutNoticeOrderCloseProcess(baseOrderCommonCancelBo, inOutNoticeOrderContext.getInOutNoticeOrderEo());
        }
    }

    @Override
    public void assembleDisassembleOutNoticeOrderClose(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY);
        this.assemblyDisassemblyNoticeOrderAble.close(inOutNoticeOrderContext);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void receiveNoticeOrderClose(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        this.receiveNoticeOrderAbleImpl.close(receiveDeliveryNoticeOrderContext);
        List noticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"pre_order_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.INO_PORTION_IN.getCode()}))).list();
        Optional.ofNullable(noticeOrderEos).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> eos.forEach(eo -> {
            BaseOrderCommonCancelBo bo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            bo.setDocumentNo(eo.getDocumentNo());
            this.inNoticeOrderClose(bo);
        }));
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.pushEvent(new BaseOrderReceiveNoticeCloseEvent(receiveDeliveryNoticeOrderContext));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void deliveryNoticeOrderClose(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.DELIVERY);
        this.deliveryNoticeOrderAbleImpl.close(receiveDeliveryNoticeOrderContext);
        List noticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"pre_order_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_PORTION_OUT.getCode(), BaseOrderStatusEnum.ONO_WAIT_OUT.getCode()}))).list();
        Optional.ofNullable(noticeOrderEos).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> eos.forEach(eo -> {
            BaseOrderCommonCancelBo bo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            bo.setDocumentNo(eo.getDocumentNo());
            this.outNoticeOrderClose(bo);
        }));
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.pushEvent(new BaseOrderDeliveryNoticeCloseEvent(receiveDeliveryNoticeOrderContext));
        }
    }

    @Override
    public void inNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN);
        this.inNoticeOrderAbleImpl.cancel(inOutNoticeOrderContext);
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.pushEvent(new BaseOrderInNoticeCancelEvent(inOutNoticeOrderContext));
        }
    }

    public void adjustNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN_OUT);
        this.adjustNoticeOrderAble.cancel(inOutNoticeOrderContext);
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.pushEvent(new BaseOrderInNoticeCancelEvent(inOutNoticeOrderContext));
        }
    }

    @Override
    public void outNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        this.cancelSendOrder(baseOrderCommonCancelBo);
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)baseOrderCommonCancelBo.getDocumentNo())).one();
        AssertUtil.isTrue((null != inOutNoticeOrderEo ? 1 : 0) != 0, (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        ArrayList statusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_PORTION_OUT.getCode(), BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode()});
        AssertUtil.isTrue((boolean)statusList.contains(inOutNoticeOrderEo.getOrderStatus()), (String)("\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u53d6\u6d88:" + inOutNoticeOrderEo.getOrderStatus()));
        if (!baseOrderCommonCancelBo.isOnlyCurOrder() && StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getMergeDocumentNo())) {
            this.doOutNoticeCancel(baseOrderCommonCancelBo);
            InOutNoticeOrderEo mergeInOutNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getMergeDocumentNo())).one();
            baseOrderCommonCancelBo.setDocumentNo(mergeInOutNoticeOrderEo.getDocumentNo());
            ArrayList status = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_CANCEL.getCode()});
            if (status.contains(mergeInOutNoticeOrderEo.getOrderStatus())) {
                log.info("\u5408\u5355\u5df2\u53d6\u6d88\u4e0d\u5904\u7406:{}", (Object)mergeInOutNoticeOrderEo.getDocumentNo());
                return;
            }
            this.mergeOutNoticeOrderCancel(baseOrderCommonCancelBo, mergeInOutNoticeOrderEo);
            return;
        }
        if (BaseOrderDocumentTypeEnum.MERGE.getCode().equalsIgnoreCase(inOutNoticeOrderEo.getDocumentType())) {
            InOutNoticeOrderEo mergeInOutNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo())).one();
            this.mergeOutNoticeOrderCancel(baseOrderCommonCancelBo, mergeInOutNoticeOrderEo);
            return;
        }
        this.doOutNoticeCancel(baseOrderCommonCancelBo);
    }

    private void doOutNoticeCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
        this.outNoticeOrderAbleImpl.cancel(inOutNoticeOrderContext);
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.pushEvent(new BaseOrderOutNoticeCancelEvent(inOutNoticeOrderContext));
        }
    }

    public void mergeOutNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo, InOutNoticeOrderEo mergeInOutNoticeOrderEo) {
        baseOrderCommonCancelBo.setDocumentNo(mergeInOutNoticeOrderEo.getDocumentNo());
        this.doOutNoticeCancel(baseOrderCommonCancelBo);
        List subInOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"merge_document_no", (Object)mergeInOutNoticeOrderEo.getDocumentNo())).notIn((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_CANCEL.getCode()}))).list();
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode()});
        AssertUtil.isTrue((boolean)subInOutNoticeOrderEoList.stream().allMatch(r -> arrayList.contains(r.getOrderStatus())), (String)"\u5408\u5e76\u5b50\u5355\u5b58\u5728\u72b6\u6001\u5f02\u5e38");
        InventoryConfig.registerSynchronizationAfterCommit(() -> {
            MergeOrderNoticeVo mergeOrderNoticeVo = new MergeOrderNoticeVo();
            mergeOrderNoticeVo.setOptType("split");
            mergeOrderNoticeVo.setRelevanceOrderNos(subInOutNoticeOrderEoList.stream().map(InOutNoticeOrderEo::getRelevanceNo).distinct().collect(Collectors.toList()));
            mergeOrderNoticeVo.setMergeOrderNo(mergeInOutNoticeOrderEo.getDocumentNo());
            this.sendMqHelper.sendPublishMq(mergeOrderNoticeVo, "NOTICE_MERGE_TAG");
        });
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void mergeOutNoticeOrderCloseProcess(BaseOrderCommonCancelBo baseOrderCommonCancelBo, InOutNoticeOrderEo mergeInOutNoticeOrderEo) {
        log.info("\u5408\u5355\u901a\u77e5\u5355\u5b8c\u7ed3\u5904\u7406:{}", (Object)baseOrderCommonCancelBo.getDocumentNo());
        baseOrderCommonCancelBo.setDocumentNo(mergeInOutNoticeOrderEo.getDocumentNo());
        List subInOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"merge_document_no", (Object)mergeInOutNoticeOrderEo.getDocumentNo())).notIn((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_CANCEL.getCode()}))).list();
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode(), BaseOrderStatusEnum.ONO_PORTION_OUT.getCode()});
        AssertUtil.isTrue((boolean)subInOutNoticeOrderEoList.stream().allMatch(r -> arrayList.contains(r.getOrderStatus())), (String)"\u5408\u5e76\u5b50\u5355\u5b58\u5728\u72b6\u6001\u5f02\u5e38");
        List receiveDeliveryNoticeOrderEos = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().in((Object)"document_no", (Collection)subInOutNoticeOrderEoList.stream().map(InOutNoticeOrderEo::getPreOrderNo).collect(Collectors.toList()))).list();
        receiveDeliveryNoticeOrderEos.forEach(r -> {
            BaseOrderCommonCancelBo commonCancelBo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            commonCancelBo.setDocumentNo(r.getDocumentNo());
            this.deliveryNoticeOrderClose(commonCancelBo);
        });
    }

    @NotNull
    private InOutNoticeOrderContext getInOutNoticeOrderCancelContext(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = new InOutNoticeOrderContext();
        inOutNoticeOrderContext.setDocumentNo(baseOrderCommonCancelBo.getDocumentNo());
        inOutNoticeOrderContext.setSourceType(baseOrderCommonCancelBo.getSourceType());
        inOutNoticeOrderContext.setRemark(baseOrderCommonCancelBo.getRemark());
        inOutNoticeOrderContext.setCancelBizOrder(baseOrderCommonCancelBo.isCancelBizOrder());
        inOutNoticeOrderContext.setCancelWms(baseOrderCommonCancelBo.isCancelWms());
        return inOutNoticeOrderContext;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void receiveNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        this.receiveNoticeOrderAbleImpl.cancel(receiveDeliveryNoticeOrderContext);
        boolean isAdjust = Arrays.asList("inventory_status_adjustment", "batch_adjustment_order").contains(baseOrderCommonCancelBo.getBusinessType());
        List noticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"pre_order_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.INO_PORTION_IN.getCode()}))).list();
        Optional.ofNullable(noticeOrderEos).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> eos.forEach(eo -> {
            BaseOrderCommonCancelBo bo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            bo.setDocumentNo(eo.getDocumentNo());
            bo.setCancelWms(!isAdjust);
            bo.setPushEvent(!isAdjust && bo.isPushEvent());
            this.inNoticeOrderCancel(bo);
        }));
        if (isAdjust) {
            List adjustNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)receiveDeliveryNoticeOrderContext.getRelevanceNo())).eq((Object)"order_type", (Object)BaseOrderOperateTypeEnum.IN_OUT.getCode().toLowerCase())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.INO_PORTION_IN.getCode()}))).list();
            Optional.ofNullable(adjustNoticeOrderEos).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> eos.forEach(eo -> {
                BaseOrderCommonCancelBo bo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, BaseOrderCommonCancelBo.class, (String[])new String[0]);
                bo.setDocumentNo(eo.getDocumentNo());
                this.adjustNoticeOrderCancel(bo);
            }));
        }
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.pushEvent(new BaseOrderReceiveNoticeCancelEvent(receiveDeliveryNoticeOrderContext));
        }
    }

    private void cancelSendOrder(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        SendOrderDetailDto sendOrderDetailDto = new SendOrderDetailDto();
        sendOrderDetailDto.setDocumentNo(baseOrderCommonCancelBo.getDocumentNo());
        sendOrderDetailDto.setNoticeStatus(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        if (InventoryConfig.isCanSendLogistics()) {
            RestResponseHelper.checkOrThrow((RestResponse)this.iSendOrderApiProxy.updateStatus(sendOrderDetailDto));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void deliveryNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, ReceiveDeliveryNoticeOrderContext.class, (String[])new String[0]);
        receiveDeliveryNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.DELIVERY);
        this.deliveryNoticeOrderAbleImpl.cancel(receiveDeliveryNoticeOrderContext);
        List noticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"pre_order_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_PORTION_OUT.getCode(), BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode()}))).list();
        Optional.ofNullable(noticeOrderEos).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> eos.forEach(eo -> {
            BaseOrderCommonCancelBo bo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)baseOrderCommonCancelBo, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            bo.setDocumentNo(eo.getDocumentNo());
            this.outNoticeOrderCancel(bo);
        }));
        if (baseOrderCommonCancelBo.isPushEvent()) {
            InventoryConfig.pushEvent(new BaseOrderDeliveryNoticeCancelEvent(receiveDeliveryNoticeOrderContext));
        }
    }

    @Override
    public void assembleDisassembleOutNoticeOrderCancel(BaseOrderCommonCancelBo baseOrderCommonCancelBo) {
        this.cancelSendOrder(baseOrderCommonCancelBo);
        InOutNoticeOrderContext inOutNoticeOrderContext = this.getInOutNoticeOrderCancelContext(baseOrderCommonCancelBo);
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY);
        this.assemblyDisassemblyNoticeOrderAble.cancel(inOutNoticeOrderContext);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void outResultOrderConfirm(InOutResultOrderConfirmFacadeBo facadeBo) {
        InOutResultOrderContext inOutResultOrderContext = this.wrapperConfirmContext(facadeBo);
        this.outResultOrderAbleImpl.confirm(inOutResultOrderContext);
        if (facadeBo.isOnlyProcessResult()) {
            return;
        }
        List receiveDeliveryResultOrderEos = this.receiveDeliveryResultOrderDomain.queryByPreOrderNo(facadeBo.getDocumentNo());
        if (CollectionUtils.isEmpty((Collection)receiveDeliveryResultOrderEos)) {
            ReceiveDeliveryResultOrderContext resultOrderContext = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
            resultOrderContext.setPreOrderNo(inOutResultOrderContext.getDocumentNo());
            this.deliveryResultOrderGen(resultOrderContext);
            InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderOutBackEvent(resultOrderContext));
        }
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, InOutNoticeOrderContext.class, (String[])new String[0]);
        outNoticeOrderContext.setDocumentNo(inOutResultOrderContext.getPreOrderNo());
        this.outNoticeOrderAbleImpl.complete(outNoticeOrderContext);
        inOutResultOrderContext.execComplete(inOutResultOrderContext);
    }

    @Override
    public void inOutResultOrderUnhook(InOutResultOrderUnhookFacadeBo facadeBo) {
        this.unHookBaseOrderFacadeHelper.inOutResultOrderUnhook(facadeBo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void receiveNoticeOrderCloseByRelevanceNo(BaseOrderCommonCancelBo receiveDeliveryNoticeOrderContext) {
        List<ReceiveDeliveryNoticeOrderEo> receiveDeliveryNoticeOrderEos = this.loadByRelevanceNo(receiveDeliveryNoticeOrderContext, Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode(), BaseOrderStatusEnum.RNO_WAIT_RECEIVE.getCode()}));
        receiveDeliveryNoticeOrderEos.forEach(document -> {
            BaseOrderCommonCancelBo baseOrderCommonCancelBo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderContext, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            baseOrderCommonCancelBo.setDocumentNo(document.getDocumentNo());
            this.receiveNoticeOrderClose(baseOrderCommonCancelBo);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void deliveryNoticeOrderCloseByRelevanceNo(BaseOrderCommonCancelBo receiveDeliveryNoticeOrderContext) {
        List<ReceiveDeliveryNoticeOrderEo> deliveryNoticeOrderEoList = this.loadByRelevanceNo(receiveDeliveryNoticeOrderContext, Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode(), BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode()}));
        deliveryNoticeOrderEoList.forEach(document -> {
            BaseOrderCommonCancelBo baseOrderCommonCancelBo = (BaseOrderCommonCancelBo)BeanUtil.copyProperties((Object)receiveDeliveryNoticeOrderContext, BaseOrderCommonCancelBo.class, (String[])new String[0]);
            baseOrderCommonCancelBo.setDocumentNo(document.getDocumentNo());
            this.deliveryNoticeOrderClose(baseOrderCommonCancelBo);
        });
    }

    @Override
    public void retryMq(String documentNo) {
        InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"document_no", (Object)documentNo)).one();
        List inOutResultOrderDetailEos = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
        InOutResultOrderConfirmFacadeBo facadeBo = new InOutResultOrderConfirmFacadeBo();
        facadeBo.setInOutResultOrderEo(inOutResultOrderEo);
        facadeBo.setInOutResultOrderEoList(inOutResultOrderDetailEos);
        facadeBo.setOrderType(inOutResultOrderEo.getOrderType());
        InOutResultOrderContext inOutResultOrderContext = this.wrapperConfirmContext(facadeBo);
        ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)inOutResultOrderContext, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
        ReceiveDeliveryResultOrderEo deliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"pre_order_no", (Object)inOutResultOrderEo.getDocumentNo())).eq((Object)"relevance_no", (Object)inOutResultOrderEo.getRelevanceNo())).one();
        List receiveDeliveryResultOrderDetailEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().eq((Object)"document_no", (Object)deliveryResultOrderEo.getDocumentNo())).list();
        receiveDeliveryResultOrderContext.setReceiveDeliveryResultOrderEo(deliveryResultOrderEo);
        receiveDeliveryResultOrderContext.setReceiveDeliveryResultOrderDetailEoList(receiveDeliveryResultOrderDetailEos);
        receiveDeliveryResultOrderContext.setDocumentNo(deliveryResultOrderEo.getDocumentNo());
        receiveDeliveryResultOrderContext.setPreOrderNo(deliveryResultOrderEo.getPreOrderNo());
        receiveDeliveryResultOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE.getCode().equalsIgnoreCase(deliveryResultOrderEo.getOrderType()) ? BaseOrderOperateTypeEnum.RECEIVE : BaseOrderOperateTypeEnum.DELIVERY);
        this.sendMqHelper.sendPublishMq(receiveDeliveryResultOrderContext, BaseOrderOperateTypeEnum.RECEIVE.getCode().equalsIgnoreCase(deliveryResultOrderEo.getOrderType()) ? "inBack" : "outBack", (TransactionCallback<Boolean>)((TransactionCallback)transactionStatus -> true));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void mergeOutResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        this.inOutBackBaseOrderFacadeHelper.mergeOutResultOrderGen(facadeBo);
    }

    private List<ReceiveDeliveryNoticeOrderEo> loadByRelevanceNo(BaseOrderCommonCancelBo receiveDeliveryNoticeOrderContext, List<String> statusList) {
        AssertUtil.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)receiveDeliveryNoticeOrderContext.getRelevanceNo()), (String)"\u5173\u8054\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)receiveDeliveryNoticeOrderContext.getRelevanceNo())).in((Object)"order_status", statusList)).list();
    }

    @NotNull
    private InOutResultOrderContext wrapperConfirmContext(InOutResultOrderConfirmFacadeBo facadeBo) {
        InOutResultOrderEo inOutResultOrderEo = Optional.ofNullable(facadeBo.getInOutResultOrderEo()).orElseGet(() -> (InOutResultOrderEo)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"document_no", (Object)facadeBo.getDocumentNo())).oneOpt().orElseThrow(() -> new BizException("\u65e0\u6cd5\u627e\u5230\u7ed3\u679c\u5355:{}", facadeBo.getDocumentNo())));
        InOutResultOrderContext inOutResultOrderContext = (InOutResultOrderContext)BeanUtil.copyProperties((Object)facadeBo, InOutResultOrderContext.class, (String[])new String[0]);
        inOutResultOrderContext.setInOutResultOrderEo(inOutResultOrderEo);
        inOutResultOrderContext.setDocumentNo(inOutResultOrderEo.getDocumentNo());
        inOutResultOrderContext.setInOutResultOrderDetailEoList(Optional.ofNullable(facadeBo.getInOutResultOrderEoList()).filter(CollectionUtils::isNotEmpty).orElseGet(() -> ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"document_no", (Object)facadeBo.getDocumentNo())).list()));
        BeanUtil.copyProperties((Object)inOutResultOrderEo, (Object)inOutResultOrderContext, (String[])new String[0]);
        inOutResultOrderContext.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutResultOrderEo.getRelevanceTableName()));
        inOutResultOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.getByCode(inOutResultOrderEo.getOrderType()));
        inOutResultOrderContext.setOrderBasicsDetailReqDtoList(inOutResultOrderContext.getInOutResultOrderDetailEoList().stream().map(re -> {
            BaseOrderDetailReqDto reqDto = (BaseOrderDetailReqDto)((Object)((Object)BeanUtil.copyProperties((Object)re, BaseOrderDetailReqDto.class, (String[])new String[0])));
            reqDto.setSnCodes(DataExtractUtils.strToList((String)re.getSnCode(), (String)","));
            reqDto.setRelateId(re.getId());
            return reqDto;
        }).collect(Collectors.toList()));
        BaseOrderExtensionHelper.loadByExtension(inOutResultOrderContext, inOutResultOrderEo);
        inOutResultOrderContext.setShippingInfoReqDtoList(DataExtractUtils.jsonStrToList((String)inOutResultOrderEo.getShippingJson(), CsWmsShippingInfoReqDto.class));
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)inOutResultOrderContext.getRelevanceTableName()) && StringUtils.isBlank((CharSequence)inOutResultOrderContext.getTransferInLogicWarehouseCode())) {
            ((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutResultOrderEo.getPreOrderNo())).oneOpt().ifPresent(r -> inOutResultOrderContext.setTransferInLogicWarehouseCode(r.getInLogicWarehouseCode()));
        }
        return inOutResultOrderContext;
    }
}

