/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.impl;

import com.alibaba.fastjson.JSON;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.abstracts.AbstractInOutNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OutNoticeOrderAbleImpl
extends AbstractInOutNoticeOrderAble {
    private static final Logger log = LoggerFactory.getLogger(OutNoticeOrderAbleImpl.class);

    @Override
    protected void wrapperGenerateAfter(InOutNoticeOrderContext context) {
    }

    @Override
    protected void wrapperGenerate(InOutNoticeOrderContext context) {
        InOutNoticeOrderEo outNoticeOrderEo = context.getInOutNoticeOrderEo();
        outNoticeOrderEo.setOutLogicWarehouseCode(context.getLogicWarehouseCode());
        outNoticeOrderEo.setOutLogicWarehouseName(context.getLogicWarehouseName());
        outNoticeOrderEo.setOutPhysicsWarehouseCode(context.getPhysicsWarehouseCode());
        outNoticeOrderEo.setOutPhysicsWarehouseName(context.getPhysicsWarehouseName());
        outNoticeOrderEo.setWarehouseCode(context.getPhysicsWarehouseCode());
    }

    @Override
    public boolean validCancel(InOutNoticeOrderContext context) {
        if (!super.validCancel(context)) {
            return false;
        }
        if (BaseOrderStatusEnum.ONO_CANCEL.getCode().equals(context.getInOutNoticeOrderEo().getOrderStatus())) {
            log.error("\u5df2\u53d6\u6d88\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u53d6\u6d88:{}", (Object)context.getDocumentNo());
            return false;
        }
        return true;
    }

    @Override
    protected String getCompleteStatus(InOutNoticeOrderContext inOutNoticeOrderContext) {
        return inOutNoticeOrderContext.isNoticeEnd() ? (inOutNoticeOrderContext.isNoticeEndStatus() ? BaseOrderStatusEnum.FINISH_OVER.getCode() : BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode()) : BaseOrderStatusEnum.ONO_PORTION_OUT.getCode();
    }

    @Override
    public void doClose(InOutNoticeOrderContext context) {
        super.doClose(context);
        log.info("\u51fa\u5e93\u901a\u77e5\u5355\u6267\u884c\u5b8c\u7ed3\u903b\u8f91\uff1a{}", (Object)JSON.toJSONString((Object)context));
        InOutNoticeOrderEo inOutNoticeOrderEo = context.getInOutNoticeOrderEo();
        this.updateStatus(inOutNoticeOrderEo, BaseOrderStatusEnum.FINISH_OVER);
        this.updateDetailQuantity(context);
    }

    @Override
    public void doCancel(InOutNoticeOrderContext context) {
        super.doCancel(context);
        InOutNoticeOrderEo inOutNoticeOrderEo = context.getInOutNoticeOrderEo();
        this.updateStatus(inOutNoticeOrderEo, BaseOrderStatusEnum.ONO_CANCEL);
        this.updateDetailQuantity(context);
    }
}

