/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.assemble.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.AssemblyDisassemblyOrderBizTypeEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CommitEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.AssemblyDisassemblyOrderConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IAssemblyDisassemblyOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IAssemblyDisassemblyOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IAutomaticAuditPolicyDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderAuditReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderItemComboRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderItemRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderProcessReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsReceiveReqDto;
import com.yunxi.dg.base.center.inventory.eo.AssemblyDisassemblyOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.AssemblyDisassemblyOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.service.annotatin.OptLogContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.PushWmsAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.assemble.IAssemblyDisassemblyOrderService;
import com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.enums.AssemblyDisassemblyOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.enums.AssemblyDisassemblyOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.service.commons.CommonService;
import com.yunxi.dg.base.center.inventory.service.commonsendback.CommonSendBackAble;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineMap;
import com.yunxi.dg.base.center.inventory.statemachine.executor.AssemblyDisassemblyOrderStatemachineExecutor;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.item.dto.old.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AssemblyDisassemblyOrderServiceImpl
extends BaseServiceImpl<AssemblyDisassemblyOrderDto, AssemblyDisassemblyOrderEo, IAssemblyDisassemblyOrderDomain>
implements IAssemblyDisassemblyOrderService {
    private static final Logger log = LoggerFactory.getLogger(AssemblyDisassemblyOrderServiceImpl.class);
    @Resource
    protected GenerateCodeUtil generateCodeUtil;
    @Resource
    protected IAssemblyDisassemblyOrderDetailDomain assemblyDisassemblyOrderDetailDomain;
    @Resource
    protected AssemblyDisassemblyOrderStatemachineExecutor assemblyDisassemblyOrderStatemachineExecutor;
    @Resource
    protected ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    protected IContext context;
    @Resource
    private CommonService commonService;
    @Resource
    protected CommonSendBackAble commonSendBackAble;
    @Resource
    protected IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    protected BaseOrderFacade baseOrderFacade;
    @Resource
    protected IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    protected IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    protected IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    protected IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private RepeatFilter repeatFilter;
    @Resource
    protected IAutomaticAuditPolicyDomain automaticAuditPolicyDomain;
    @Resource
    private IItemSkuDgQueryApiProxy skuDgQueryApiProxy;

    public AssemblyDisassemblyOrderServiceImpl(IAssemblyDisassemblyOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<AssemblyDisassemblyOrderDto, AssemblyDisassemblyOrderEo> converter() {
        return AssemblyDisassemblyOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Long saveOrUpdate(AssemblyDisassemblyOrderComboReqDto reqDto) {
        log.info("\u65b0\u589e\u3001\u7f16\u8f91\u7ec4\u88c5\u62c6\u5378\u5355\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)reqDto));
        boolean isEdit = Objects.nonNull(reqDto.getOrder().getId());
        this.checkParam(reqDto);
        this.initOrder(reqDto);
        AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo = this.processAssemblyDisassemblyOrder(reqDto);
        List<AssemblyDisassemblyOrderDetailEo> detailList = this.processPackageAndDetailData(reqDto, assemblyDisassemblyOrderEo.getOrderNo());
        String logEvent = OperationLogTypeEnum.CREATED.name();
        if (isEdit) {
            logEvent = OperationLogTypeEnum.EDITED.name();
        }
        OptUtil.addOptLog((String)logEvent, (String)"EMPTY", (String)assemblyDisassemblyOrderEo.getOrderNo(), (String)CsRelevanceTableNameEnum.ASSEMBLY_DISASSEMBLY_ORDER.name());
        if (CommitEnum.isCommit((String)reqDto.getCommitType()) || CommitEnum.isAutoComplete((String)reqDto.getCommitType())) {
            this.submit(AssemblyDisassemblyOrderStatusEventEnum.SUBMIT, "\u63d0\u4ea4\u5931\u8d25", CommitEnum.isAutoComplete((String)reqDto.getCommitType()), assemblyDisassemblyOrderEo, detailList);
        }
        return assemblyDisassemblyOrderEo.getId();
    }

    @Override
    public void submit(String orderNo) {
        AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo = ((IAssemblyDisassemblyOrderDomain)this.domain).queryByOrderNo(orderNo);
        if (assemblyDisassemblyOrderEo == null) {
            throw new RuntimeException("\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List detailList = this.assemblyDisassemblyOrderDetailDomain.queryByOrderNo(orderNo);
        if (CollUtil.isEmpty((Collection)detailList)) {
            throw new RuntimeException("\u5355\u636e\u7236\u54c1\u3001\u5b50\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.submit(AssemblyDisassemblyOrderStatusEventEnum.SUBMIT, "\u63d0\u4ea4\u5931\u8d25", false, assemblyDisassemblyOrderEo, detailList);
    }

    private void submit(AssemblyDisassemblyOrderStatusEventEnum event, String errorMsg, boolean isAutoAudit, AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo, List<AssemblyDisassemblyOrderDetailEo> detailList) {
        this.executeMachine(event, errorMsg, assemblyDisassemblyOrderEo, detailList);
        AssemblyDisassemblyOrderBizTypeEnum typeEnum = AssemblyDisassemblyOrderBizTypeEnum.getByType((Integer)assemblyDisassemblyOrderEo.getBizType());
        boolean bl = isAutoAudit = isAutoAudit || this.automaticAuditPolicyDomain.isAutoAudit(CsRelevanceTableNameEnum.ASSEMBLY_DISASSEMBLY_ORDER.getCode(), typeEnum.name());
        if (isAutoAudit && AssemblyDisassemblyOrderStatusEnum.isWaitAudit(assemblyDisassemblyOrderEo.getOrderStatus())) {
            AssemblyDisassemblyOrderAuditReqDto auditReqDto = new AssemblyDisassemblyOrderAuditReqDto();
            auditReqDto.setOrderNo(assemblyDisassemblyOrderEo.getOrderNo());
            auditReqDto.setAuditResult(Integer.valueOf(1));
            auditReqDto.setRemark("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
            this.audit(auditReqDto);
        }
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.WITHDRAW, orderCodeSpel="#orderNo", value="ASSEMBLY_DISASSEMBLY_ORDER")
    public void withdraw(String orderNo) {
        log.info("\u7ec4\u88c5\u62c6\u5378\u5355\u64a4\u9500\u5355\u53f7\uff1a{}", (Object)orderNo);
        AssemblyDisassemblyOrderEo orderEo = ((IAssemblyDisassemblyOrderDomain)this.domain).queryByOrderNo(orderNo);
        if (orderEo == null) {
            throw new RuntimeException("\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        AssertUtil.isTrue((boolean)AssemblyDisassemblyOrderStatusEnum.PROCESSING.getKey().equals(orderEo.getOrderStatus()), (String)"\u8be5\u5355\u636e\u4e0d\u662f\u52a0\u5de5\u4e2d\u72b6\u6001,\u4e0d\u53ef\u8fdb\u884c\u64a4\u9500\uff01");
        this.executeMachine(AssemblyDisassemblyOrderStatusEventEnum.WITHDRAW, "\u64a4\u9500\u5931\u8d25", orderEo, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    @OptLogContext(logType=OperationLogTypeEnum.CANCELED, orderCodeSpel="#orderNo", value="ASSEMBLY_DISASSEMBLY_ORDER")
    public void cancel(String orderNo) {
        log.info("\u7ec4\u88c5\u62c6\u5378\u5355\u53d6\u6d88\u5355\u53f7\uff1a{}", (Object)orderNo);
        AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo = ((IAssemblyDisassemblyOrderDomain)this.domain).queryByOrderNo(orderNo);
        if (assemblyDisassemblyOrderEo == null) {
            throw new RuntimeException("\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List detailList = this.assemblyDisassemblyOrderDetailDomain.queryByOrderNo(orderNo);
        if (CollUtil.isEmpty((Collection)detailList)) {
            throw new RuntimeException("\u5355\u636e\u7236\u54c1\u3001\u5b50\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.executeMachine(AssemblyDisassemblyOrderStatusEventEnum.CANCEL, "\u53d6\u6d88\u5931\u8d25", assemblyDisassemblyOrderEo, detailList);
    }

    @Override
    public void audit(AssemblyDisassemblyOrderAuditReqDto dto) {
        AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo = ((IAssemblyDisassemblyOrderDomain)this.domain).queryByOrderNo(dto.getOrderNo());
        if (assemblyDisassemblyOrderEo == null) {
            throw new RuntimeException("\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        AssemblyDisassemblyOrderDtoExtension extension = new AssemblyDisassemblyOrderDtoExtension();
        extension.setAuditRemark(dto.getRemark());
        assemblyDisassemblyOrderEo.setExtension(JSONObject.toJSONString((Object)extension));
        String logEvent = OperationLogTypeEnum.APPROVED.name();
        AssemblyDisassemblyOrderStatusEventEnum event = AssemblyDisassemblyOrderStatusEventEnum.AUDIT;
        if (dto.getAuditResult() == 0) {
            event = AssemblyDisassemblyOrderStatusEventEnum.AUDITFAILED;
            logEvent = OperationLogTypeEnum.REJECTED.name();
        }
        String remark = StringUtils.isNotBlank((CharSequence)dto.getRemark()) ? dto.getRemark() : "EMPTY";
        this.executeMachine(event, "\u5ba1\u6838\u5931\u8d25", assemblyDisassemblyOrderEo, null);
        OptUtil.addOptLog((String)logEvent, (String)remark, (String)dto.getOrderNo(), (String)CsRelevanceTableNameEnum.ASSEMBLY_DISASSEMBLY_ORDER.name());
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.CLOSE, orderCodeSpel="#orderNo", value="ASSEMBLY_DISASSEMBLY_ORDER")
    public void close(String orderNo) {
        log.info("\u7ec4\u88c5\u62c6\u5378\u5355\u5173\u95ed\u64cd\u4f5c\uff0c\u5355\u53f7\uff1a{}", (Object)orderNo);
        AssemblyDisassemblyOrderEo orderEo = ((IAssemblyDisassemblyOrderDomain)this.domain).queryByOrderNo(orderNo);
        if (orderEo == null) {
            throw new RuntimeException("\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        AssertUtil.isTrue((boolean)AssemblyDisassemblyOrderStatusEnum.PORTION_PROCESSING.getKey().equals(orderEo.getOrderStatus()), (String)"\u8be5\u5355\u636e\u4e0d\u662f\u90e8\u5206\u52a0\u5de5\u72b6\u6001,\u4e0d\u53ef\u8fdb\u884c\u5173\u95ed\u64cd\u4f5c\uff01");
        this.executeMachine(AssemblyDisassemblyOrderStatusEventEnum.CLOSE, "\u5173\u95ed\u5931\u8d25", orderEo, null);
    }

    @Override
    public void processById(Long id) {
        AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo = (AssemblyDisassemblyOrderEo)((IAssemblyDisassemblyOrderDomain)this.domain).selectByPrimaryKey(id);
        if (assemblyDisassemblyOrderEo == null) {
            throw new RuntimeException("\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List detailList = this.assemblyDisassemblyOrderDetailDomain.queryByOrderNo(assemblyDisassemblyOrderEo.getOrderNo());
        if (CollUtil.isEmpty((Collection)detailList)) {
            throw new RuntimeException("\u5355\u636e\u7236\u54c1\u3001\u5b50\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.process(this.buildAssemblyDisassemblyOrderProcessReqDto(assemblyDisassemblyOrderEo, detailList));
    }

    public AssemblyDisassemblyOrderProcessReqDto buildAssemblyDisassemblyOrderProcessReqDto(AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo, List<AssemblyDisassemblyOrderDetailEo> detailList) {
        AssemblyDisassemblyOrderProcessReqDto reqDto = new AssemblyDisassemblyOrderProcessReqDto();
        reqDto.setOrderNo(assemblyDisassemblyOrderEo.getOrderNo());
        reqDto.setBizDate(assemblyDisassemblyOrderEo.getBizTime());
        reqDto.setBizType(assemblyDisassemblyOrderEo.getBizType());
        reqDto.setPackageList(detailList.stream().filter(x -> x.getType() == 0).map(x -> (AssemblyDisassemblyOrderDetailDto)BeanUtil.copyProperties((Object)x, AssemblyDisassemblyOrderDetailDto.class, (String[])new String[0])).collect(Collectors.toList()));
        reqDto.setDetailList(detailList.stream().filter(x -> x.getType() == 1).map(x -> (AssemblyDisassemblyOrderDetailDto)BeanUtil.copyProperties((Object)x, AssemblyDisassemblyOrderDetailDto.class, (String[])new String[0])).collect(Collectors.toList()));
        this.commonService.getSetUserName();
        return reqDto;
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.PROCESS_CONFIRM, orderCodeSpel="#reqDto.orderNo", value="ASSEMBLY_DISASSEMBLY_ORDER")
    public void process(AssemblyDisassemblyOrderProcessReqDto reqDto) {
        log.info("\u52a0\u5de5\u786e\u8ba4\u64cd\u4f5c:{}", (Object)JSON.toJSONString((Object)reqDto));
        AssemblyDisassemblyOrderEo orderEo = ((IAssemblyDisassemblyOrderDomain)this.domain).queryByOrderNo(reqDto.getOrderNo());
        if (orderEo == null) {
            throw new RuntimeException("\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        AssertUtil.isTrue((boolean)AssemblyDisassemblyOrderStatusEnum.canProcess(orderEo.getOrderStatus()), (String)"\u8be5\u5355\u636e\u4e0d\u662f\u52a0\u5de5\u4e2d/\u90e8\u5206\u52a0\u5de5\u4e2d\u72b6\u6001,\u4e0d\u53ef\u8fdb\u884c\u52a0\u5de5\u786e\u8ba4\uff01");
        this.repeatFilter.checkRepeat(orderEo.getOrderNo(), () -> {
            InOutResultOrderEo resultOrderEo = new InOutResultOrderEo();
            resultOrderEo.setRelevanceNo(orderEo.getOrderNo());
            resultOrderEo.setOrderType(BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY.getCode().toLowerCase());
            resultOrderEo.setOrderStatus(BaseOrderStatusEnum.ORO_HANG_UP.getCode());
            List outResultOrderEoList = this.inOutResultOrderDomain.selectList((BaseEo)resultOrderEo);
            if (CollectionUtils.isNotEmpty((Collection)outResultOrderEoList)) {
                throw new RuntimeException(String.format("\u901a\u77e5\u5355\u5b58\u5728\u6302\u8d77\u5355\u636e\uff0c\u5355\u636e\u53f7\uff1a%s", ((InOutResultOrderEo)outResultOrderEoList.get(0)).getDocumentNo()));
            }
            String relevanceNo = orderEo.getOrderNo();
            String orderType = BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY.getCode().toLowerCase();
            List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)relevanceNo)).eq((Object)"order_type", (Object)orderType)).notIn((Object)"order_status", new Object[]{BaseOrderStatusEnum.ONO_CANCEL.getCode(), BaseOrderStatusEnum.INO_CANCEL.getCode()})).list();
            AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos), (String)"\u67e5\u8be2\u4e0d\u5230\u7ec4\u88c5\u62c6\u5378\u901a\u77e5\u5355\u4fe1\u606f");
            InOutNoticeOrderEo assemblyDisassemblyNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
            reqDto.setWarehouseCode(orderEo.getLogicWarehouseCode());
            reqDto.setBizType(orderEo.getBizType());
            BasicsReceiveReqDto basicsReceiveBasicsReqDto = this.buildBasicsReceiveReqDto(reqDto, assemblyDisassemblyNoticeOrderEo);
            this.commonSendBackAble.receiveIn(basicsReceiveBasicsReqDto);
        }, true, "\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c");
    }

    public BasicsReceiveReqDto buildBasicsReceiveReqDto(AssemblyDisassemblyOrderProcessReqDto reqDto, InOutNoticeOrderEo assemblyDisassemblyNoticeOrderEo) {
        BasicsReceiveReqDto basicsReceiveReqDto = new BasicsReceiveReqDto();
        basicsReceiveReqDto.setBizDate(reqDto.getBizDate());
        basicsReceiveReqDto.setRelevanceNo(reqDto.getOrderNo());
        basicsReceiveReqDto.setInOutNoticeOrderNo(assemblyDisassemblyNoticeOrderEo.getDocumentNo());
        if (!InventoryConfig.isMultipleOut() || reqDto.getIsAutoComplete().booleanValue()) {
            basicsReceiveReqDto.setIsAllDeal(Integer.valueOf(1));
        }
        log.info("\u662f\u5426\u5b58\u5728\u591a\u4e2a\u8f93\u51fa\u9009\u9879\uff1a{}\uff0c\u662f\u5426\u9700\u8981\u81ea\u52a8\u5b8c\u6210\uff1a{}\uff0c \u52a0\u5de5\u786e\u8ba4\u72b6\u6001\uff1a{}", new Object[]{InventoryConfig.isMultipleOut(), reqDto.getIsAutoComplete(), basicsReceiveReqDto.getIsAllDeal()});
        ArrayList<BasicsDetailReqDto> detailReqDtoList = new ArrayList<BasicsDetailReqDto>();
        reqDto.getPackageList().forEach(x -> {
            BasicsDetailReqDto detailReqDto = (BasicsDetailReqDto)BeanUtil.copyProperties((Object)x, BasicsDetailReqDto.class, (String[])new String[0]);
            detailReqDto.setBatch(x.getActualBatch());
            detailReqDto.setProduceTime(x.getActualProduceTime());
            detailReqDto.setWarehouseCode(reqDto.getWarehouseCode());
            detailReqDto.setExpireTime(x.getActualExpireTime());
            detailReqDtoList.add(detailReqDto);
        });
        for (AssemblyDisassemblyOrderDetailDto detailDto : reqDto.getDetailList()) {
            BasicsDetailReqDto detailReqDto = (BasicsDetailReqDto)BeanUtil.copyProperties((Object)detailDto, BasicsDetailReqDto.class, (String[])new String[0]);
            detailReqDto.setBatch(detailDto.getActualBatch());
            detailReqDto.setProduceTime(detailDto.getActualProduceTime());
            detailReqDto.setWarehouseCode(reqDto.getWarehouseCode());
            detailReqDto.setExpireTime(detailDto.getActualExpireTime());
            detailReqDtoList.add(detailReqDto);
        }
        basicsReceiveReqDto.setDetailReqDtoList(detailReqDtoList);
        return basicsReceiveReqDto;
    }

    @Override
    public AssemblyDisassemblyOrderDto queryByOrderNo(String orderNo) {
        List physicsWarehouseEoList;
        AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo = ((IAssemblyDisassemblyOrderDomain)this.domain).queryByOrderNo(orderNo);
        AssemblyDisassemblyOrderDto result = new AssemblyDisassemblyOrderDto();
        BeanUtils.copyProperties((Object)assemblyDisassemblyOrderEo, (Object)result);
        String extension = assemblyDisassemblyOrderEo.getExtension();
        AssemblyDisassemblyOrderDtoExtension orderDtoExtension = null;
        if (StringUtils.isNotBlank((CharSequence)extension) && Objects.nonNull(orderDtoExtension = (AssemblyDisassemblyOrderDtoExtension)JSONObject.parseObject((String)extension, AssemblyDisassemblyOrderDtoExtension.class))) {
            result.setAuditRemark(orderDtoExtension.getAuditRemark());
        }
        if (CollectionUtils.isNotEmpty((Collection)(physicsWarehouseEoList = this.warehouseAddressDomain.queryByWarehouseCodes(new ArrayList<String>(Collections.singleton(assemblyDisassemblyOrderEo.getPhysicsWarehouseCode())), "physics")))) {
            WarehouseAddressEo warehouseAddressEo = (WarehouseAddressEo)physicsWarehouseEoList.get(0);
            String warehouseAddress = warehouseAddressEo.getProvince() + warehouseAddressEo.getCity() + warehouseAddressEo.getDistrict() + warehouseAddressEo.getDetailAddress();
            result.setWarehouseAddress(warehouseAddress);
        }
        return result;
    }

    @Override
    public PageInfo<AssemblyDisassemblyOrderDto> queryPage(AssemblyDisassemblyOrderQueryDto queryDto) {
        PageInfo pageInfo = ((IAssemblyDisassemblyOrderDomain)this.domain).queryPage(queryDto);
        return this.assemblyRespPageData((PageInfo<AssemblyDisassemblyOrderDto>)pageInfo);
    }

    @Override
    public PageInfo<AssemblyDisassemblyOrderItemComboRespDto> queryByItemPage(AssemblyDisassemblyOrderQueryDto queryDto) {
        queryDto.setType(Integer.valueOf(1));
        PageInfo pageInfo = ((IAssemblyDisassemblyOrderDomain)this.domain).queryByItemPage(queryDto);
        return this.assemblyRespData((PageInfo<AssemblyDisassemblyOrderDetailRespDto>)pageInfo);
    }

    public PageInfo<AssemblyDisassemblyOrderDto> assemblyRespPageData(PageInfo<AssemblyDisassemblyOrderDto> pageInfo) {
        if (pageInfo == null || CollUtil.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo();
        }
        Set warehouseCodes = pageInfo.getList().stream().map(AssemblyDisassemblyOrderDto::getPhysicsWarehouseCode).collect(Collectors.toSet());
        Map<String, String> code2WarehouseEoMap = this.warehouseAddressDomain.queryByWarehouseCodes(new ArrayList(warehouseCodes), "physics").stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, this::convertEoToString, (existing, replacement) -> existing));
        HashMap cacheMap = new HashMap();
        pageInfo.getList().forEach(x -> {
            if (!cacheMap.containsKey(x.getLogicWarehouseCode())) {
                boolean b = InventoryConfig.getPushWms().canPushWms(PushWmsAble.CanPushWmsBo.builder().logicWarehouseCode(x.getLogicWarehouseCode()).businessType(String.valueOf(x.getBizType())).orderType(x.getOrderType()).orderType("adjust").relevanceNo(x.getOrderNo()).build());
                cacheMap.put(x.getLogicWarehouseCode(), !b);
            }
            x.setShowProcess((Boolean)cacheMap.get(x.getLogicWarehouseCode()));
            x.setWarehouseAddress((String)code2WarehouseEoMap.get(x.getPhysicsWarehouseCode()));
            x.setShowCancel(Boolean.valueOf(InventoryConfig.isMultipleOut()));
            String extension = x.getExtension();
            AssemblyDisassemblyOrderDtoExtension orderDtoExtension = null;
            if (StringUtils.isNotBlank((CharSequence)extension) && Objects.nonNull(orderDtoExtension = (AssemblyDisassemblyOrderDtoExtension)JSONObject.parseObject((String)extension, AssemblyDisassemblyOrderDtoExtension.class))) {
                x.setAuditRemark(orderDtoExtension.getAuditRemark());
            }
        });
        return pageInfo;
    }

    public PageInfo<AssemblyDisassemblyOrderItemComboRespDto> assemblyRespData(PageInfo<AssemblyDisassemblyOrderDetailRespDto> pageInfo) {
        if (pageInfo == null || CollUtil.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo();
        }
        Set<String> orderNos = pageInfo.getList().stream().map(AssemblyDisassemblyOrderDto::getOrderNo).collect(Collectors.toSet());
        Map<String, List<AssemblyDisassemblyOrderDetailEo>> orderNo2packListMap = this.assemblyDisassemblyOrderDetailDomain.queryPackListByOrderNos(new ArrayList(orderNos)).stream().collect(Collectors.groupingBy(AssemblyDisassemblyOrderDetailEo::getOrderNo));
        Set warehouseCodes = pageInfo.getList().stream().map(AssemblyDisassemblyOrderDto::getPhysicsWarehouseCode).collect(Collectors.toSet());
        Map<String, String> code2WarehouseEoMap = this.warehouseAddressDomain.queryByWarehouseCodes(new ArrayList(warehouseCodes), "physics").stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, this::convertEoToString, (existing, replacement) -> existing));
        Map<String, BigDecimal> processingQuantityOfTheDocumentMap = this.getProcessingQuantityOfTheDocument(orderNos);
        List<String> skuCodes = pageInfo.getList().stream().map(AssemblyDisassemblyOrderDetailRespDto::getSkuCode).distinct().collect(Collectors.toList());
        Map<String, ItemSkuDgRespDto> itemSkuDgRespDtoMap = this.getItemSkuDgRespDto(skuCodes);
        HashMap resultOrderMap = new HashMap();
        List inOutResultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().in((Object)"relevance_no", orderNos)).eq((Object)"order_type", (Object)BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY.getCode().toLowerCase())).list();
        if (CollectionUtils.isNotEmpty((Collection)inOutResultOrderEoList)) {
            Set documentCodes = inOutResultOrderEoList.stream().map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toSet());
            resultOrderMap.putAll(((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", documentCodes)).list().stream().collect(Collectors.toMap(InOutResultOrderDetailEo::getSkuCode, Function.identity(), (v1, v2) -> v2)));
        }
        HashMap cacheMap = new HashMap();
        List list = pageInfo.getList().stream().map(respDto -> {
            List detailEoList;
            InOutResultOrderDetailEo detailEo;
            String detailKey;
            AssemblyDisassemblyOrderItemComboRespDto comboRespDto = new AssemblyDisassemblyOrderItemComboRespDto();
            BeanUtils.copyProperties((Object)respDto, (Object)comboRespDto);
            AssemblyDisassemblyOrderItemRespDto resp = new AssemblyDisassemblyOrderItemRespDto();
            BeanUtils.copyProperties((Object)respDto, (Object)resp);
            if (itemSkuDgRespDtoMap.containsKey(respDto.getSkuCode())) {
                ItemSkuDgRespDto itemSkuDgRespDto = (ItemSkuDgRespDto)itemSkuDgRespDtoMap.get(respDto.getSkuCode());
                resp.setBarCode(Objects.nonNull(itemSkuDgRespDto) ? itemSkuDgRespDto.getBarCode() : null);
                comboRespDto.setBarCode(Objects.nonNull(itemSkuDgRespDto) ? itemSkuDgRespDto.getBarCode() : null);
            }
            if (processingQuantityOfTheDocumentMap.containsKey(detailKey = this.genKey(respDto.getOrderNo(), resp.getSkuCode(), 1))) {
                resp.setActualQuantity(Integer.valueOf(((BigDecimal)processingQuantityOfTheDocumentMap.get(detailKey)).intValueExact()));
            }
            if (resultOrderMap.containsKey(respDto.getSkuCode()) && Objects.nonNull(detailEo = (InOutResultOrderDetailEo)resultOrderMap.get(respDto.getSkuCode()))) {
                resp.setBatch(detailEo.getBatch());
                resp.setProduceTime(detailEo.getProduceTime());
                resp.setExpireTime(detailEo.getExpireTime());
            }
            comboRespDto.setDetail(resp);
            if (orderNo2packListMap.containsKey(respDto.getOrderNo()) && !CollUtil.isEmpty((Collection)(detailEoList = (List)orderNo2packListMap.get(respDto.getOrderNo())))) {
                InOutResultOrderDetailEo detailEo2;
                AssemblyDisassemblyOrderItemRespDto packResp = new AssemblyDisassemblyOrderItemRespDto();
                BeanUtils.copyProperties(detailEoList.get(0), (Object)packResp, (String[])new String[]{"mixtureRatio", "mixtureRatioDenominator"});
                packResp.setPlanQuantity(((AssemblyDisassemblyOrderDetailEo)detailEoList.get(0)).getQuantity());
                String key = this.genKey(respDto.getOrderNo(), packResp.getSkuCode(), 0);
                if (processingQuantityOfTheDocumentMap.containsKey(key)) {
                    packResp.setActualQuantity(Integer.valueOf(((BigDecimal)processingQuantityOfTheDocumentMap.get(key)).intValueExact()));
                }
                if (itemSkuDgRespDtoMap.containsKey(packResp.getSkuCode())) {
                    ItemSkuDgRespDto itemSkuDgRespDto = (ItemSkuDgRespDto)itemSkuDgRespDtoMap.get(packResp.getSkuCode());
                    packResp.setBarCode(Objects.nonNull(itemSkuDgRespDto) ? itemSkuDgRespDto.getBarCode() : null);
                }
                if (resultOrderMap.containsKey(packResp.getSkuCode()) && Objects.nonNull(detailEo2 = (InOutResultOrderDetailEo)resultOrderMap.get(packResp.getSkuCode()))) {
                    packResp.setBatch(detailEo2.getBatch());
                    packResp.setProduceTime(detailEo2.getProduceTime());
                    packResp.setExpireTime(detailEo2.getExpireTime());
                }
                comboRespDto.setPack(packResp);
            }
            comboRespDto.setWarehouseAddress((String)code2WarehouseEoMap.get(respDto.getPhysicsWarehouseCode()));
            if (!cacheMap.containsKey(respDto.getLogicWarehouseCode())) {
                boolean b = InventoryConfig.getPushWms().canPushWms(PushWmsAble.CanPushWmsBo.builder().logicWarehouseCode(respDto.getLogicWarehouseCode()).businessType(String.valueOf(respDto.getBizType())).orderType(respDto.getOrderType()).orderType("adjust").relevanceNo(respDto.getOrderNo()).build());
                cacheMap.put(respDto.getLogicWarehouseCode(), !b);
            }
            String extension = respDto.getExtension();
            AssemblyDisassemblyOrderDtoExtension orderDtoExtension = null;
            if (StringUtils.isNotBlank((CharSequence)extension) && Objects.nonNull(orderDtoExtension = (AssemblyDisassemblyOrderDtoExtension)JSONObject.parseObject((String)extension, AssemblyDisassemblyOrderDtoExtension.class))) {
                comboRespDto.setAuditRemark(orderDtoExtension.getAuditRemark());
            }
            comboRespDto.setShowProcess((Boolean)cacheMap.get(respDto.getLogicWarehouseCode()));
            comboRespDto.setShowCancel(Boolean.valueOf(InventoryConfig.isMultipleOut()));
            return comboRespDto;
        }).collect(Collectors.toList());
        PageInfo pageInfoResult = new PageInfo();
        BeanUtils.copyProperties(pageInfo, (Object)pageInfoResult, (String[])new String[]{"list", "navigatepageNums"});
        pageInfoResult.setList(list);
        return pageInfoResult;
    }

    public Map<String, BigDecimal> getProcessingQuantityOfTheDocument(Set<String> orderNos) {
        HashMap<String, BigDecimal> code2DoneQuantityMap = new HashMap<String, BigDecimal>();
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().in((Object)"relevance_no", orderNos)).eq((Object)"order_type", (Object)BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY.getCode().toLowerCase())).notIn((Object)"order_status", new Object[]{BaseOrderStatusEnum.ONO_CANCEL.getCode(), BaseOrderStatusEnum.INO_CANCEL.getCode()})).list();
        if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos)) {
            Set documentCodes = inOutNoticeOrderEos.stream().map(InOutNoticeOrderEo::getDocumentNo).collect(Collectors.toSet());
            code2DoneQuantityMap.putAll(((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().in((Object)"document_no", documentCodes)).list().stream().collect(Collectors.groupingBy(x -> this.genKey(x.getRelevanceNo(), x.getSkuCode(), x.getPackType()), Collectors.mapping(InOutNoticeOrderDetailEo::getDoneQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))));
        }
        return code2DoneQuantityMap;
    }

    public String genKey(String relevanceNo, String skuCode, Integer packType) {
        return relevanceNo + '@' + skuCode + '@' + packType;
    }

    public String convertEoToString(WarehouseAddressEo eo) {
        return eo.getProvince() + eo.getCity() + eo.getDistrict() + eo.getDetailAddress();
    }

    private List<AssemblyDisassemblyOrderDetailEo> processPackageAndDetailData(AssemblyDisassemblyOrderComboReqDto reqDto, String orderNo) {
        ArrayList<AssemblyDisassemblyOrderDetailEo> detailEoList = new ArrayList<AssemblyDisassemblyOrderDetailEo>();
        detailEoList.addAll(this.convertOrderDetailEoList(reqDto.getPackageList(), 0));
        detailEoList.addAll(this.convertOrderDetailEoList(reqDto.getDetailList(), 1));
        detailEoList.forEach(x -> x.setOrderNo(orderNo));
        this.assemblyDisassemblyOrderDetailDomain.insertBatch(detailEoList);
        return detailEoList;
    }

    private List<AssemblyDisassemblyOrderDetailEo> convertOrderDetailEoList(List<AssemblyDisassemblyOrderDetailDto> dtoList, int type) {
        ArrayList<AssemblyDisassemblyOrderDetailEo> detailEoList = new ArrayList<AssemblyDisassemblyOrderDetailEo>();
        DtoHelper.dtoList2EoList(dtoList, detailEoList, AssemblyDisassemblyOrderDetailEo.class);
        detailEoList.forEach(x -> {
            x.setId(null);
            x.setType(Integer.valueOf(type));
            x.setMixtureRatioDenominator((Integer)ObjectUtils.defaultIfNull((Object)x.getMixtureRatioDenominator(), (Object)1));
        });
        return detailEoList;
    }

    private void executeMachine(AssemblyDisassemblyOrderStatusEventEnum event, String errorMsg, AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo, List<AssemblyDisassemblyOrderDetailEo> list) {
        StatemachineExecutorBo<AssemblyDisassemblyOrderEo> statemachineExecutorBo = this.buildStatemachineExecutorBo(assemblyDisassemblyOrderEo, list);
        if (!this.assemblyDisassemblyOrderStatemachineExecutor.execute(event, statemachineExecutorBo)) {
            throw new RuntimeException(errorMsg);
        }
    }

    private AssemblyDisassemblyOrderEo processAssemblyDisassemblyOrder(AssemblyDisassemblyOrderComboReqDto reqDto) {
        AssemblyDisassemblyOrderDto orderDto = reqDto.getOrder();
        AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo = Objects.nonNull(orderDto.getId()) ? this.updateExistingAssemblyDisassemblyOrder(orderDto) : this.createNewAssemblyDisassemblyOrder(orderDto);
        return assemblyDisassemblyOrderEo;
    }

    private AssemblyDisassemblyOrderEo updateExistingAssemblyDisassemblyOrder(AssemblyDisassemblyOrderDto orderDto) {
        AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo = (AssemblyDisassemblyOrderEo)((IAssemblyDisassemblyOrderDomain)this.domain).selectByPrimaryKey(orderDto.getId());
        AssertUtil.isTrue((boolean)Objects.nonNull(assemblyDisassemblyOrderEo), (String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        DtoHelper.dto2Eo((BaseVo)orderDto, (BaseEo)assemblyDisassemblyOrderEo, (String[])new String[]{"id"});
        ((IAssemblyDisassemblyOrderDomain)this.domain).update((BaseEo)assemblyDisassemblyOrderEo);
        this.assemblyDisassemblyOrderDetailDomain.removeByOrderNo(orderDto.getOrderNo());
        return assemblyDisassemblyOrderEo;
    }

    private AssemblyDisassemblyOrderEo createNewAssemblyDisassemblyOrder(AssemblyDisassemblyOrderDto orderDto) {
        String orderNo = this.generateCodeUtil.generateCode(CodeGenEnum.getByCode(orderDto.getOrderType()));
        AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo = new AssemblyDisassemblyOrderEo();
        DtoHelper.dto2Eo((BaseVo)orderDto, (BaseEo)assemblyDisassemblyOrderEo);
        assemblyDisassemblyOrderEo.setOrderStatus(AssemblyDisassemblyOrderStatusEnum.WAIT_SUBMIT.getKey());
        assemblyDisassemblyOrderEo.setOrderNo(orderNo);
        ((IAssemblyDisassemblyOrderDomain)this.domain).insert((BaseEo)assemblyDisassemblyOrderEo);
        return assemblyDisassemblyOrderEo;
    }

    private StatemachineExecutorBo<AssemblyDisassemblyOrderEo> buildStatemachineExecutorBo(AssemblyDisassemblyOrderEo eo, List<AssemblyDisassemblyOrderDetailEo> list) {
        StatemachineExecutorBo<AssemblyDisassemblyOrderEo> statemachineExecutorBo = new StatemachineExecutorBo<AssemblyDisassemblyOrderEo>();
        statemachineExecutorBo.setEo(eo);
        if (CollUtil.isNotEmpty(list)) {
            StatemachineMap statemachineMap = new StatemachineMap();
            statemachineMap.put("assembly_disassembly_order_detail", list);
            statemachineExecutorBo.setVariables(statemachineMap);
        }
        return statemachineExecutorBo;
    }

    private void initOrder(AssemblyDisassemblyOrderComboReqDto reqDto) {
        AssemblyDisassemblyOrderDto orderDto = reqDto.getOrder();
        orderDto.setPackingFactor((Integer)ObjectUtils.defaultIfNull((Object)orderDto.getPackingFactor(), (Object)1));
        LogicWarehouseEo logicWarehouseEo = this.logicWarehouseDomain.queryByCode(orderDto.getLogicWarehouseCode());
        AssertUtil.isTrue((boolean)Objects.nonNull(logicWarehouseEo), (String)(orderDto.getLogicWarehouseCode() + ",\u4ed3\u5e93\u4e0d\u5b58\u5728"));
        orderDto.setLogicWarehouseId(logicWarehouseEo.getId());
        orderDto.setLogicWarehouseName(logicWarehouseEo.getWarehouseName());
        orderDto.setOrganizationName(logicWarehouseEo.getOrganizationName());
        orderDto.setOrganizationCode(logicWarehouseEo.getOrganizationCode());
        orderDto.setOrganizationId(logicWarehouseEo.getOrganizationId());
        if (StringUtils.isBlank((CharSequence)orderDto.getPhysicsWarehouseCode())) {
            orderDto.setPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
            orderDto.setPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
        }
    }

    private void checkParam(AssemblyDisassemblyOrderComboReqDto addReq) {
    }

    private Map<String, ItemSkuDgRespDto> getItemSkuDgRespDto(List<String> skuCodes) {
        HashMap skuDgRespDtoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skuCodes)) {
            List itemSkuDgRespDtos;
            int length;
            int i = 0;
            for (length = skuCodes.size(); length > 1000; length -= 1000) {
                itemSkuDgRespDtos = this.skuDgQueryApiProxy.queryBySkuCode(skuCodes.subList(i, i + 1000));
                if (CollectionUtils.isNotEmpty((Collection)itemSkuDgRespDtos)) {
                    skuDgRespDtoMap.putAll(itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (k1, k2) -> k2)));
                }
                i += 1000;
            }
            if (length > 0 && CollectionUtils.isNotEmpty((Collection)(itemSkuDgRespDtos = this.skuDgQueryApiProxy.queryBySkuCode(skuCodes.subList(i, i + length))))) {
                skuDgRespDtoMap.putAll(itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (k1, k2) -> k2)));
            }
        }
        return skuDgRespDtoMap;
    }
}

