/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.action;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IAssemblyDisassemblyOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.eo.AssemblyDisassemblyOrderEo;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.AssembleDisassembleOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.helper.ReceiveDeliveryNoticeOrderHelper;
import com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.enums.AssemblyDisassemblyOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.enums.AssemblyDisassemblyOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class AssemblyDisassemblyAuditPassAction
extends AbstractAction<AssemblyDisassemblyOrderStatusEnum, AssemblyDisassemblyOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(AssemblyDisassemblyAuditPassAction.class);
    @Resource
    protected BaseOrderFacade baseOrderFacade;
    @Resource
    protected IAssemblyDisassemblyOrderDetailDomain assemblyDisassemblyOrderDetailDomain;
    @Resource
    private IWarehouseAddressDomain warehouseAddressDomain;

    @Override
    protected void doExecute(StateContext<AssemblyDisassemblyOrderStatusEnum, AssemblyDisassemblyOrderStatusEventEnum> context) {
        StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
        AssemblyDisassemblyOrderEo orderEo = (AssemblyDisassemblyOrderEo)executorBo.getEo();
        List detailList = this.assemblyDisassemblyOrderDetailDomain.queryByOrderNo(orderEo.getOrderNo());
        if (CollUtil.isEmpty((Collection)detailList)) {
            throw new RuntimeException("\u5355\u636e\u7236\u54c1\u3001\u5b50\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AssembleDisassembleOrderFacadeBo noticeOrder = ReceiveDeliveryNoticeOrderHelper.assembleDisassembleNoticeOrderParam(orderEo, detailList);
        noticeOrder.setBaseOrderAddressEoList(this.getBaseOrderAddress(orderEo.getPhysicsWarehouseCode()));
        this.baseOrderFacade.deliveryNoticeOrderGen(noticeOrder);
    }

    private List<BaseOrderAddressEo> getBaseOrderAddress(String physicsWarehouseCode) {
        WarehouseAddressEo warehouseCodeEo = (WarehouseAddressEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseAddressDomain.filter().eq((Object)"warehouse_code", (Object)physicsWarehouseCode)).eq((Object)"warehouse_classify", (Object)"physics")).last("limit 1")).one();
        ArrayList<BaseOrderAddressEo> baseOrderAddressEos = new ArrayList<BaseOrderAddressEo>();
        if (warehouseCodeEo != null) {
            baseOrderAddressEos.add(this.buildBaseOrderAddress(warehouseCodeEo, "consignor"));
            baseOrderAddressEos.add(this.buildBaseOrderAddress(warehouseCodeEo, "consignee"));
        }
        return baseOrderAddressEos;
    }

    public BaseOrderAddressEo buildBaseOrderAddress(WarehouseAddressEo warehouseCodeEo, String contactsType) {
        BaseOrderAddressEo baseOrderAddressEo = new BaseOrderAddressEo();
        baseOrderAddressEo.setContactsType(contactsType);
        baseOrderAddressEo.setProvince(warehouseCodeEo.getProvince());
        baseOrderAddressEo.setCity(warehouseCodeEo.getCity());
        baseOrderAddressEo.setDistrict(warehouseCodeEo.getDistrict());
        baseOrderAddressEo.setDetailAddress(warehouseCodeEo.getDetailAddress());
        baseOrderAddressEo.setEncryptProvince(warehouseCodeEo.getProvince());
        baseOrderAddressEo.setEncryptCity(warehouseCodeEo.getCity());
        baseOrderAddressEo.setEncryptDistrict(warehouseCodeEo.getDistrict());
        baseOrderAddressEo.setEncryptDetailAddress(warehouseCodeEo.getDetailAddress());
        baseOrderAddressEo.setContacts(warehouseCodeEo.getContacts());
        baseOrderAddressEo.setEncryptContacts(warehouseCodeEo.getContacts());
        baseOrderAddressEo.setPhone(warehouseCodeEo.getPhone());
        baseOrderAddressEo.setEncryptPhone(warehouseCodeEo.getPhone());
        return baseOrderAddressEo;
    }
}

