/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.action;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.AssemblyDisassemblyOrderBizTypeEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.eo.AssemblyDisassemblyOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.AssemblyDisassemblyOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.enums.AssemblyDisassemblyOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.enums.AssemblyDisassemblyOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class AssemblyDisassemblySaveAction
extends AbstractAction<AssemblyDisassemblyOrderStatusEnum, AssemblyDisassemblyOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(AssemblyDisassemblySaveAction.class);
    @Resource
    protected ICalcInventoryService calcInventoryService;

    @Override
    protected void doExecute(StateContext<AssemblyDisassemblyOrderStatusEnum, AssemblyDisassemblyOrderStatusEventEnum> context) {
        log.info("\u8fdb\u5165\u7ec4\u88c5\u62c6\u5378\u6263\u51cf\u5e93\u5b58\u52a8\u4f5c....");
        StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
        log.info("\u6253\u5370\uff1a{}", (Object)JSONObject.toJSONString((Object)executorBo));
        AssemblyDisassemblyOrderEo assemblyDisassemblyOrderEo = (AssemblyDisassemblyOrderEo)executorBo.getEo();
        List detailEoList = (List)executorBo.getVariables().get("assembly_disassembly_order_detail");
        int type = AssemblyDisassemblyOrderBizTypeEnum.getByType((Integer)assemblyDisassemblyOrderEo.getBizType()).getPackType();
        List eos = detailEoList.stream().filter(x -> x.getType() == type).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(eos)) {
            throw new RuntimeException("\u9884\u5360\u5e93\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u4e0d\u5230\u5546\u54c1");
        }
        long count = detailEoList.stream().filter(x -> x.getType() != type).count();
        AtomicInteger i = new AtomicInteger((int)count + 1);
        if (!AssemblyDisassemblyOrderBizTypeEnum.isAssemble((Integer)assemblyDisassemblyOrderEo.getBizType())) {
            i = new AtomicInteger(1);
        }
        ArrayList detailParams = Lists.newArrayList();
        for (AssemblyDisassemblyOrderDetailEo detailEo : eos) {
            CalcDetailDto param = new CalcDetailDto();
            param.setNum(new BigDecimal(detailEo.getQuantity()));
            param.setSkuCode(detailEo.getSkuCode());
            param.setLogicWarehouseCode(assemblyDisassemblyOrderEo.getLogicWarehouseCode());
            param.setInventoryProperty(detailEo.getInventoryProperty());
            param.setBatch(detailEo.getBatch());
            param.setLineNo(Long.valueOf((long)i.getAndIncrement() * 10L));
            detailParams.add(param);
        }
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(assemblyDisassemblyOrderEo.getOrderNo());
        preemptParam.setSourceType(assemblyDisassemblyOrderEo.getOrderType());
        preemptParam.setRemark("\u9884\u5360\u5e93\u5b58");
        preemptParam.setExternalOrderNo(assemblyDisassemblyOrderEo.getExternalOrderNo());
        preemptParam.setBusinessType(AssemblyDisassemblyOrderBizTypeEnum.getByType((Integer)assemblyDisassemblyOrderEo.getBizType()).name());
        preemptParam.setNoneBatch(Boolean.valueOf(assemblyDisassemblyOrderEo.getNoBatch() == 0));
        preemptParam.setNoneLineNo(Boolean.valueOf(true));
        preemptParam.setDetails((List)detailParams);
        this.calcInventoryService.updatePreempt(preemptParam);
    }
}

