/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsValidFlagEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageBusinessTypeDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageBusinessTypeEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.business.other.impl.OtherStorageOrderContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherStorageOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class InOutStorageAuditPassAction
extends AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(InOutStorageAuditPassAction.class);
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private IInOtherStorageOrderDomain otherStorageOrderDomain;
    @Resource
    private IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private IInOtherStorageBusinessTypeDomain inOtherStorageBusinessTypeDomain;
    @Resource
    private IWarehouseAddressDomain iWarehouseAddressDomain;

    @Override
    public void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> stateContext) {
        log.info("\u8fdb\u5165\u5176\u4ed6\u51fa\u5165\u5e93\u5ba1\u6838\u901a\u8fc7InOutNoticeAuditPassAction:{}", (Object)JSONObject.toJSONString(stateContext));
        StatemachineExecutorBo<InOtherStorageOrderEo> executorBo = StatemachineHelper.getExecutorBo(stateContext);
        List inOtherStorageOrderDetailEos = (List)executorBo.getVariables().get(OtherStorageOrderContextEnum.OTHER_STORAGE_ORDER_DETAIL.getCode());
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = this.getReceiveDeliveryNoticeOrderFacadeBo(executorBo, inOtherStorageOrderDetailEos, stateContext);
        receiveDeliveryNoticeOrderFacadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutNoticeOrderContext) {
                    InOutNoticeOrderContext inOutNoticeOrderContext = (InOutNoticeOrderContext)context;
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(true);
            }
        });
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(executorBo.getEo().getWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseName(executorBo.getEo().getWarehouseName());
        receiveDeliveryNoticeOrderFacadeBo.setPhysicsWarehouseCode(executorBo.getEo().getPhysicsWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setPhysicsWarehouseName(executorBo.getEo().getPhysicsWarehouseName());
        if (DgOtherStorageOrderTypeEnum.PARTS_REQUISITION.getCode().equals(executorBo.getEo().getType())) {
            receiveDeliveryNoticeOrderFacadeBo.setValidNegative(false);
        }
        if (DgOtherStorageOrderTypeEnum.IN.getCode().equals(executorBo.getEo().getType())) {
            receiveDeliveryNoticeOrderFacadeBo.setShoutBatch(false);
            this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        } else {
            this.baseOrderFacade.deliveryNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        }
    }

    @NotNull
    public ReceiveDeliveryNoticeOrderFacadeBo getReceiveDeliveryNoticeOrderFacadeBo(StatemachineExecutorBo<InOtherStorageOrderEo> executorBo, List<InOtherStorageOrderDetailEo> detailList, StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> stateContext) {
        InOtherStorageOrderEo respDto = executorBo.getEo();
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        boolean autoComplete = Objects.equals(executorBo.getVariables().getByType("autoComplete", String.class), "1");
        InOtherStorageBusinessTypeEo inOtherStorageBusinessTypeEo = (InOtherStorageBusinessTypeEo)Optional.ofNullable(((ExtQueryChainWrapper)this.inOtherStorageBusinessTypeDomain.filter().eq((Object)"business_type_code", (Object)respDto.getBusinessType())).one()).orElse(new InOtherStorageBusinessTypeEo());
        if (ObjectUtil.equals((Object)inOtherStorageBusinessTypeEo.getAutoOut(), (Object)1)) {
            autoComplete = true;
        }
        boolean noPushWms = Objects.equals(executorBo.getVariables().getByType("noPushWms", String.class), "1");
        CubeBeanUtils.copyProperties((Object)facadeBo, (Object)respDto, (String[])new String[0]);
        facadeBo.setPreOrderNo(respDto.getPreOrderNo());
        facadeBo.setRelevanceNo(respDto.getStorageOrderNo());
        facadeBo.setSourceType(respDto.getBusinessType());
        facadeBo.setPreemptReleaseType(CsInventorySourceTypeEnum.OUT_OTHER_RELEASE.getCode());
        facadeBo.setDisplayBusinessType(respDto.getBusinessType());
        facadeBo.setBusinessType(respDto.getBusinessType());
        facadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.IN_OTHER_STORAGE_ORDER);
        facadeBo.setRemark(respDto.getRemark());
        facadeBo.setSendWms(true);
        facadeBo.setShipmentEnterpriseCode(respDto.getLogisticsCompanyCode());
        facadeBo.setShipmentEnterpriseName(respDto.getLogisticsCompanyName());
        facadeBo.setRemark(respDto.getRemark());
        facadeBo.setExternalOrderNo(respDto.getExternalOrderNo());
        facadeBo.setSendWms(!noPushWms);
        if (autoComplete) {
            facadeBo.setAutoComplete(autoComplete);
        }
        List<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(detailList.size());
        Map<Object, OrderUnitConversionRecordDto> unitConversionRecordDtoMap = this.unitProcess(respDto, detailList);
        for (InOtherStorageOrderDetailEo detail : detailList) {
            BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
            CubeBeanUtils.copyProperties((Object)((Object)basic), (Object)detail, (String[])new String[0]);
            OrderUnitConversionRecordDto orderUnitConversionRecordDto = unitConversionRecordDtoMap.get(this.getKey(detail.getSkuCode(), detail.getQuantity(), detail.getUnit()));
            basic.setSkuCode(detail.getSkuCode());
            basic.setSkuName(detail.getSkuName());
            basic.setQuantity(BeanUtil.isNotEmpty((Object)orderUnitConversionRecordDto, (String[])new String[0]) ? orderUnitConversionRecordDto.getToNum() : BigDecimal.ZERO);
            basic.setBatch(detail.getBatch());
            basic.setVolume(detail.getVolume());
            basic.setWeight(detail.getWeight());
            basic.setUnit(detail.getUnit());
            basic.setPreOrderItemId(detail.getId());
            basic.setInventoryProperty(detail.getInventoryProperty());
            deliveryDetailList.add(basic);
        }
        if ("in".equals(respDto.getType()) && YesNoEnum.YES.getValue().equals(respDto.getNoBatch())) {
            deliveryDetailList = this.getCsBasicsOrderDetailList(facadeBo.getRelevanceNo(), deliveryDetailList);
            facadeBo.setShoutBatch(false);
        }
        facadeBo.setBaseOrderAddressEoList(Optional.of(this.getBaseOrderAddress(respDto)).map(xva$0 -> Lists.newArrayList((Object[])new BaseOrderAddressEo[]{xva$0})).orElse(null));
        facadeBo.setOrderBasicsDetailReqDtoList(deliveryDetailList);
        return facadeBo;
    }

    private List<BaseOrderDetailReqDto> getCsBasicsOrderDetailList(String relevanceNo, List<BaseOrderDetailReqDto> buildList) {
        List<InventoryUsageRecordEo> inventoryUsageRecordEoList = this.queryPreemptTypeBySourceNo(relevanceNo, CsValidFlagEnum.ENABLE.getCode(), CsWarehouseClassifyEnum.LOGIC.getCode());
        if (CollectionUtils.isNotEmpty(inventoryUsageRecordEoList)) {
            Map tradeOrderItemMap = buildList.stream().collect(HashMap::new, (m, v) -> m.put(v.getSkuCode(), v), HashMap::putAll);
            ArrayList<BaseOrderDetailReqDto> detailReqDtoList = new ArrayList<BaseOrderDetailReqDto>();
            for (InventoryUsageRecordEo inventoryUsageRecordEo : inventoryUsageRecordEoList) {
                BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
                basic.setSkuCode(inventoryUsageRecordEo.getSkuCode());
                basic.setSkuName(inventoryUsageRecordEo.getSkuName());
                basic.setQuantity(inventoryUsageRecordEo.getPreemptNum());
                basic.setBatch(inventoryUsageRecordEo.getBatch());
                BaseOrderDetailReqDto csBasicsOrderDetailReqDto = (BaseOrderDetailReqDto)((Object)tradeOrderItemMap.get(inventoryUsageRecordEo.getSkuCode()));
                basic.setPreOrderItemId(csBasicsOrderDetailReqDto.getPreOrderItemId());
                basic.setExtension(csBasicsOrderDetailReqDto.getExtension());
                basic.setExpireTime(csBasicsOrderDetailReqDto.getExpireTime());
                basic.setWeight(csBasicsOrderDetailReqDto.getWeight());
                basic.setVolume(csBasicsOrderDetailReqDto.getVolume());
                basic.setProduceTime(csBasicsOrderDetailReqDto.getProduceTime());
                detailReqDtoList.add(basic);
            }
            return detailReqDtoList;
        }
        return buildList;
    }

    public List<InventoryUsageRecordEo> queryPreemptTypeBySourceNo(String sourceNo, String valid, String warehouseClassify) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"source_no", (Object)sourceNo);
        wrapper.eq((Object)"valid", (Object)valid);
        wrapper.eq((Object)"warehouse_classify", (Object)warehouseClassify);
        wrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        wrapper.orderByDesc((Object)"create_time");
        return this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)wrapper);
    }

    private BaseOrderAddressEo getBaseOrderAddress(InOtherStorageOrderEo respDto) {
        BaseOrderAddressEo baseOrderAddressEo = new BaseOrderAddressEo();
        BeanUtil.copyProperties((Object)respDto, (Object)baseOrderAddressEo, (String[])new String[0]);
        baseOrderAddressEo.setId(null);
        baseOrderAddressEo.setOrderType(respDto.getType());
        if (respDto.getType().equals(DgOtherStorageOrderTypeEnum.IN.getCode())) {
            baseOrderAddressEo.setContactsType("consignor");
            WarehouseAddressEo warehouseCodeEo = (WarehouseAddressEo)Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iWarehouseAddressDomain.filter().eq((Object)"warehouse_code", (Object)respDto.getPhysicsWarehouseCode())).last("limit 1")).one()).orElse(new WarehouseAddressEo());
            baseOrderAddressEo.setProvince(warehouseCodeEo.getProvince());
            baseOrderAddressEo.setCity(warehouseCodeEo.getCity());
            baseOrderAddressEo.setDistrict(warehouseCodeEo.getDistrict());
            baseOrderAddressEo.setDetailAddress(warehouseCodeEo.getDetailAddress());
            baseOrderAddressEo.setEncryptProvince(warehouseCodeEo.getProvince());
            baseOrderAddressEo.setEncryptCity(warehouseCodeEo.getCity());
            baseOrderAddressEo.setEncryptDistrict(warehouseCodeEo.getDistrict());
            baseOrderAddressEo.setEncryptDetailAddress(warehouseCodeEo.getDetailAddress());
            baseOrderAddressEo.setContacts(warehouseCodeEo.getContacts());
            baseOrderAddressEo.setEncryptContacts(warehouseCodeEo.getContacts());
            baseOrderAddressEo.setPhone(warehouseCodeEo.getPhone());
            baseOrderAddressEo.setEncryptPhone(warehouseCodeEo.getPhone());
        } else {
            baseOrderAddressEo.setContactsType("consignee");
            baseOrderAddressEo.setProvince(respDto.getProvinceName());
            baseOrderAddressEo.setCity(respDto.getCityName());
            baseOrderAddressEo.setDistrict(respDto.getAreaName());
            baseOrderAddressEo.setDetailAddress(respDto.getAddress());
            baseOrderAddressEo.setEncryptProvince(respDto.getProvinceName());
            baseOrderAddressEo.setEncryptCity(respDto.getCityName());
            baseOrderAddressEo.setEncryptDistrict(respDto.getAreaName());
            baseOrderAddressEo.setEncryptDetailAddress(respDto.getAddress());
            baseOrderAddressEo.setContacts(respDto.getConsignee());
            baseOrderAddressEo.setEncryptContacts(respDto.getConsignee());
            baseOrderAddressEo.setCustomerCode(respDto.getCustomerCode());
            baseOrderAddressEo.setCustomerName(respDto.getCustomerName());
        }
        return baseOrderAddressEo;
    }

    private Map<Object, OrderUnitConversionRecordDto> unitProcess(InOtherStorageOrderEo inOtherStorageOrderEo, List<InOtherStorageOrderDetailEo> inOtherStorageOrderDetailEos) {
        ArrayList unitConversionDetails = new ArrayList();
        inOtherStorageOrderDetailEos.forEach(detailEo -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(detailEo.getUnit());
            unitConversionDetail.setSkuCode(detailEo.getSkuCode());
            unitConversionDetail.setCurNum(detailEo.getQuantity());
            unitConversionDetails.add(unitConversionDetail);
        });
        OrderUnitConversionReqDto orderUnitConversionReqDto = new OrderUnitConversionReqDto();
        orderUnitConversionReqDto.setDocumentCode(inOtherStorageOrderEo.getStorageOrderNo());
        orderUnitConversionReqDto.setType(inOtherStorageOrderEo.getType());
        orderUnitConversionReqDto.setOrderUnitConversionDetailList(unitConversionDetails);
        List<OrderUnitConversionRecordDto> orderUnitConversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(orderUnitConversionReqDto);
        return orderUnitConversionRecordDtos.stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), o.getNum(), o.getUnit()), Function.identity(), (k1, k2) -> k1));
    }

    private Object getKey(String skuCode, BigDecimal num, String currentUnit) {
        return skuCode + InventoryConfig.getCommonSeparate() + num.setScale(6) + InventoryConfig.getCommonSeparate() + currentUnit;
    }
}

