/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.third.PushSapAble;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class InOutStorageReceiveDeliveryAction
extends AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(InOutStorageReceiveDeliveryAction.class);
    @Resource
    private PushSapAble pushSapAble;
    @Resource
    private IInOtherStorageOrderDetailDomain inOtherStorageOrderDetailDomain;
    @Resource
    private IInOutResultOrderDomain iInOutResultOrderDomain;
    @Resource
    private IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordDomain iOrderUnitConversionRecordDomain;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> stateContext) {
        log.info("\u8fdb\u5165\u51fa\u5165\u5e93\u52a8\u4f5cInOutStorageReceiveDeliveryAction{}");
        String storageOrderNo = (String)stateContext.getExtendedState().getVariables().get("storageOrderNo");
        InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iInOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)storageOrderNo)).orderByDesc((Object)"create_time")).list().get(0);
        StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(stateContext);
        if (StringUtils.isNotBlank((CharSequence)inOutResultOrderEo.getShippingCompanyCode()) || StringUtils.isNotBlank((CharSequence)inOutResultOrderEo.getShippingCompany())) {
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)executorBo.getEo();
            inOtherStorageOrderEo.setLogisticsCompanyCode(inOutResultOrderEo.getShippingCompanyCode());
            inOtherStorageOrderEo.setLogisticsCompanyName(inOutResultOrderEo.getShippingCompany());
        }
        List inOtherStorageOrderDetailEoList = ((ExtQueryChainWrapper)this.inOtherStorageOrderDetailDomain.filter().eq((Object)"storage_order_no", (Object)storageOrderNo)).list();
        Map idMap = inOtherStorageOrderDetailEoList.stream().filter(r -> com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)r.getExtension())).collect(Collectors.toMap(BaseEo::getId, Function.identity(), (o1, o) -> o));
        Map id2EoMap = inOtherStorageOrderDetailEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (o1, o) -> o));
        List receiveDeliveryResultOrderDetailEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)storageOrderNo)).list();
        ArrayList<InOtherStorageOrderDetailEo> updateInOtherStorageOrderDetailEoList = new ArrayList<InOtherStorageOrderDetailEo>();
        List orderUnitConversionRecordEoList = ((ExtQueryChainWrapper)this.iOrderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)storageOrderNo)).list();
        Map orderUnitConversionRecordEoMap = orderUnitConversionRecordEoList.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, Function.identity(), (o2, o1) -> o1));
        if (CollectionUtil.isNotEmpty((Collection)receiveDeliveryResultOrderDetailEos)) {
            Map<String, List<ReceiveDeliveryResultOrderDetailEo>> stringListMap = receiveDeliveryResultOrderDetailEos.stream().collect(Collectors.groupingBy(r -> r.getSkuCode() + r.getBatch() + r.getInventoryProperty()));
            stringListMap.forEach((k, v) -> {
                ReceiveDeliveryResultOrderDetailEo o = (ReceiveDeliveryResultOrderDetailEo)v.get(0);
                InOtherStorageOrderDetailEo updateInOtherStorageOrderDetailEo = new InOtherStorageOrderDetailEo();
                updateInOtherStorageOrderDetailEo.setQuantity(v.stream().map(ReceiveDeliveryResultOrderDetailEo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                updateInOtherStorageOrderDetailEo.setDoneQuantity(v.stream().map(ReceiveDeliveryResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                Optional.ofNullable(orderUnitConversionRecordEoMap.get(o.getSkuCode())).ifPresent(orderUnitConversionRecordEo -> {
                    BigDecimal quantity = UnitTransferUtils.pareSaleNum((BigDecimal)v.stream().map(ReceiveDeliveryResultOrderDetailEo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add), (OrderUnitConversionRecordDto)((OrderUnitConversionRecordDto)BeanUtil.copyProperties((Object)orderUnitConversionRecordEo, OrderUnitConversionRecordDto.class, (String[])new String[0])), (boolean)false);
                    updateInOtherStorageOrderDetailEo.setQuantity(quantity);
                    BigDecimal doneQuantity = UnitTransferUtils.pareSaleNum((BigDecimal)v.stream().map(ReceiveDeliveryResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add), (OrderUnitConversionRecordDto)((OrderUnitConversionRecordDto)BeanUtil.copyProperties((Object)orderUnitConversionRecordEo, OrderUnitConversionRecordDto.class, (String[])new String[0])), (boolean)false);
                    updateInOtherStorageOrderDetailEo.setDoneQuantity(doneQuantity);
                    updateInOtherStorageOrderDetailEo.setUnit(orderUnitConversionRecordEo.getUnit());
                });
                updateInOtherStorageOrderDetailEo.setStorageOrderNo(o.getRelevanceNo());
                updateInOtherStorageOrderDetailEo.setSkuCode(o.getSkuCode());
                updateInOtherStorageOrderDetailEo.setSkuName(o.getSkuName());
                updateInOtherStorageOrderDetailEo.setBatch(o.getBatch());
                if (ObjectUtil.isNotEmpty(idMap.get(o.getPreOrderItemId()))) {
                    InOtherStorageOrderDetailEo inOtherStorageOrderDetailEo = (InOtherStorageOrderDetailEo)idMap.get(o.getPreOrderItemId());
                    updateInOtherStorageOrderDetailEo.setExtension(inOtherStorageOrderDetailEo.getExtension());
                    updateInOtherStorageOrderDetailEo.setUnitPrice(inOtherStorageOrderDetailEo.getUnitPrice());
                    updateInOtherStorageOrderDetailEo.setLineNo(inOtherStorageOrderDetailEo.getLineNo());
                }
                updateInOtherStorageOrderDetailEo.setInventoryProperty(o.getInventoryProperty());
                InOtherStorageOrderDetailEo orderDetail = (InOtherStorageOrderDetailEo)id2EoMap.get(o.getPreOrderItemId());
                if (orderDetail != null) {
                    updateInOtherStorageOrderDetailEo.setVolume(orderDetail.getVolume());
                    updateInOtherStorageOrderDetailEo.setWeight(orderDetail.getWeight());
                    updateInOtherStorageOrderDetailEo.setProjectId(orderDetail.getProjectId());
                    updateInOtherStorageOrderDetailEo.setProjectCode(orderDetail.getProjectCode());
                    updateInOtherStorageOrderDetailEo.setProjectName(orderDetail.getProjectName());
                }
                updateInOtherStorageOrderDetailEoList.add(updateInOtherStorageOrderDetailEo);
            });
            InOtherStorageOrderDetailEo inOtherStorageOrderDetailEo = new InOtherStorageOrderDetailEo();
            inOtherStorageOrderDetailEo.setStorageOrderNo(storageOrderNo);
            this.inOtherStorageOrderDetailDomain.delete((BaseEo)inOtherStorageOrderDetailEo);
            this.orderUnitConversionRecordService.otherOrderVolumeAndWeightProcess(storageOrderNo, updateInOtherStorageOrderDetailEoList);
            this.inOtherStorageOrderDetailDomain.insertBatch(updateInOtherStorageOrderDetailEoList);
        }
        ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = executorBo.getVariables().getByType("receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
        this.pushSapAble.push(receiveDeliveryResultOrderContext);
    }
}

