/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.transfer.action.TransferOrderCancelAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.action.TransferOrderCloseAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.action.TransferOrderDeliveryAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.AbstractTransferAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.DeliveryStateMachinePersist;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.TransferOrderApprovalStateMachineConfig;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.EnableStateMachineFactory;
import org.springframework.statemachine.config.EnumStateMachineConfigurerAdapter;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.persist.DefaultStateMachinePersister;
import org.springframework.statemachine.persist.StateMachinePersister;

@Configuration
@EnableStateMachineFactory(name={"deliveryStateMachine"})
public class TransferOrderDeliveryStateMachineConfig
extends EnumStateMachineConfigurerAdapter<TransferOrderDeliveryState, TransferOrderDeliveryEvent> {
    private static final Logger logger = LoggerFactory.getLogger(TransferOrderApprovalStateMachineConfig.class);
    @Resource
    private DeliveryStateMachinePersist deliveryStateMachinePersist;
    @Resource
    private TransferOrderCancelAction transferOrderCancelAction;
    @Resource
    private TransferOrderCloseAction transferOrderCloseAction;
    @Resource
    private TransferOrderDeliveryAction transferOrderDeliveryAction;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private TransactionCallBackService transactionCallBackService;

    public void configure(StateMachineConfigurationConfigurer<TransferOrderDeliveryState, TransferOrderDeliveryEvent> config) throws Exception {
        config.withConfiguration().machineId("deliveryStateMachine").autoStartup(true).listener((StateMachineListener)new StateMachineListenerAdapter<TransferOrderDeliveryState, TransferOrderDeliveryEvent>(){

            public void stateMachineError(StateMachine<TransferOrderDeliveryState, TransferOrderDeliveryEvent> stateMachine, Exception exception) {
                if (exception == null) {
                    return;
                }
                logger.info("\u72b6\u6001\u673a\u6267\u884c\u5f02\u5e38:{}", (Object)exception.getMessage());
                stateMachine.getExtendedState().getVariables().put("errMsg", exception.getMessage());
            }
        });
    }

    public void configure(StateMachineStateConfigurer<TransferOrderDeliveryState, TransferOrderDeliveryEvent> states) throws Exception {
        states.withStates().initial((Object)TransferOrderDeliveryState.WAITING_FOR_DELIVERY, this.getTransferOrderSendMqAction()).state((Object)TransferOrderDeliveryState.DELIVERED, this.getTransferOrderSendMqAction()).state((Object)TransferOrderDeliveryState.PARTIALLY_DELIVERED, this.getTransferOrderSendMqAction()).state((Object)TransferOrderDeliveryState.PARTIALLY_DELIVERED_CLOSED, this.getTransferOrderSendMqAction()).choice((Object)TransferOrderDeliveryState.SHIP_CHOICE).state((Object)TransferOrderDeliveryState.CANCELLED);
    }

    public void configure(StateMachineTransitionConfigurer<TransferOrderDeliveryState, TransferOrderDeliveryEvent> transitions) throws Exception {
        ((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)transitions.withExternal().source((Object)TransferOrderDeliveryState.WAITING_FOR_DELIVERY)).event((Object)TransferOrderDeliveryEvent.DELIVERY)).target((Object)TransferOrderDeliveryState.SHIP_CHOICE).and()).withExternal().source((Object)TransferOrderDeliveryState.PARTIALLY_DELIVERED)).event((Object)TransferOrderDeliveryEvent.DELIVERY)).target((Object)TransferOrderDeliveryState.SHIP_CHOICE).and()).withChoice().source((Object)TransferOrderDeliveryState.SHIP_CHOICE).first((Object)TransferOrderDeliveryState.DELIVERED, r -> this.transferOrderDeliveryAction.isAllShip((StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent>)r) || this.transferOrderDeliveryAction.isFinishShip((StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent>)r), this.getOrderDeliveryStateTransferOrderDeliveryEventAction()).last((Object)TransferOrderDeliveryState.PARTIALLY_DELIVERED, this.getTransferOrderDeliveryStateTransferOrderDeliveryEventAction()).and()).withExternal().source((Object)TransferOrderDeliveryState.PARTIALLY_DELIVERED)).target((Object)TransferOrderDeliveryState.PARTIALLY_DELIVERED_CLOSED).event((Object)TransferOrderDeliveryEvent.CLOSE)).action(this.getDeliveryStateTransferOrderDeliveryEventAction())).and()).withExternal().source((Object)TransferOrderDeliveryState.WAITING_FOR_DELIVERY)).target((Object)TransferOrderDeliveryState.CANCELLED).event((Object)TransferOrderDeliveryEvent.CANCEL)).action(this.getStateTransferOrderDeliveryEventAction())).action(this.getTransferOrderSendMqAction())).and()).withExternal().source((Object)TransferOrderDeliveryState.WAITING_FOR_DELIVERY)).target((Object)TransferOrderDeliveryState.WAITING_FOR_DELIVERY).event((Object)TransferOrderDeliveryEvent.WAITING_FOR_DELIVERY_WITHDRAW)).action(this.getTransferOrderDeliveryEventAction())).action(this.getTransferOrderSendMqAction());
    }

    @NotNull
    private Action<TransferOrderDeliveryState, TransferOrderDeliveryEvent> getTransferOrderDeliveryEventAction() {
        return new AbstractTransferAction<TransferOrderDeliveryState, TransferOrderDeliveryEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
                TransferOrderDeliveryStateMachineConfig.this.transferOrderDeliveryAction.waitingForDeliveryWithdraw(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderDeliveryState, TransferOrderDeliveryEvent> getStateTransferOrderDeliveryEventAction() {
        return new AbstractTransferAction<TransferOrderDeliveryState, TransferOrderDeliveryEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
                TransferOrderDeliveryStateMachineConfig.this.transferOrderCancelAction.shipmentStatusCancel(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderDeliveryState, TransferOrderDeliveryEvent> getDeliveryStateTransferOrderDeliveryEventAction() {
        return new AbstractTransferAction<TransferOrderDeliveryState, TransferOrderDeliveryEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
                TransferOrderDeliveryStateMachineConfig.this.transferOrderCloseAction.close(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderDeliveryState, TransferOrderDeliveryEvent> getOrderDeliveryStateTransferOrderDeliveryEventAction() {
        return new AbstractTransferAction<TransferOrderDeliveryState, TransferOrderDeliveryEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
                TransferOrderDeliveryStateMachineConfig.this.transferOrderDeliveryAction.allShip(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderDeliveryState, TransferOrderDeliveryEvent> getTransferOrderDeliveryStateTransferOrderDeliveryEventAction() {
        return new AbstractTransferAction<TransferOrderDeliveryState, TransferOrderDeliveryEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context) {
                TransferOrderDeliveryStateMachineConfig.this.transferOrderDeliveryAction.partiallyShip(context);
            }
        };
    }

    @Bean(name={"deliveryStateMachinePersister"})
    public StateMachinePersister<TransferOrderDeliveryState, TransferOrderDeliveryEvent, String> shipmentStateMachinePersister() {
        return new DefaultStateMachinePersister((StateMachinePersist)this.deliveryStateMachinePersist);
    }

    @NotNull
    private Action<TransferOrderDeliveryState, TransferOrderDeliveryEvent> getTransferOrderSendMqAction() {
        return context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            logger.info("getTransferOrderSendMqAction\uff1a{}", (Object)JSONObject.toJSONString(executorBo));
            if (executorBo == null) {
                return;
            }
            TransferOrderEo transferOrderEo = (TransferOrderEo)executorBo.getEo();
            InventoryConfig.registerSynchronizationAfterCommit(() -> {
                logger.info("\u8c03\u62e8\u5355\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u63a8\u9001:{},{}", (Object)transferOrderEo.getTransferOrderNo(), (Object)transferOrderEo.getExternalOrderNo());
                this.commonsMqService.publishMessage("PUBLISH_TOPIC", "PUSH_TRANSFER_ORDER", (Object)JSON.toJSONString((Object)transferOrderEo));
            });
        };
    }
}

