/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commonsendback.component;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeComponent;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.service.commonsendback.component.MatchLineNoBo;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

@LiteflowComponent(value="matchLineNo")
public class MatchLineNoComponent
extends NodeComponent {
    public void process() throws Exception {
        this.getRequestData();
    }

    public void matchLineNoMoreLine(MatchLineNoBo matchLineNoBo) {
        if (!InventoryConfig.isOrderLineCallbackProcess()) {
            this.noLineProcess(matchLineNoBo);
            return;
        }
        boolean hasPreOrderNo = matchLineNoBo.getDetailReqDtoList().stream().noneMatch(d -> Objects.isNull(d.getTradeOrderItemId()));
        if (hasPreOrderNo && InventoryConfig.isNoneBatch()) {
            Map<Long, Long> sourceMap = matchLineNoBo.getInOutNoticeOrderDetailEoList().stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getPreOrderItemId, InOutNoticeOrderDetailEo::getLineNo, (o, o1) -> o));
            matchLineNoBo.getDetailReqDtoList().forEach(d -> d.setLineNo((Long)sourceMap.get(d.getTradeOrderItemId())));
        } else if (hasPreOrderNo) {
            Map<Long, List<InOutNoticeOrderDetailEo>> sourceMap = matchLineNoBo.getInOutNoticeOrderDetailEoList().stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getPreOrderItemId));
            matchLineNoBo.getDetailReqDtoList().forEach(r -> {
                List inOutNoticeOrderDetailEos = (List)sourceMap.get(r.getTradeOrderItemId());
                if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderDetailEos)) {
                    throw new BizException("\u884c\u53f7\u56de\u4f20\u5f02\u5e38");
                }
                if (inOutNoticeOrderDetailEos.size() == 1) {
                    r.setLineNo(((InOutNoticeOrderDetailEo)((List)sourceMap.get(r.getTradeOrderItemId())).get(0)).getLineNo());
                    r.setInventoryProperty((String)ObjectUtils.defaultIfNull((Object)r.getInventoryProperty(), (Object)((InOutNoticeOrderDetailEo)((List)sourceMap.get(r.getTradeOrderItemId())).get(0)).getInventoryProperty()));
                } else {
                    Map<String, Long> lineNoMap = inOutNoticeOrderDetailEos.stream().collect(Collectors.toMap(d -> d.getSkuCode() + InventoryConfig.getCommonSeparate() + d.getBatch(), InOutNoticeOrderDetailEo::getLineNo));
                    r.setLineNo(lineNoMap.get(r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch()));
                    r.setInventoryProperty((String)ObjectUtils.defaultIfNull((Object)r.getInventoryProperty(), (Object)((InOutNoticeOrderDetailEo)((List)sourceMap.get(r.getTradeOrderItemId())).get(0)).getInventoryProperty()));
                }
            });
        } else {
            this.noLineProcess(matchLineNoBo);
        }
    }

    private void noLineProcess(MatchLineNoBo matchLineNoBo) {
        MatchLineNoComponent.mergeDetails(matchLineNoBo);
        Map<String, List<InOutNoticeOrderDetailEo>> sourceMap = matchLineNoBo.getInOutNoticeOrderDetailEoList().stream().collect(Collectors.groupingBy(MatchLineNoComponent::getKey));
        Map<Long, BigDecimal> marginMap = matchLineNoBo.getInOutNoticeOrderDetailEoList().stream().collect(Collectors.toMap(BaseEo::getId, InOutNoticeOrderDetailEo::getWaitQuantity));
        ArrayList newBasicsDetailReqDtos = new ArrayList();
        Optional.of(matchLineNoBo.getDetailReqDtoList().stream().filter(r -> {
            AtomicReference<BigDecimal> quantity = new AtomicReference<BigDecimal>(r.getQuantity());
            return Optional.ofNullable(sourceMap.get(MatchLineNoComponent.getDetailKey(r))).map(eos -> {
                if (eos.size() == 1) {
                    InOutNoticeOrderDetailEo eo = (InOutNoticeOrderDetailEo)eos.get(0);
                    r.setLineNo(eo.getLineNo());
                    r.setTradeOrderItemId(eo.getPreOrderItemId());
                    r.setInventoryProperty((String)ObjectUtils.defaultIfNull((Object)r.getInventoryProperty(), (Object)eo.getInventoryProperty()));
                    marginMap.computeIfPresent(eo.getId(), (d, v) -> {
                        BigDecimal subtract = v.subtract((BigDecimal)quantity.get());
                        if (subtract.compareTo(BigDecimal.ZERO) < 1) {
                            return null;
                        }
                        return subtract;
                    });
                } else {
                    this.matchLineNoMoreLine((BasicsDetailReqDto)r, (List<InOutNoticeOrderDetailEo>)eos, marginMap, newBasicsDetailReqDtos);
                }
                return false;
            }).orElse(true);
        }).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).ifPresent(list -> {
            Map<String, List<InOutNoticeOrderDetailEo>> codeSourceMap = matchLineNoBo.getInOutNoticeOrderDetailEoList().stream().sorted(Comparator.comparing(BaseEo::getId)).collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode));
            list.forEach(k -> Optional.ofNullable(codeSourceMap.get(k.getSkuCode())).ifPresent(eoList -> {
                if (eoList.size() == 1) {
                    k.setLineNo(((InOutNoticeOrderDetailEo)eoList.get(0)).getLineNo());
                    k.setTradeOrderItemId(((InOutNoticeOrderDetailEo)eoList.get(0)).getPreOrderItemId());
                    k.setInventoryProperty((String)ObjectUtils.defaultIfNull((Object)k.getInventoryProperty(), (Object)((InOutNoticeOrderDetailEo)eoList.get(0)).getInventoryProperty()));
                } else {
                    this.matchLineNoMoreLine((BasicsDetailReqDto)k, (List<InOutNoticeOrderDetailEo>)eoList, marginMap, newBasicsDetailReqDtos);
                }
            }));
        });
        matchLineNoBo.getDetailReqDtoList().addAll(newBasicsDetailReqDtos);
    }

    @NotNull
    private static String getDetailKey(BasicsDetailReqDto i) {
        return String.join((CharSequence)InventoryConfig.getCommonSeparate(), i.getSkuCode(), ((String)DataExtractUtils.ifNullElse((Object)i.getBatch(), (Object)InventoryConfig.getDefaultBatch())).toUpperCase());
    }

    @NotNull
    private static String getKey(InOutNoticeOrderDetailEo i) {
        return String.join((CharSequence)InventoryConfig.getCommonSeparate(), i.getSkuCode(), ((String)DataExtractUtils.ifNullElse((Object)i.getBatch(), (Object)InventoryConfig.getDefaultBatch())).toUpperCase());
    }

    private static void mergeDetails(MatchLineNoBo matchLineNoBo) {
        Map reqDtoMap = matchLineNoBo.getDetailReqDtoList().stream().collect(Collectors.toMap(r -> r.getSkuCode() + "__" + r.getBatch(), Function.identity(), (o, o1) -> {
            o.setQuantity(BigDecimalUtils.add((BigDecimal)o.getQuantity(), (BigDecimal)o1.getQuantity()));
            return o;
        }));
        matchLineNoBo.getDetailReqDtoList().clear();
        matchLineNoBo.getDetailReqDtoList().addAll(reqDtoMap.values());
    }

    private void matchLineNoMoreLine(BasicsDetailReqDto origDetail, List<InOutNoticeOrderDetailEo> eos, Map<Long, BigDecimal> canDispatchNum, List<BasicsDetailReqDto> newBasicsDetailReqDtos) {
        BigDecimal targetQuantity = origDetail.getQuantity();
        for (InOutNoticeOrderDetailEo eo : eos) {
            if (BigDecimalUtils.leZero((BigDecimal)targetQuantity).booleanValue()) {
                if (eos.indexOf(eo) != 0) {
                    return;
                }
                origDetail.setQuantity(BigDecimal.ZERO);
                InOutNoticeOrderDetailEo firstEo = eos.get(0);
                origDetail.setLineNo(firstEo.getLineNo());
                origDetail.setInventoryProperty((String)ObjectUtils.defaultIfNull((Object)origDetail.getInventoryProperty(), (Object)firstEo.getInventoryProperty()));
                origDetail.setTradeOrderItemId(firstEo.getPreOrderItemId());
                break;
            }
            BasicsDetailReqDto detailReqDto = eos.indexOf(eo) == 0 ? origDetail : (BasicsDetailReqDto)BeanUtil.copyProperties((Object)origDetail, BasicsDetailReqDto.class, (String[])new String[0]);
            BigDecimal decimal = canDispatchNum.get(eo.getId());
            if (Objects.isNull(decimal)) continue;
            BigDecimal finalTargetQuantity = targetQuantity;
            canDispatchNum.computeIfPresent(eo.getId(), (d, v) -> {
                BigDecimal subtract = v.subtract(finalTargetQuantity);
                return BigDecimalUtils.leZero((BigDecimal)subtract) != false ? null : subtract;
            });
            if (BigDecimalUtils.gt((BigDecimal)targetQuantity, (BigDecimal)decimal).booleanValue()) {
                detailReqDto.setQuantity(decimal);
                targetQuantity = BigDecimalUtils.subtract((BigDecimal)targetQuantity, (BigDecimal)decimal);
            } else {
                detailReqDto.setQuantity(targetQuantity);
                targetQuantity = BigDecimal.ZERO;
            }
            detailReqDto.setLineNo(eo.getLineNo());
            detailReqDto.setInventoryProperty((String)ObjectUtils.defaultIfNull((Object)detailReqDto.getInventoryProperty(), (Object)eo.getInventoryProperty()));
            detailReqDto.setTradeOrderItemId(eo.getPreOrderItemId());
            if (eos.indexOf(eo) == 0) continue;
            newBasicsDetailReqDtos.add(detailReqDto);
        }
        if (BigDecimalUtils.gtZero((BigDecimal)targetQuantity).booleanValue()) {
            InOutNoticeOrderDetailEo eo = eos.get(0);
            origDetail.setLineNo(eo.getLineNo());
            origDetail.setInventoryProperty((String)ObjectUtils.defaultIfNull((Object)origDetail.getInventoryProperty(), (Object)eo.getInventoryProperty()));
            origDetail.setTradeOrderItemId(eo.getPreOrderItemId());
            origDetail.setQuantity(BigDecimalUtils.add((BigDecimal)origDetail.getQuantity(), (BigDecimal)targetQuantity));
        }
    }
}

