/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.convert.entity.PurchaseConfigurationConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IPurchaseConfigurationDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.PurchaseConfigurationDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PurchaseConfigurationPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.PurchaseConfigurationEo;
import com.yunxi.dg.base.center.inventory.service.entity.IPurchaseConfigurationService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PurchaseConfigurationServiceImpl
extends BaseServiceImpl<PurchaseConfigurationDto, PurchaseConfigurationEo, IPurchaseConfigurationDomain>
implements IPurchaseConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseConfigurationServiceImpl.class);

    public PurchaseConfigurationServiceImpl(IPurchaseConfigurationDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<PurchaseConfigurationDto, PurchaseConfigurationEo> converter() {
        return PurchaseConfigurationConverter.INSTANCE;
    }

    @Override
    public Long add(PurchaseConfigurationDto dto) {
        log.info("\u65b0\u589e\u91c7\u8d2d\u5165\u5e93\u4ed3\u914d\u7f6e:{}", (Object)dto);
        this.validParams(dto);
        PurchaseConfigurationEo insertEo = new PurchaseConfigurationEo();
        BeanUtil.copyProperties((Object)dto, (Object)insertEo, (String[])new String[0]);
        insertEo.setId(null);
        ((IPurchaseConfigurationDomain)this.domain).insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public RestResponse modify(PurchaseConfigurationDto dto) {
        log.info("\u66f4\u65b0\u91c7\u8d2d\u5165\u5e93\u4ed3\u914d\u7f6e:{}", (Object)dto);
        this.validParams(dto);
        AssertUtils.isTrue((null != dto.getId() ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseConfigurationEo updateEo = new PurchaseConfigurationEo();
        BeanUtil.copyProperties((Object)dto, (Object)updateEo, (String[])new String[0]);
        ((IPurchaseConfigurationDomain)this.domain).update((BaseEo)updateEo);
        return RestResponse.VOID;
    }

    @Override
    public List<PurchaseConfigurationDto> queryList(PurchaseConfigurationPageReqDto dto) {
        return ((IPurchaseConfigurationDomain)this.domain).queryList(dto);
    }

    @Override
    public PageInfo<PurchaseConfigurationDto> queryPage(PurchaseConfigurationPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(this.queryList(dto));
    }

    private void validParams(PurchaseConfigurationDto dto) {
        AssertUtils.isTrue((null != dto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((null != dto.getBusinessEntityCode() ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5b9e\u4f53\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((null != dto.getBusinessEntityName() ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5b9e\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((null != dto.getSubWarehouseCode() ? 1 : 0) != 0, (String)"\u5b50\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((null != dto.getSubWarehouseName() ? 1 : 0) != 0, (String)"\u5b50\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((null != dto.getMaterialType() ? 1 : 0) != 0, (String)"\u7269\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((null != dto.getInLogicWarehouseCode() ? 1 : 0) != 0, (String)"\u91c7\u8d2d\u5165\u5e93\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((null != dto.getInLogicWarehouseName() ? 1 : 0) != 0, (String)"\u91c7\u8d2d\u5165\u5e93\u903b\u8f91\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List list = Optional.ofNullable(this.queryList(new PurchaseConfigurationPageReqDto())).orElse(new ArrayList());
        Map map = list.stream().collect(Collectors.toMap(o -> o.getBusinessEntityCode() + o.getSubWarehouseCode() + o.getMaterialType(), Function.identity(), (a1, a2) -> a1));
        if (dto.getId() == null) {
            AssertUtils.isTrue((!map.containsKey(dto.getBusinessEntityCode() + dto.getSubWarehouseCode() + dto.getMaterialType()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u5931\u8d25");
        }
        AssertUtils.isTrue((!map.containsKey(dto.getBusinessEntityCode() + dto.getSubWarehouseCode() + dto.getMaterialType()) ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5931\u8d25");
    }
}

