/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.pda.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.convert.entity.LogisticsPdaSettingConverter;
import com.yunxi.dg.base.center.inventory.convert.entity.LogisticsSiteLinkConverter;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsSiteLinkDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogisticsPdaSettingDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPdaSettingDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsSiteLinkDto;
import com.yunxi.dg.base.center.inventory.eo.LogisticsPdaSettingEo;
import com.yunxi.dg.base.center.inventory.eo.LogisticsSiteLinkEo;
import com.yunxi.dg.base.center.inventory.service.pda.ILogisticsPdaSettingService;
import com.yunxi.dg.base.center.inventory.service.pda.impl.LinkSelectTypeEnum;
import com.yunxi.dg.base.center.inventory.service.pda.impl.LinkSuitTypeEnum;
import com.yunxi.dg.base.center.inventory.service.pda.impl.PdaMatchUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;

@Service
public class LogisticsPdaSettingServiceImpl
extends BaseServiceImpl<LogisticsPdaSettingDto, LogisticsPdaSettingEo, ILogisticsPdaSettingDomain>
implements ILogisticsPdaSettingService {
    @Resource
    private ILogisticsSiteLinkDas logisticsSiteLinkDas;

    public LogisticsPdaSettingServiceImpl(ILogisticsPdaSettingDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogisticsPdaSettingDto, LogisticsPdaSettingEo> converter() {
        return LogisticsPdaSettingConverter.INSTANCE;
    }

    @Override
    public RestResponse<LogisticsPdaSettingDto> getAndInit() {
        List list = ((ILogisticsPdaSettingDomain)this.domain).filter().list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            LogisticsPdaSettingDto dto = (LogisticsPdaSettingDto)this.converter().toDto((BaseEo)list.get(0));
            this.wrapperResult(Lists.newArrayList((Object[])new LogisticsPdaSettingDto[]{dto}));
            return new RestResponse((Object)dto);
        }
        LogisticsPdaSettingEo dto = new LogisticsPdaSettingEo();
        dto.setAutoTake(Integer.valueOf(0));
        ((ILogisticsPdaSettingDomain)this.domain).insert((BaseEo)dto);
        return new RestResponse((Object)this.converter().toDto((BaseEo)dto));
    }

    public RestResponse<Long> insert(LogisticsPdaSettingDto dto) {
        RestResponse insert = super.insert((BaseDto)dto);
        Long data = (Long)insert.getData();
        this.addLink(data, dto.getLogisticsSiteLinkDtoList());
        return insert;
    }

    public RestResponse<Integer> update(LogisticsPdaSettingDto dto) {
        this.removeLink(dto.getId());
        this.addLink(dto.getId(), dto.getLogisticsSiteLinkDtoList());
        return super.update((BaseDto)dto);
    }

    public RestResponse<PageInfo<LogisticsPdaSettingDto>> page(LogisticsPdaSettingDto queryDto, Integer currentPage, Integer pageSize) {
        RestResponse page = super.page((BaseDto)queryDto, currentPage, pageSize);
        if (CollectionUtils.isNotEmpty((Collection)((PageInfo)page.getData()).getList())) {
            this.wrapperResult(((PageInfo)page.getData()).getList());
        }
        return super.page((BaseDto)queryDto, currentPage, pageSize);
    }

    private void wrapperResult(List<LogisticsPdaSettingDto> dtoList) {
        Map<Long, List<LogisticsSiteLinkEo>> listMap = ((ExtQueryChainWrapper)this.logisticsSiteLinkDas.filter().in((Object)"link_id", (Collection)dtoList.stream().map(BaseDto::getId).collect(Collectors.toSet()))).list().stream().collect(Collectors.groupingBy(LogisticsSiteLinkEo::getLinkId));
        dtoList.forEach(r -> r.setLogisticsSiteLinkDtoList(LogisticsSiteLinkConverter.INSTANCE.toDtoList((List)listMap.get(r.getId()))));
    }

    private void removeLink(Long id) {
        LogisticsSiteLinkEo linkEo = new LogisticsSiteLinkEo();
        linkEo.setLinkId(id);
        this.logisticsSiteLinkDas.delete((BaseEo)linkEo);
    }

    private void addLink(Long linkId, List<LogisticsSiteLinkDto> logisticsSiteLinkDtoList) {
        if (CollectionUtils.isNotEmpty(logisticsSiteLinkDtoList)) {
            this.logisticsSiteLinkDas.insertBatch(LogisticsSiteLinkConverter.INSTANCE.toEoList(logisticsSiteLinkDtoList.stream().peek(r -> {
                r.setLinkId(linkId);
                r.setLinkMatchKey(PdaMatchUtils.buildMatchKey(LinkSelectTypeEnum.SELECT, r.getLinkCode(), LinkSuitTypeEnum.CODE_LOOKUP.get(r.getLinkType())));
            }).collect(Collectors.toList())));
        }
    }
}

