/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.pda.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.LogisticsPlatformShopConverter;
import com.yunxi.dg.base.center.inventory.convert.entity.LogisticsSiteLinkConverter;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsPlatformShopDas;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsSiteLinkDas;
import com.yunxi.dg.base.center.inventory.dao.vo.LogisticsSiteLinkMatchDto;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogisticsPlatformShopDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPlatformShopDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPlatformShopEnableDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsPlatformShopPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogisticsSiteLinkDto;
import com.yunxi.dg.base.center.inventory.eo.LogisticsPlatformShopEo;
import com.yunxi.dg.base.center.inventory.eo.LogisticsSiteLinkEo;
import com.yunxi.dg.base.center.inventory.service.pda.ILogisticsPlatformShopService;
import com.yunxi.dg.base.center.inventory.service.pda.ILogisticsSiteLinkService;
import com.yunxi.dg.base.center.inventory.service.pda.impl.LinkSelectTypeEnum;
import com.yunxi.dg.base.center.inventory.service.pda.impl.LinkSuitTypeEnum;
import com.yunxi.dg.base.center.inventory.service.pda.impl.PdaMatchUtils;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogisticsPlatformShopServiceImpl
extends BaseServiceImpl<LogisticsPlatformShopDto, LogisticsPlatformShopEo, ILogisticsPlatformShopDomain>
implements ILogisticsPlatformShopService {
    private static final Logger logger = LoggerFactory.getLogger(LogisticsPlatformShopServiceImpl.class);
    @Resource
    private ILogisticsPlatformShopDas logisticsPlatformShopDas;
    @Resource
    private ILogisticsSiteLinkDas logisticsSiteLinkDas;
    @Resource
    private ILogisticsSiteLinkService logisticsSiteLinkService;

    public LogisticsPlatformShopServiceImpl(ILogisticsPlatformShopDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogisticsPlatformShopDto, LogisticsPlatformShopEo> converter() {
        return LogisticsPlatformShopConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addLogisticsPlatformShop(LogisticsPlatformShopDto addReqDto) {
        logger.info("\u65b0\u589e\u5e73\u53f0\u9762\u5355\u6388\u6743\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)addReqDto));
        this.addCheckInputValidity(addReqDto);
        LogisticsPlatformShopEo logisticsPlatformShopEo = new LogisticsPlatformShopEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)logisticsPlatformShopEo);
        this.logisticsPlatformShopDas.insert((BaseEo)logisticsPlatformShopEo);
        this.addLink(addReqDto, logisticsPlatformShopEo);
        return logisticsPlatformShopEo.getId();
    }

    public RestResponse<LogisticsPlatformShopDto> get(Long id) {
        RestResponse logisticsPlatformShopDtoRestResponse = super.get(id);
        this.wrapperResult(Lists.newArrayList((Object[])new LogisticsPlatformShopDto[]{(LogisticsPlatformShopDto)logisticsPlatformShopDtoRestResponse.getData()}));
        return logisticsPlatformShopDtoRestResponse;
    }

    @Override
    public void modifyLogisticsPlatformShop(LogisticsPlatformShopDto modifyReqDto) {
        logger.info("\u66f4\u65b0\u5e73\u53f0\u9762\u5355\u6388\u6743\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)modifyReqDto));
        if (null == modifyReqDto.getId()) {
            List<LogisticsPlatformShopEo> logisticsPlatformShopEos = this.checkInputValidity(modifyReqDto);
            logisticsPlatformShopEos.forEach(info -> {
                LogisticsPlatformShopEo logisticsPlatformShopEo = new LogisticsPlatformShopEo();
                DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)logisticsPlatformShopEo);
                logisticsPlatformShopEo.setId(info.getId());
                this.logisticsPlatformShopDas.updateSelective((BaseEo)logisticsPlatformShopEo);
            });
        } else {
            LogisticsPlatformShopEo logisticsPlatformShopEo = new LogisticsPlatformShopEo();
            DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)logisticsPlatformShopEo);
            this.logisticsPlatformShopDas.updateSelective((BaseEo)logisticsPlatformShopEo);
            this.removeLink(modifyReqDto.getId());
            this.addLink(modifyReqDto, logisticsPlatformShopEo);
        }
    }

    private void removeLink(Long id) {
        LogisticsSiteLinkEo linkEo = new LogisticsSiteLinkEo();
        linkEo.setLinkId(id);
        this.logisticsSiteLinkDas.delete((BaseEo)linkEo);
    }

    private void addLink(LogisticsPlatformShopDto modifyReqDto, LogisticsPlatformShopEo logisticsPlatformShopEo) {
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getLogisticsSiteLinkDtoList())) {
            this.logisticsSiteLinkDas.insertBatch(LogisticsSiteLinkConverter.INSTANCE.toEoList(modifyReqDto.getLogisticsSiteLinkDtoList().stream().peek(r -> {
                r.setLinkId(logisticsPlatformShopEo.getId());
                r.setLinkMatchKey(PdaMatchUtils.buildMatchKey(LinkSelectTypeEnum.SELECT, r.getLinkCode(), LinkSuitTypeEnum.CODE_LOOKUP.get(r.getLinkType())));
            }).collect(Collectors.toList())));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeLogisticsPlatformShop(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ids.forEach(v -> {
            this.logisticsPlatformShopDas.logicDeleteById(v);
            this.removeLink((Long)v);
        });
    }

    @Override
    public PageInfo<LogisticsPlatformShopDto> queryByPage(LogisticsPlatformShopPageReqDto reqDto, Integer pageNum, Integer pageSize) {
        reqDto = (LogisticsPlatformShopPageReqDto)ObjectUtil.defaultIfNull((Object)reqDto, (Object)new LogisticsPlatformShopPageReqDto());
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.logisticsPlatformShopDas.filter().orderByDesc((Object)"id");
        ExtQueryChainWrapper<LogisticsPlatformShopEo> platformShopEoExtQueryChainWrapper = this.wrapperQuery(reqDto, (ExtQueryChainWrapper<LogisticsPlatformShopEo>)sqlFilters);
        PageInfo dtoPageInfo = new PageInfo();
        if (ObjectUtil.isNull(platformShopEoExtQueryChainWrapper)) {
            return dtoPageInfo;
        }
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<LogisticsPlatformShopDto> dtoList = new ArrayList<LogisticsPlatformShopDto>();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, LogisticsPlatformShopDto.class);
        this.wrapperResult(dtoList);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void wrapperResult(List<LogisticsPlatformShopDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        Map<Long, List<LogisticsSiteLinkEo>> listMap = ((ExtQueryChainWrapper)this.logisticsSiteLinkDas.filter().in((Object)"link_id", (Collection)dtoList.stream().map(BaseDto::getId).collect(Collectors.toSet()))).list().stream().collect(Collectors.groupingBy(LogisticsSiteLinkEo::getLinkId));
        dtoList.forEach(r -> r.setLogisticsSiteLinkDtoList(LogisticsSiteLinkConverter.INSTANCE.toDtoList((List)listMap.get(r.getId()))));
    }

    private ExtQueryChainWrapper<LogisticsPlatformShopEo> wrapperQuery(LogisticsPlatformShopPageReqDto reqDto, ExtQueryChainWrapper<LogisticsPlatformShopEo> sqlFilters) {
        List match;
        HashSet<String> matchSet;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getShopCode())) {
            if (!InventoryConfig.isPadModule()) {
                matchSet = new HashSet<String>();
                matchSet.add(PdaMatchUtils.buildMatchKey(LinkSelectTypeEnum.SELECT, reqDto.getShopCode(), LinkSuitTypeEnum.SHOP));
                match = this.logisticsPlatformShopDas.match(matchSet, 1);
                if (CollectionUtils.isEmpty((Collection)match)) {
                    return null;
                }
                sqlFilters.in((Object)"id", (Collection)match.stream().map(BaseEo::getId).collect(Collectors.toList()));
            } else {
                sqlFilters.eq((Object)"shop_code", (Object)reqDto.getShopCode());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getLinkShopCodeList()) && !InventoryConfig.isPadModule()) {
            matchSet = new HashSet();
            reqDto.getLinkShopCodeList().forEach(r -> matchSet.add(PdaMatchUtils.buildMatchKey(LinkSelectTypeEnum.SELECT, r, LinkSuitTypeEnum.SHOP)));
            match = this.logisticsPlatformShopDas.match(matchSet, 1);
            if (CollectionUtils.isEmpty((Collection)match)) {
                return null;
            }
            sqlFilters.in((Object)"id", (Collection)match.stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getWarehouseCodeList()) && !InventoryConfig.isPadModule()) {
            matchSet = new HashSet();
            reqDto.getWarehouseCodeList().forEach(r -> matchSet.add(PdaMatchUtils.buildMatchKey(LinkSelectTypeEnum.SELECT, r, LinkSuitTypeEnum.WAREHOUSE)));
            match = this.logisticsPlatformShopDas.match(matchSet, 1);
            if (CollectionUtils.isEmpty((Collection)match)) {
                return null;
            }
            sqlFilters.in((Object)"id", (Collection)match.stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
        ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)sqlFilters.in(CollectionUtils.isNotEmpty((Collection)reqDto.getAuthShopCodeList()), (Object)"shop_code", (Collection)reqDto.getAuthShopCodeList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getChannelCodeList()), (Object)"channel_code", (Collection)reqDto.getChannelCodeList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getPlatformCodeList()), (Object)"platform_code", (Collection)reqDto.getPlatformCodeList())).ge(ObjectUtil.isNotNull((Object)reqDto.getCreateTimeStarter()), (Object)"create_time", (Object)reqDto.getCreateTimeStarter())).le(ObjectUtil.isNotNull((Object)reqDto.getCreateTimeEnd()), (Object)"create_time", (Object)reqDto.getCreateTimeEnd())).ge(ObjectUtil.isNotNull((Object)reqDto.getUpdateTimeStarter()), (Object)"update_time", (Object)reqDto.getUpdateTimeStarter())).le(ObjectUtil.isNotNull((Object)reqDto.getUpdateTimeEnd()), (Object)"update_time", (Object)reqDto.getUpdateTimeEnd())).like(ObjectUtil.isNotNull((Object)reqDto.getCreatePerson()), (Object)"create_person", (Object)reqDto.getCreatePerson())).like(ObjectUtil.isNotNull((Object)reqDto.getCreatePerson()), (Object)"create_person", (Object)reqDto.getCreatePerson())).like(ObjectUtil.isNotNull((Object)reqDto.getUpdatePerson()), (Object)"update_person", (Object)reqDto.getUpdatePerson())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getStatusList()), (Object)"auth_state", (Collection)reqDto.getStatusList());
        if (Objects.nonNull(reqDto.getAuthState())) {
            sqlFilters.eq((Object)"auth_state", (Object)reqDto.getAuthState());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getChannelCode())) {
            sqlFilters.eq((Object)"channel_code", (Object)reqDto.getChannelCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPlatformCode())) {
            sqlFilters.eq((Object)"platform_code", (Object)reqDto.getPlatformCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getWarehouseCode())) {
            sqlFilters.eq((Object)"warehouse_code", (Object)reqDto.getWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPlatformType())) {
            sqlFilters.eq((Object)"platform_type", (Object)reqDto.getPlatformType());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdatePerson())) {
            sqlFilters.eq((Object)"update_person", (Object)reqDto.getUpdatePerson());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCreatePerson())) {
            sqlFilters.eq((Object)"create_person", (Object)reqDto.getCreatePerson());
        }
        return sqlFilters;
    }

    @Override
    public List<LogisticsPlatformShopDto> queryByParam(LogisticsPlatformShopPageReqDto reqDto) {
        logger.info("\u67e5\u8be2\u5e73\u53f0\u9762\u5355\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)reqDto));
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.logisticsPlatformShopDas.filter().orderByDesc((Object)"id");
        if (null != reqDto.getId()) {
            sqlFilters.eq((Object)"id", (Object)reqDto.getId());
        }
        if (null != reqDto.getShopId()) {
            sqlFilters.eq((Object)"shop_id", (Object)reqDto.getShopId());
        }
        this.wrapperQuery(reqDto, (ExtQueryChainWrapper<LogisticsPlatformShopEo>)sqlFilters);
        List list = sqlFilters.list();
        ArrayList<LogisticsPlatformShopDto> logisticsPlatformShopRespDtoList = new ArrayList<LogisticsPlatformShopDto>();
        CubeBeanUtils.copyCollection(logisticsPlatformShopRespDtoList, (Collection)list, LogisticsPlatformShopDto.class);
        this.wrapperResult(logisticsPlatformShopRespDtoList);
        return logisticsPlatformShopRespDtoList;
    }

    @Override
    public RestResponse<Void> enable(LogisticsPlatformShopEnableDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getIds())) {
            return RestResponse.VOID;
        }
        LogisticsPlatformShopEo logisticsPlatformShopEo = new LogisticsPlatformShopEo();
        logisticsPlatformShopEo.setAuthState(dto.getStatus());
        this.logisticsPlatformShopDas.getMapper().update((Object)logisticsPlatformShopEo, (Wrapper)Wrappers.query((Object)new LogisticsPlatformShopEo()).in((Object)"id", (Collection)dto.getIds()));
        return RestResponse.VOID;
    }

    public void addCheckInputValidity(LogisticsPlatformShopDto logisticsPlatformShopDto) {
        this.checkParamNotNull(logisticsPlatformShopDto);
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPlatformShopDas.filter().eq((Object)"shop_code", (Object)logisticsPlatformShopDto.getShopCode())).eq((Object)"channel_code", (Object)logisticsPlatformShopDto.getChannelCode())).eq(!InventoryConfig.isPadModule(), (Object)"warehouse_code", (Object)logisticsPlatformShopDto.getWarehouseCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list) && !InventoryConfig.isPadModule() && CollectionUtils.isNotEmpty((Collection)logisticsPlatformShopDto.getLogisticsSiteLinkDtoList())) {
            List<LogisticsPlatformShopEo> platformShopEos = this.matchByLink(logisticsPlatformShopDto.getLogisticsSiteLinkDtoList());
            List ids = platformShopEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            list = list.stream().filter(r -> ids.contains(r.getId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BizException("\u6388\u6743\u5e97\u94fa+\u5feb\u9012\u5df2\u5b58\u5728\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0!");
        }
    }

    private List<LogisticsPlatformShopEo> matchByLink(List<LogisticsSiteLinkDto> logisticsSiteLinkDtoList) {
        Map<String, List<LogisticsSiteLinkDto>> listMap = logisticsSiteLinkDtoList.stream().collect(Collectors.groupingBy(LogisticsSiteLinkDto::getLinkType));
        List matchList = listMap.entrySet().stream().map(r -> {
            LogisticsSiteLinkMatchDto matchDto = new LogisticsSiteLinkMatchDto();
            matchDto.setType((String)r.getKey());
            matchDto.setKeys(((List)r.getValue()).stream().map(LogisticsSiteLinkDto::getLinkMatchKey).collect(Collectors.toList()));
            return matchDto;
        }).collect(Collectors.toList());
        return this.logisticsPlatformShopDas.matchByList(matchList);
    }

    public List<LogisticsPlatformShopEo> checkInputValidity(LogisticsPlatformShopDto logisticsPlatformShopDto) {
        this.checkParamNotNull(logisticsPlatformShopDto);
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsPlatformShopDas.filter().eq(StrUtil.isNotBlank((CharSequence)logisticsPlatformShopDto.getShopCode()), (Object)"shop_code", (Object)logisticsPlatformShopDto.getShopCode())).eq(StrUtil.isNotBlank((CharSequence)logisticsPlatformShopDto.getChannelCode()), (Object)"channel_code", (Object)logisticsPlatformShopDto.getChannelCode())).eq(StrUtil.isNotBlank((CharSequence)logisticsPlatformShopDto.getPlatformCode()), (Object)"platform_code", (Object)logisticsPlatformShopDto.getPlatformCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            logger.info("\u672a\u627e\u5230\u9762\u5355\u6388\u6743\u4fe1\u606f\u65e0\u6cd5\u66f4\u65b0!");
        }
        return list;
    }

    public void checkParamNotNull(LogisticsPlatformShopDto logisticsPlatformShopDto) {
        AssertUtil.assertNotBlank((String)logisticsPlatformShopDto.getShopCode(), (String)"\u5e97\u94fa\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertTrue((InventoryConfig.isPadModule() || StringUtils.isNotBlank((CharSequence)logisticsPlatformShopDto.getChannelCode()) ? 1 : 0) != 0, (String)"\u9762\u5355\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertNotBlank((String)logisticsPlatformShopDto.getPlatformCode(), (String)"\u9762\u5355\u7ad9\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

