package com.yunxi.dg.base.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.item.dto.request.DgSyncItemInfoDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * @author :wuhui
 * @Desc:TODO
 * @Date:2023/7/7 10:49
 */
@Api(tags = {"基线的商品中心：同步商品通用接口"})
@FeignClient(
        contextId = "yunxi-dg-base-center-item-api-DgSyncItemInfoApi",
        name = "${com.yunxi.dg.base.center.item.api.name:yunxi-dg-base-center-item}",
        path = "/v1/dg/sync/item",
        url = "${com.yunxi.dg.base.center.item.api:}"
)
public interface IDgSyncItemInfoApi {


    @ApiOperation(value = "同步商品通用接口", notes = "同步商品通用接口")
    @PostMapping({""})
    RestResponse<Void> syncItem(@Valid @RequestBody DgSyncItemInfoDto itemInfoDto);

    @ApiOperation(value = "同步商品通用接口", notes = "同步商品通用接口")
    @PostMapping({"/batch"})
    RestResponse<Void> syncItemBatch(@Valid @RequestBody List<DgSyncItemInfoDto> itemInfoDtos);
}
