/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.domain.entity.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dao.das.DirItemRelationDgDas;
import com.yunxi.dg.base.center.item.domain.entity.IDirItemRelationDgDomain;
import com.yunxi.dg.base.center.item.eo.DirItemRelationDgEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DirItemRelationDgDomainImpl
extends BaseDomainImpl<DirItemRelationDgEo>
implements IDirItemRelationDgDomain {
    @Resource
    private DirItemRelationDgDas das;

    public ICommonDas<DirItemRelationDgEo> commonDas() {
        return this.das;
    }

    @Override
    public List<DirItemRelationDgEo> selectByParam(Long shopId, Long itemId) {
        if (shopId == null && itemId == null) {
            return Lists.newArrayList();
        }
        DirItemRelationDgEo param = DirItemRelationDgEo.newInstance();
        if (shopId != null) {
            param.setShopId(shopId);
        }
        if (itemId != null) {
            param.setItemId(itemId);
        }
        return this.das.selectList((BaseEo)param);
    }

    @Override
    public List<DirItemRelationDgEo> selectByItemIdsAndDirType(List<Long> itemIds, String dirType) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return Lists.newArrayList();
        }
        DirItemRelationDgEo dirsItemsEo = DirItemRelationDgEo.newInstance();
        if (StringUtils.isNotEmpty((CharSequence)dirType)) {
            dirsItemsEo.setDirType(dirType);
        }
        dirsItemsEo.setStatus(Integer.valueOf(1));
        dirsItemsEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"item_id", (Object)StringUtils.join(itemIds, (String)",")));
        dirsItemsEo.setSqlFilters((List)sqlFilters);
        return this.das.selectList((BaseEo)dirsItemsEo);
    }

    @Override
    public List<DirItemRelationDgEo> selectByItemIds(List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return Lists.newArrayList();
        }
        DirItemRelationDgEo dirsItemsEo = DirItemRelationDgEo.newInstance();
        dirsItemsEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"item_id", (Object)StringUtils.join(itemIds, (String)",")));
        dirsItemsEo.setSqlFilters((List)sqlFilters);
        return this.das.selectList((BaseEo)dirsItemsEo);
    }
}

