/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.constants.ItemDgItemAttributeEnum;
import com.yunxi.dg.base.center.item.dao.das.ItemSkuDgDas;
import com.yunxi.dg.base.center.item.dao.vo.DgItemSkuRespVo;
import com.yunxi.dg.base.center.item.dao.vo.ItemRelationSkuDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ItemSkuConditionDgVo;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.dto.request.AccessoryItemReqDto;
import com.yunxi.dg.base.center.item.dto.request.DgItemSkuPlanQueryReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSkuQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.MarketSkuSearchDto;
import com.yunxi.dg.base.center.item.dto.request.ShopItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.AccessoryItemRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuExtDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuQueryDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class ItemSkuDgDomainImpl
extends BaseDomainImpl<ItemSkuDgEo>
implements IItemSkuDgDomain {
    @Resource
    private ItemSkuDgDas das;

    public ICommonDas<ItemSkuDgEo> commonDas() {
        return this.das;
    }

    @Override
    public List<ItemSkuDgEo> selectItemSkuByIds(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return Lists.newArrayList();
        }
        return ((ExtQueryChainWrapper)this.das.filter().in((Object)"id", skuIds)).list();
    }

    @Override
    public List<ItemSkuDgEo> selectItemSkuByCodes(List<String> skuCodes) {
        if (CollectionUtils.isEmpty(skuCodes)) {
            return Lists.newArrayList();
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"dr", (Object)0)).in((Object)"code", skuCodes)).list();
    }

    @Override
    public PageInfo<ItemRelationSkuDgVo> queryItemSkuPageByCondition(ItemSkuConditionDgVo itemSkuConditionVo, Integer pageNum, Integer pageSize) {
        return this.das.queryItemSkuPageByCondition(itemSkuConditionVo, pageNum, pageSize);
    }

    @Override
    public List<ItemSkuDgEo> selectByItemIds(List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return Lists.newArrayList();
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"dr", (Object)0)).in((Object)"item_id", itemIds)).list();
    }

    @Override
    public void deleteBatchItemSku(List<Long> ids) {
        this.das.deleteBatchItemSku(ids);
    }

    @Override
    public List<ItemRelationSkuDgVo> queryItemRelationSku(ItemRelationSkuDgVo itemRelationSkuVo) {
        return this.das.queryItemRelationSku(itemRelationSkuVo);
    }

    @Override
    public Integer updateByItemIdAndSkuId(ItemSkuDgEo stdItemSkuEo) {
        return this.das.updateByItemIdAndSkuId(stdItemSkuEo);
    }

    @Override
    public List<ItemSkuQueryDgRespDto> querySkuPage(ItemSkuQueryDgReqDto itemSkuQueryReqDto) {
        return this.das.querySkuPage(itemSkuQueryReqDto);
    }

    @Override
    public List<ItemSkuDgEo> selectByItemId(Long itemId) {
        ItemSkuDgEo ex = ItemSkuDgEo.newInstance();
        ex.setItemId(itemId);
        return this.das.selectList((BaseEo)ex);
    }

    @Override
    public void addGift(List<Long> skuIds, Integer status) {
        this.das.addGift(skuIds, status);
    }

    @Override
    public void addGiftByCodes(List<String> skuCodes, Integer status) {
        this.das.addGiftByCodes(skuCodes, status);
    }

    @Override
    public void batchModifyGiftStatus(List<Long> skuIds, Integer status) {
        this.das.batchModifyGiftStatus(skuIds, status);
    }

    @Override
    public void removeGift(Long skuId) {
        this.das.removeGift(skuId);
    }

    @Override
    public List<ItemSkuExtDgRespDto> querySkuList(ItemSkuQueryDgReqDto itemSkuQueryDgReqDto) {
        return this.das.querySkuList(itemSkuQueryDgReqDto);
    }

    @Override
    public List<ItemSkuExtDgRespDto> queryItemListByPage(ItemQueryDgReqDto itemDgReqDto, List<String> itemCodes, List<String> skuCodes) {
        return this.das.queryItemListByPage(itemDgReqDto, itemCodes, skuCodes);
    }

    @Override
    public void batchChangeStatus(List<Long> ids, Integer status) {
        this.das.batchChangeStatus(ids, status);
    }

    @Override
    public PageInfo<DgItemSkuRespVo> queryItemSkuPage(@NotNull ItemQueryDgReqDto itemDgReqDto) {
        PageHelper.startPage((int)itemDgReqDto.getPageNum(), (int)itemDgReqDto.getPageSize());
        List itemAttributeList = itemDgReqDto.getItemAttributeList();
        if (CollectionUtils.isEmpty((Collection)itemAttributeList)) {
            itemDgReqDto.setItemAttributeList(ItemDgItemAttributeEnum.getCommonTypeList());
        }
        return new PageInfo(this.das.queryItemSkuList(itemDgReqDto));
    }

    @Override
    public PageInfo<DgItemSkuRespVo> queryItemPageByCodes(List<String> skuCodes, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new PageInfo(this.das.queryItemPageByCodes(skuCodes));
    }

    @Override
    public List<DgItemSkuRespVo> queryItemSkuList(ItemQueryDgReqDto itemDgReqDto) {
        return this.das.queryItemSkuList(itemDgReqDto);
    }

    @Override
    public PageInfo<ItemSkuDgEo> querySkuPageByPlan(DgItemSkuPlanQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        ItemSkuDgEo skuDgEo = new ItemSkuDgEo();
        skuDgEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            sqlFilters.add(SqlFilter.in((String)"code", (Object)reqDto.getSkuCodeList()));
        } else {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)reqDto.getSkuCode()));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuIds())) {
            sqlFilters.add(SqlFilter.in((String)"id", (Object)reqDto.getSkuIds()));
        }
        if (Objects.nonNull(reqDto.getName())) {
            sqlFilters.add(SqlFilter.in((String)"name", (Object)reqDto.getName()));
        }
        skuDgEo.setSqlFilters((List)sqlFilters);
        return this.das.selectPage((BaseEo)skuDgEo, pageNum, pageSize, Boolean.valueOf(false));
    }

    @Override
    public void batchRemoveGift(List<Long> skuIds) {
        this.das.batchRemoveGift(skuIds);
    }

    @Override
    public PageInfo<DgItemSkuPageRespDto> queryShopItemSkuPage(ShopItemQueryDgReqDto shopItemQueryDgReqDto) {
        PageHelper.startPage((int)shopItemQueryDgReqDto.getPageNum(), (int)shopItemQueryDgReqDto.getPageSize());
        return new PageInfo(this.das.queryShopItemSkuPage(shopItemQueryDgReqDto));
    }

    @Override
    public List<DgItemSkuRespVo> queryShopItemSkuList(ShopItemQueryDgReqDto shopItemQueryDgReqDto) {
        return this.das.queryShopItemSkuList(shopItemQueryDgReqDto);
    }

    @Override
    public void removeBomByIds(List<Long> skuIds) {
        this.das.removeBomByIds(skuIds);
    }

    @Override
    public PageInfo<DgItemSkuRespDto> queryMarketSkuPage(MarketSkuSearchDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new PageInfo(this.das.queryMarketSkuPage(reqDto));
    }

    @Override
    public List<AccessoryItemRespDto> queryAccessoryItemList(AccessoryItemReqDto reqDto) {
        return this.das.queryAccessoryItemList(reqDto);
    }

    @Override
    public PageInfo<DgItemSkuPageRespDto> queryItemSkuPageV2(ItemQueryDgReqDto itemDgReqDto) {
        PageHelper.startPage((int)itemDgReqDto.getPageNum(), (int)itemDgReqDto.getPageSize());
        return new PageInfo(this.das.queryItemSkuListV2(itemDgReqDto));
    }

    @Override
    public List<ItemSkuDgEo> queryByFirstMarketDateRange(String firstMarketDateStart, String firstMarketDateEnd) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().lt((Object)"first_market_date", (Object)firstMarketDateEnd)).ge((Object)"first_market_date", (Object)firstMarketDateStart)).list();
    }

    @Override
    public List<DgItemSkuPageRespDto> querySimpleItemList(ItemQueryDgReqDto itemDgReqDto) {
        PageHelper.startPage((int)itemDgReqDto.getPageNum(), (int)itemDgReqDto.getPageSize(), (boolean)false);
        return this.das.querySimpleItemList(itemDgReqDto);
    }

    @Override
    public Long countSimpleItemList(ItemQueryDgReqDto itemDgReqDto) {
        return this.das.countSimpleItemList(itemDgReqDto);
    }

    @Override
    public List<String> querySpecModelBySkuCode(List<String> skuCodes) {
        return this.das.querySpecModelBySkuCode(skuCodes);
    }
}

