/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.dto.response;

import com.dtyunxi.cube.commons.dto.TreeNode;
import com.yunxi.dg.base.center.item.dto.response.DirIndexDgRespDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="DirIndexDgTreeDto", description="\u76ee\u5f55\u54cd\u5e94\u9644\u5e26\u7d22\u5f15\u4fe1\u606fDto")
public class DirIndexDgTreeDto
extends BaseDto {
    private static Logger logger = LoggerFactory.getLogger(DirIndexDgTreeDto.class);
    @ApiModelProperty(name="node", value="\u76ee\u5f55\u8282\u70b9")
    private DirIndexDgRespDto node;
    @ApiModelProperty(name="children", value="\u76ee\u5f55\u5b50\u8282\u70b9\u96c6\u5408")
    private List<DirIndexDgTreeDto> children;

    public DirIndexDgTreeDto() {
    }

    public DirIndexDgTreeDto(DirIndexDgRespDto node) {
        this.node = node;
    }

    public static List<DirIndexDgTreeDto> createTreeDto(List<DirIndexDgRespDto> listT) {
        ArrayList<DirIndexDgTreeDto> treeDtos = new ArrayList<DirIndexDgTreeDto>();
        Long topId = DirIndexDgTreeDto.findTopId(listT);
        if (!CollectionUtils.isEmpty(listT)) {
            TreeMap<String, List<DirIndexDgTreeDto>> subTreeMap = new TreeMap<String, List<DirIndexDgTreeDto>>();
            for (DirIndexDgRespDto t : listT) {
                DirIndexDgTreeDto treeDto = new DirIndexDgTreeDto(t);
                if (topId.equals(t.getParentId())) {
                    treeDtos.add(treeDto);
                    continue;
                }
                String parentIdString = String.valueOf(t.getParentId());
                ArrayList<DirIndexDgTreeDto> subList = (ArrayList<DirIndexDgTreeDto>)subTreeMap.get(parentIdString);
                if (CollectionUtils.isEmpty((Collection)subList)) {
                    subList = new ArrayList<DirIndexDgTreeDto>();
                }
                subList.add(treeDto);
                subTreeMap.put(parentIdString, subList);
            }
            for (DirIndexDgTreeDto tree : treeDtos) {
                DirIndexDgTreeDto.getSubTree(tree, subTreeMap);
            }
        }
        return treeDtos;
    }

    private static <T extends TreeNode> void getSubTree(DirIndexDgTreeDto tree, Map<String, List<DirIndexDgTreeDto>> map) {
        String parentIdString = String.valueOf(tree.getNode().getId());
        List<DirIndexDgTreeDto> childList = map.get(parentIdString);
        if (!CollectionUtils.isEmpty(childList)) {
            tree.setChildren(childList);
            for (DirIndexDgTreeDto child : childList) {
                DirIndexDgTreeDto.getSubTree(child, map);
            }
        }
    }

    private static Long findTopId(List<DirIndexDgRespDto> list) {
        Long topId = null;
        for (DirIndexDgRespDto t : list) {
            if (t == null || t.getParentId() == null) continue;
            if (topId == null) {
                topId = t.getParentId();
                continue;
            }
            if (t.getParentId().equals(TreeNode.TOP_ID)) {
                topId = t.getParentId();
                return topId;
            }
            if (!topId.equals(t.getId())) continue;
            topId = t.getParentId();
        }
        if (topId == null) {
            topId = 0L;
        }
        return topId;
    }

    public DirIndexDgRespDto getNode() {
        return this.node;
    }

    public List<DirIndexDgTreeDto> getChildren() {
        return this.children;
    }

    public void setNode(DirIndexDgRespDto node) {
        this.node = node;
    }

    public void setChildren(List<DirIndexDgTreeDto> children) {
        this.children = children;
    }
}

