/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.boot.mqc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dao.vo.StorageChangeLogMessageDgVo;
import com.yunxi.dg.base.center.item.domain.entity.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemStorageDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IStorageChangeLogDgDomain;
import com.yunxi.dg.base.center.item.eo.ItemBundleRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemStorageDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfDgEo;
import com.yunxi.dg.base.center.item.eo.StorageChangeLogDgEo;
import com.yunxi.dg.base.center.item.service.entity.IItemStorageDgService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="ITEM_STORAGE_CHANGE_LOG_DG")
public class StorageChangeLogDgProcess
implements IMessageProcessor {
    private Logger logger = LoggerFactory.getLogger(StorageChangeLogDgProcess.class);
    @Resource
    private IStorageChangeLogDgDomain storageChangeLogDgDomain;
    @Resource
    private IItemStorageDgDomain itemStorageDgDomain;
    @Resource
    private IShelfDgDomain shelfDgDomain;
    @Resource
    private IItemBundleRelationDgDomain itemBundleRelationDgDomain;
    @Resource
    private IItemStorageDgService itemStorageDgService;
    private String done = "done";

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(Object messageObj) {
        try {
            String messageStr = (String)messageObj;
            this.logger.info("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55\u540c\u6b65\u5230\u5546\u54c1\u5e93\u5b58\u8868\u63a5\u6536\u5230me\u6d88\u606f:{}", (Object)messageStr);
            StorageChangeLogMessageDgVo storageChangeLogMessageDgVo = (StorageChangeLogMessageDgVo)JSON.parseObject((String)messageStr, StorageChangeLogMessageDgVo.class);
            if (storageChangeLogMessageDgVo == null || CollectionUtils.isEmpty((Collection)storageChangeLogMessageDgVo.getChangeLogIdList())) {
                this.logger.info("\u65e0\u6cd5\u89e3\u6790\u51famq\u6d88\u606f\u5185\u5bb9");
                return MessageResponse.SUCCESS;
            }
            String date = null;
            for (Long changeLogId : storageChangeLogMessageDgVo.getChangeLogIdList()) {
                StorageChangeLogDgEo storageChangeLogDgEo = (StorageChangeLogDgEo)this.storageChangeLogDgDomain.selectByPrimaryKey(changeLogId);
                date = (String)storageChangeLogMessageDgVo.getParams().get(changeLogId);
                if (storageChangeLogDgEo == null) {
                    this.logger.error("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55id:{}\u4e0d\u5b58\u5728", (Object)changeLogId);
                    continue;
                }
                if (storageChangeLogDgEo.getExtension().indexOf(this.done) > 0) continue;
                ItemStorageDgEo itemStorageDgEo = new ItemStorageDgEo();
                itemStorageDgEo.setShelfId(storageChangeLogDgEo.getShelfId());
                itemStorageDgEo.setItemId(storageChangeLogDgEo.getItemId());
                itemStorageDgEo.setSkuId(storageChangeLogDgEo.getSkuId());
                itemStorageDgEo.setShopId(storageChangeLogDgEo.getShopId());
                if (StringUtils.isNotBlank((CharSequence)date)) {
                    ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
                    sqlFilterList.add(SqlFilter.eq((String)"inventory_effective_date", (Object)date));
                    itemStorageDgEo.setSqlFilters(sqlFilterList);
                }
                Long balance = 0L;
                for (int count = 5; count > 1; --count) {
                    JSONObject jsonObject;
                    if ((itemStorageDgEo = (ItemStorageDgEo)this.itemStorageDgDomain.selectOne((BaseEo)itemStorageDgEo)) == null) {
                        this.logger.error("\u5546\u54c1\u4e2d\u5fc3\u6570\u636e\u95ee\u9898\uff0c\u6263\u51cf\u5e93\u5b58\u65f6\u672a\u68c0\u6d4b\u662f\u5426\u5b58\u5728\u5546\u54c1\u5e93\u5b58\u4fe1\u606f");
                        return MessageResponse.SUCCESS;
                    }
                    ItemStorageDgEo storageUpdateEo = new ItemStorageDgEo();
                    storageUpdateEo.setId(itemStorageDgEo.getId());
                    if (storageChangeLogDgEo.getAppending() != null) {
                        if (itemStorageDgEo.getAppending() == null) {
                            itemStorageDgEo.setAppending(Long.valueOf(0L));
                        }
                        storageUpdateEo.setAppending(Long.valueOf(itemStorageDgEo.getAppending() + storageChangeLogDgEo.getAppending()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)storageChangeLogDgEo.getExtension()) && (balance = Long.valueOf((jsonObject = JSON.parseObject((String)storageChangeLogDgEo.getExtension())).getLongValue("balance"))) != null) {
                        if (itemStorageDgEo.getBalance() == null) {
                            itemStorageDgEo.setBalance(Long.valueOf(0L));
                        }
                        this.logger.info("\u53d8\u66f4\u5e93\u5b58itemId={},skuId={},storeId={},balance={}", new Object[]{storageChangeLogDgEo.getSkuId(), storageChangeLogDgEo.getItemId(), storageUpdateEo.getId(), Long.valueOf(balance.toString())});
                        storageUpdateEo.setBalance(Long.valueOf(itemStorageDgEo.getBalance() + balance));
                    }
                    ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                    sqlFilters.add(SqlFilter.eq((String)"id", (Object)itemStorageDgEo.getId()));
                    sqlFilters.add(SqlFilter.eq((String)"balance", (Object)itemStorageDgEo.getBalance()));
                    sqlFilters.add(SqlFilter.eq((String)"appending", (Object)itemStorageDgEo.getAppending()));
                    storageUpdateEo.setSqlFilters(sqlFilters);
                    if (this.itemStorageDgDomain.updateSelectiveSqlFilter((BaseEo)storageUpdateEo) <= 1) {
                        continue;
                    }
                    StorageChangeLogDgEo updateStorageChangeLogDgEo = new StorageChangeLogDgEo();
                    updateStorageChangeLogDgEo.setId(changeLogId);
                    if (StringUtils.isNotEmpty((CharSequence)storageChangeLogDgEo.getExtension())) {
                        JSONObject map = JSON.parseObject((String)storageChangeLogDgEo.getExtension());
                        map.put("stage", this.done);
                        updateStorageChangeLogDgEo.setExtension(JSON.toJSONString((Object)map));
                    } else {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("stage", this.done);
                        updateStorageChangeLogDgEo.setExtension(JSON.toJSONString(map));
                    }
                    this.storageChangeLogDgDomain.updateSelective((BaseEo)updateStorageChangeLogDgEo);
                    return MessageResponse.SUCCESS;
                }
                this.updateBundleItemVirStorage(itemStorageDgEo.getId(), storageChangeLogDgEo.getShopId(), storageChangeLogDgEo.getItemId(), storageChangeLogDgEo.getSkuId(), balance);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.ERROR;
    }

    public void updateBundleItemVirStorage(Long subItemStorageId, Long shopId, Long itemId, Long skuId, Long balance) {
        this.logger.info("\u66f4\u65b0\u5b50\u5546\u54c1\u5bf9\u5e94\u7ec4\u5408\u5546\u54c1\u7684\u5e93\u5b58: shopId={}, itemId={}, skuId={}", new Object[]{shopId, itemId, skuId});
        try {
            List bundleItemStorageDgEoList;
            List bundleShelfDgEoList;
            List itemBundleRelationDgEoList = this.itemBundleRelationDgDomain.getBundleItemBySubItem(itemId, skuId);
            if (CollectionUtils.isNotEmpty((Collection)itemBundleRelationDgEoList) && CollectionUtils.isNotEmpty((Collection)(bundleShelfDgEoList = this.shelfDgDomain.selectByParam((List)Lists.newArrayList((Object[])new Long[]{shopId}), itemBundleRelationDgEoList.stream().map(ItemBundleRelationDgEo::getItemId).distinct().collect(Collectors.toList()), itemBundleRelationDgEoList.stream().map(ItemBundleRelationDgEo::getSkuId).distinct().collect(Collectors.toList()), null))) && CollectionUtils.isNotEmpty((Collection)(bundleItemStorageDgEoList = this.itemStorageDgDomain.selectByParam((List)Lists.newArrayList((Object[])new Long[]{shopId}), bundleShelfDgEoList.stream().map(ShelfDgEo::getItemId).distinct().collect(Collectors.toList()), bundleShelfDgEoList.stream().map(ShelfDgEo::getSkuId).distinct().collect(Collectors.toList()))))) {
                if (balance < 0L) {
                    ItemStorageDgEo subItemStorageDgEo = (ItemStorageDgEo)this.itemStorageDgDomain.selectByPrimaryKey(subItemStorageId);
                    long subItemBalance = subItemStorageDgEo.getBalance();
                    Map<String, Long> itemBundleNumMap = itemBundleRelationDgEoList.stream().filter(eo -> eo.getNum() != null && eo.getNum() > 0).collect(Collectors.toMap(eo -> eo.getItemId() + eo.getSkuId() + "", eo -> subItemBalance / (long)eo.getNum().intValue()));
                    bundleItemStorageDgEoList.forEach(bundleItemStorageEo -> {
                        Long oldBalance = bundleItemStorageEo.getBalance();
                        Long itemBundleNum = (Long)itemBundleNumMap.get(bundleItemStorageEo.getItemId() + bundleItemStorageEo.getSkuId() + "");
                        if (oldBalance > 0L && itemBundleNum != null && itemBundleNum < oldBalance) {
                            this.logger.info("\u7ec4\u5408\u5546\u54c1\u7684\u5e93\u5b58\u51cf\u5c11: shopId={}, bundleItemId={}, bundleSkuId={}", new Object[]{shopId, bundleItemStorageEo.getItemId(), bundleItemStorageEo.getSkuId()});
                            bundleItemStorageEo.setBalance(itemBundleNum);
                            this.itemStorageDgDomain.updateSelective((BaseEo)bundleItemStorageEo);
                        }
                    });
                } else {
                    bundleItemStorageDgEoList.forEach(bundleItemStorageEo -> {
                        this.logger.info("\u7ec4\u5408\u5546\u54c1\u7684\u5e93\u5b58\u589e\u52a0: shopId={}, bundleItemId={}, bundleSkuId={}", new Object[]{shopId, bundleItemStorageEo.getItemId(), bundleItemStorageEo.getSkuId()});
                        Long newBalance = this.itemStorageDgService.getBundleItemSkuStorage(bundleItemStorageEo.getShopId(), bundleItemStorageEo.getSkuId());
                        bundleItemStorageEo.setBalance(newBalance);
                        this.itemStorageDgDomain.updateSelective((BaseEo)bundleItemStorageEo);
                    });
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5b50\u5546\u54c1\u5bf9\u5e94\u7ec4\u5408\u5546\u54c1\u7684\u5e93\u5b58\u65f6\u5931\u8d25: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

