/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.mqc;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.item.dto.request.FreightItemEsDto;
import com.yunxi.dg.base.center.item.dto.request.ItemOffShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemOnShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.MarketSkuDto;
import com.yunxi.dg.base.center.item.service.entity.IItemShelfDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemSkuDgService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ITEM_FREIGHT_TAG")
public class ItemFreightConsumer
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(ItemFreightConsumer.class);
    @Resource
    private IItemSkuDgService itemSkuDgService;
    @Resource
    private IItemShelfDgService itemShelfDgService;

    public MessageResponse process(String message) {
        MessageResponse response;
        log.info("\u8fd0\u8d39\u5546\u54c1MQ:{}", (Object)message);
        try {
            long time = System.currentTimeMillis();
            FreightItemEsDto freightItemEsDto = (FreightItemEsDto)JSONObject.parseObject((String)message, FreightItemEsDto.class);
            if ("1".equals(freightItemEsDto.getType())) {
                MarketSkuDto marketSkuDto = (MarketSkuDto)JSONObject.parseObject((String)freightItemEsDto.getMessage(), MarketSkuDto.class);
                log.info("\u8fd0\u8d39\u5546\u54c1MQ\u4e0a\u5e02:{}", (Object)freightItemEsDto.getType());
                this.itemSkuDgService.batchOnMarketSku(marketSkuDto);
            } else if ("2".equals(freightItemEsDto.getType())) {
                ItemOnShelfDgReqDto itemOnShelfDgReqDto = (ItemOnShelfDgReqDto)JSONObject.parseObject((String)freightItemEsDto.getMessage(), ItemOnShelfDgReqDto.class);
                log.info("\u8fd0\u8d39\u5546\u54c1MQ\u4e0a\u67b6:{}", (Object)freightItemEsDto.getType());
                this.itemShelfDgService.batchOnShelfItem(itemOnShelfDgReqDto);
            } else {
                ItemOffShelfDgReqDto itemOffShelfDgReqDto = (ItemOffShelfDgReqDto)JSONObject.parseObject((String)freightItemEsDto.getMessage(), ItemOffShelfDgReqDto.class);
                log.info("\u8fd0\u8d39\u5546\u54c1MQ\u4e0b\u67b6:{}", (Object)freightItemEsDto.getType());
                this.itemShelfDgService.batchOffShelfItem(itemOffShelfDgReqDto);
            }
            log.info("end to item freight consume mq message:{},cost time:{} ms", (Object)JSONObject.toJSONString((Object)message), (Object)(System.currentTimeMillis() - time));
            response = MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            response = MessageResponse.ERROR;
            log.error(e.getMessage(), (Throwable)e);
        }
        return response;
    }
}

