/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.scheduler;

import cn.hutool.core.collection.CollUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class JobTaskInit
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(JobTaskInit.class);
    @Autowired
    private ITaskQueryApi taskQueryApiApi;
    @Autowired
    private ITaskApi taskApi;
    @Value(value="${scheduler.client.app_code:yunxi-dg-base-center-item}")
    private String appCode;
    private static final Long INSTANCEID = 1694195275012247553L;
    private static final Long TENANTID = 1L;

    public void run(ApplicationArguments args) throws Exception {
        log.info("======\u5f00\u59cb\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u521d\u59cb\u5316========");
        this.task1();
        this.task2();
        log.info("======\u7ed3\u675f\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u521d\u59cb\u5316========");
    }

    private void task1() {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setAppCode(this.appCode);
        taskQueryReqDto.setTaskName("shopSkuNewProductAddTagTask");
        PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApiApi.queryByPage(JacksonUtil.toJson((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(1)));
        if (taskQueryRespDtoPageInfo != null && CollUtil.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
            log.info("======\u5df2\u521b\u5efa\u8c03\u5ea6\u4efb\u52a11========");
            return;
        }
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode("shopSkuNewProductAddTagTask");
        dto.setBizName("\u65b0\u589e\u5e97\u94fasku\u65b0\u54c1\u6807\u7b7e\u4efb\u52a1");
        dto.setScheduleExpression("0 30 0 * * ?");
        dto.setShardType("SINGLE");
        dto.setTaskBatchId(null);
        dto.setTaskDesc("\u65b0\u589e\u5e97\u94fasku\u65b0\u54c1\u6807\u7b7e\u4efb\u52a1");
        dto.setTaskName("shopSkuNewProductAddTagTask");
        dto.setInstanceId(INSTANCEID);
        dto.setTenantId(TENANTID);
        RestResponse addResult = this.taskApi.addWithBiz(dto);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
    }

    private void task2() {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setAppCode(this.appCode);
        taskQueryReqDto.setTaskName("skuProductTagTask");
        PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApiApi.queryByPage(JacksonUtil.toJson((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(1)));
        if (taskQueryRespDtoPageInfo != null && CollUtil.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
            log.info("======\u5df2\u521b\u5efa\u8c03\u5ea6\u4efb\u52a12========");
            return;
        }
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode("skuProductTagTask");
        dto.setBizName("sku\u65b0\u54c1\u6807\u7b7e\u4efb\u52a1");
        dto.setScheduleExpression("0 10 0 * * ?");
        dto.setShardType("SINGLE");
        dto.setTaskBatchId(null);
        dto.setTaskDesc("sku\u65b0\u54c1\u6807\u7b7e\u4efb\u52a1");
        dto.setTaskName("skuProductTagTask");
        dto.setInstanceId(INSTANCEID);
        dto.setTenantId(TENANTID);
        RestResponse addResult = this.taskApi.addWithBiz(dto);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
    }
}

