/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.scheduler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.item.constants.ShelfTaskStatusDgEnum;
import com.yunxi.dg.base.center.item.constants.ShelfTaskTypeDgEnum;
import com.yunxi.dg.base.center.item.domain.entity.IShelfTaskDgDomain;
import com.yunxi.dg.base.center.item.dto.request.AllowOrderTimeDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.OffItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfTimeDetailDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfTimeDgReqDto;
import com.yunxi.dg.base.center.item.eo.ShelfTaskDgEo;
import com.yunxi.dg.base.center.item.service.entity.IItemShelfDgService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shelfDgTask")
@Scope(value="prototype")
public class ShelfDgTask
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(ShelfDgTask.class);
    @Resource
    private IItemShelfDgService itemShelfService;
    @Resource
    private IShelfTaskDgDomain shelfTaskDgDomain;

    public void before(TaskMsg taskMsg) {
        System.out.println("\u6267\u884c\u4efb\u52a1\u524d..");
    }

    public boolean execute(TaskMsg taskMsg) {
        block7: {
            logger.info("\u4efb\u52a1\u8c03\u5ea6\u6267\u884c\uff0c\u6267\u884c\u4e0a\u4e0b\u67b6\u5b9a\u5236\u4efb\u52a1\uff0c\u53c2\u6570:{}", (Object)taskMsg.getTaskId());
            Long taskId = taskMsg.getTaskId();
            ShelfTaskDgEo shelfTaskDgEo = ShelfTaskDgEo.newInstance();
            shelfTaskDgEo.setTaskId(taskId);
            try {
                ArrayList<ItemShelfDgReqDto> onShelfReqDtos = new ArrayList<ItemShelfDgReqDto>();
                ArrayList<OffItemDgReqDto> offItemDgReqDtos = new ArrayList<OffItemDgReqDto>();
                shelfTaskDgEo.setStatus(ShelfTaskStatusDgEnum.UNPROCESSED.getStatus());
                List shelfTaskDgEoList = this.shelfTaskDgDomain.selectList((BaseEo)shelfTaskDgEo);
                for (ShelfTaskDgEo eo : shelfTaskDgEoList) {
                    if (ShelfTaskTypeDgEnum.ON.getType().equals(eo.getType())) {
                        ItemShelfDgReqDto itemShelfDgReqDto = new ItemShelfDgReqDto();
                        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)itemShelfDgReqDto);
                        JSONObject jsonObject = JSON.parseObject((String)taskMsg.getContent());
                        if (jsonObject != null) {
                            itemShelfDgReqDto.setPrice(jsonObject.getBigDecimal("price"));
                            itemShelfDgReqDto.setPriceId(jsonObject.getLong("priceId"));
                        }
                        ShelfTimeDgReqDto shelfTimeDgReqDto = new ShelfTimeDgReqDto();
                        ArrayList<ShelfTimeDetailDgReqDto> shelfTimeDetailDgReqDtos = new ArrayList<ShelfTimeDetailDgReqDto>();
                        ShelfTimeDetailDgReqDto shelfTimeDetailDgReqDto = new ShelfTimeDetailDgReqDto();
                        List allowOrderTimeDgReqDtos = JSON.parseArray((String)eo.getAllowOrderTime(), AllowOrderTimeDgReqDto.class);
                        shelfTimeDetailDgReqDto.setOnShelfTime(eo.getShelfTime());
                        shelfTimeDetailDgReqDto.setAllowOrderTimeDgReqDtoList(allowOrderTimeDgReqDtos);
                        shelfTimeDetailDgReqDtos.add(shelfTimeDetailDgReqDto);
                        shelfTimeDgReqDto.setShelfTimeDetailDgReqDtoList(shelfTimeDetailDgReqDtos);
                        itemShelfDgReqDto.setShelfTimeDgReqDto(shelfTimeDgReqDto);
                        itemShelfDgReqDto.setTiming(false);
                        onShelfReqDtos.add(itemShelfDgReqDto);
                        continue;
                    }
                    if (!ShelfTaskTypeDgEnum.OFF.getType().equals(eo.getType())) continue;
                    OffItemDgReqDto offItemDgReqDto = new OffItemDgReqDto();
                    DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)offItemDgReqDto);
                    offItemDgReqDto.setOffTime(eo.getShelfTime());
                    offItemDgReqDtos.add(offItemDgReqDto);
                }
                if (CollectionUtils.isNotEmpty(onShelfReqDtos)) {
                    this.itemShelfService.onShelfOperation(onShelfReqDtos, false, taskId);
                }
                if (!CollectionUtils.isNotEmpty(offItemDgReqDtos)) break block7;
                this.itemShelfService.offShelfOperation(offItemDgReqDtos, false, taskId);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                List queryEos = this.shelfTaskDgDomain.selectList((BaseEo)shelfTaskDgEo);
                for (ShelfTaskDgEo eo : queryEos) {
                    eo.setStatus(ShelfTaskStatusDgEnum.FAIL.getStatus());
                    this.shelfTaskDgDomain.updateSelective((BaseEo)eo);
                }
            }
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        System.out.println("\u6267\u884c\u4efb\u52a1\u540e..");
    }
}

