/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.scheduler;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.data.dto.dto.DictDto;
import com.yunxi.dg.base.center.data.dto.dto.DictValueDto;
import com.yunxi.dg.base.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.item.domain.entity.ISkuMarketRefDgDomain;
import com.yunxi.dg.base.center.item.eo.SkuMarketRefDgEo;
import com.yunxi.dg.base.center.item.service.commons.ReportHelper;
import com.yunxi.dg.base.center.report.dto.entity.BizTagRecordDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shopSkuNewProductAddTagTask")
@Scope(value="prototype")
public class ShopSkuNewProductAddTagTask
extends AbstractSingleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(ShopSkuNewProductAddTagTask.class);
    @Resource
    private ISkuMarketRefDgDomain skuMarketRefDgDomain;
    @Resource
    private ReportHelper reportHelper;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;

    public void before(TaskMsg taskMsg) {
        log.info("\u65b0\u54c1\u6807\u7b7ejob\u4efb\u52a1\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        log.info("\u5f00\u59cb\u65b0\u54c1\u6807\u7b7e\u4efb\u52a1\u5f00\u59cb");
        try {
            DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("newProductTagDate", "yunxi-dg-base-center-item"));
            if (CollectionUtil.isEmpty((Collection)dictDto.getDictValueList())) {
                log.info("\u6570\u636e\u5b57\u5178\u6ca1\u6709\u914d\u7f6e");
                return Boolean.TRUE;
            }
            List dictValueList = dictDto.getDictValueList();
            String value = ((DictValueDto)dictValueList.get(0)).getValue();
            LocalDate localDate = LocalDate.now().minusDays(Long.valueOf(value));
            log.info("\u65b0\u54c1\u6253\u6807\u7b7e\u65e5\u671f:{}", (Object)localDate);
            List skuMarketRefDgEoList = this.skuMarketRefDgDomain.queryByLeMarketDate(localDate + " 00:00:00", LocalDate.now() + " 23:59:59");
            List BizTagRecordDtos = this.reportHelper.getShopSkuTag(null, null, "New_product", true);
            List<Object> skuMarketRefDgEos = Lists.newArrayList();
            List<Object> bizTagRecordIds = Lists.newArrayList();
            if (CollectionUtil.isNotEmpty((Collection)skuMarketRefDgEoList)) {
                HashSet skuIdList = Sets.newHashSet();
                HashSet shopIdList = Sets.newHashSet();
                for (SkuMarketRefDgEo skuMarketRefDgEo : skuMarketRefDgEoList) {
                    skuIdList.add(skuMarketRefDgEo.getSkuId());
                    shopIdList.add(skuMarketRefDgEo.getShopId());
                }
                Map skuMarketRefDgEoMap = skuMarketRefDgEoList.stream().collect(Collectors.toMap(s -> s.getSkuId() + "_" + s.getShopId(), Function.identity(), (v1, v2) -> v1));
                if (CollectionUtil.isNotEmpty((Collection)BizTagRecordDtos)) {
                    Map BizTagRecordDtoMap = BizTagRecordDtos.stream().filter(b -> Objects.nonNull(b.getRecordLinkParentId())).collect(Collectors.toMap(b -> b.getRecordLinkId() + "_" + b.getRecordLinkParentId(), Function.identity(), (v1, v2) -> v1));
                    HashMap differenceMap1 = Maps.newHashMap();
                    for (Map.Entry entry : skuMarketRefDgEoMap.entrySet()) {
                        String string = entry.getKey();
                        if (BizTagRecordDtoMap.containsKey(string)) continue;
                        differenceMap1.put(string, entry.getValue());
                    }
                    skuMarketRefDgEos = differenceMap1.values().stream().collect(Collectors.toList());
                    HashMap differenceMap2 = Maps.newHashMap();
                    for (Map.Entry entry : BizTagRecordDtoMap.entrySet()) {
                        String key = (String)entry.getKey();
                        if (skuMarketRefDgEoMap.containsKey(key)) continue;
                        differenceMap2.put(key, entry.getValue());
                    }
                    List BizTagRecordDtoList = differenceMap2.values().stream().collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(BizTagRecordDtoList)) {
                        for (BizTagRecordDto BizTagRecordDto2 : BizTagRecordDtoList) {
                            bizTagRecordIds.add(BizTagRecordDto2.getId());
                        }
                    }
                } else {
                    skuMarketRefDgEos.addAll(skuMarketRefDgEoList);
                }
            } else {
                bizTagRecordIds = BizTagRecordDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
            }
            this.reportHelper.addOrDeleteShopTag((List)bizTagRecordIds, (List)skuMarketRefDgEos, SkuMarketRefDgEo::getSkuId, SkuMarketRefDgEo::getShopId, "New_product");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u81ea\u52a8\u6253\u65b0\u54c1\u6807\u7b7e\u4efb\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return Boolean.TRUE;
    }

    public void after(TaskMsg taskMsg) {
        log.info("\u65b0\u54c1\u6807\u7b7ejob\u4efb\u52a1\u7ed3\u675f");
    }
}

