/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.aop;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.yunxi.dg.base.center.item.plugin.EnableCachePlugin;
import com.yunxi.dg.base.center.item.service.util.SerializeDgUtils;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Aspect
@Order(value=5)
@RefreshScope
public class CacheEnableAspect {
    private static Logger logger = LoggerFactory.getLogger(CacheEnableAspect.class);
    @Value(value="${point.cache.plugin.open:true}")
    private Boolean cachePluginOpen;
    @Resource
    private ICacheService cacheService;

    @Pointcut(value="@annotation(com.yunxi.dg.base.center.item.plugin.EnableCachePlugin)")
    private void annotationAop() {
    }

    @Around(value="annotationAop()")
    public Object controllerAround(ProceedingJoinPoint point) throws Throwable {
        Object response = null;
        if (!this.cachePluginOpen.booleanValue()) {
            logger.debug("\u4e0d\u542f\u7528\u7f13\u5b58\uff0c\u76f4\u63a5\u8df3\u8fc7\u2026\u2026");
            return point.proceed();
        }
        try {
            String className = point.getTarget().getClass().getName();
            Signature signature = point.getSignature();
            MethodSignature methodSignature = (MethodSignature)signature;
            Method targetMethod = methodSignature.getMethod();
            Method realMethod = point.getTarget().getClass().getDeclaredMethod(signature.getName(), targetMethod.getParameterTypes());
            Class<?> returnType = realMethod.getReturnType();
            EnableCachePlugin annotation = realMethod.getAnnotation(EnableCachePlugin.class);
            response = annotation.disabled() ? point.proceed() : this.handleProceed(className, returnType, realMethod, point, annotation, methodSignature.getParameterNames());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    private Object handleProceed(String targetClass, Class returnType, Method realMethod, ProceedingJoinPoint point, EnableCachePlugin annotation, String[] parameterNames) throws Throwable {
        Object response = null;
        String beforeKey = realMethod.getName() + "->" + JSON.toJSONString((Object)parameterNames) + ":" + JSON.toJSONString((Object)point.getArgs());
        String field = CacheEnableAspect.md5(beforeKey);
        String key = this.getKey(annotation.entityClass());
        String fullKey = targetClass + "_" + realMethod.getName() + "_" + key + "_";
        try {
            response = this.getDeserializeData(fullKey, field, returnType);
        }
        catch (Exception e) {
            response = null;
        }
        if (null == response && null != (response = point.proceed())) {
            try {
                Integer expireTime = annotation.expireTime();
                this.cacheService.hset(fullKey, field, this.getSerializeData(response), expireTime.intValue());
                this.relativeList(fullKey, annotation.entityClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return response;
    }

    private static String md5(String s) throws Exception {
        char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        byte[] btInput = s.getBytes("UTF-8");
        MessageDigest mdInst = MessageDigest.getInstance("MD5");
        mdInst.update(btInput);
        byte[] md = mdInst.digest();
        int j = md.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = md[i];
            str[k++] = hexdigits[byte0 >>> 4 & 0xF];
            str[k++] = hexdigits[byte0 & 0xF];
        }
        return new String(str);
    }

    private void relativeList(String key, Class<?>[] entityClass) throws Exception {
        for (Class<?> clazz : entityClass) {
            this.cacheService.zadd(clazz.getName() + "_", Long.valueOf(0L), key);
        }
    }

    private Object getDeserializeData(String key, String filed, Class returnType) {
        String dataKey = "data";
        Map temp = (Map)this.cacheService.hget(key, filed, Map.class);
        if (null != temp && temp.containsKey(dataKey) && null != temp.get(dataKey)) {
            String data = temp.get(dataKey).toString();
            return SerializeDgUtils.deserialize(data, returnType);
        }
        return null;
    }

    private Map<String, Object> getSerializeData(Object object) {
        String serializeData = SerializeDgUtils.serialize(object, object.getClass());
        HashMap<String, Object> data = new HashMap<String, Object>(1);
        data.put("data", serializeData);
        return data;
    }

    private String getKey(Class<?>[] entityClass) throws Exception {
        StringBuilder key = new StringBuilder();
        for (Class<?> clazz : entityClass) {
            key.append(clazz.getName()).append("_");
        }
        return CacheEnableAspect.md5(key.toString());
    }
}

