/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.event.localEvent;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.item.constants.ItemDgItemAttributeEnum;
import com.yunxi.dg.base.center.item.dto.entity.ItemVersionDgDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemVersionDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.SkuBomMqDto;
import com.yunxi.dg.base.center.item.event.localEvent.ItemVersionMqEvent;
import com.yunxi.dg.base.center.item.service.entity.IItemSkuDgService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class ItemVersionListener {
    private static final Logger log = LoggerFactory.getLogger(ItemVersionListener.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IItemSkuDgService itemSkuDgService;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={ItemVersionMqEvent.class})
    public void itemVersionPush(ItemVersionMqEvent itemVersionMqEvent) {
        try {
            List<ItemVersionDgDto> itemVersionDgDtoList = itemVersionMqEvent.getItemVersionDgDtoList();
            if (CollectionUtil.isEmpty(itemVersionDgDtoList)) {
                log.info("itemVersionDgDtoList is null");
                return;
            }
            ArrayList detailRespDtoList = Lists.newArrayList();
            DgItemSkuDetailRespDto itemSkuDetailRespDto = this.itemSkuDgService.getItemSkuDetailById(itemVersionDgDtoList.get(0).getSkuId());
            Map versionDgRespDtoMap = itemSkuDetailRespDto.getVersionDgReqDtos().stream().collect(Collectors.toMap(ItemVersionDgRespDto::getId, Function.identity(), (v1, v2) -> v1));
            ArrayList versionDgRespDtoList = Lists.newArrayList();
            for (ItemVersionDgDto itemVersionDgDto : itemVersionDgDtoList) {
                if (!ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PRODUCT.getType().equals(itemSkuDetailRespDto.getItemAttribute()) || !versionDgRespDtoMap.containsKey(itemVersionDgDto.getId())) continue;
                ItemVersionDgRespDto itemVersionDgRespDto = (ItemVersionDgRespDto)versionDgRespDtoMap.get(itemVersionDgDto.getId());
                versionDgRespDtoList.add(itemVersionDgRespDto);
            }
            itemSkuDetailRespDto.setVersionDgReqDtos((List)versionDgRespDtoList);
            detailRespDtoList.add(itemSkuDetailRespDto);
            if (CollectionUtil.isNotEmpty((Collection)detailRespDtoList)) {
                SkuBomMqDto skuBomMqDto = new SkuBomMqDto();
                skuBomMqDto.setDgItemSkuDetailRespDtoList((List)detailRespDtoList);
                skuBomMqDto.setEventType("add");
                log.info("\u53d1\u9001bom\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)skuBomMqDto));
                MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("ITEM_SKU_BOM_CHANGE_TAG", (Object)JSONObject.toJSONString((Object)skuBomMqDto));
                log.info("bomMQ\u72b6\u6001\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)messageResponse));
            }
        }
        catch (Exception e) {
            log.info("Bom\u65b0\u589e\u4e8b\u4ef6\u76d1\u542c\u5f02\u5e38:{}", (Throwable)e);
        }
    }
}

