/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.event.localEvent;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.item.dto.ItemShopMessageDto;
import com.yunxi.dg.base.center.item.event.localEvent.SendItemShopMqEvent;
import java.time.LocalTime;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class SendItemShopMqListener {
    private static final Logger log = LoggerFactory.getLogger(SendItemShopMqListener.class);
    @Resource
    private ICommonsMqService commonsMqService;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={SendItemShopMqEvent.class})
    public void sendItemSkuMq(SendItemShopMqEvent shopMqEvent) {
        log.info("\u76d1\u542c\u5e97\u94fa\u5546\u54c1\u4fe1\u606f\u53d8\u66f4\u4e8b\u4ef6  time: " + LocalTime.now());
        String reqId = RequestId.createReqId();
        ItemShopMessageDto itemShopMessageDto = new ItemShopMessageDto();
        itemShopMessageDto.setReqId(reqId);
        itemShopMessageDto.setItemShopIds(shopMqEvent.getItemShopIdList());
        itemShopMessageDto.setEventType(shopMqEvent.getEventType());
        itemShopMessageDto.setExecuteTime(new Date());
        log.info("\u53d1\u9001\u5e97\u94fa\u5546\u54c1\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)itemShopMessageDto));
        MessageResponse messageResponse = this.commonsMqService.publishMessage("ITEM_ITEM_SHOP_CHANGE_TAG", (Object)JSON.toJSONString((Object)itemShopMessageDto));
        log.info("\u53d1\u9001\u5e97\u94fa\u5546\u54c1\u6d88\u606f==>messageResponse====>:{}", (Object)JSON.toJSONString((Object)messageResponse));
    }
}

