/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.event.localEvent;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.center.item.common.enums.ItemSkuOperationTypeEnum;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfDgDomain;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfDgEo;
import com.yunxi.dg.base.center.item.event.localEvent.SendItemSkuMqEvent;
import com.yunxi.dg.base.center.item.service.commons.ReportHelper;
import com.yunxi.dg.base.center.report.dto.entity.BizTagRecordDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class SendItemSkuMqListener {
    private static final Logger log = LoggerFactory.getLogger(SendItemSkuMqListener.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IShelfDgDomain shelfDgDomain;
    @Resource
    private ReportHelper reportHelper;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={SendItemSkuMqEvent.class})
    public void sendItemSkuMq(SendItemSkuMqEvent itemSkuMqEvent) {
        List itemSkuDgEos;
        log.info("\u76d1\u542c\u5546\u54c1sku\u4fe1\u606f\u53d8\u66f4\u4e8b\u4ef6\u6d88\u8d39\u6267\u884c  time: " + LocalTime.now());
        List<Long> skuIdList = itemSkuMqEvent.getSkuIdList();
        if (CollectionUtil.isNotEmpty(skuIdList) && CollectionUtil.isNotEmpty((Collection)(itemSkuDgEos = this.itemSkuDgDomain.selectItemSkuByIds(skuIdList)))) {
            for (ItemSkuDgEo itemSkuDgEo : itemSkuDgEos) {
                log.info("\u76d1\u542c\u5546\u54c1sku\u4fe1\u606f\u53d8\u66f4\u4e8b\u4ef6 " + itemSkuDgEo.getId() + " time: " + LocalTime.now());
                itemSkuDgEo.setExtension(itemSkuMqEvent.getOperationType().getCode());
                this.commonsMqService.sendSingleMessage("ITEM_UPDATE_CHANGE_LOG_TAG_DG", (Object)JacksonUtil.toJson((Object)itemSkuDgEo));
            }
            try {
                this.setItemTag(itemSkuMqEvent, itemSkuDgEos, skuIdList);
            }
            catch (Exception e) {
                log.info("\u6253\u6807\u7b7e\u5f02\u5e38:{}", (Throwable)e);
            }
        }
    }

    private void setItemTag(SendItemSkuMqEvent itemSkuMqEvent, List<ItemSkuDgEo> itemSkuDgEos, List<Long> skuIdList) {
        if (ItemSkuOperationTypeEnum.UPDATE.equals((Object)itemSkuMqEvent.getOperationType())) {
            this.setShopSkuTag(itemSkuDgEos, skuIdList);
            this.setSkuTag(itemSkuDgEos, skuIdList);
        }
    }

    private void setShopSkuTag(List<ItemSkuDgEo> itemSkuDgEos, List<Long> skuIdList) {
        List shelfDgEoList = ((ExtQueryChainWrapper)this.shelfDgDomain.filter().in((Object)"sku_id", skuIdList)).list();
        Map skuDgEoMap = itemSkuDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v1));
        if (CollectionUtil.isNotEmpty((Collection)shelfDgEoList)) {
            ArrayList skuIds = Lists.newArrayList();
            ArrayList shopIds = Lists.newArrayList();
            for (ShelfDgEo shelfDgEo : shelfDgEoList) {
                skuIds.add(shelfDgEo.getSkuId());
                shopIds.add(shelfDgEo.getShopId());
            }
            List<BizTagRecordDto> skuShopTagRecordEoList = this.reportHelper.getShopSkuTag(skuIds, shopIds, "Obsolete_product", true);
            ArrayList skuShopTagRecordIds = Lists.newArrayList();
            ArrayList addShopSkuTagList = Lists.newArrayList();
            for (ShelfDgEo shelfDgEo : shelfDgEoList) {
                if (!skuDgEoMap.containsKey(shelfDgEo.getSkuId())) continue;
                if (YesNoEnum.YES.getValue().equals(((ItemSkuDgEo)skuDgEoMap.get(shelfDgEo.getSkuId())).getEliminate())) {
                    if (CollectionUtil.isNotEmpty(skuShopTagRecordEoList)) {
                        Map bizTagRecordDtoMap = skuShopTagRecordEoList.stream().collect(Collectors.toMap(s -> this.getKey(s.getRecordLinkParentId(), s.getRecordLinkId()), Function.identity(), (v1, v2) -> v1));
                        if (!bizTagRecordDtoMap.containsKey(this.getKey(shelfDgEo.getShopId(), shelfDgEo.getSkuId()))) {
                            addShopSkuTagList.add(shelfDgEo);
                        }
                    } else {
                        addShopSkuTagList.add(shelfDgEo);
                    }
                }
                if (!YesNoEnum.NO.getValue().equals(((ItemSkuDgEo)skuDgEoMap.get(shelfDgEo.getSkuId())).getEliminate()) || !CollectionUtil.isNotEmpty(skuShopTagRecordEoList)) continue;
                Set tagIds = skuShopTagRecordEoList.stream().map(BaseDto::getId).collect(Collectors.toSet());
                skuShopTagRecordIds.addAll(tagIds);
            }
            this.reportHelper.addOrDeleteShopTag(skuShopTagRecordIds, addShopSkuTagList, ShelfDgEo::getSkuId, ShelfDgEo::getShopId, "Obsolete_product");
        }
    }

    private String getKey(Long shopId, Long skuId) {
        return shopId + "_" + skuId;
    }

    private void setSkuTag(List<ItemSkuDgEo> itemSkuDgEos, List<Long> skuIdList) {
        ArrayList skuTagRecordIds = Lists.newArrayList();
        ArrayList addSkuTagList = Lists.newArrayList();
        List<BizTagRecordDto> skuShopTagRecordEoList = this.reportHelper.getShopSkuTag(skuIdList, null, "Obsolete_product", false);
        for (ItemSkuDgEo skuDgEo : itemSkuDgEos) {
            if (YesNoEnum.YES.getValue().equals(skuDgEo.getEliminate())) {
                if (CollectionUtil.isNotEmpty(skuShopTagRecordEoList)) {
                    Map tagRecordDtoMap = skuShopTagRecordEoList.stream().collect(Collectors.toMap(BizTagRecordDto::getRecordLinkId, Function.identity(), (v1, v2) -> v1));
                    if (!tagRecordDtoMap.containsKey(skuDgEo.getId())) {
                        addSkuTagList.add(skuDgEo);
                    }
                } else {
                    addSkuTagList.add(skuDgEo);
                }
            }
            if (!YesNoEnum.NO.getValue().equals(skuDgEo.getEliminate()) || !CollectionUtil.isNotEmpty(skuShopTagRecordEoList)) continue;
            Set tagRecordIds = skuShopTagRecordEoList.stream().map(BaseDto::getId).collect(Collectors.toSet());
            skuTagRecordIds.addAll(tagRecordIds);
        }
        this.reportHelper.addOrDeleteShopTag(skuTagRecordIds, addSkuTagList, BaseEo::getId, null, "Obsolete_product");
    }
}

