/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.apiImpl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.yunxi.dg.base.center.item.api.directory.IDirectoryDgApi;
import com.yunxi.dg.base.center.item.dao.das.DirPropRelationDgDas;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.dto.request.BatchAddDirectoryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ChildrenDirDgDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.CommanderInfoMqDgDto;
import com.yunxi.dg.base.center.item.dto.request.DirSpecificationGroupDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirectoryCreateDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirectoryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirectorySortUpdateDgDto;
import com.yunxi.dg.base.center.item.dto.request.MergeDirectoryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.PropGroupDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.RootDirectoryDgReqDto;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.eo.DirIndexDgEo;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.cache.ClearDirectoryDgCache;
import com.yunxi.dg.base.center.item.service.entity.IDirPropRelationDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemShelfDgService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DirectoryDgApiImpl
implements IDirectoryDgApi {
    @Resource
    private IDirectoryItemDgService directoryItemDgService;
    @Resource
    private IDirectoryDgService directoryDgService;
    @Resource
    private IItemShelfDgService itemShelfDgService;
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private DirPropRelationDgDas dirPropRelationDgDas;
    @Resource
    private IDirPropRelationDgService dirPropRelationDgService;
    @Resource
    private ClearDirectoryDgCache clearDirectoryDgCache;

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addDirectory(DirectoryDgReqDto directoryDgReqDto) {
        if (Objects.nonNull(directoryDgReqDto) && Objects.isNull(directoryDgReqDto.getCode())) {
            throw new BizException("\u6839\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DirDgEo directoryItemEo = DirDgEo.newInstance((Map)directoryDgReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)directoryDgReqDto, (BaseEo)directoryItemEo);
        directoryItemEo.setAttrs(directoryDgReqDto.getAttrs());
        directoryItemEo.setFrontRelationBack(directoryDgReqDto.getFrontRelationBack());
        this.directoryItemDgService.saveDirectoryItem(directoryItemEo, directoryDgReqDto.getLinks());
        this.addDirPropGroup(directoryItemEo.getId(), directoryDgReqDto.getPropGroupIds());
        this.dirPropRelationDgService.addRDirSpecification(directoryDgReqDto.getGroupIdList(), directoryItemEo.getId());
        this.clearDirectoryDgCache.clearDirTree();
        return new RestResponse((Object)directoryItemEo.getId());
    }

    public RestResponse<Void> batchImportAddDirectory(BatchAddDirectoryDgReqDto reqDto) {
        this.directoryDgService.batchImportAddDirectory(reqDto.getDirectoryDgReqDtos(), reqDto.getDirUsage());
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> addDirList(List<DirectoryCreateDgReqDto> directoryCreateDgReqDtos) {
        if (CollectionUtils.isEmpty(directoryCreateDgReqDtos)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        for (DirectoryCreateDgReqDto dto : directoryCreateDgReqDtos) {
            RootDirectoryDgReqDto rootDir = dto.getRootDir();
            if (rootDir == null) {
                throw new ItemBusinessRuntimeException("\u6839\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Long rootId = (Long)this.addRootDirectory(rootDir).getData();
            List childrenDirs = dto.getChildrenDirs();
            this.addChildrenDir(childrenDirs, rootId, rootId);
        }
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    private void addChildrenDir(List<ChildrenDirDgDgReqDto> childrenDirs, Long rootId, Long parentId) {
        if (!CollectionUtils.isEmpty(childrenDirs)) {
            for (ChildrenDirDgDgReqDto childrenDir : childrenDirs) {
                childrenDir.setRootId(rootId);
                childrenDir.setParentId(parentId);
                Long subParentId = (Long)this.addDirectory((DirectoryDgReqDto)childrenDir).getData();
                if (CollectionUtils.isEmpty((Collection)childrenDir.getChildrenDirs())) continue;
                this.addChildrenDir(childrenDir.getChildrenDirs(), rootId, subParentId);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> removeDirectory(Long dirId) {
        int i = this.itemShelfDgService.countByDirId(null, null, dirId);
        if (i > 0) {
            throw new ItemBusinessRuntimeException("10200", "\u6b64\u76ee\u5f55\u5b58\u5728\u5546\u54c1\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        ItemDgEo itemDgEoParam = ItemDgEo.newInstance();
        itemDgEoParam.setDirId(dirId);
        itemDgEoParam.setDr(0);
        int count = this.itemDgDomain.count((BaseEo)itemDgEoParam);
        if (count > 0) {
            throw new BizException("\u7c7b\u76ee\u88ab\u5546\u54c1\u5f15\u7528, \u65e0\u6cd5\u5220\u9664");
        }
        this.directoryItemDgService.deleteDirectoryItem(dirId);
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> modifyDirectory(DirectoryDgReqDto directoryDgReqDto) {
        if (directoryDgReqDto == null && Objects.isNull(directoryDgReqDto.getId())) {
            throw new BizException("\u7c7b\u76eeid\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        AssertUtils.notNull((Object)directoryDgReqDto, (String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)directoryDgReqDto.getId(), (String)"\u7c7b\u76eeid\u4e0d\u53ef\u4e3a\u7a7a!");
        DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectById((Serializable)directoryDgReqDto.getId());
        AssertUtils.notNull((Object)dirDgEo, (String)"\u7c7b\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728!");
        DirDgEo directoryItemEo = DirDgEo.newInstance((Map)directoryDgReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)directoryDgReqDto, (BaseEo)directoryItemEo);
        directoryItemEo.setFrontRelationBack(directoryDgReqDto.getFrontRelationBack());
        this.directoryItemDgService.updateDirectoryItem(directoryItemEo, directoryDgReqDto.getLinks());
        this.addDirPropGroup(directoryItemEo.getId(), directoryDgReqDto.getPropGroupIds());
        this.dirPropRelationDgService.addRDirSpecification(directoryDgReqDto.getGroupIdList(), directoryDgReqDto.getId());
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyDirStatus(Long id, Integer status) {
        DirDgEo directoryItemEo = DirDgEo.newInstance();
        directoryItemEo.setId(id);
        directoryItemEo.setStatus(status);
        this.directoryItemDgService.updateDirectoryItem(directoryItemEo, null);
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addRootDirectory(RootDirectoryDgReqDto dirReqDto) {
        if (Objects.nonNull(dirReqDto) && Objects.isNull(dirReqDto.getCode())) {
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String timeStampStr = simpleDateFormat.format(date);
            dirReqDto.setCode(timeStampStr);
        }
        DirIndexDgEo directoryEo = DirIndexDgEo.newInstance((Map)dirReqDto.getExtFields());
        dirReqDto.setId(null);
        DtoHelper.dto2Eo((BaseVo)dirReqDto, (BaseEo)directoryEo);
        Long rootId = dirReqDto.getLink();
        if (null == rootId) {
            DirDgEo dirDgEo = DirDgEo.newInstance();
            dirDgEo.setName(dirReqDto.getName());
            dirDgEo.setCode(dirReqDto.getCode());
            dirDgEo.setAttrs(dirReqDto.getAttrs());
            dirDgEo.setExtension(dirReqDto.getExtension());
            dirDgEo.setInstanceId(dirReqDto.getInstanceId());
            dirDgEo.setTenantId(dirReqDto.getTenantId());
            dirDgEo.setStatus(dirReqDto.getStatus());
            dirDgEo.setLogoUrl(dirReqDto.getLogoUrl());
            dirDgEo.setDescription(dirReqDto.getDescription());
            this.directoryItemDgService.saveDirectoryItem(dirDgEo, null);
            rootId = dirDgEo.getId();
        } else {
            DirDgEo directoryItemEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(rootId);
            if (directoryItemEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.LINK_NOT_EXISTS);
            }
        }
        directoryEo.setRootId(rootId);
        this.directoryDgService.saveDirectory(directoryEo);
        this.clearDirectoryDgCache.clearDirTree();
        return new RestResponse((Object)rootId);
    }

    public RestResponse<Void> removeRootDirectory(Long id) {
        if (id == null) {
            throw new ItemBusinessRuntimeException("\u76ee\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.directoryDgService.removeDirIndex(id);
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeRootDirectoryByRootId(Long rootId) {
        if (rootId == null) {
            throw new ItemBusinessRuntimeException("\u76ee\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.directoryDgService.removeDirIndexByRootId(rootId);
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<String> initShopDir(List<CommanderInfoMqDgDto> shopList) {
        return new RestResponse((Object)this.directoryDgService.initShopDir(shopList));
    }

    public RestResponse<Void> modifyRootDirectory(RootDirectoryDgReqDto directoryReqDto) {
        if (directoryReqDto == null) {
            throw new ItemBusinessRuntimeException("\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DirIndexDgEo directoryEo = DirIndexDgEo.newInstance((Map)directoryReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)directoryReqDto, (BaseEo)directoryEo);
        directoryEo.setRootId(directoryReqDto.getLink());
        this.directoryDgService.modifyDirectory(directoryEo);
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> mergeDirectory(MergeDirectoryDgReqDto reqDto) {
        this.directoryItemDgService.mergeDir(reqDto.getTargetDirId(), reqDto.getSourceDirId());
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> initDirTree() {
        this.directoryItemDgService.initTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> sortDirectory(Long id, DirectorySortUpdateDgDto directorySortUpdateDgDto) {
        this.directoryItemDgService.sortDirectory(id, directorySortUpdateDgDto);
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> compatSortDirectory(@NotNull(message="\u76ee\u5f55ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @NotNull(message="\u76ee\u5f55ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") Long id, DirectorySortUpdateDgDto directorySortUpdateDgDto) {
        this.directoryItemDgService.compatSortDirectory(id, directorySortUpdateDgDto);
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> sortDirectory(DirectorySortUpdateDgDto directorySortUpdateDgDto) {
        this.directoryItemDgService.sortDirectory(directorySortUpdateDgDto);
        this.clearDirectoryDgCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> saveDirPropGroup(Long dirId, List<PropGroupDgReqDto> propGroupDgReqDtos) {
        this.dirPropRelationDgService.saveDirPropGroup(dirId, propGroupDgReqDtos);
        return new RestResponse();
    }

    public RestResponse<Void> addDirPropGroup(Long dirId, List<Long> propGroupIds) {
        this.dirPropRelationDgService.deleteDirPropRelation(Arrays.asList(dirId));
        if (CollectionUtil.isNotEmpty(propGroupIds)) {
            HashSet<Long> propGroupIdsSet = new HashSet<Long>(propGroupIds);
            this.dirPropRelationDgService.addDirPropGroup(dirId, propGroupIdsSet);
        }
        return new RestResponse();
    }

    public RestResponse<Void> addDirSpecificationGroup(DirSpecificationGroupDgReqDto reqDto) {
        this.dirPropRelationDgService.addDirSpecificationGroup(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeDirSpecificationGroup(DirSpecificationGroupDgReqDto reqDto) {
        this.dirPropRelationDgService.removeDirSpecificationGroup(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateDirPropGroupUsage(Long dirId, Long propGroupId, Integer usage) {
        this.dirPropRelationDgService.updateDirPropGroupUsage(dirId, propGroupId, usage);
        return new RestResponse();
    }

    public RestResponse<Void> removeDirPropGroup(Long dirId, List<Long> propGroupIds) {
        HashSet<Long> set = new HashSet<Long>(propGroupIds);
        this.dirPropRelationDgService.removeDirPropGroup(dirId, set);
        return new RestResponse();
    }

    public RestResponse<Void> updateDirPropGroupSort(Long dirId, Long propGroupId, String action) {
        this.dirPropRelationDgService.updateDirPropGroupSort(dirId, propGroupId, action);
        return new RestResponse();
    }

    public RestResponse<Void> copyDirPropGroup(Long sourceDirId, Long targetDirId) {
        this.dirPropRelationDgService.copyDirPropGroup(sourceDirId, targetDirId);
        return new RestResponse();
    }
}

