/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.apiImpl.query;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.api.directory.IDirectoryDgQueryApi;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IFrontShopRelationBackDgDomain;
import com.yunxi.dg.base.center.item.dto.request.DirectoryDgFilterReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirectoryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.DirectoryQueryParentReqDto;
import com.yunxi.dg.base.center.item.dto.response.DirParentRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirPropRelationMapRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirSpecificationRelationMapRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemLevelDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemListDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.PropGroupDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.PropNameDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.PropValueDgDto;
import com.yunxi.dg.base.center.item.dto.response.SpecificationGroupDetailRespDto;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.eo.FrontShopRelationBackDgEo;
import com.yunxi.dg.base.center.item.service.entity.IDirDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirPropRelationDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryItemDgService;
import com.yunxi.dg.base.center.item.service.util.QueryParamDgUtils;
import com.yunxi.dg.base.center.prop.api.prop.IPropQueryDgApi;
import com.yunxi.dg.base.center.prop.dto.Schemas.PropGroupRespDto;
import com.yunxi.dg.base.center.prop.dto.Schemas.PropNameRespDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.stereotype.Service;

@Service
public class DirectoryDgQueryApiImpl
implements IDirectoryDgQueryApi {
    @Resource
    private IDirectoryItemDgService directoryItemDgService;
    @Resource
    private IDirectoryDgService directoryDgService;
    @Resource
    private IDirPropRelationDgService dirPropRelationDgService;
    @Resource
    private IDirDgService dirDgService;
    @Resource
    private IPropQueryDgApi propQueryDgApi;
    @Resource
    private IFrontShopRelationBackDgDomain frontShopRelationBackDgDomian;
    @Resource
    private IDirDgDomain dirDgDomain;

    public RestResponse<PageInfo<DirectoryItemListDgRespDto>> queryDirectoryItem(DirectoryDgReqDto directoryDgReqDto) {
        PageInfo respDto = new PageInfo();
        DirDgEo dirDgEo = DirDgEo.newInstance((Map)directoryDgReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)directoryDgReqDto, (BaseEo)dirDgEo);
        QueryParamDgUtils.columnLike((BaseEo)dirDgEo, "name", dirDgEo.getName());
        Integer pageNum = Objects.nonNull(directoryDgReqDto.getPageNum()) ? directoryDgReqDto.getPageNum() : 1;
        Integer pageSize = Objects.nonNull(directoryDgReqDto.getPageSize()) ? directoryDgReqDto.getPageSize() : 10;
        PageInfo<DirDgEo> dirDgEoPageInfo = this.directoryItemDgService.queryDirectoryByPage(dirDgEo, pageNum, pageSize);
        if (CollectionUtil.isEmpty((Collection)dirDgEoPageInfo.getList())) {
            return new RestResponse((Object)respDto);
        }
        CubeBeanUtils.copyProperties((Object)respDto, dirDgEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList directoryItemRepsDtoList = new ArrayList();
        Object dirMap = new HashedMap();
        Object frontRelationMap = new HashedMap();
        Map<Object, Object> backMap = new HashMap();
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DirDgEo dgEo : dirDgEoPageInfo.getList()) {
            parentIds.add(dgEo.getParentId());
            ids.add(dgEo.getId());
        }
        List frontShopEo = ((ExtQueryChainWrapper)this.frontShopRelationBackDgDomian.filter().in((Object)"front_shop_id", ids)).list();
        if (CollectionUtil.isNotEmpty((Collection)frontShopEo)) {
            List<Long> backIds = frontShopEo.stream().map(FrontShopRelationBackDgEo::getBackId).collect(Collectors.toList());
            frontRelationMap = frontShopEo.stream().collect(Collectors.groupingBy(FrontShopRelationBackDgEo::getFrontShopId));
            List<DirDgEo> backDirDgEos = this.directoryItemDgService.queryByIds(backIds);
            backMap = backDirDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
        }
        List<DirDgEo> dirDgEos = this.directoryItemDgService.queryByIds(parentIds);
        dirMap = dirDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
        DtoHelper.eoList2DtoList((Collection)dirDgEoPageInfo.getList(), directoryItemRepsDtoList, DirectoryItemListDgRespDto.class);
        for (DirectoryItemListDgRespDto directoryDto : directoryItemRepsDtoList) {
            List frontShopRelationBackDgEos;
            DirDgEo dgEo = (DirDgEo)dirMap.get(directoryDto.getParentId());
            if (Objects.nonNull(dgEo)) {
                directoryDto.setParentCode(dgEo.getCode());
                directoryDto.setParentName(dgEo.getName());
            }
            if (!CollectionUtil.isNotEmpty((Collection)(frontShopRelationBackDgEos = (List)frontRelationMap.get(directoryDto.getId())))) continue;
            String backName = "";
            for (FrontShopRelationBackDgEo frontShopRelationBackDgEo : frontShopRelationBackDgEos) {
                DirDgEo backEo = (DirDgEo)backMap.get(frontShopRelationBackDgEo.getBackId());
                if (!Objects.nonNull(backEo)) continue;
                backName = backName.length() > 0 ? backName + "," + backEo.getName() : backName + backEo.getName();
            }
            directoryDto.setFrontRelationBack(backName);
        }
        respDto.setList(directoryItemRepsDtoList);
        return new RestResponse((Object)respDto);
    }

    public RestResponse<DirectoryItemDgRespDto> queryDirById(Long id) {
        return new RestResponse((Object)this.directoryItemDgService.queryById(id, true));
    }

    public RestResponse<List<DirectoryItemDgRespDto>> queryDirByIds(List<Long> dirIdList) {
        return new RestResponse(this.directoryDgService.queryByIds(dirIdList, null));
    }

    public RestResponse<List<DirPropRelationMapRespDto>> queryPropGroupListByDirIds(List<Long> dirIds) {
        return new RestResponse(this.dirPropRelationDgService.queryPropGroupListByDirIds(dirIds));
    }

    public RestResponse<List<DirSpecificationRelationMapRespDto>> querySpecificationGroupByDirIds(List<Long> dirIds) {
        return new RestResponse(this.dirPropRelationDgService.querySpecificationGroupByDirIds(dirIds));
    }

    public RestResponse<DirectoryItemDgRespDto> queryBaseInfo(Long id) {
        return new RestResponse((Object)this.directoryItemDgService.queryById(id, false));
    }

    public RestResponse<DirectoryItemDgRespDto> queryDetailInfoByCode(String code, Integer usage) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DirDgEo::getCode, (Object)code);
        wrapper.eq(BaseEo::getDr, (Object)0);
        DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.getMapper().selectOne((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)dirDgEo)) {
            return this.queryDetailInfo(dirDgEo.getId(), usage);
        }
        return null;
    }

    public RestResponse<DirectoryItemDgRespDto> queryDetailInfo(Long id, Integer usage) {
        DirectoryItemDgRespDto directoryItemDgRespDto = this.directoryItemDgService.queryById(id, false);
        if (Objects.isNull(directoryItemDgRespDto)) {
            return null;
        }
        List<Long> propGroupDgIdList = this.dirPropRelationDgService.queryPropGroupIdsByDirId(id, usage);
        List propGroupRespDtos = (List)this.propQueryDgApi.groupBatchGetAndCommonByIds(propGroupDgIdList).getData();
        if (CollectionUtil.isNotEmpty((Collection)propGroupRespDtos)) {
            ArrayList propGroupDgRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(propGroupDgRespDtos, (Collection)propGroupRespDtos, PropGroupDgRespDto.class);
            for (int i = 0; i < propGroupDgRespDtos.size(); ++i) {
                ArrayList propNameDgRespDtos = new ArrayList();
                List propNameRespDtos = ((PropGroupRespDto)propGroupRespDtos.get(i)).getPropNameRespDtos();
                CubeBeanUtils.copyCollection(propNameDgRespDtos, (Collection)propNameRespDtos, PropNameDgRespDto.class);
                for (int j = 0; j < propNameDgRespDtos.size(); ++j) {
                    List propValueList = ((PropNameRespDto)propNameRespDtos.get(j)).getPropValueList();
                    if (!CollectionUtil.isNotEmpty((Collection)propValueList)) continue;
                    ArrayList valueList = new ArrayList();
                    CubeBeanUtils.copyCollection(valueList, (Collection)propValueList, PropValueDgDto.class);
                    ((PropNameDgRespDto)propNameDgRespDtos.get(j)).setPropValueList(valueList);
                }
                ((PropGroupDgRespDto)propGroupDgRespDtos.get(i)).setPropNameDgRespDtos(propNameDgRespDtos);
            }
            directoryItemDgRespDto.setPropGroup(propGroupDgRespDtos);
        }
        List<SpecificationGroupDetailRespDto> groupDetailRespDtos = this.dirPropRelationDgService.querySpecificationGroupByDirId(directoryItemDgRespDto.getId());
        directoryItemDgRespDto.setSpecificationGroupDetailRespDtos(groupDetailRespDtos);
        return new RestResponse((Object)directoryItemDgRespDto);
    }

    public RestResponse<List<DirectoryItemDgRespDto>> queryShopDirList(Long itemId, Long shopId, Integer busType, String dirType) {
        return new RestResponse(this.directoryItemDgService.queryShopDirList(itemId, shopId, busType, dirType));
    }

    public RestResponse<List<Long>> queryListDirById(Long id, String dirUsage) {
        return new RestResponse(this.directoryItemDgService.queryListDirById(id, dirUsage));
    }

    public RestResponse<List<Long>> queryFontDirIdsByBackId(Long id, String dirUsage, Long shopId) {
        return new RestResponse(this.directoryItemDgService.queryFontDirIdsByBackId(id, dirUsage, shopId));
    }

    public RestResponse<List<Long>> selectBackNameById(Long id) {
        return new RestResponse(this.directoryItemDgService.selectBackNameById(id));
    }

    public RestResponse<List<DirectoryItemLevelDgRespDto>> queryLevels(List<Long> ids) {
        ArrayList<DirectoryItemLevelDgRespDto> levelDgRespDtos = new ArrayList<DirectoryItemLevelDgRespDto>();
        List dirDgEos = ((ExtQueryChainWrapper)this.dirDgDomain.filter().in((Object)"id", ids)).list();
        if (CollectionUtil.isEmpty((Collection)dirDgEos)) {
            return new RestResponse(levelDgRespDtos);
        }
        for (DirDgEo dirDgEo : dirDgEos) {
            DirectoryItemLevelDgRespDto levelDgRespDto = new DirectoryItemLevelDgRespDto();
            int level = 0;
            if (Objects.nonNull(dirDgEo.getIndexPath())) {
                String[] fruits = dirDgEo.getIndexPath().split(",");
                level = fruits.length - 1;
            }
            levelDgRespDto.setLevel(Integer.valueOf(level));
            levelDgRespDto.setId(dirDgEo.getId());
            levelDgRespDtos.add(levelDgRespDto);
        }
        return new RestResponse(levelDgRespDtos);
    }

    public RestResponse<List<Long>> queryLinkAndChildDirIdListByDirId(DirectoryDgReqDto directoryDgReqDto) {
        if (CollUtil.isEmpty((Collection)directoryDgReqDto.getIds())) {
            return new RestResponse((Object)ListUtil.empty());
        }
        List<Long> dirIdList = this.dirDgService.queryLinkAndChildDirIdListByDirId(directoryDgReqDto);
        dirIdList.addAll(directoryDgReqDto.getIds());
        return new RestResponse(new HashSet<Long>(dirIdList).stream().collect(Collectors.toList()));
    }

    public RestResponse<List<DirectoryItemDgRespDto>> queryDirByFilter(List<String> filter, Integer type, String dirUsage) {
        return new RestResponse(this.directoryItemDgService.queryDirByFilter(filter, type, dirUsage));
    }

    public RestResponse<List<DirectoryItemDgRespDto>> queryDirListByCondition(DirectoryDgFilterReqDto reqDto) {
        return new RestResponse(this.directoryItemDgService.queryDirListByCondition(reqDto));
    }

    public RestResponse<List<DirParentRespDto>> queryParentDir(DirectoryQueryParentReqDto reqDto) {
        return new RestResponse(this.directoryItemDgService.queryParentDir(reqDto));
    }
}

