/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.domain.entity.IBrandDgDomain;
import com.yunxi.dg.base.center.item.dto.sync.DgSyncBrandDto;
import com.yunxi.dg.base.center.item.eo.BrandDgEo;
import com.yunxi.dg.base.center.item.service.entity.impl.adapter.AbstractDgSyncBrandServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dgIDgSyncBrandService")
public class DgSyncBrandServiceImpl
extends AbstractDgSyncBrandServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(DgSyncBrandServiceImpl.class);
    @Resource
    private IBrandDgDomain brandDgDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncBrand(DgSyncBrandDto syncBrandDto) {
        super.syncBrand(syncBrandDto);
        List brandDgEoList = this.brandDgDomain.queryBrandByCodeList((Collection)Lists.newArrayList((Object[])new String[]{syncBrandDto.getCode()}));
        if (CollectionUtil.isNotEmpty((Collection)brandDgEoList)) {
            BrandDgEo brandDgEo = (BrandDgEo)brandDgEoList.get(0);
            BeanUtil.copyProperties((Object)syncBrandDto, (Object)brandDgEo, (String[])new String[]{"id"});
            this.brandDgDomain.update((BaseEo)brandDgEo);
        } else {
            BrandDgEo brandDgEo = new BrandDgEo();
            BeanUtil.copyProperties((Object)syncBrandDto, (Object)brandDgEo, (String[])new String[0]);
            this.brandDgDomain.insert((BaseEo)brandDgEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncBrandBatch(List<DgSyncBrandDto> syncBrandDtoList) {
        super.syncBrandBatch(syncBrandDtoList);
        List codeList = syncBrandDtoList.stream().map(DgSyncBrandDto::getCode).collect(Collectors.toList());
        List brandDgEoList = this.brandDgDomain.queryBrandByCodeList(codeList);
        Map syncUnitDtoMap = brandDgEoList.stream().collect(Collectors.toMap(BrandDgEo::getCode, Function.identity(), (oldValue, newValue) -> newValue));
        ArrayList notExistList = Lists.newArrayList();
        ArrayList existList = Lists.newArrayList();
        syncBrandDtoList.forEach(syncDirDto -> {
            if (!syncUnitDtoMap.containsKey(syncDirDto.getCode())) {
                notExistList.add(syncDirDto);
            } else {
                existList.add(syncDirDto);
            }
        });
        if (CollectionUtil.isNotEmpty((Collection)notExistList)) {
            List brandDgEos = BeanUtil.copyToList((Collection)notExistList, BrandDgEo.class);
            this.brandDgDomain.insertBatch(brandDgEos);
        }
        if (CollectionUtil.isNotEmpty((Collection)existList)) {
            for (DgSyncBrandDto dgSyncBrandDto : existList) {
                BrandDgEo brandDgEo = (BrandDgEo)syncUnitDtoMap.get(dgSyncBrandDto.getCode());
                BeanUtil.copyProperties((Object)dgSyncBrandDto, (Object)brandDgEo, (String[])new String[]{"id"});
                this.brandDgDomain.updateSelective((BaseEo)brandDgEo);
            }
        }
    }
}

