/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.dto.sync.DgSyncDirDto;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.service.entity.impl.adapter.AbstractDgSyncDirServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dgIDgSyncDirService")
public class DgSyncDirServiceImpl
extends AbstractDgSyncDirServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(DgSyncDirServiceImpl.class);
    @Resource
    private IDirDgDomain dirDgDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncDir(DgSyncDirDto syncDirDto) {
        super.syncDir(syncDirDto);
        List dirDgEoList = this.dirDgDomain.queryDirByCodeList((Collection)Lists.newArrayList((Object[])new String[]{syncDirDto.getCode()}));
        if (CollectionUtil.isNotEmpty((Collection)dirDgEoList)) {
            DirDgEo dirDgEo = (DirDgEo)dirDgEoList.get(0);
            BeanUtil.copyProperties((Object)syncDirDto, (Object)dirDgEo, (String[])new String[]{"id"});
            this.dirDgDomain.update((BaseEo)dirDgEo);
        } else {
            DirDgEo dirDgEo = new DirDgEo();
            BeanUtil.copyProperties((Object)syncDirDto, (Object)dirDgEo, (String[])new String[0]);
            this.dirDgDomain.insert((BaseEo)dirDgEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncDirBatch(List<DgSyncDirDto> syncDirDtoList) {
        super.syncDirBatch(syncDirDtoList);
        List codeList = syncDirDtoList.stream().map(DgSyncDirDto::getCode).collect(Collectors.toList());
        List dirDgEoList = this.dirDgDomain.queryDirByCodeList(codeList);
        Map syncUnitDtoMap = dirDgEoList.stream().collect(Collectors.toMap(DirDgEo::getCode, Function.identity(), (oldValue, newValue) -> newValue));
        ArrayList notExistList = Lists.newArrayList();
        ArrayList existList = Lists.newArrayList();
        syncDirDtoList.forEach(syncDirDto -> {
            if (!syncUnitDtoMap.containsKey(syncDirDto.getCode())) {
                notExistList.add(syncDirDto);
            } else {
                existList.add(syncDirDto);
            }
        });
        if (CollectionUtil.isNotEmpty((Collection)notExistList)) {
            List unitDgEos = BeanUtil.copyToList((Collection)notExistList, DirDgEo.class);
            this.dirDgDomain.insertBatch(unitDgEos);
        }
        if (CollectionUtil.isNotEmpty((Collection)existList)) {
            for (DgSyncDirDto dgSyncDirDto : existList) {
                DirDgEo unitDgEo = (DirDgEo)syncUnitDtoMap.get(dgSyncDirDto.getCode());
                BeanUtil.copyProperties((Object)dgSyncDirDto, (Object)unitDgEo, (String[])new String[]{"id"});
                this.dirDgDomain.updateSelective((BaseEo)unitDgEo);
            }
        }
    }
}

