/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.dto.request.DirectoryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DirRespDto;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.plugin.EnableCachePlugin;
import com.yunxi.dg.base.center.item.service.entity.IDirDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryItemDgService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dirDgService")
public class DirDgServiceImpl
implements IDirDgService {
    private static Logger logger = LoggerFactory.getLogger(DirDgServiceImpl.class);
    @Autowired
    private IDirDgDomain dirDgDomain;
    @Autowired
    private IDirectoryItemDgService directoryItemDgService;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;

    @Override
    public List<Long> getChildDirIdList(List<Long> dirIdList, Long instanceId, Long tenantId) {
        return this.queryChildDirIdList(dirIdList, instanceId, tenantId);
    }

    @Override
    @EnableCachePlugin(expireTime=15)
    public List<Long> getLinkAndChildDirIdList(List<Long> dirIdList, Long instanceId, Long tenantId) {
        logger.info("\u67e5\u8be2link\u76ee\u5f55\u53ca\u5b50\u76ee\u5f55ID\u96c6\u5408...");
        dirIdList = this.directoryItemDgService.convertLinkDir(dirIdList, instanceId, tenantId);
        dirIdList = this.getChildDirIdList(dirIdList, instanceId, tenantId);
        return dirIdList;
    }

    @Override
    @EnableCachePlugin(expireTime=15)
    public List<Long> queryLinkAndChildDirIdListByDirId(DirectoryDgReqDto directoryDgReqDto) {
        ArrayList<Long> dirIds = new ArrayList<Long>();
        if (CollUtil.isNotEmpty((Collection)directoryDgReqDto.getIds())) {
            this.setSubDirIdList(dirIds, directoryDgReqDto.getIds(), directoryDgReqDto);
        }
        dirIds.addAll(directoryDgReqDto.getIds());
        return new HashSet<Long>(dirIds).stream().collect(Collectors.toList());
    }

    @Override
    public Map<Long, List<DirDgEo>> getParentByChildDriIds(List<Long> dirIdList) {
        HashMap<Long, List<DirDgEo>> map = new HashMap<Long, List<DirDgEo>>();
        if (CollectionUtil.isEmpty(dirIdList)) {
            return map;
        }
        List<DirDgEo> dirDgEoList = this.getParentByIds(dirIdList);
        if (CollectionUtil.isEmpty(dirDgEoList)) {
            return map;
        }
        Map dirMap = dirDgEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
        for (Long dirId : dirIdList) {
            String[] fruits;
            ArrayList<DirDgEo> dirList = new ArrayList<DirDgEo>();
            DirDgEo dirDgEo = (DirDgEo)dirMap.get(dirId);
            if (Objects.isNull(dirDgEo) || Objects.isNull(dirDgEo.getIndexPath())) continue;
            for (String fruit : fruits = dirDgEo.getIndexPath().split(",")) {
                DirDgEo eo;
                if (!StrUtil.isNumeric((CharSequence)fruit) || !Objects.nonNull(eo = (DirDgEo)dirMap.get(Long.valueOf(fruit)))) continue;
                dirList.add(eo);
            }
            map.put(dirDgEo.getId(), dirList);
        }
        return map;
    }

    @Override
    public Map<String, DirRespDto> queryLastDirBySkuCodes(List<String> skuCodes) {
        HashMap<String, DirRespDto> map = new HashMap<String, DirRespDto>();
        if (CollectionUtils.isEmpty(skuCodes)) {
            return map;
        }
        List skuDgEos = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in((Object)"code", skuCodes)).list();
        if (CollectionUtils.isEmpty((Collection)skuDgEos)) {
            return map;
        }
        HashSet ids = new HashSet();
        HashMap lastDirIdMap = new HashMap();
        skuDgEos.forEach(e -> {
            Long id = null;
            if (Objects.nonNull(e.getDirId3())) {
                id = e.getDirId3();
            }
            if (Objects.isNull(id) && Objects.nonNull(e.getDirId2())) {
                id = e.getDirId2();
            }
            if (Objects.isNull(id) && Objects.nonNull(e.getDirId())) {
                id = e.getDirId();
            }
            ids.add(id);
            List skuCodeList = Optional.ofNullable(lastDirIdMap.get(id)).orElse(new ArrayList());
            skuCodeList.add(e.getCode());
            lastDirIdMap.put(id, skuCodeList);
        });
        List itDirEos = ((ExtQueryChainWrapper)this.dirDgDomain.filter().in((Object)"id", ids)).list();
        if (CollectionUtils.isNotEmpty((Collection)itDirEos)) {
            itDirEos.forEach(e -> {
                List skuCodeList = (List)lastDirIdMap.get(e.getId());
                if (CollectionUtils.isNotEmpty((Collection)skuCodeList)) {
                    DirRespDto dto = new DirRespDto();
                    CubeBeanUtils.copyProperties((Object)dto, (Object)e, (String[])new String[0]);
                    skuCodeList.forEach(skuCode -> map.put((String)skuCode, dto));
                }
            });
        }
        return map;
    }

    @Override
    public List<String> querySkuCodeListByDirList(List<Long> dirList) {
        List<String> skuCodeList = new ArrayList<String>();
        if (CollectionUtils.isEmpty(dirList)) {
            return skuCodeList;
        }
        List skuDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in((Object)"dir_id", dirList)).or()).in((Object)"dir_id2", dirList)).or()).in((Object)"dir_id3", dirList)).list();
        if (CollectionUtils.isNotEmpty((Collection)skuDgEos)) {
            skuCodeList = skuDgEos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCode())).map(e -> e.getCode()).distinct().collect(Collectors.toList());
        }
        return skuCodeList;
    }

    private List<DirDgEo> getParentByIds(List<Long> dirIdList) {
        ArrayList<DirDgEo> dirDgEoList = new ArrayList<DirDgEo>();
        List dirDgEos = this.dirDgDomain.selectByIds(dirIdList);
        if (CollectionUtil.isEmpty((Collection)dirDgEos)) {
            return dirDgEoList;
        }
        HashSet<Long> ids = new HashSet<Long>(dirIdList);
        for (DirDgEo dirDgEo : dirDgEos) {
            String[] indexPathList;
            if (Objects.isNull(dirDgEo.getIndexPath())) continue;
            for (String indexPath : indexPathList = dirDgEo.getIndexPath().split(",")) {
                if (!StrUtil.isNumeric((CharSequence)indexPath)) continue;
                ids.add(Long.valueOf(indexPath));
            }
        }
        return this.dirDgDomain.selectByIds(new ArrayList<Long>(ids));
    }

    private void setSubDirIdList(List<Long> dirIds, List<Long> dirIdList, DirectoryDgReqDto directoryDgReqDto) {
        DirDgEo dirDgEo = new DirDgEo();
        dirDgEo.setDr(0);
        dirDgEo.setInstanceId(directoryDgReqDto.getInstanceId());
        dirDgEo.setTenantId(directoryDgReqDto.getTenantId());
        dirDgEo.setStatus(directoryDgReqDto.getStatus());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)dirDgEo);
        queryWrapper.in(DirDgEo::getParentId, dirIdList);
        List dirDgEos = this.dirDgDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)dirDgEos)) {
            return;
        }
        List indexPaths = dirDgEos.stream().map(DirDgEo::getIndexPath).collect(Collectors.toList());
        List dirDgEoList = this.dirDgDomain.selectChildByIndexPaths(indexPaths);
        List subDirIds = dirDgEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        dirIds.addAll(subDirIds);
    }

    @Override
    public List<Long> queryChildDirIdList(List<Long> dirIdList, Long instanceId, Long tenantId) {
        ArrayList<Long> childDirIdList = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(dirIdList)) {
            return childDirIdList;
        }
        List dirDgEos = this.dirDgDomain.selectByIds(dirIdList);
        if (CollectionUtils.isEmpty((Collection)dirDgEos)) {
            return childDirIdList;
        }
        List childIds = dirDgEos.stream().map(BaseEo::getId).map(String::valueOf).collect(Collectors.toList());
        logger.info("\u5f97\u5230\u4e0b\u4e00\u7ea7\u7684\u6240\u6709\u7c7b\u76ee(\u5305\u542b\u81ea\u5df1){}", childIds);
        List dirDgEoList = this.dirDgDomain.selectChildByIndexPaths(childIds);
        if (CollectionUtil.isNotEmpty((Collection)dirDgEoList)) {
            childDirIdList.addAll(dirDgEoList.stream().map(DirDgEo::getParentId).collect(Collectors.toList()));
        }
        return childDirIdList;
    }
}

