/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.item.domain.entity.IDirItemAttributesRelationDgDomain;
import com.yunxi.dg.base.center.item.eo.DirItemAttributesRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemAttributesDgEo;
import com.yunxi.dg.base.center.item.service.entity.IDirItemAttributesDgService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class DirItemAttributesDgServiceImpl
implements IDirItemAttributesDgService {
    @Resource
    private IDirItemAttributesRelationDgDomain dirItemAttributesRelationDgDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSearchAttrsAttributes(Long dirId, List<ItemAttributesDgEo> attributesList) {
        List<DirItemAttributesRelationDgEo> itemAttributesEos = this.transToItemAttributesList(attributesList);
        ArrayList<DirItemAttributesRelationDgEo> insertItemAttributes = new ArrayList<DirItemAttributesRelationDgEo>();
        for (DirItemAttributesRelationDgEo dirItemAttributesEo : itemAttributesEos) {
            dirItemAttributesEo.setDirId(dirId);
            List itemAttributes = this.dirItemAttributesRelationDgDomain.selectList((BaseEo)dirItemAttributesEo);
            if (itemAttributes != null && itemAttributes.size() > 0) continue;
            insertItemAttributes.add(dirItemAttributesEo);
        }
        if (CollectionUtils.isNotEmpty(insertItemAttributes = DirItemAttributesDgServiceImpl.removeDirItemAttributes(insertItemAttributes))) {
            this.dirItemAttributesRelationDgDomain.insertBatch(insertItemAttributes);
        }
    }

    private List<DirItemAttributesRelationDgEo> transToItemAttributesList(List<ItemAttributesDgEo> attributesList) {
        ArrayList<DirItemAttributesRelationDgEo> resultAttributes = new ArrayList<DirItemAttributesRelationDgEo>();
        for (ItemAttributesDgEo itemAttributesDgEo : attributesList) {
            String searchAttrs = itemAttributesDgEo.getSearchAttrs();
            if (StringUtils.isEmpty((Object)searchAttrs)) continue;
            Map map = (Map)JSON.parseObject((String)searchAttrs, Map.class);
            Set entrys = map.entrySet();
            for (Map.Entry entry : entrys) {
                DirItemAttributesRelationDgEo dirItemAttributesEo = DirItemAttributesRelationDgEo.newInstance();
                dirItemAttributesEo.setPropName((String)entry.getKey());
                dirItemAttributesEo.setPropValue((String)entry.getValue());
                resultAttributes.add(dirItemAttributesEo);
            }
        }
        return resultAttributes;
    }

    private static ArrayList<DirItemAttributesRelationDgEo> removeDirItemAttributes(List<DirItemAttributesRelationDgEo> attrList) {
        TreeSet<DirItemAttributesRelationDgEo> s = new TreeSet<DirItemAttributesRelationDgEo>((o1, o2) -> {
            String uniqueString1 = o1.getPropName() + ":" + o1.getPropValue() + ":" + o1.getDirId();
            String uniqueString2 = o2.getPropName() + ":" + o2.getPropValue() + ":" + o2.getDirId();
            return uniqueString1.compareTo(uniqueString2);
        });
        s.addAll(attrList);
        return new ArrayList<DirItemAttributesRelationDgEo>(s);
    }
}

