/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.domain.entity.IItemAttributesDgDomain;
import com.yunxi.dg.base.center.item.dto.response.ItemAttributesDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemAttributesDgEo;
import com.yunxi.dg.base.center.item.service.entity.IItemAttributesDgService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="itemAttributesDgService")
public class ItemAttributesDgServiceImpl
implements IItemAttributesDgService {
    @Resource
    private IItemAttributesDgDomain itemAttributesDgDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int addPropBatch(List<ItemAttributesDgEo> itemAttributesDgEos) {
        return this.itemAttributesDgDomain.insertBatch(itemAttributesDgEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addProp(ItemAttributesDgEo itemAttributesDgEo) {
        this.itemAttributesDgDomain.insert((BaseEo)itemAttributesDgEo);
        return itemAttributesDgEo.getId();
    }

    @Override
    public void removeById(Long id) {
        this.itemAttributesDgDomain.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByItemId(Long itemId) {
        ItemAttributesDgEo itemAttributesDgEo = ItemAttributesDgEo.newInstance();
        itemAttributesDgEo.setItemId(itemId);
        this.itemAttributesDgDomain.logicDelete((BaseEo)itemAttributesDgEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBySkuId(Long skuId) {
        ItemAttributesDgEo itemAttributesDgEo = ItemAttributesDgEo.newInstance();
        itemAttributesDgEo.setSkuId(skuId);
        this.itemAttributesDgDomain.logicDelete((BaseEo)itemAttributesDgEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int removeByIds(List<ItemAttributesDgEo> itemAttributesDgEos) {
        List ids = itemAttributesDgEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        return this.itemAttributesDgDomain.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyProp(ItemAttributesDgEo itemAttributesDgEo) {
        this.itemAttributesDgDomain.updateSelective((BaseEo)itemAttributesDgEo);
    }

    @Override
    public ItemAttributesDgEo queryById(Long id) {
        return (ItemAttributesDgEo)this.itemAttributesDgDomain.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<ItemAttributesDgEo> queryByPage(ItemAttributesDgEo itemAttributesDgEo, Integer pageNum, Integer pageSize) {
        return this.itemAttributesDgDomain.selectPage((BaseEo)itemAttributesDgEo, pageNum, pageSize);
    }

    @Override
    public List<ItemAttributesDgEo> queryByItemIds(List<Long> itemIds) {
        return this.itemAttributesDgDomain.selectByItemIds(itemIds);
    }

    @Override
    public List<ItemAttributesDgEo> queryByList(ItemAttributesDgEo itemAttributesDgEo) {
        return this.itemAttributesDgDomain.selectList((BaseEo)itemAttributesDgEo);
    }

    @Override
    @Cacheable(value={"ITEM_ATTR_CACHE"}, key="#itemId", unless="#result== null")
    public List<ItemAttributesDgRespDto> queryByItemId(Long itemId) {
        List itemAttributesDgEoList = this.itemAttributesDgDomain.selectByItemIds((List)Lists.newArrayList((Object[])new Long[]{itemId}));
        ArrayList itemAttributesDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemAttributesDgEoList, (Collection)itemAttributesDtoList, ItemAttributesDgRespDto.class);
        return itemAttributesDtoList;
    }

    @Override
    public List<ItemAttributesDgRespDto> queryItemAttrByItemIdList(List<Long> itemIdList) {
        if (CollectionUtils.isEmpty(itemIdList)) {
            return Lists.newArrayList();
        }
        ItemAttributesDgEo itemAttributesDgEo = new ItemAttributesDgEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"item_id", itemIdList));
        itemAttributesDgEo.setSqlFilters((List)sqlFilters);
        List itemAttributesDgEos = this.itemAttributesDgDomain.selectList((BaseEo)itemAttributesDgEo);
        ArrayList itemAttributesDgRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemAttributesDgRespDtos, (Collection)itemAttributesDgEos, ItemAttributesDgRespDto.class);
        return itemAttributesDgRespDtos;
    }
}

