/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ValidateException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.item.common.constant.ItemStatus;
import com.yunxi.dg.base.center.item.constants.DrDgEnum;
import com.yunxi.dg.base.center.item.constants.ItemBusTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.ItemDgStatus;
import com.yunxi.dg.base.center.item.constants.ItemDgStatusEnum;
import com.yunxi.dg.base.center.item.constants.ItemTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.ShelfStatusDgEnum;
import com.yunxi.dg.base.center.item.constants.ShelfTaskStatusDgEnum;
import com.yunxi.dg.base.center.item.constants.ShelfTaskTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.ShelfTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.SkuItemMarketStatusEnum;
import com.yunxi.dg.base.center.item.domain.entity.IDirDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IDirItemRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemShopDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfPointsDeductionDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfTaskDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.ISkuMarketRefDgDomain;
import com.yunxi.dg.base.center.item.dto.ShelfItemDgDto;
import com.yunxi.dg.base.center.item.dto.request.AllowOrderTimeDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemCycleBuyDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemOffShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemOnShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemOnShelfReqListDgDto;
import com.yunxi.dg.base.center.item.dto.request.ItemShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.OffItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.OffShelfItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.PointsDeductionDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfIntegralAddDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfIntegralModifyDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfItemInfoDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfModifyShopAuthDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfTaskUpdateDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfTimeDetailDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.ItemStorageQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfIntegralDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ShelfQueryDgRespDto;
import com.yunxi.dg.base.center.item.eo.DirDgEo;
import com.yunxi.dg.base.center.item.eo.DirItemRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemAttributesDgEo;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfPointsDeductionDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfTaskDgEo;
import com.yunxi.dg.base.center.item.eo.SkuMarketRefDgEo;
import com.yunxi.dg.base.center.item.event.ItemShelfDgProducer;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IDirItemAttributesDgService;
import com.yunxi.dg.base.center.item.service.entity.IDirectoryItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IDistributionSetDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemAttributesDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemCycleBuyDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemSearchDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemShelfDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemSkuDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemStorageDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfIntegralDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfSchedulerDgService;
import com.yunxi.dg.base.center.item.service.util.ItemStorageDgUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ItemShelfDgServiceImpl
implements IItemShelfDgService {
    private static Logger logger = LoggerFactory.getLogger(ItemShelfDgServiceImpl.class);
    @Resource
    private IDirItemRelationDgDomain dirItemRelationDgDomain;
    @Resource
    private IItemAttributesDgService itemAttributesDgService;
    @Resource
    private IDirItemAttributesDgService dirItemAttributesDgService;
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private IShelfDgService shelfDgService;
    @Resource
    private IDirectoryItemDgService directoryItemDgService;
    @Resource
    private IShelfDgDomain shelfDgDomain;
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private IShelfSchedulerDgService shelfSchedulerDgService;
    @Resource
    private IShelfTaskDgDomain shelfTaskDgDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IItemSkuDgService itemSkuDgService;
    @Autowired(required=false)
    private IShelfIntegralDgService shelfIntegralDgService;
    @Resource
    private IItemShopDgDomain itemShopDgDomain;
    @Resource
    private ItemStorageDgUtils itemStorageDgUtils;
    @Resource
    private IItemBundleRelationDgDomain itemBundleRelationDgDomain;
    @Resource
    private IItemSearchDgService itemSearchDgService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IShelfPointsDeductionDgDomain shelfPointsDeductionDgDomain;
    @Resource
    private IItemStorageDgService itemStorageDgService;
    @Autowired(required=false)
    private IDistributionSetDgService distributionSetDgService;
    @Autowired(required=false)
    private IItemCycleBuyDgService itemCycleBuyDgService;
    @Resource
    private ItemShelfDgProducer itemShelfDgProducer;
    @Resource
    private ISkuMarketRefDgDomain skuMarketRefDgDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void onShelfItem(List<ItemShelfDgReqDto> itemShelfDgReqDtoList) {
        ArrayList<ItemShelfDgReqDto> onShelfDtos = new ArrayList<ItemShelfDgReqDto>();
        for (ItemShelfDgReqDto itemShelfDgReqDto : itemShelfDgReqDtoList) {
            if (itemShelfDgReqDto.getTiming()) {
                this.autoShelfProcess(itemShelfDgReqDto);
                continue;
            }
            ShelfItemDgDto shelfItemDgDto = new ShelfItemDgDto();
            CubeBeanUtils.copyProperties((Object)shelfItemDgDto, (Object)itemShelfDgReqDto, (String[])new String[0]);
            this.updateShelfTaskStatus(shelfItemDgDto, ShelfTaskStatusDgEnum.UNPROCESSED.getStatus(), ShelfTaskTypeDgEnum.ON.getType(), ShelfTaskStatusDgEnum.CANCEL.getStatus());
            onShelfDtos.add(itemShelfDgReqDto);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(onShelfDtos)) {
            this.onShelfOperation(onShelfDtos, true, null);
        }
    }

    @Override
    public void onShelfItemList(ItemOnShelfReqListDgDto itemOnShelfReqListDgDto) {
        List itemShelfDgReqDtoList = itemOnShelfReqListDgDto.getItemShelfDgReqDtos();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemShelfDgReqDtoList)) {
            List itemIds = itemShelfDgReqDtoList.stream().map(ItemShelfDgReqDto::getItemId).collect(Collectors.toList());
            List itemDgEos = this.itemDgDomain.selectByIds(itemIds);
            AssertUtils.notEmpty((Collection)itemDgEos, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            Map dgEoMap = itemDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
            itemShelfDgReqDtoList.forEach(itemShelfDgReqDto -> {
                ItemDgEo itemDgEo = (ItemDgEo)dgEoMap.get(itemShelfDgReqDto.getItemId());
                AssertUtils.notNull((Object)itemDgEo, (String)(itemShelfDgReqDto.getItemId() + "\u5546\u54c1\u4e0d\u5b58\u5728"));
                itemShelfDgReqDto.setItemType(itemDgEo.getType());
                if (itemShelfDgReqDto.getType() == null) {
                    itemShelfDgReqDto.setType(ShelfTypeDgEnum.NORMAL.getType());
                }
            });
            this.onShelfItem(itemShelfDgReqDtoList);
            if (null != this.itemCycleBuyDgService) {
                List cycleBuyReqDtoList = itemOnShelfReqListDgDto.getCycleBuyReqDtos();
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)cycleBuyReqDtoList)) {
                    itemShelfDgReqDtoList.forEach(shelfItem -> this.itemCycleBuyDgService.removeCycleBuyByShopItem(shelfItem.getShopId(), shelfItem.getItemId()));
                } else {
                    cycleBuyReqDtoList.forEach(itemCycleBuyDgReqDto -> this.itemCycleBuyDgService.removeCycleBuyByShopItem(itemCycleBuyDgReqDto.getShopId(), itemCycleBuyDgReqDto.getItemId()));
                    cycleBuyReqDtoList.forEach(buyReqDto -> this.itemCycleBuyDgService.addItemCycleBuy((ItemCycleBuyDgReqDto)buyReqDto));
                }
            }
            this.itemDgDomain.updateStatusByIds(itemIds, ItemStatus.ON_LINE.getStatus());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void onShelfOperation(List<ItemShelfDgReqDto> onShelfDtoList, boolean isManual, Long taskId) {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u4e0a\u67b6\u64cd\u4f5c: {}", (Object)JSON.toJSONString(onShelfDtoList));
        ArrayList shelfDirItems = Lists.newArrayList();
        List<DirItemRelationDgEo> dirsItemsEos = onShelfDtoList.stream().map(dto -> {
            DirItemRelationDgEo dirItemRelationDgEo = DirItemRelationDgEo.newInstance();
            if (dto.getShelfTimeDgReqDto() == null) {
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)dirItemRelationDgEo);
            } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty(this.getAllowOrderTime((ItemShelfDgReqDto)dto))) {
                dirItemRelationDgEo.setAllowOrderTime(this.Date2JsonString(this.getAllowOrderTime((ItemShelfDgReqDto)dto), "yyyy-MM-dd HH:mm:ss"));
            }
            return dirItemRelationDgEo;
        }).collect(Collectors.toList());
        if (dirsItemsEos.stream().anyMatch(dto -> dto.getDirId() != null)) {
            logger.info("\u4fdd\u5b58\u4e0a\u67b6\u5546\u54c1\u548c\u76ee\u5f55\u5173\u7cfb");
            this.verifyDirItems(dirsItemsEos);
            dirsItemsEos = this.removeReply(dirsItemsEos);
            HashSet itemIds = new HashSet();
            HashSet dirIds = new HashSet();
            HashSet skuIds = new HashSet();
            dirsItemsEos.forEach(dirItem -> {
                itemIds.add(dirItem.getItemId());
                dirIds.add(dirItem.getDirId());
                skuIds.add(dirItem.getSkuId());
            });
            this.verifyItemIds(Lists.newArrayList(itemIds), Lists.newArrayList(dirIds), Lists.newArrayList(skuIds), taskId, ShelfTaskTypeDgEnum.ON.getType());
            ArrayList<DirItemRelationDgEo> insertEos = new ArrayList<DirItemRelationDgEo>();
            ArrayList<DirItemRelationDgEo> updateEos = new ArrayList<DirItemRelationDgEo>();
            for (DirItemRelationDgEo dirsItemsEo2 : dirsItemsEos) {
                DirItemRelationDgEo result = this.queryDirItemRelationInfo(dirsItemsEo2);
                if (result == null) {
                    dirsItemsEo2.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
                    insertEos.add(dirsItemsEo2);
                    continue;
                }
                dirsItemsEo2.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
                dirsItemsEo2.setId(result.getId());
                updateEos.add(dirsItemsEo2);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateEos)) {
                updateEos.forEach(dirsItemsEo -> this.dirItemRelationDgDomain.updateSelective((BaseEo)dirsItemsEo));
                shelfDirItems.addAll(updateEos);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(insertEos)) {
                this.dirItemRelationDgDomain.insertBatch(insertEos);
                shelfDirItems.addAll(insertEos);
            }
            List<ItemAttributesDgEo> allItemAttributes = this.itemAttributesDgService.queryByItemIds(Lists.newArrayList(itemIds));
            Map<Long, List<ItemAttributesDgEo>> groupItemIdAttributes = this.getGroupItemIdAttributes(Lists.newArrayList(itemIds), allItemAttributes);
            for (DirItemRelationDgEo dirsItemsEo3 : dirsItemsEos) {
                List<ItemAttributesDgEo> attributesList = groupItemIdAttributes.get(dirsItemsEo3.getItemId());
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(attributesList)) continue;
                this.dirItemAttributesDgService.addSearchAttrsAttributes(dirsItemsEo3.getDirId(), attributesList);
            }
        }
        logger.info("\u4fdd\u5b58\u4e0a\u67b6\u8bb0\u5f55");
        ArrayList shelfDgReqDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfDgReqDtos, onShelfDtoList, ShelfDgReqDto.class);
        List<ShelfDgEo> shelfDgEoList = this.saveShelf(shelfDgReqDtos, ItemDgStatus.ITEM_ONSHELF.getStatus());
        logger.info("\u4fdd\u5b58\u4e0a\u67b6\u5546\u54c1\u5e93\u5b58");
        Map<String, List<ItemShelfDgReqDto>> onShelfItemMap = onShelfDtoList.stream().collect(Collectors.groupingBy(itemShelfDgReqDto -> itemShelfDgReqDto.getShopId() + itemShelfDgReqDto.getChannelId() + "" + itemShelfDgReqDto.getSkuId()));
        onShelfItemMap.keySet().forEach(key -> {
            ItemShelfDgReqDto itemShelfDgReqDto = (ItemShelfDgReqDto)((List)onShelfItemMap.get(key)).get(0);
            Long balance = itemShelfDgReqDto.getStorage();
            ItemStorageQueryDgReqDto itemStorageQueryDgReqDto = new ItemStorageQueryDgReqDto();
            itemStorageQueryDgReqDto.setShopId(itemShelfDgReqDto.getShopId());
            itemStorageQueryDgReqDto.setChannelId(itemShelfDgReqDto.getChannelId());
            itemStorageQueryDgReqDto.setSkuIds((List)Lists.newArrayList((Object[])new Long[]{itemShelfDgReqDto.getSkuId()}));
            itemStorageQueryDgReqDto.setInstanceId(itemShelfDgReqDto.getInstanceId());
            itemStorageQueryDgReqDto.setTenantId(itemShelfDgReqDto.getTenantId());
            ArrayList itemStorageQueryDgReqDtoList = Lists.newArrayList((Object[])new ItemStorageQueryDgReqDto[]{itemStorageQueryDgReqDto});
            List<ItemStorageQueryDgRespDto> itemStorageQueryDgRespDtoList = this.itemStorageDgService.queryItemStorage(itemStorageQueryDgReqDtoList, itemShelfDgReqDto.getInstanceId(), itemShelfDgReqDto.getTenantId());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemStorageQueryDgReqDtoList) && itemStorageQueryDgRespDtoList.get(0).getAvaNum() != null) {
                balance = balance - itemStorageQueryDgRespDtoList.get(0).getAvaNum();
            }
            ItemStorageDgReqDto itemStorageDgReqDto = new ItemStorageDgReqDto();
            itemStorageDgReqDto.setShopId(itemShelfDgReqDto.getShopId());
            itemStorageDgReqDto.setChannelId(itemShelfDgReqDto.getChannelId());
            itemStorageDgReqDto.setSkuId(itemShelfDgReqDto.getSkuId());
            itemStorageDgReqDto.setBalance(balance);
            itemStorageDgReqDto.setInstanceId(itemShelfDgReqDto.getInstanceId());
            itemStorageDgReqDto.setTenantId(itemShelfDgReqDto.getTenantId());
            this.itemStorageDgService.operatingItemStorage(itemStorageDgReqDto);
        });
        logger.info("\u4fdd\u5b58\u5546\u54c1\u5206\u9500\u8bbe\u7f6e");
        this.saveDistribution(onShelfDtoList);
        this.savePointsDeductionRule(onShelfDtoList, shelfDgEoList);
        this.itemSearchDgService.asyncItemIndex(onShelfDtoList.get(0).getBusType(), shelfDirItems);
        if (!isManual) {
            for (ItemShelfDgReqDto dto2 : onShelfDtoList) {
                ShelfItemDgDto shelfItemDgDto = new ShelfItemDgDto();
                CubeBeanUtils.copyProperties((Object)shelfItemDgDto, (Object)dto2, (String[])new String[0]);
                shelfItemDgDto.setTaskId(taskId);
                this.updateShelfTaskStatus(shelfItemDgDto, ShelfTaskStatusDgEnum.UNPROCESSED.getStatus(), ShelfTaskTypeDgEnum.ON.getType(), ShelfTaskStatusDgEnum.SUCCESS.getStatus());
            }
        }
    }

    private void saveDistribution(List<ItemShelfDgReqDto> onShelfDtoList) {
        if (null != this.distributionSetDgService) {
            HashSet distributionSets = Sets.newHashSet();
            onShelfDtoList.forEach(itemShelfDgReqDto -> {
                if (itemShelfDgReqDto.getDistribution() == 1 && null != itemShelfDgReqDto.getDistribution()) {
                    distributionSets.add(itemShelfDgReqDto.getDistributionSet());
                }
            });
            this.distributionSetDgService.saveBatch(distributionSets.stream().collect(Collectors.toList()));
        }
    }

    private void savePointsDeductionRule(List<ItemShelfDgReqDto> onShelfDtoList, List<ShelfDgEo> shelfDgEoList) {
        Map<String, Long> ShelfMap = shelfDgEoList.stream().filter(shelfEo -> shelfEo.getId() != null).collect(Collectors.toMap(shelfEo -> shelfEo.getShopId() + "" + shelfEo.getSkuId(), BaseEo::getId));
        onShelfDtoList.stream().filter(itemShelfDgReqDto -> itemShelfDgReqDto.getPointsDeduction() != null && 1 == itemShelfDgReqDto.getPointsDeduction() && itemShelfDgReqDto.getPointsDeductionDgReqDto() != null).forEach(itemShelfDgReqDto -> {
            Long shelfId = (Long)ShelfMap.get(itemShelfDgReqDto.getShopId() + "" + itemShelfDgReqDto.getSkuId());
            PointsDeductionDgReqDto pointsDeductionDgReqDto = itemShelfDgReqDto.getPointsDeductionDgReqDto();
            ShelfPointsDeductionDgEo query = ShelfPointsDeductionDgEo.newInstance();
            query.setShelfId((Long)ShelfMap.get(itemShelfDgReqDto.getShopId() + "" + itemShelfDgReqDto.getSkuId()));
            query.setShopId(itemShelfDgReqDto.getShopId());
            query.setShopId(itemShelfDgReqDto.getShopId());
            query.setItemId(itemShelfDgReqDto.getItemId());
            query.setChannelId(itemShelfDgReqDto.getChannelId());
            query.setSkuId(itemShelfDgReqDto.getSkuId());
            List list = this.shelfPointsDeductionDgDomain.selectList((BaseEo)query);
            if (CollectionUtils.isEmpty((Collection)list)) {
                ShelfPointsDeductionDgEo shelfPointsDeductionDgEo = ShelfPointsDeductionDgEo.newInstance();
                shelfPointsDeductionDgEo.setShelfId((Long)ShelfMap.get(itemShelfDgReqDto.getShopId() + "" + itemShelfDgReqDto.getSkuId()));
                shelfPointsDeductionDgEo.setShopId(itemShelfDgReqDto.getShopId());
                shelfPointsDeductionDgEo.setChannelId(itemShelfDgReqDto.getChannelId());
                shelfPointsDeductionDgEo.setItemId(itemShelfDgReqDto.getItemId());
                shelfPointsDeductionDgEo.setSkuId(itemShelfDgReqDto.getSkuId());
                shelfPointsDeductionDgEo.setMinPoints(pointsDeductionDgReqDto.getMinPoints());
                shelfPointsDeductionDgEo.setMaxPoints(pointsDeductionDgReqDto.getMaxPoints());
                shelfPointsDeductionDgEo.setCustom(pointsDeductionDgReqDto.getCustom());
                this.shelfPointsDeductionDgDomain.insert((BaseEo)shelfPointsDeductionDgEo);
            } else {
                logger.info("{}\u79ef\u5206\u62b5\u6263\u89c4\u5219\u5df2\u7ecf\u5b58\u5728", (Object)query.getShelfId());
                ShelfPointsDeductionDgEo shelfPointsDeductionDgEo = (ShelfPointsDeductionDgEo)list.get(0);
                shelfPointsDeductionDgEo.setShelfId((Long)ShelfMap.get(itemShelfDgReqDto.getShopId() + "" + itemShelfDgReqDto.getSkuId()));
                shelfPointsDeductionDgEo.setShopId(itemShelfDgReqDto.getShopId());
                shelfPointsDeductionDgEo.setChannelId(itemShelfDgReqDto.getChannelId());
                shelfPointsDeductionDgEo.setItemId(itemShelfDgReqDto.getItemId());
                shelfPointsDeductionDgEo.setSkuId(itemShelfDgReqDto.getSkuId());
                shelfPointsDeductionDgEo.setMinPoints(pointsDeductionDgReqDto.getMinPoints());
                shelfPointsDeductionDgEo.setMaxPoints(pointsDeductionDgReqDto.getMaxPoints());
                shelfPointsDeductionDgEo.setCustom(pointsDeductionDgReqDto.getCustom());
                this.shelfPointsDeductionDgDomain.update((BaseEo)shelfPointsDeductionDgEo);
                if (list.size() > 1) {
                    logger.info("{}\u79ef\u5206\u62b5\u6263\u89c4\u5219\u5b58\u5728\u591a\u6761\uff0c\u9700\u8981\u5220\u9664", (Object)query.getShelfId());
                    for (int i = 1; i < list.size(); ++i) {
                        ShelfPointsDeductionDgEo eo = (ShelfPointsDeductionDgEo)list.get(i);
                        if (eo == null) continue;
                        this.shelfPointsDeductionDgDomain.logicDelete((BaseEo)eo);
                    }
                }
            }
        });
    }

    @Override
    public List<ShelfDgEo> saveShelf(List<ShelfDgReqDto> shelfDgReqDtos, Integer itemStatus) {
        HashMap<String, ShelfDgReqDto> shelfMap = new HashMap<String, ShelfDgReqDto>();
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (ShelfDgReqDto shelfDgReqDto : shelfDgReqDtos) {
            shelfMap.put(shelfDgReqDto.getChannelId() + shelfDgReqDto.getItemId().toString() + shelfDgReqDto.getSkuId(), shelfDgReqDto);
            itemIds.add(shelfDgReqDto.getItemId());
        }
        ArrayList<ShelfDgEo> shelfDgEoList = new ArrayList<ShelfDgEo>();
        ArrayList<ShelfDgEo> subShelfDgEoList = new ArrayList<ShelfDgEo>();
        Map itemEoMap = ((ExtQueryChainWrapper)this.itemDgDomain.filter().in((Object)"id", itemIds)).list().stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (ShelfDgReqDto shelfDgReqDto : shelfMap.values()) {
            ItemDgEo itemDgEo = (ItemDgEo)itemEoMap.get(shelfDgReqDto.getItemId());
            ShelfDgEo shelfDgEo = new ShelfDgEo();
            Date shelfTime = new Date();
            this.getshelfDgEo(shelfDgEo, shelfDgReqDto, itemDgEo, itemStatus, shelfTime, shelfDgEoList);
            this.updateOrInsertBundleItemShelf(shelfDgEo, shelfDgReqDto, itemDgEo, shelfTime, subShelfDgEoList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shelfDgEoList)) {
            this.shelfDgDomain.insertBatch(shelfDgEoList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(subShelfDgEoList)) {
            this.shelfDgDomain.insertBatch(subShelfDgEoList);
        }
        for (ShelfDgReqDto shelfDgReqDto : shelfMap.values()) {
            this.shelfDgService.clearItemShelfCache(shelfDgReqDto);
        }
        return shelfDgEoList;
    }

    private void getShelfIntegralService(Map<String, ShelfDgReqDto> shelfMap, List<ShelfDgReqDto> shelfDgReqDtos, Integer itemStatus) {
        if (null != this.shelfIntegralDgService && ItemBusTypeDgEnum.INTEGRAL.getType().equals(shelfDgReqDtos.get(0).getBusType())) {
            for (ShelfDgReqDto shelfDgReqDto : shelfMap.values()) {
                ShelfDgEo shelfQuery = new ShelfDgEo();
                shelfQuery.setItemType(shelfDgReqDto.getItemType());
                shelfQuery.setSkuId(shelfDgReqDto.getSkuId());
                shelfQuery.setBusType(shelfDgReqDto.getBusType());
                shelfQuery.setItemId(shelfDgReqDto.getItemId());
                shelfQuery.setShopId(shelfDgReqDto.getShopId());
                ShelfDgEo result = (ShelfDgEo)this.shelfDgDomain.selectOne((BaseEo)shelfQuery);
                ShelfIntegralDgRespDto shelfIntegralDgRespDto = this.shelfIntegralDgService.queryBySkuInfo(shelfDgReqDto.getSkuId(), shelfDgReqDto.getShopId());
                if (shelfIntegralDgRespDto == null) {
                    ShelfIntegralAddDgReqDto shelfIntegralAddDgReqDto = new ShelfIntegralAddDgReqDto();
                    shelfIntegralAddDgReqDto.setCashAmount(shelfDgReqDto.getCashAmount());
                    shelfIntegralAddDgReqDto.setShelfId(result.getId());
                    shelfIntegralAddDgReqDto.setCashType(shelfDgReqDto.getCashType());
                    shelfIntegralAddDgReqDto.setCashLimit(shelfDgReqDto.getCashLimit());
                    shelfIntegralAddDgReqDto.setCashIntegral(shelfDgReqDto.getCashIntegral());
                    shelfIntegralAddDgReqDto.setRuleRemark(shelfDgReqDto.getRuleRemark());
                    shelfIntegralAddDgReqDto.setSkuId(shelfDgReqDto.getSkuId());
                    shelfIntegralAddDgReqDto.setItemId(shelfDgReqDto.getItemId());
                    shelfIntegralAddDgReqDto.setShopId(shelfDgReqDto.getShopId());
                    this.shelfIntegralDgService.add(shelfIntegralAddDgReqDto);
                    continue;
                }
                ShelfIntegralModifyDgReqDto shelfIntegralModifyDgReqDto = new ShelfIntegralModifyDgReqDto();
                shelfIntegralModifyDgReqDto.setCashAmount(shelfDgReqDto.getCashAmount());
                shelfIntegralModifyDgReqDto.setShelfId(result.getId());
                shelfIntegralModifyDgReqDto.setCashType(shelfDgReqDto.getCashType());
                shelfIntegralModifyDgReqDto.setId(shelfIntegralDgRespDto.getId());
                shelfIntegralModifyDgReqDto.setCashLimit(shelfDgReqDto.getCashLimit());
                shelfIntegralModifyDgReqDto.setCashIntegral(shelfDgReqDto.getCashIntegral());
                shelfIntegralModifyDgReqDto.setItemId(shelfDgReqDto.getItemId());
                shelfIntegralModifyDgReqDto.setRuleRemark(shelfDgReqDto.getRuleRemark());
                shelfIntegralModifyDgReqDto.setShopId(shelfDgReqDto.getShopId());
                shelfIntegralModifyDgReqDto.setSkuId(shelfDgReqDto.getSkuId());
                if (ItemDgStatus.ITEM_ONSHELF.getStatus().equals(itemStatus)) {
                    this.shelfIntegralDgService.modify(shelfIntegralModifyDgReqDto);
                    continue;
                }
                this.shelfIntegralDgService.modifySelective(shelfIntegralModifyDgReqDto);
            }
        }
    }

    private void updateOrInsertBundleItemShelf(ShelfDgEo shelfDgEo, ShelfDgReqDto shelfDgReqDto, ItemDgEo itemDgEo, Date shelfTime, List<ShelfDgEo> subShelfDgEoList) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfDgReqDto.getBundleItemDtos())) {
            ShelfDgEo finalShelfDgEo = shelfDgEo;
            shelfDgReqDto.getBundleItemDtos().forEach(bundleItemReqDto -> {
                if (bundleItemReqDto.getShelfStatus() == null) {
                    ShelfQueryDgReqDto shelfQueryDgReqDto = new ShelfQueryDgReqDto();
                    shelfQueryDgReqDto.setShopId(shelfDgReqDto.getShopId());
                    shelfQueryDgReqDto.setItemId(bundleItemReqDto.getSubItemId());
                    shelfQueryDgReqDto.setSkuId(bundleItemReqDto.getSubSkuId());
                    List<ShelfQueryDgRespDto> shelfQueryDgRespDtoList = this.shelfDgService.queryShelfList(shelfQueryDgReqDto);
                    bundleItemReqDto.setShelfStatus(Integer.valueOf(org.apache.commons.collections.CollectionUtils.isEmpty(shelfQueryDgRespDtoList) ? ShelfStatusDgEnum.WAIT_SHELF.getCode() : shelfQueryDgRespDtoList.get(0).getStatus().intValue()));
                }
                if (ShelfStatusDgEnum.WAIT_SHELF.getCode() == bundleItemReqDto.getShelfStatus().intValue()) {
                    ShelfDgEo subShelfDgEo = new ShelfDgEo();
                    subShelfDgEo.setItemType(ItemTypeDgEnum.GENERAL.getType());
                    subShelfDgEo.setBusType(ItemBusTypeDgEnum.ORDINARY.getType());
                    subShelfDgEo.setShopId(shelfDgReqDto.getShopId());
                    subShelfDgEo.setSellerId(shelfDgReqDto.getSellerId());
                    subShelfDgEo.setItemId(bundleItemReqDto.getSubItemId());
                    subShelfDgEo.setSkuId(bundleItemReqDto.getSubSkuId());
                    subShelfDgEo.setInstanceId(shelfDgReqDto.getInstanceId());
                    subShelfDgEo.setTenantId(shelfDgReqDto.getTenantId());
                    if (this.shelfDgDomain.selectOne((BaseEo)finalShelfDgEo) == null) {
                        subShelfDgEo.setPointsDeduction(shelfDgReqDto.getPointsDeduction());
                        subShelfDgEo.setDistribution(shelfDgReqDto.getDistribution());
                        subShelfDgEo.setOrganizationId(shelfDgReqDto.getOrganizationId());
                        subShelfDgEo.setOrganizationName(shelfDgReqDto.getOrganizationName());
                        subShelfDgEo.setShelfTime(shelfTime);
                        subShelfDgEo.setStatus(Integer.valueOf(ShelfStatusDgEnum.OFF_SHELF.getCode()));
                        subShelfDgEo.setPrice(bundleItemReqDto.getRetailPrice());
                        subShelfDgEo.setType(Integer.valueOf(1));
                        subShelfDgEo.setVersionId(itemDgEo.getVersion());
                        subShelfDgEo.setSellerId(shelfDgReqDto.getSellerId());
                        subShelfDgEoList.add(subShelfDgEo);
                    }
                }
            });
        }
    }

    private boolean firstOnShelf(Long itemId) {
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        shelfDgEo.setItemId(itemId);
        shelfDgEo.setDr(0);
        shelfDgEo.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
        int count = this.shelfDgDomain.count((BaseEo)shelfDgEo);
        return count == 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void offShelfItem(List<OffItemDgReqDto> offItemDgReqDtos) {
        ArrayList<OffItemDgReqDto> offDtos = new ArrayList<OffItemDgReqDto>();
        for (OffItemDgReqDto dto : offItemDgReqDtos) {
            if (dto.isTiming()) {
                AssertUtils.notNull((Object)dto.getOffTime(), (String)ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), (Object[])new Object[]{ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":" + dto.getItemId() + "\u5b9a\u65f6\u4e0b\u67b6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"});
                this.saveShelfTask(null, null, dto);
                continue;
            }
            ShelfItemDgDto shelfItemDgDto = new ShelfItemDgDto();
            CubeBeanUtils.copyProperties((Object)shelfItemDgDto, (Object)dto, (String[])new String[0]);
            this.updateShelfTaskStatus(shelfItemDgDto, ShelfTaskStatusDgEnum.UNPROCESSED.getStatus(), ShelfTaskTypeDgEnum.OFF.getType(), ShelfTaskStatusDgEnum.CANCEL.getStatus());
            offDtos.add(dto);
        }
        ArrayList itemIds = Lists.newArrayList();
        offItemDgReqDtos.forEach(itemReqDto -> itemIds.add(itemReqDto.getItemId()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(offDtos)) {
            this.offShelfOperation(offDtos, true, null);
        }
        this.updateItemStatus(itemIds);
    }

    private void updateItemStatus(List<Long> itemIds) {
        List shelfDgEos = this.shelfDgDomain.selectByItemIds(itemIds, ItemDgStatus.ITEM_ONSHELF.getStatus());
        if (CollectionUtil.isNotEmpty((Collection)shelfDgEos)) {
            List removeItemIds = shelfDgEos.stream().map(ShelfDgEo::getItemId).collect(Collectors.toList());
            itemIds.removeAll(removeItemIds);
        }
        if (CollectionUtil.isNotEmpty(itemIds)) {
            this.itemDgService.updateStatusBatch(itemIds, ItemDgStatus.ITEM_OFFSHELF.getStatus());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void offShelfOperation(List<OffItemDgReqDto> offItemDgReqDtos, boolean isManual, Long taskId) {
        HashSet itemIds = Sets.newHashSet();
        ArrayList offDirItems = Lists.newArrayList();
        for (OffItemDgReqDto offItemDgReqDto : offItemDgReqDtos) {
            if (offItemDgReqDto.getItemId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
            }
            itemIds.add(offItemDgReqDto.getItemId());
            ItemDgEo itemDgEo = this.itemDgService.queryById(offItemDgReqDto.getItemId());
            if (itemDgEo != null) {
                if (offItemDgReqDto.getSkuId() != null) {
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    skuIds.add(offItemDgReqDto.getSkuId());
                    this.verifyItemIds(null, null, skuIds, taskId, ShelfTaskTypeDgEnum.OFF.getType());
                }
                if (offItemDgReqDto.getDirId() != null) {
                    ArrayList<Long> dirIds = new ArrayList<Long>();
                    dirIds.add(offItemDgReqDto.getDirId());
                    this.verifyItemIds(null, dirIds, null, taskId, ShelfTaskTypeDgEnum.OFF.getType());
                }
                DirItemRelationDgEo dirItemRelationDgEo = DirItemRelationDgEo.newInstance();
                dirItemRelationDgEo.setItemId(itemDgEo.getId());
                dirItemRelationDgEo.setSkuId(offItemDgReqDto.getSkuId());
                dirItemRelationDgEo.setShopId(offItemDgReqDto.getShopId());
                dirItemRelationDgEo.setDirId(offItemDgReqDto.getDirId());
                dirItemRelationDgEo.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
                dirItemRelationDgEo.setTenantId(offItemDgReqDto.getTenantId());
                dirItemRelationDgEo.setInstanceId(offItemDgReqDto.getInstanceId());
                dirItemRelationDgEo.setBusType(offItemDgReqDto.getBusType());
                List relations = this.dirItemRelationDgDomain.selectList((BaseEo)dirItemRelationDgEo);
                for (DirItemRelationDgEo e : relations) {
                    DirItemRelationDgEo updateEo = DirItemRelationDgEo.newInstance();
                    updateEo.setId(e.getId());
                    updateEo.setStatus(ItemDgStatus.ITEM_OFFSHELF.getStatus());
                    this.dirItemRelationDgDomain.updateSelective((BaseEo)updateEo);
                    offDirItems.add(e);
                }
                if (isManual) continue;
                ShelfItemDgDto shelfItemDgDto = new ShelfItemDgDto();
                CubeBeanUtils.copyProperties((Object)shelfItemDgDto, (Object)offItemDgReqDto, (String[])new String[0]);
                shelfItemDgDto.setTaskId(taskId);
                this.updateShelfTaskStatus(shelfItemDgDto, ShelfTaskStatusDgEnum.UNPROCESSED.getStatus(), ShelfTaskTypeDgEnum.OFF.getType(), ShelfTaskStatusDgEnum.SUCCESS.getStatus());
                continue;
            }
            if (taskId == null) continue;
            ShelfItemDgDto shelfItemDgDto = new ShelfItemDgDto();
            shelfItemDgDto.setItemId(offItemDgReqDto.getItemId());
            shelfItemDgDto.setTaskId(taskId);
            this.updateShelfTaskStatus(shelfItemDgDto, ShelfTaskStatusDgEnum.UNPROCESSED.getStatus(), ShelfTaskTypeDgEnum.OFF.getType(), ShelfTaskStatusDgEnum.FAIL.getStatus());
        }
        ArrayList shelfDgReqDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfDgReqDtos, offItemDgReqDtos, ShelfDgReqDto.class);
        logger.info("\u4e0b\u67b6\u64cd\u4f5c\u66f4\u65b0\u8bb0\u5f55shelfReqDtos>>>{}", (Object)JSON.toJSONString((Object)shelfDgReqDtos));
        this.saveShelf(shelfDgReqDtos, ItemDgStatus.ITEM_OFFSHELF.getStatus());
        this.itemSearchDgService.syncEsOff(offItemDgReqDtos.get(0).getBusType(), offDirItems);
    }

    @Override
    public void removeShelf(List<Long> skuIds) {
        ShelfDgEo shelfDgEo = new ShelfDgEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"sku_id", skuIds));
        shelfDgEo.setSqlFilters(sqlFilters);
        this.shelfDgDomain.logicDelete((BaseEo)shelfDgEo);
    }

    @Override
    public void batchAddShelf(List<ShelfDgEo> shelfDgEos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(shelfDgEos)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        this.shelfDgDomain.insertBatch(shelfDgEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteDirItemByIds(List<Long> dirItemIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dirItemIds)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        List dirsItemsEos = this.dirItemRelationDgDomain.selectByIds(dirItemIds);
        for (DirItemRelationDgEo dirsItemsEo : dirsItemsEos) {
            this.dirItemRelationDgDomain.deleteById(dirsItemsEo.getId());
            ShelfDgEo shelfDgEo = new ShelfDgEo();
            shelfDgEo.setItemId(dirsItemsEo.getItemId());
            this.shelfDgDomain.logicDelete((BaseEo)shelfDgEo);
        }
    }

    @Override
    public PageInfo<DirItemRelationDgEo> queryByItemId(Long instanceId, Long itemId, Integer pageNum, Integer pageSize) {
        DirItemRelationDgEo dirsItemsEo = DirItemRelationDgEo.newInstance();
        dirsItemsEo.setItemId(itemId);
        dirsItemsEo.setInstanceId(instanceId);
        return this.dirItemRelationDgDomain.selectPage((BaseEo)dirsItemsEo, pageNum, pageSize);
    }

    @Override
    public List<Long> queryByBundleItemIds(List<Long> itemIds) {
        return this.shelfDgDomain.selectByBundleItemIds(itemIds);
    }

    @Override
    @Transactional
    public void batchOnShelfItem(ItemOnShelfDgReqDto onShelfDgReqDto) {
        AssertUtils.notNull((Object)onShelfDgReqDto, (String)"\u4e0a\u67b6\u5546\u54c1\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a");
        List shelfItemInfoDgReqDtos = onShelfDgReqDto.getShelfItemInfoDgReqDtos();
        AssertUtils.notEmpty((Collection)onShelfDgReqDto.getShelfItemInfoDgReqDtos(), (String)"\u4e0a\u67b6\u5546\u54c1\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a");
        this.checkSkuMarketStatus(shelfItemInfoDgReqDtos);
        Map<Long, List<ShelfItemInfoDgReqDto>> listMap = shelfItemInfoDgReqDtos.stream().collect(Collectors.groupingBy(ShelfItemInfoDgReqDto::getShopId));
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        for (Map.Entry<Long, List<ShelfItemInfoDgReqDto>> listEntry : listMap.entrySet()) {
            List<Long> itemIds = this.batchOnShelfByShop(listEntry.getKey(), listEntry.getValue());
            itemIdList.addAll(itemIds);
        }
        this.itemDgDomain.updateStatusByIds(itemIdList, ItemStatus.ON_LINE.getStatus());
        this.pushMessageEs(onShelfDgReqDto.getShelfItemInfoDgReqDtos(), ShelfItemInfoDgReqDto::getShopId, ShelfItemInfoDgReqDto::getItemId, "INSERT");
    }

    private void checkSkuMarketStatus(List<ShelfItemInfoDgReqDto> shelfItemInfoDgReqDtos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(shelfItemInfoDgReqDtos)) {
            return;
        }
        Set itemIdSet = shelfItemInfoDgReqDtos.stream().filter(e -> Objects.nonNull(e.getItemId())).map(ShelfItemInfoDgReqDto::getItemId).collect(Collectors.toSet());
        Set shopIds = shelfItemInfoDgReqDtos.stream().filter(e -> Objects.nonNull(e.getShopId())).map(ShelfItemInfoDgReqDto::getShopId).collect(Collectors.toSet());
        List shelfDgEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shelfDgDomain.filter().in((Object)"shop_id", shopIds)).in((Object)"item_id", itemIdSet)).list();
        Map shelfDgMap = shelfDgEoList.stream().collect(Collectors.toMap(s -> this.getKey(s.getShopId(), s.getSkuId()), Function.identity()));
        List itemSkuDgEoList = this.itemSkuDgDomain.selectByItemIds((List)Lists.newArrayList(itemIdSet));
        Set skuIds = itemSkuDgEoList.stream().map(BaseEo::getId).collect(Collectors.toSet());
        List skuMarketRefDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.skuMarketRefDgDomain.filter().in((Object)"shop_id", shopIds)).in((Object)"sku_id", skuIds)).eq((Object)"market_status", (Object)SkuItemMarketStatusEnum.MARKET_STATUS_ON.getStatus())).list();
        if (CollectionUtil.isNotEmpty((Collection)skuMarketRefDgEos)) {
            for (SkuMarketRefDgEo skuMarketRefDgEo : skuMarketRefDgEos) {
                if (!shelfDgMap.containsKey(this.getKey(skuMarketRefDgEo.getShopId(), skuMarketRefDgEo.getSkuId()))) continue;
                throw new BizException("sku\u5df2\u9000\u5e02\uff0c\u65e0\u6cd5\u4e0a\u67b6");
            }
        }
    }

    private String getKey(Long shopId, Long skuId) {
        return shopId + "_" + skuId;
    }

    private void checkItemMarketStatus(List<ShelfItemInfoDgReqDto> shelfItemInfoDgReqDtos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(shelfItemInfoDgReqDtos)) {
            return;
        }
        Set itemIdSet = shelfItemInfoDgReqDtos.stream().filter(e -> Objects.nonNull(e.getItemId())).map(ShelfItemInfoDgReqDto::getItemId).collect(Collectors.toSet());
        List itemDgEos = ((ExtQueryChainWrapper)this.itemDgDomain.filter().in((Object)"id", itemIdSet)).list();
        for (ItemDgEo itemDgEo : itemDgEos) {
            AssertUtils.isTrue((boolean)ItemDgStatusEnum.MARKET_STATUS_ON.getStatus().equals(itemDgEo.getMarketStatus()), (String)"\u975e\u4e0a\u5e02\u5546\u54c1\u4e0d\u5141\u8bb8\u4e0a\u67b6!");
        }
    }

    private <T> void pushMessageEs(List<T> dtos, Function<T, Long> shopIdList, Function<T, Long> itemIdList, String eventType) {
        Set<Long> shopIds = this.extractIds(dtos, shopIdList);
        Set<Long> itemIds = this.extractIds(dtos, itemIdList);
        List itemShopDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemShopDgDomain.filter().in(CollectionUtil.isNotEmpty(shopIds), (Object)"shop_id", shopIds)).in(CollectionUtil.isNotEmpty(itemIds), (Object)"item_id", itemIds)).list();
        if (CollectionUtil.isNotEmpty((Collection)itemShopDgEos)) {
            Set<Long> itemShopIds = itemShopDgEos.stream().map(BaseEo::getId).collect(Collectors.toSet());
            this.itemShelfDgProducer.sendMqItemShopEsMessage(itemShopIds, eventType);
        }
    }

    private <T, R> Set<R> extractIds(List<T> dtos, Function<T, R> id) {
        return dtos.stream().filter(dto -> Objects.nonNull(id.apply(dto))).map(id).collect(Collectors.toSet());
    }

    @Override
    public void batchOffShelfItem(ItemOffShelfDgReqDto itemOffShelfDgReqDto) {
        AssertUtils.notNull((Object)itemOffShelfDgReqDto, (String)"\u4e0b\u67b6\u5546\u54c1\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a");
        List offShelfItemDgReqDtos = itemOffShelfDgReqDto.getOffShelfItemDgReqDtos();
        AssertUtils.notEmpty((Collection)offShelfItemDgReqDtos, (String)"\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a");
        Map<Long, List<OffShelfItemDgReqDto>> listMap = offShelfItemDgReqDtos.stream().collect(Collectors.groupingBy(OffShelfItemDgReqDto::getShopId));
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        for (Map.Entry<Long, List<OffShelfItemDgReqDto>> listEntry : listMap.entrySet()) {
            List<Long> itemIds = this.batchOffShelfByShop(listEntry.getKey(), listEntry.getValue());
            itemIdList.addAll(itemIds);
        }
        this.updateItemStatus(itemIdList);
        this.pushMessageEs(itemOffShelfDgReqDto.getOffShelfItemDgReqDtos(), OffShelfItemDgReqDto::getShopId, OffShelfItemDgReqDto::getItemId, "UPDATE");
    }

    private List<Long> batchOffShelfByShop(Long shopId, List<OffShelfItemDgReqDto> shelfItemInfoDgReqDtos) {
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty(shelfItemInfoDgReqDtos)) {
            List shelfDgEoList;
            ArrayList shelfDgEos = new ArrayList();
            HashSet<Long> itemIds = new HashSet<Long>();
            HashSet<Long> skuIds = new HashSet<Long>();
            for (OffShelfItemDgReqDto shelfItemInfoDgReqDto : shelfItemInfoDgReqDtos) {
                itemIdList.add(shelfItemInfoDgReqDto.getItemId());
                if (Objects.nonNull(shelfItemInfoDgReqDto.getSkuId())) {
                    skuIds.add(shelfItemInfoDgReqDto.getSkuId());
                    continue;
                }
                itemIds.add(shelfItemInfoDgReqDto.getItemId());
            }
            if (CollectionUtil.isNotEmpty(itemIds) && CollectionUtil.isNotEmpty((Collection)(shelfDgEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shelfDgDomain.filter().eq((Object)"shop_id", (Object)shopId)).in((Object)"item_id", itemIds)).list()))) {
                shelfDgEos.addAll(shelfDgEoList);
            }
            if (CollectionUtil.isNotEmpty(skuIds) && CollectionUtil.isNotEmpty((Collection)(shelfDgEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shelfDgDomain.filter().eq((Object)"shop_id", (Object)shopId)).in((Object)"sku_id", skuIds)).list()))) {
                shelfDgEos.addAll(shelfDgEoList);
            }
            AssertUtils.notEmpty(shelfDgEos, (String)("\u5546\u54c1\u672a\u53d1\u5e03\u81f3\u5e97\u94fa" + shopId));
            List ids = shelfDgEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.shelfDgDomain.updateShelfStatusByIds(ids, ShelfStatusDgEnum.OFF_SHELF.getCode());
            List shelfDgEoList2 = this.shelfDgDomain.selectByItemIdsAndShop(itemIds, shopId, ItemDgStatus.ITEM_ONSHELF.getStatus());
            if (CollectionUtil.isNotEmpty((Collection)shelfDgEoList2)) {
                List removeItemIds = shelfDgEos.stream().map(ShelfDgEo::getItemId).collect(Collectors.toList());
                itemIds.removeAll(removeItemIds);
            }
            if (CollectionUtil.isNotEmpty(itemIdList)) {
                this.itemShopDgDomain.updateShopItemStatus(itemIdList, shopId, ItemDgStatus.ITEM_OFFSHELF.getStatus().intValue());
            }
        }
        return itemIdList;
    }

    private List<Long> batchOnShelfByShop(Long shopId, List<ShelfItemInfoDgReqDto> shelfItemInfoDgReqDtos) {
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty(shelfItemInfoDgReqDtos)) {
            List shelfDgEoList;
            ArrayList shelfDgEos = new ArrayList();
            HashSet<Long> itemIds = new HashSet<Long>();
            HashSet<Long> skuIds = new HashSet<Long>();
            for (ShelfItemInfoDgReqDto shelfItemInfoDgReqDto : shelfItemInfoDgReqDtos) {
                itemIdList.add(shelfItemInfoDgReqDto.getItemId());
                if (Objects.nonNull(shelfItemInfoDgReqDto.getSkuId())) {
                    skuIds.add(shelfItemInfoDgReqDto.getSkuId());
                    continue;
                }
                itemIds.add(shelfItemInfoDgReqDto.getItemId());
            }
            if (CollectionUtil.isNotEmpty(itemIds) && CollectionUtil.isNotEmpty((Collection)(shelfDgEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shelfDgDomain.filter().eq((Object)"shop_id", (Object)shopId)).in((Object)"item_id", itemIds)).list()))) {
                shelfDgEos.addAll(shelfDgEoList);
            }
            if (CollectionUtil.isNotEmpty(skuIds) && CollectionUtil.isNotEmpty((Collection)(shelfDgEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shelfDgDomain.filter().eq((Object)"shop_id", (Object)shopId)).in((Object)"sku_id", skuIds)).list()))) {
                shelfDgEos.addAll(shelfDgEoList);
            }
            AssertUtils.notEmpty(shelfDgEos, (String)("\u5546\u54c1\u672a\u53d1\u5e03\u81f3\u5e97\u94fa" + shopId));
            List ids = shelfDgEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.shelfDgDomain.updateShelfStatusByIds(ids, ShelfStatusDgEnum.ON_SHELF.getCode());
            this.itemShopDgDomain.updateShopItemStatus(itemIdList, shopId, ShelfStatusDgEnum.ON_SHELF.getCode());
        }
        return itemIdList;
    }

    @Override
    public PageInfo<DirItemRelationDgEo> queryByDirId(Long instanceId, Long dirId, Integer pageNum, Integer pageSize) {
        DirItemRelationDgEo dirsItemsEo = DirItemRelationDgEo.newInstance();
        dirsItemsEo.setInstanceId(instanceId);
        dirsItemsEo.setDirId(dirId);
        return this.dirItemRelationDgDomain.selectPage((BaseEo)dirsItemsEo, pageNum, pageSize);
    }

    @Override
    public int countByDirId(Long instanceId, Long tenantId, Long dirId) {
        DirItemRelationDgEo dirsItemsEo = DirItemRelationDgEo.newInstance();
        dirsItemsEo.setDirId(dirId);
        dirsItemsEo.setInstanceId(instanceId);
        dirsItemsEo.setTenantId(tenantId);
        dirsItemsEo.setDr(0);
        return this.dirItemRelationDgDomain.count((BaseEo)dirsItemsEo);
    }

    @Override
    public PageInfo<DirItemRelationDgEo> queryByDirIds(Long tenantId, Long instanceId, List<Long> dirIds, Integer pageNum, Integer pageSize) {
        DirItemRelationDgEo dirsItemsEo = DirItemRelationDgEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dirIds)) {
            sqlFilters.add(SqlFilter.in((String)"dir_id", (Object)StringUtils.join(dirIds, (String)",")));
        }
        dirsItemsEo.setSqlFilters((List)sqlFilters);
        return this.dirItemRelationDgDomain.selectPage((BaseEo)dirsItemsEo, pageNum, pageSize);
    }

    @Override
    public void offShelfByDirId(Long dirId) {
        DirItemRelationDgEo example = DirItemRelationDgEo.newInstance();
        example.setDirId(dirId);
        this.dirItemRelationDgDomain.logicDelete((BaseEo)example);
    }

    @Override
    public void offShelfByBrandId(Long brandId) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addItemDir(Long itemId, String dirIds, Long shopId, Long channelId) {
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemId);
        if (!(itemDgEo != null && ItemDgStatus.ITEM_ONSHELF.getStatus().equals(itemDgEo.getStatus()) && itemDgEo.getInstanceId().equals(ServiceContext.getContext().getRequestInstanceId()) && itemDgEo.getTenantId().equals(ServiceContext.getContext().getRequestTenantId()))) {
            return;
        }
        String[] dirIdsStr = dirIds.split(",");
        if (dirIdsStr != null && dirIdsStr.length != 0) {
            for (String dirIdStr : dirIdsStr) {
                if (!NumberUtils.isDigits((String)dirIdStr)) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
                }
                Long dirId = Long.valueOf(dirIdStr);
                DirDgEo dirDgEo = (DirDgEo)this.dirDgDomain.selectByPrimaryKey(dirId);
                if (dirDgEo == null || !dirDgEo.getInstanceId().equals(ServiceContext.getContext().getRequestInstanceId()) || !dirDgEo.getTenantId().equals(ServiceContext.getContext().getRequestTenantId())) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
                }
                DirItemRelationDgEo dirItemRelationDgEo = new DirItemRelationDgEo();
                dirItemRelationDgEo.setItemId(itemId);
                dirItemRelationDgEo.setDirId(dirId);
                dirItemRelationDgEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
                dirItemRelationDgEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
                dirItemRelationDgEo.setDr(0);
                if (this.dirItemRelationDgDomain.count((BaseEo)dirItemRelationDgEo) > 0) continue;
                dirItemRelationDgEo.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
                this.dirItemRelationDgDomain.insert((BaseEo)dirItemRelationDgEo);
            }
        }
    }

    @Override
    public void modifyShelfTask(List<ShelfTaskUpdateDgReqDto> shelfTaskUpdateDgReqDtos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(shelfTaskUpdateDgReqDtos)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":\u5b9a\u65f6\u4efb\u52a1dto\u5217\u8868\u65e0\u6570\u636e");
        }
        for (ShelfTaskUpdateDgReqDto dto : shelfTaskUpdateDgReqDtos) {
            ShelfTaskDgEo eo = (ShelfTaskDgEo)this.shelfTaskDgDomain.selectByPrimaryKey(dto.getId());
            if (eo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg() + ":" + dto.getId() + "\u5bf9\u5e94\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            if (ShelfTaskStatusDgEnum.UNPROCESSED.getStatus().equals(eo.getStatus())) {
                ShelfTaskDgEo shelfTaskDgEo = ShelfTaskDgEo.newInstance();
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)shelfTaskDgEo);
                this.shelfTaskDgDomain.updateSelective((BaseEo)shelfTaskDgEo);
                continue;
            }
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + "\u8bf7\u68c0\u67e5:" + dto.getId() + "\u7684\u4efb\u52a1\u72b6\u6001");
        }
    }

    @Override
    public void removeShelfTask(List<Long> ids, Long instanceId, Long tenantId) {
        for (Long id : ids) {
            if (!ShelfTaskStatusDgEnum.UNPROCESSED.getStatus().equals(((ShelfTaskDgEo)this.shelfTaskDgDomain.selectByPrimaryKey(id)).getStatus())) continue;
            ShelfTaskDgEo shelfTaskDgEo = ShelfTaskDgEo.newInstance();
            shelfTaskDgEo.setId(id);
            shelfTaskDgEo.setInstanceId(instanceId);
            shelfTaskDgEo.setTenantId(tenantId);
            this.shelfTaskDgDomain.logicDelete((BaseEo)shelfTaskDgEo);
        }
    }

    private void getshelfDgEo(ShelfDgEo shelfDgEo, ShelfDgReqDto shelfDgReqDto, ItemDgEo itemDgEo, Integer itemStatus, Date shelfTime, List<ShelfDgEo> shelfDgEoList) {
        shelfDgEo.setItemId(shelfDgReqDto.getItemId());
        shelfDgEo.setSkuId(shelfDgReqDto.getSkuId());
        shelfDgEo.setShopId(shelfDgReqDto.getShopId());
        shelfDgEo.setBusType(shelfDgReqDto.getBusType());
        shelfDgEo.setChannelId(shelfDgReqDto.getChannelId());
        shelfDgEo.setChannelCode(shelfDgReqDto.getChannelCode());
        shelfDgEo.setChannelName(shelfDgReqDto.getChannelName());
        ShelfDgEo update = (ShelfDgEo)this.shelfDgDomain.selectOne((BaseEo)shelfDgEo);
        if (update != null) {
            shelfDgEo = update;
        }
        shelfDgEo.setFreightTemplateId(shelfDgReqDto.getFreightTemplateId());
        shelfDgEo.setInstanceId(itemDgEo.getInstanceId());
        shelfDgEo.setTenantId(itemDgEo.getTenantId());
        shelfDgEo.setSellerId(shelfDgReqDto.getSellerId());
        shelfDgEo.setDistribution(shelfDgReqDto.getDistribution());
        shelfDgEo.setItemType(shelfDgReqDto.getItemType());
        shelfDgEo.setPointsDeduction(shelfDgReqDto.getPointsDeduction());
        shelfDgEo.setStockDisplay(shelfDgReqDto.getStockDisplay());
        shelfDgEo.setLimitMin(shelfDgReqDto.getLimitMin());
        shelfDgEo.setLimitMinMode(shelfDgReqDto.getLimitMinMode());
        shelfDgEo.setMultipleStatus(shelfDgReqDto.getMultipleStatus());
        shelfDgEo.setShelfTime(shelfTime);
        shelfDgEo.setStatus(itemStatus);
        shelfDgEo.setPrice(shelfDgReqDto.getPrice());
        shelfDgEo.setFreightTemplateId(shelfDgReqDto.getFreightTemplateId());
        shelfDgEo.setVersionId(itemDgEo.getVersion());
        if (null != update) {
            shelfDgEo.setType(update.getType());
            shelfDgEo.setShopAuth(shelfDgReqDto.getShopAuth());
            this.shelfDgDomain.updateSelective((BaseEo)shelfDgEo);
        } else {
            shelfDgEo.setOrganizationId(shelfDgReqDto.getOrganizationId());
            shelfDgEo.setOrganizationName(shelfDgReqDto.getOrganizationName());
            shelfDgEo.setType(shelfDgReqDto.getType());
            shelfDgEo.setSellerId(shelfDgReqDto.getSellerId());
            shelfDgEoList.add(shelfDgEo);
        }
    }

    private List<DirItemRelationDgEo> removeReply(List<DirItemRelationDgEo> dirItemRelationDgEoList) {
        HashMap<String, DirItemRelationDgEo> dirsItemsEoMap = new HashMap<String, DirItemRelationDgEo>();
        for (DirItemRelationDgEo dirsItemsEo : dirItemRelationDgEoList) {
            StringBuilder sb = new StringBuilder();
            sb.append(dirsItemsEo.getDirId()).append("_");
            sb.append(dirsItemsEo.getItemId()).append("_");
            sb.append(dirsItemsEo.getSkuId()).append("_");
            sb.append(dirsItemsEo.getShopId()).append("_");
            sb.append(dirsItemsEo.getBusType());
            dirsItemsEoMap.put(sb.toString(), dirsItemsEo);
        }
        ArrayList<DirItemRelationDgEo> resultEos = new ArrayList<DirItemRelationDgEo>();
        resultEos.addAll(dirsItemsEoMap.values());
        return resultEos;
    }

    private Map<Long, List<Long>> getItemSkuRelationMap(List<DirItemRelationDgEo> dirItemRelationDgEoList) {
        HashMap<Long, List<Long>> itemSkuRelationMap = new HashMap<Long, List<Long>>();
        for (DirItemRelationDgEo dirItemRelationDgEo : dirItemRelationDgEoList) {
            ArrayList<Long> skuIdList = (ArrayList<Long>)itemSkuRelationMap.get(dirItemRelationDgEo.getItemId());
            if (skuIdList == null) {
                skuIdList = new ArrayList<Long>();
                itemSkuRelationMap.put(dirItemRelationDgEo.getItemId(), skuIdList);
            }
            if (dirItemRelationDgEo.getSkuId() == null) continue;
            skuIdList.add(dirItemRelationDgEo.getSkuId());
        }
        return itemSkuRelationMap;
    }

    private List<Long> getDirIds(List<DirItemRelationDgEo> dirItemRelationDgEoList) {
        HashMap<Long, DirItemRelationDgEo> dirsItemsEoMap = new HashMap<Long, DirItemRelationDgEo>();
        for (DirItemRelationDgEo dirsItemsEo : dirItemRelationDgEoList) {
            if (dirsItemsEo.getDirId() == null) continue;
            dirsItemsEoMap.put(dirsItemsEo.getDirId(), dirsItemsEo);
        }
        ArrayList<Long> resultEos = new ArrayList<Long>();
        resultEos.addAll(dirsItemsEoMap.keySet());
        return resultEos;
    }

    private DirItemRelationDgEo queryDirItemRelationInfo(DirItemRelationDgEo dirItemRelationDgEo) {
        if (dirItemRelationDgEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        if (dirItemRelationDgEo.getItemId() == null && dirItemRelationDgEo.getSkuId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        DirItemRelationDgEo relationEo = new DirItemRelationDgEo();
        relationEo.setItemId(dirItemRelationDgEo.getItemId());
        relationEo.setSkuId(dirItemRelationDgEo.getSkuId());
        relationEo.setDirId(dirItemRelationDgEo.getDirId());
        relationEo.setShopId(dirItemRelationDgEo.getShopId());
        relationEo.setSellerId(dirItemRelationDgEo.getSellerId());
        return (DirItemRelationDgEo)this.dirItemRelationDgDomain.selectOne((BaseEo)relationEo);
    }

    private void saveShelfTask(ShelfTaskDgEo shelfTaskDgEo, ItemShelfDgReqDto itemShelfDgReqDto, OffItemDgReqDto offItemDgReqDto) {
        if (itemShelfDgReqDto != null && offItemDgReqDto == null) {
            ShelfTaskDgEo onQueryEos = this.getSameTimeEo(shelfTaskDgEo.getShelfTime());
            List eos = this.shelfTaskDgDomain.selectList((BaseEo)onQueryEos);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)eos)) {
                ShelfTaskDgEo insertEo = this.getShelfTaskInsertEo(shelfTaskDgEo, itemShelfDgReqDto, null);
                JSONObject priceJson = new JSONObject();
                if (itemShelfDgReqDto.getPrice() != null || itemShelfDgReqDto.getPriceId() != null) {
                    priceJson.put("price", (Object)itemShelfDgReqDto.getPrice());
                    priceJson.put("priceId", (Object)itemShelfDgReqDto.getPriceId());
                }
                Long taskId = this.shelfSchedulerDgService.createShelfTask(insertEo, "\u5b9a\u65f6\u4e0a\u4e0b\u67b6\u4efb\u52a1\u521b\u5efa", "shelfTask", priceJson);
                insertEo.setTaskId(taskId);
                this.shelfTaskDgDomain.insert((BaseEo)insertEo);
            } else {
                DtoHelper.dto2Eo((BaseVo)itemShelfDgReqDto, (BaseEo)onQueryEos);
                this.checkExistTask(onQueryEos);
                ShelfTaskDgEo insertEo = this.getShelfTaskInsertEo(shelfTaskDgEo, itemShelfDgReqDto, null);
                insertEo.setTaskId(((ShelfTaskDgEo)eos.get(0)).getTaskId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(this.getAllowOrderTime(itemShelfDgReqDto))) {
                    insertEo.setAllowOrderTime(this.Date2JsonString(this.getAllowOrderTime(itemShelfDgReqDto), "yyyy-MM-dd HH:mm:ss"));
                }
                this.shelfTaskDgDomain.insert((BaseEo)insertEo);
            }
        } else if (itemShelfDgReqDto == null && offItemDgReqDto != null) {
            ShelfTaskDgEo offQueryEos = this.getSameTimeEo(offItemDgReqDto.getOffTime());
            List eos = this.shelfTaskDgDomain.selectList((BaseEo)offQueryEos);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)eos)) {
                ShelfTaskDgEo insertEo = this.getShelfTaskInsertEo(null, null, offItemDgReqDto);
                Long taskId = this.shelfSchedulerDgService.createShelfTask(insertEo, "\u5b9a\u65f6\u4e0a\u4e0b\u67b6\u4efb\u52a1\u521b\u5efa", "shelfTask", new JSONObject());
                insertEo.setTaskId(taskId);
                this.shelfTaskDgDomain.insert((BaseEo)insertEo);
            } else {
                DtoHelper.dto2Eo((BaseVo)offItemDgReqDto, (BaseEo)offQueryEos);
                this.checkExistTask(offQueryEos);
                ShelfTaskDgEo insertEo = this.getShelfTaskInsertEo(null, null, offItemDgReqDto);
                insertEo.setTaskId(((ShelfTaskDgEo)eos.get(0)).getTaskId());
                this.shelfTaskDgDomain.insert((BaseEo)insertEo);
            }
        }
    }

    private void updateItemStatus(List<Long> itemIds, Integer itemStatus) {
        for (Long id : itemIds) {
            ItemDgEo itemDgEo = ItemDgEo.newInstance();
            itemDgEo.setStatus(itemStatus);
            itemDgEo.setId(id);
            this.itemDgService.updateItem(itemDgEo);
        }
    }

    private void updateItemSkuStatus(Map<Long, List<Long>> itemSkuRelationMap, Integer status) {
        if (itemSkuRelationMap == null || itemSkuRelationMap.isEmpty()) {
            return;
        }
        List<Long> skuIdList = null;
        for (Long itemId : itemSkuRelationMap.keySet()) {
            skuIdList = itemSkuRelationMap.get(itemId);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(skuIdList)) {
                ItemSkuDgEo itemSkuDgEo = new ItemSkuDgEo();
                itemSkuDgEo.setItemId(itemId);
                itemSkuDgEo.setStatus(status);
                this.itemSkuDgDomain.updateSelective((BaseEo)itemSkuDgEo);
                continue;
            }
            for (Long skuId : skuIdList) {
                ItemSkuDgEo itemSkuDgEo = new ItemSkuDgEo();
                itemSkuDgEo.setId(skuId);
                itemSkuDgEo.setStatus(status);
                this.itemSkuDgDomain.updateSelective((BaseEo)itemSkuDgEo);
            }
        }
    }

    private void verifyDirItems(List<DirItemRelationDgEo> dirsItemsEos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dirsItemsEos)) {
            ValidateException validateException = new ValidateException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
            validateException.addError("dirsItemsEos", "dirsItemsEos \u4e0d\u80fd\u4e3a\u7a7a");
            throw validateException;
        }
        for (DirItemRelationDgEo dirsItemsEo : dirsItemsEos) {
            ValidateException validateException = new ValidateException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
            if (dirsItemsEo == null) {
                validateException.addError("itemId", "itemId \u4e0d\u80fd\u4e3a\u7a7a");
                throw validateException;
            }
            if (dirsItemsEo.getItemId() != null && dirsItemsEo.getItemId() != 0L) continue;
            validateException.addError("itemId", "itemId \u4e0d\u80fd\u4e3a\u7a7a");
            throw validateException;
        }
    }

    private void verifyItemIds(List<Long> itemIds, List<Long> dirIds, List<Long> skuIds, Long taskId, String type) {
        List<ItemSkuDgEo> itemSkuDgEos;
        List<DirDgEo> directoryItemEos;
        List<ItemDgEo> itemDgEos;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemIds) && (itemDgEos = this.itemDgService.queryItemByIds(itemIds)).size() != itemIds.size()) {
            Map eoMap = itemDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
            for (Long id : itemIds) {
                boolean isExist = !Objects.isNull(eoMap.get(id));
                if (isExist) continue;
                ShelfItemDgDto shelfItemDgDto = new ShelfItemDgDto();
                shelfItemDgDto.setItemId(id);
                shelfItemDgDto.setTaskId(taskId);
                this.updateShelfTaskStatus(shelfItemDgDto, ShelfTaskStatusDgEnum.UNPROCESSED.getStatus(), type, ShelfTaskStatusDgEnum.FAIL.getStatus());
                throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), "itemId=" + id + "\u4e0d\u5b58\u5728");
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dirIds) && (directoryItemEos = this.directoryItemDgService.queryByIds(dirIds)).size() != dirIds.size()) {
            for (Long id : dirIds) {
                boolean isExist = false;
                for (DirDgEo directoryItemEo : directoryItemEos) {
                    if (!id.equals(directoryItemEo.getId())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                ShelfItemDgDto shelfItemDgDto = new ShelfItemDgDto();
                shelfItemDgDto.setDirId(id);
                shelfItemDgDto.setTaskId(taskId);
                this.updateShelfTaskStatus(shelfItemDgDto, ShelfTaskStatusDgEnum.UNPROCESSED.getStatus(), type, ShelfTaskStatusDgEnum.FAIL.getStatus());
                throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), "dirId=" + id + "\u4e0d\u5b58\u5728");
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skuIds) && (itemSkuDgEos = this.itemSkuDgService.queryItemSkuByIds(skuIds)).size() != skuIds.size()) {
            for (Long skuId : skuIds) {
                boolean isExist = false;
                for (ItemSkuDgEo eo : itemSkuDgEos) {
                    if (!skuId.equals(eo.getId())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                ShelfItemDgDto shelfItemDgDto = new ShelfItemDgDto();
                shelfItemDgDto.setSkuId(skuId);
                shelfItemDgDto.setTaskId(taskId);
                this.updateShelfTaskStatus(shelfItemDgDto, ShelfTaskStatusDgEnum.UNPROCESSED.getStatus(), type, ShelfTaskStatusDgEnum.FAIL.getStatus());
                throw new BizException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), "skuId=" + skuId + "\u4e0d\u5b58\u5728");
            }
        }
    }

    private Map<Long, List<ItemAttributesDgEo>> getGroupItemIdAttributes(List<Long> itemIds, List<ItemAttributesDgEo> itemAttributesDgEos) {
        HashMap<Long, List<ItemAttributesDgEo>> divisionItemAttributesMap = new HashMap<Long, List<ItemAttributesDgEo>>();
        for (Long itemId : itemIds) {
            ArrayList<ItemAttributesDgEo> itemAttributes = new ArrayList<ItemAttributesDgEo>();
            for (ItemAttributesDgEo itemAttributesDgEo : itemAttributesDgEos) {
                if (!itemAttributesDgEo.getItemId().equals(itemId)) continue;
                itemAttributes.add(itemAttributesDgEo);
            }
            divisionItemAttributesMap.put(itemId, itemAttributes);
        }
        return divisionItemAttributesMap;
    }

    private void autoShelfProcess(ItemShelfDgReqDto itemShelfDgReqDto) {
        List shelfTimeDetailDtoList = itemShelfDgReqDto.getShelfTimeDgReqDto().getShelfTimeDetailDgReqDtoList();
        ShelfTaskDgEo shelfTaskDgEo = ShelfTaskDgEo.newInstance();
        for (ShelfTimeDetailDgReqDto dto : shelfTimeDetailDtoList) {
            Calendar calendar;
            if (dto.getOnShelfTime() != null) {
                calendar = Calendar.getInstance();
                calendar.setTime(dto.getOnShelfTime());
                calendar.set(14, 0);
                dto.setOnShelfTime(calendar.getTime());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getAllowOrderTimeDgReqDtoList()) && dto.getOnShelfTime().after(((AllowOrderTimeDgReqDto)dto.getAllowOrderTimeDgReqDtoList().get(0)).getStartTime())) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":\u8bf7\u68c0\u67e5\u5b9a\u65f6\u4efb\u52a1\u4e0a\u67b6\u65f6\u95f4\u4e0e\u5f00\u59cb\u4e0b\u5355\u65f6\u95f4" + itemShelfDgReqDto.getItemId());
                }
                shelfTaskDgEo.setShelfTime(dto.getOnShelfTime());
                shelfTaskDgEo.setStatus(ShelfTaskStatusDgEnum.UNPROCESSED.getStatus());
                shelfTaskDgEo.setType(ShelfTaskTypeDgEnum.ON.getType());
                this.saveShelfTask(shelfTaskDgEo, itemShelfDgReqDto, null);
            } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getAllowOrderTimeDgReqDtoList())) {
                shelfTaskDgEo.setShelfTime(DateUtil.addMinutes((Date)((AllowOrderTimeDgReqDto)dto.getAllowOrderTimeDgReqDtoList().get(0)).getStartTime(), (int)-1));
                shelfTaskDgEo.setStatus(ShelfTaskStatusDgEnum.UNPROCESSED.getStatus());
                shelfTaskDgEo.setType(ShelfTaskTypeDgEnum.ON.getType());
                this.saveShelfTask(shelfTaskDgEo, itemShelfDgReqDto, null);
            } else {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":\u8bf7\u68c0\u67e5\u5b9a\u65f6\u4efb\u52a1\u4e0a\u67b6\u65f6\u95f4" + itemShelfDgReqDto.getItemId());
            }
            if (dto.getOffShelfTime() != null) {
                calendar = Calendar.getInstance();
                calendar.setTime(dto.getOffShelfTime());
                calendar.set(14, 0);
                dto.setOffShelfTime(calendar.getTime());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getAllowOrderTimeDgReqDtoList())) {
                    List allowOrderTimeDgReqDtos = dto.getAllowOrderTimeDgReqDtoList();
                    if (dto.getOffShelfTime().before(((AllowOrderTimeDgReqDto)allowOrderTimeDgReqDtos.get(allowOrderTimeDgReqDtos.size() - 1)).getEndTime())) {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg() + ":\u8bf7\u68c0\u67e5\u5b9a\u65f6\u4efb\u52a1\u4e0b\u67b6\u65f6\u95f4\u4e0e\u7ed3\u675f\u4e0b\u5355\u65f6\u95f4" + itemShelfDgReqDto.getItemId());
                    }
                }
                shelfTaskDgEo.setShelfTime(dto.getOffShelfTime());
                shelfTaskDgEo.setStatus(ShelfTaskStatusDgEnum.UNPROCESSED.getStatus());
                shelfTaskDgEo.setType(ShelfTaskTypeDgEnum.OFF.getType());
                this.saveShelfTask(shelfTaskDgEo, itemShelfDgReqDto, null);
                continue;
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getAllowOrderTimeDgReqDtoList())) continue;
            List allowOrderTimeDgReqDtos = dto.getAllowOrderTimeDgReqDtoList();
            shelfTaskDgEo.setShelfTime(DateUtil.addMinutes((Date)((AllowOrderTimeDgReqDto)allowOrderTimeDgReqDtos.get(allowOrderTimeDgReqDtos.size() - 1)).getEndTime(), (int)1));
            shelfTaskDgEo.setStatus(ShelfTaskStatusDgEnum.UNPROCESSED.getStatus());
            shelfTaskDgEo.setType(ShelfTaskTypeDgEnum.OFF.getType());
            this.saveShelfTask(shelfTaskDgEo, itemShelfDgReqDto, null);
        }
    }

    private void updateShelfTaskStatus(ShelfItemDgDto shelfItemDgDto, Integer oldStatus, String type, Integer newStatus) {
        ShelfTaskDgEo shelfTaskDgEo = ShelfTaskDgEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfItemDgDto, (BaseEo)shelfTaskDgEo);
        shelfTaskDgEo.setStatus(oldStatus);
        shelfTaskDgEo.setType(type);
        List shelfTaskDgEoList = this.shelfTaskDgDomain.selectList((BaseEo)shelfTaskDgEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfTaskDgEoList)) {
            for (ShelfTaskDgEo eo : shelfTaskDgEoList) {
                eo.setStatus(newStatus);
                this.shelfTaskDgDomain.updateSelective((BaseEo)eo);
            }
        }
    }

    private List<AllowOrderTimeDgReqDto> getAllowOrderTime(ItemShelfDgReqDto itemShelfDgReqDto) {
        List shelfTimeDetailDgReqDtos = itemShelfDgReqDto.getShelfTimeDgReqDto().getShelfTimeDetailDgReqDtoList();
        ArrayList<AllowOrderTimeDgReqDto> allowOrderTimeDgReqDtoList = new ArrayList<AllowOrderTimeDgReqDto>();
        for (ShelfTimeDetailDgReqDto shelfTimeDetailDgReqDto : shelfTimeDetailDgReqDtos) {
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfTimeDetailDgReqDto.getAllowOrderTimeDgReqDtoList())) continue;
            allowOrderTimeDgReqDtoList.addAll(shelfTimeDetailDgReqDto.getAllowOrderTimeDgReqDtoList());
        }
        return allowOrderTimeDgReqDtoList;
    }

    private String Date2JsonString(Object object, String format) {
        return JSON.toJSONStringWithDateFormat((Object)object, (String)format, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    private void checkExistTask(ShelfTaskDgEo shelfTaskDgEo) {
        shelfTaskDgEo.setDr(0);
        if (this.shelfTaskDgDomain.count((BaseEo)shelfTaskDgEo) > 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.TASK_EXISTS.getCode(), ItemExceptionCode.TASK_EXISTS.getMsg());
        }
    }

    private ShelfTaskDgEo getSameTimeEo(Date shelfTime) {
        ShelfTaskDgEo queryEos = ShelfTaskDgEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"shelf_time", (Object)new DateTime((Object)shelfTime).toString("yyyy-MM-dd HH:mm:ss")));
        queryEos.setSqlFilters(sqlFilters);
        return queryEos;
    }

    private ShelfTaskDgEo getShelfTaskInsertEo(ShelfTaskDgEo shelfTaskDgEo, ItemShelfDgReqDto itemShelfDgReqDto, OffItemDgReqDto offItemDgReqDto) {
        ShelfTaskDgEo insertEo = ShelfTaskDgEo.newInstance();
        if (itemShelfDgReqDto != null && offItemDgReqDto == null) {
            DtoHelper.dto2Eo((BaseVo)itemShelfDgReqDto, (BaseEo)insertEo);
            insertEo.setShelfTime(shelfTaskDgEo.getShelfTime());
            insertEo.setStatus(shelfTaskDgEo.getStatus());
            insertEo.setType(shelfTaskDgEo.getType());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(this.getAllowOrderTime(itemShelfDgReqDto))) {
                insertEo.setAllowOrderTime(this.Date2JsonString(this.getAllowOrderTime(itemShelfDgReqDto), "yyyy-MM-dd HH:mm:ss"));
            }
        } else if (itemShelfDgReqDto == null && offItemDgReqDto != null) {
            DtoHelper.dto2Eo((BaseVo)offItemDgReqDto, (BaseEo)insertEo);
            insertEo.setShelfTime(offItemDgReqDto.getOffTime());
            insertEo.setStatus(ShelfTaskStatusDgEnum.UNPROCESSED.getStatus());
            insertEo.setType(ShelfTaskTypeDgEnum.OFF.getType());
        }
        return insertEo;
    }

    private void onShelfCheckSubItemStatus(List<ItemShelfDgReqDto> onShelfDtoList, Integer status) {
        Map<String, List<ItemShelfDgReqDto>> onShelfDtoMap = onShelfDtoList.stream().collect(Collectors.groupingBy(itemShelfDgReqDto -> itemShelfDgReqDto.getShopId() + "" + itemShelfDgReqDto.getItemId() + "" + itemShelfDgReqDto.getSkuId()));
        onShelfDtoMap.forEach((k, v) -> {
            ItemShelfDgReqDto itemShelfDgReqDto = (ItemShelfDgReqDto)v.get(0);
            List bundleItemDgReqDtoList = itemShelfDgReqDto.getBundleItemDtos();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)bundleItemDgReqDtoList)) {
                bundleItemDgReqDtoList.forEach(bundleItemReqDto -> {
                    List shelfDgEoList = this.shelfDgDomain.selectByParam(itemShelfDgReqDto.getShopId(), itemShelfDgReqDto.getChannelId(), bundleItemReqDto.getSubItemId(), bundleItemReqDto.getSubSkuId(), status);
                    AssertUtils.notEmpty((Collection)shelfDgEoList, (String)"\u7ec4\u5408\u5546\u54c1\u4e2d\u5305\u542b\u672a\u53d1\u5e03\u5546\u54c1\uff0c\u8bf7\u5148\u53d1\u5e03");
                });
            }
        });
    }

    @Override
    public boolean allOffShelf(Long itemId, Long sellerId) {
        return this.countShelf(itemId, sellerId, null, null) == 0;
    }

    @Override
    public boolean allOffShelf2(Long itemId, Long shopId) {
        return this.countShelf2(itemId, shopId) == 0;
    }

    @Override
    public boolean hasOnShelf(Long itemId) {
        return this.countShelf(itemId, null, null, null) > 0;
    }

    @Override
    public boolean isOnShelf(Long itemId, Long skuId, Long shopId) {
        return this.countShelf(itemId, null, skuId, shopId) > 0;
    }

    private int countShelf(Long itemId, Long sellerId, Long skuId, Long shopId) {
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        shelfDgEo.setItemId(itemId);
        shelfDgEo.setSellerId(sellerId);
        shelfDgEo.setShopId(shopId);
        shelfDgEo.setSkuId(skuId);
        shelfDgEo.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
        shelfDgEo.setDr(0);
        return this.shelfDgDomain.count((BaseEo)shelfDgEo);
    }

    private int countShelf2(Long itemId, Long shopId) {
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        shelfDgEo.setItemId(itemId);
        shelfDgEo.setShopId(shopId);
        shelfDgEo.setDr(0);
        shelfDgEo.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
        return this.shelfDgDomain.count((BaseEo)shelfDgEo);
    }

    @Override
    public void offAndDrop(List<ItemShelfDgReqDto> itemShelfDgReqDtoList) {
        ArrayList allShelfDgEos = Lists.newArrayList();
        itemShelfDgReqDtoList.forEach(itemShelfDgReqDto -> {
            ShelfDgEo shelfDgEo = new ShelfDgEo();
            shelfDgEo.setItemId(itemShelfDgReqDto.getItemId());
            shelfDgEo.setShopId(itemShelfDgReqDto.getShopId());
            shelfDgEo.setChannelId(itemShelfDgReqDto.getChannelId());
            shelfDgEo.setItemType(itemShelfDgReqDto.getItemType());
            shelfDgEo.setBusType(itemShelfDgReqDto.getBusType());
            List shelfDgEos = this.shelfDgDomain.selectList((BaseEo)shelfDgEo);
            allShelfDgEos.addAll(shelfDgEos);
        });
        List<OffItemDgReqDto> offItemDgReqDtos = allShelfDgEos.stream().filter(shelfEo -> ItemDgStatus.ITEM_ONSHELF.getStatus().equals(shelfEo.getStatus())).map(shelfEo -> {
            OffItemDgReqDto offItemDgReqDto = new OffItemDgReqDto();
            offItemDgReqDto.setShopId(shelfEo.getShopId());
            offItemDgReqDto.setChannelId(shelfEo.getChannelId());
            offItemDgReqDto.setSkuId(shelfEo.getSkuId());
            offItemDgReqDto.setItemId(shelfEo.getItemId());
            offItemDgReqDto.setItemType(shelfEo.getItemType());
            offItemDgReqDto.setBusType(shelfEo.getBusType());
            return offItemDgReqDto;
        }).collect(Collectors.toList());
        this.offShelfItem(offItemDgReqDtos);
        logger.info("\u903b\u8f91\u5220\u9664\u4e0b\u67b6\u5546\u54c1={}", (Object)JSON.toJSONString((Object)allShelfDgEos));
        allShelfDgEos.forEach(shelfEo -> this.shelfDgDomain.logicDeleteById(shelfEo.getId()));
    }

    @Override
    public void updateIndex(Long itemId) {
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        shelfDgEo.setItemId(itemId);
        shelfDgEo.setStatus(ItemDgStatus.ITEM_ONSHELF.getStatus());
        List shelfDgEos = this.shelfDgDomain.selectList((BaseEo)shelfDgEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shelfDgEos)) {
            logger.info("\u65e0\u4e0a\u67b6\u4e2d\u5546\u54c1\uff0c\u4e0d\u9700\u8981\u66f4\u65b0ES\u6570\u636e");
            return;
        }
        this.itemSearchDgService.refreshIndexBatchHandler(shelfDgEos.stream().map(sh -> this.itemSearchDgService.getIndexDocId(sh.getSellerId(), sh.getItemId(), sh.getBusType())).distinct().collect(Collectors.toList()), Lists.newArrayList((Object[])new ItemDgEo[]{(ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemId)}), shelfDgEos);
    }

    @Override
    public Integer countByFreightTemplateId(Long freightTemplateId) {
        ShelfDgEo shelfDgEo = ShelfDgEo.newInstance();
        shelfDgEo.setFreightTemplateId(freightTemplateId);
        shelfDgEo.setDr(DrDgEnum.VALID.getCode());
        shelfDgEo.setDr(0);
        return this.shelfDgDomain.count((BaseEo)shelfDgEo);
    }

    @Override
    public void batchModifyShelfShopAuth(ShelfModifyShopAuthDgReqDto modifyShopAuthReqDto) {
        if (Objects.isNull(modifyShopAuthReqDto)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)modifyShopAuthReqDto.getSkuIds())) {
            return;
        }
        ShelfDgEo shelfDgEo = new ShelfDgEo();
        shelfDgEo.setShopAuth(modifyShopAuthReqDto.getShopAuth());
        UpdateWrapper updateWrapper = (UpdateWrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"sku_id", (Collection)modifyShopAuthReqDto.getSkuIds())).eq((Object)"shop_id", (Object)modifyShopAuthReqDto.getShopId());
        this.shelfDgDomain.getMapper().update((Object)shelfDgEo, (Wrapper)updateWrapper);
    }
}

