/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.convert.entity.SerialCodeConverter;
import com.yunxi.dg.base.center.item.domain.entity.ISerialCodeDomain;
import com.yunxi.dg.base.center.item.dto.entity.BatchOperateDto;
import com.yunxi.dg.base.center.item.dto.entity.SerialCodeDto;
import com.yunxi.dg.base.center.item.dto.entity.SerialCodePageReqDto;
import com.yunxi.dg.base.center.item.dto.request.SerialCodeReqDto;
import com.yunxi.dg.base.center.item.dto.request.SerialCodeStatusReqDto;
import com.yunxi.dg.base.center.item.eo.SerialCodeEo;
import com.yunxi.dg.base.center.item.event.localEvent.SerialCodeMqEvent;
import com.yunxi.dg.base.center.item.service.entity.ISerialCodeService;
import com.yunxi.dg.base.center.item.service.util.ConvertDgUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SerialCodeServiceImpl
extends BaseServiceImpl<SerialCodeDto, SerialCodeEo, ISerialCodeDomain>
implements ISerialCodeService {
    @Resource
    private ISerialCodeDomain serialCodeDomain;
    @Autowired
    private ApplicationContext applicationContext;

    public SerialCodeServiceImpl(ISerialCodeDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SerialCodeDto, SerialCodeEo> converter() {
        return SerialCodeConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> add(SerialCodeReqDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getCode(), (String)"\u5546\u54c1\u7cfb\u5217\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getName(), (String)"\u5546\u54c1\u7cfb\u5217\u7801\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a!");
        List codeEos = ((ExtQueryChainWrapper)this.serialCodeDomain.filter().eq((Object)"code", (Object)dto.getCode())).list();
        AssertUtils.isTrue((boolean)CollectionUtil.isEmpty((Collection)codeEos), (String)"\u5546\u54c1\u7cfb\u5217\u7f16\u7801\u5df2\u5b58\u5728!");
        SerialCodeEo serialCodeEo = new SerialCodeEo();
        this.checkName(dto);
        BeanUtil.copyProperties((Object)dto, (Object)serialCodeEo, (String[])new String[0]);
        this.serialCodeDomain.insert((BaseEo)serialCodeEo);
        this.applicationContext.publishEvent((Object)new SerialCodeMqEvent(Lists.newArrayList((Object[])new SerialCodeEo[]{serialCodeEo}), "insert"));
        return new RestResponse((Object)serialCodeEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> modify(SerialCodeReqDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getId(), (String)"\u5546\u54c1\u5e8f\u5217\u7801id\u4e0d\u53ef\u4e3a\u7a7a!");
        SerialCodeEo serialCodeEo = (SerialCodeEo)((ExtQueryChainWrapper)this.serialCodeDomain.filter().eq((Object)"id", (Object)dto.getId())).one();
        AssertUtils.notNull((Object)serialCodeEo, (String)"\u5546\u54c1\u7cfb\u5217\u7801\u4fe1\u606f\u4e0d\u5b58\u5728!");
        this.checkName(dto);
        dto.setCode(null);
        BeanUtil.copyProperties((Object)dto, (Object)serialCodeEo, (String[])new String[0]);
        this.serialCodeDomain.updateSelective((BaseEo)serialCodeEo);
        this.applicationContext.publishEvent((Object)new SerialCodeMqEvent(Lists.newArrayList((Object[])new SerialCodeEo[]{serialCodeEo}), "update"));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<SerialCodeDto> queryById(Long id) {
        SerialCodeDto serialCodeDto = new SerialCodeDto();
        SerialCodeEo serialCodeEo = (SerialCodeEo)((ExtQueryChainWrapper)this.serialCodeDomain.filter().eq((Object)"id", (Object)id)).one();
        BeanUtil.copyProperties((Object)serialCodeEo, (Object)serialCodeDto, (String[])new String[0]);
        return new RestResponse((Object)serialCodeDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> removeByIds(List<Long> ids) {
        this.serialCodeDomain.logicDeleteByIds(ids);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<PageInfo<SerialCodeDto>> queryByPage(SerialCodePageReqDto dto) {
        PageInfo<SerialCodeDto> dtoPageInfo = new PageInfo<SerialCodeDto>();
        SerialCodeEo serialCodeEo = this.queryCondition(dto);
        PageInfo eoPageInfo = this.serialCodeDomain.selectPage((BaseEo)serialCodeEo, dto.getPageNum(), dto.getPageSize());
        dtoPageInfo = ConvertDgUtil.convertPage(eoPageInfo, SerialCodeDto.class);
        return new RestResponse(dtoPageInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> batchAdd(List<SerialCodeReqDto> dtos) {
        AssertUtils.notEmpty(dtos, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a!");
        ArrayList<String> codeList = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        for (SerialCodeReqDto dto : dtos) {
            AssertUtils.notNull((Object)dto.getCode(), (String)"\u5e8f\u5217\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a!");
            AssertUtils.notNull((Object)dto.getCode(), (String)"\u5e8f\u5217\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a!");
            codeList.add(dto.getCode());
            nameList.add(dto.getName());
        }
        Map<String, List<SerialCodeEo>> serialCodeMapByCodes = this.getSerialCodeMapByCodes(codeList);
        Map<String, List<SerialCodeEo>> serialCodeMapByNames = this.getSerialCodeMapByNames(nameList);
        ArrayList<SerialCodeEo> insertEos = new ArrayList<SerialCodeEo>();
        ArrayList<SerialCodeEo> updateEos = new ArrayList<SerialCodeEo>();
        for (SerialCodeReqDto dto : dtos) {
            this.existName(dto, serialCodeMapByNames.get(dto.getName()));
            SerialCodeEo serialCodeEo = this.existCode(dto, serialCodeMapByCodes.get(dto.getCode()));
            SerialCodeEo eo = new SerialCodeEo();
            BeanUtil.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
            if (Objects.nonNull(serialCodeEo)) {
                eo.setId(serialCodeEo.getId());
                updateEos.add(eo);
                continue;
            }
            insertEos.add(eo);
        }
        if (CollectionUtil.isNotEmpty(insertEos)) {
            this.serialCodeDomain.insertBatch(insertEos);
            this.applicationContext.publishEvent((Object)new SerialCodeMqEvent(Lists.newArrayList(insertEos), "insert"));
        }
        if (CollectionUtil.isNotEmpty(updateEos)) {
            for (SerialCodeEo updateEo : updateEos) {
                this.serialCodeDomain.updateSelective((BaseEo)updateEo);
            }
            this.applicationContext.publishEvent((Object)new SerialCodeMqEvent(Lists.newArrayList(updateEos), "update"));
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<BatchOperateDto> batchChangeStatus(SerialCodeStatusReqDto dto) {
        BatchOperateDto operateDto = new BatchOperateDto();
        Integer failCount = 0;
        Integer successCount = 0;
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a!");
        List serialCodeEos = this.serialCodeDomain.selectByIds(dto.getIdList());
        AssertUtils.notEmpty((Collection)serialCodeEos, (String)"\u5546\u54c1\u7cfb\u5217\u4fe1\u606f\u4e0d\u5b58\u5728!");
        for (SerialCodeEo serialCodeEo : serialCodeEos) {
            if (Objects.equals(serialCodeEo.getStatus(), dto.getStatus())) {
                failCount = failCount + 1;
                continue;
            }
            successCount = successCount + 1;
        }
        this.serialCodeDomain.batchChangeStatus(dto.getIdList(), dto.getStatus());
        operateDto.setFailCount(failCount);
        operateDto.setSuccessCount(successCount);
        serialCodeEos.forEach(o -> o.setStatus(dto.getStatus()));
        this.applicationContext.publishEvent((Object)new SerialCodeMqEvent(Lists.newArrayList((Iterable)serialCodeEos), "update"));
        return new RestResponse((Object)operateDto);
    }

    private SerialCodeEo queryCondition(SerialCodePageReqDto dto) {
        SerialCodeEo serialCodeEo = new SerialCodeEo();
        serialCodeEo.setDr(0);
        BeanUtil.copyProperties((Object)dto, (Object)serialCodeEo, (String[])new String[0]);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (Objects.nonNull(dto)) {
            if (CollectionUtil.isNotEmpty((Collection)dto.getIdList())) {
                sqlFilters.add(SqlFilter.in((String)"id", (Object)dto.getIdList()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getCodeList())) {
                sqlFilters.add(SqlFilter.in((String)"code", (Object)dto.getCodeList()));
            }
            if (Objects.nonNull(dto.getCode())) {
                serialCodeEo.setCode(null);
                sqlFilters.add(SqlFilter.like((String)"code", (Object)dto.getCode()));
            }
            if (Objects.nonNull(dto.getExternalCode())) {
                serialCodeEo.setCode(null);
                sqlFilters.add(SqlFilter.like((String)"external_code", (Object)dto.getExternalCode()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getExternalCodeList())) {
                sqlFilters.add(SqlFilter.in((String)"external_code", (Object)dto.getExternalCodeList()));
            }
            if (Objects.nonNull(dto.getName())) {
                serialCodeEo.setName(null);
                sqlFilters.add(SqlFilter.like((String)"name", (Object)dto.getName()));
            }
            if (Objects.nonNull(dto.getDisplayName())) {
                serialCodeEo.setDisplayName(null);
                sqlFilters.add(SqlFilter.like((String)"display_name", (Object)dto.getDisplayName()));
            }
            if (Objects.nonNull(dto.getCreateStartTime())) {
                sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)dto.getCreateStartTime()));
            }
            if (Objects.nonNull(dto.getCreateEndTime())) {
                sqlFilters.add(SqlFilter.le((String)"create_time", (Object)dto.getCreateEndTime()));
            }
            if (Objects.nonNull(dto.getUpdateStartTime())) {
                sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)dto.getUpdateStartTime()));
            }
            if (Objects.nonNull(dto.getUpdateEndTime())) {
                sqlFilters.add(SqlFilter.le((String)"update_time", (Object)dto.getUpdateEndTime()));
            }
        }
        serialCodeEo.setSqlFilters(sqlFilters);
        serialCodeEo.setOrderByDesc("id");
        return serialCodeEo;
    }

    private void checkName(SerialCodeReqDto dto) {
        if (Objects.isNull(dto) || Objects.isNull(dto.getName())) {
            return;
        }
        List codeEos = ((ExtQueryChainWrapper)this.serialCodeDomain.filter().eq((Object)"name", (Object)dto.getName())).list();
        this.existName(dto, codeEos);
    }

    private SerialCodeEo existCode(SerialCodeReqDto dto, List<SerialCodeEo> existEos) {
        if (CollectionUtil.isEmpty(existEos)) {
            return null;
        }
        SerialCodeEo serialCodeEo = new SerialCodeEo();
        AssertUtils.isFalse((existEos.size() > 2 ? 1 : 0) != 0, (String)("\u5546\u54c1\u7cfb\u5217\u7f16\u7801" + dto.getCode() + "\u5df2\u91cd\u590d\u5b58\u5728!"));
        BeanUtil.copyProperties((Object)existEos.get(0), (Object)serialCodeEo, (String[])new String[0]);
        return serialCodeEo;
    }

    private void existName(SerialCodeReqDto dto, List<SerialCodeEo> existEos) {
        if (CollectionUtil.isEmpty(existEos)) {
            return;
        }
        AssertUtils.isFalse((existEos.size() > 2 ? 1 : 0) != 0, (String)"\u5546\u54c1\u7cfb\u5217\u7801\u540d\u79f0\u5df2\u91cd\u590d\u5b58\u5728!");
        AssertUtils.isTrue((boolean)Objects.equals(dto.getId(), existEos.get(0).getId()), (String)"\u5546\u54c1\u7cfb\u5217\u7801\u540d\u79f0\u5df2\u5b58\u5728!");
    }

    private Map<String, List<SerialCodeEo>> getSerialCodeMapByCodes(List<String> codeList) {
        List serialCodeEos;
        Map<String, List<SerialCodeEo>> codeMap = new HashMap<String, List<SerialCodeEo>>();
        if (CollectionUtil.isNotEmpty(codeList) && CollectionUtil.isNotEmpty((Collection)(serialCodeEos = ((ExtQueryChainWrapper)this.serialCodeDomain.filter().in((Object)"code", codeList)).list()))) {
            codeMap = serialCodeEos.stream().collect(Collectors.groupingBy(SerialCodeEo::getCode));
        }
        return codeMap;
    }

    private Map<String, List<SerialCodeEo>> getSerialCodeMapByNames(List<String> nameList) {
        List serialCodeEos;
        Map<String, List<SerialCodeEo>> nameMap = new HashMap<String, List<SerialCodeEo>>();
        if (CollectionUtil.isNotEmpty(nameList) && CollectionUtil.isNotEmpty((Collection)(serialCodeEos = ((ExtQueryChainWrapper)this.serialCodeDomain.filter().in((Object)"name", nameList)).list()))) {
            nameMap = serialCodeEos.stream().collect(Collectors.groupingBy(SerialCodeEo::getName));
        }
        return nameMap;
    }
}

